/*
 * Decompiled with CFR 0.152.
 */
package com.yuntongxun.ecsdk.voip.video;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.opengl.GLSurfaceView;
import android.os.Build;
import com.hisun.phone.core.voice.util.Log4Util;
import com.yuntongxun.ecsdk.voip.video.ECOpenGlView;
import com.yuntongxun.ecsdk.voip.video.IRender;
import java.lang.ref.WeakReference;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class ECOpenGlRender
extends IRender
implements GLSurfaceView.Renderer {
    public static final String TAG = "GLRENDER";
    private static int mGlVersion = 0;
    private WeakReference<ECOpenGlView> mGlViews;
    protected boolean mGlInitReady = false;
    boolean mSurfaceReady = false;
    private float mZoomFactor = 1.2f;
    private float mZoomCx = 1.93f;
    private float mZoomCy = 1.05f;
    int mWidth = 0;
    int mHeight = 0;
    private int mFrameWidth = 0;
    private int mFrameHeight = 0;
    private int mFrameLength = 0;
    private byte[] mByte = null;
    private byte[] mPreviewByte = null;
    private int mRotation = 0;
    private int mRenderType;

    ECOpenGlRender(ECOpenGlView mGlView, int renderType) {
        this.mGlViews = new WeakReference<ECOpenGlView>(mGlView);
        this.mRenderType = renderType;
    }

    static int getOpenGLVersion(Context context) {
        if (mGlVersion == 0) {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            ConfigurationInfo info = am.getDeviceConfigurationInfo();
            mGlVersion = info.reqGlEsVersion >= 131072 ? 2 : 1;
            if (Build.MODEL.equals("Nexus 6")) {
                mGlVersion = 2;
            }
        }
        Log4Util.d(TAG, "getOpenGLVersion " + mGlVersion);
        return mGlVersion;
    }

    public final void renderCapture(byte[] data, int width, int height, int length, int rotation) {
        if (this.mSurfaceReady && this.mPreviewByte == null) {
            this.mFrameWidth = width;
            this.mFrameHeight = height;
            this.mFrameLength = length;
            this.mPreviewByte = data;
            this.mRotation = rotation;
            this.requestRender();
        }
    }

    public final void renderFrame(byte[] data, int width, int height, int length) {
        if (this.mSurfaceReady && this.mByte == null) {
            if (this.mByte == null || this.mFrameLength != length) {
                this.mByte = new byte[length];
            }
            this.mFrameWidth = width;
            this.mFrameHeight = height;
            this.mFrameLength = length;
            System.arraycopy(data, 0, this.mByte, 0, length);
            this.requestRender();
        }
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        Log4Util.i(TAG, "onSurfaceChanged, width: " + width + ", height: " + height);
        if (this.mWidth != width || this.mHeight != height) {
            gl.glViewport(0, 0, width, height);
            this.mWidth = width;
            this.mHeight = height;
        }
    }

    public void onDrawFrame(GL10 gl) {
        ECOpenGlView mGlView = (ECOpenGlView)((Object)this.mGlViews.get());
        if (!this.mSurfaceReady || mGlView == null) {
            this.mByte = null;
            this.mPreviewByte = null;
            return;
        }
        if (!this.mGlInitReady) {
            if (mGlView.mPtr == -1L) {
                mGlView.mPtr = this.Create();
            }
            this.Init(mGlView.mPtr, mGlView.getWidth(), mGlView.getHeight());
            int mAspect = mGlView.mAspectMode == null ? -1 : mGlView.mAspectMode.ordinal();
            this.setParam(mGlView.mPtr, this.mZoomFactor, this.mZoomCx, this.mZoomCy, mAspect);
            this.mGlInitReady = true;
        }
        if (this.mPreviewByte != null) {
            this.SetPreviewYuv(mGlView.mPtr, this.mFrameWidth, this.mFrameHeight, this.mPreviewByte, this.mFrameLength, this.mRotation);
            this.mPreviewByte = null;
            return;
        }
        if (this.mByte != null) {
            this.SetYuv(mGlView.mPtr, this.mFrameWidth, this.mFrameHeight, this.mByte, this.mFrameLength);
            this.mByte = null;
        }
    }

    void requestRender() {
        Log4Util.i(TAG, "requestRender mSurfaceReady  " + this.mSurfaceReady);
        if (!this.mSurfaceReady) {
            return;
        }
        ECOpenGlView glView = (ECOpenGlView)((Object)this.mGlViews.get());
        if (glView == null) {
            Log4Util.e(TAG, "requestRender fail glView null");
            return;
        }
        glView.requestRender();
        Log4Util.v(TAG, "requestRender success " + this.mRotation);
    }

    public native long Create();

    public native void Remove(long var1);

    public native void Init(long var1, int var3, int var4);

    public native void Uninit(long var1);

    public native void setParam(long var1, float var3, float var4, float var5, int var6);

    public native void SetYuv(long var1, int var3, int var4, byte[] var5, int var6);

    public native void SetPreviewYuv(long var1, int var3, int var4, byte[] var5, int var6, int var7);

    static {
        System.loadLibrary("yuntx_gl_disp");
    }
}

