/*
 * Decompiled with CFR 0.152.
 */
package com.yuntongxun.ecsdk.core.voip;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;

class WebRtcAudioTrack {
    private AudioTrack _audioTrack = null;
    private Context _context;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private byte[] _tempBufPlay;
    private final ReentrantLock _playLock = new ReentrantLock();
    private boolean _doPlayInit = true;
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private boolean _isPlaying = false;
    private int _bufferedPlaySamples = 0;
    private int _playPosition = 0;
    final String logTag = "WebRTC AD java";

    WebRtcAudioTrack() {
        try {
            this._playBuffer = ByteBuffer.allocateDirect(960);
        }
        catch (Exception e) {
            this.DoLog(e.getMessage());
        }
        this._tempBufPlay = new byte[960];
    }

    private int InitPlayback(int sampleRate) {
        int minPlayBufSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)4, (int)2);
        int playBufSize = minPlayBufSize;
        if (playBufSize < 6000) {
            playBufSize *= 2;
        }
        this._bufferedPlaySamples = 0;
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        try {
            this._audioTrack = new AudioTrack(0, sampleRate, 4, 2, playBufSize, 1);
        }
        catch (Exception e) {
            this.DoLog(e.getMessage());
            return -1;
        }
        if (this._audioTrack.getState() != 1) {
            return -1;
        }
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return 0;
        }
        return this._audioManager.getStreamMaxVolume(0);
    }

    private int StartPlayback() {
        try {
            this._audioTrack.play();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return -1;
        }
        this._isPlaying = true;
        return 0;
    }

    private int StopPlayback() {
        this._playLock.lock();
        try {
            if (this._audioTrack.getPlayState() == 3) {
                try {
                    this._audioTrack.stop();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    int n = -1;
                    this._doPlayInit = true;
                    this._playLock.unlock();
                    return n;
                }
                this._audioTrack.flush();
            }
            this._audioTrack.release();
            this._audioTrack = null;
        }
        finally {
            this._doPlayInit = true;
            this._playLock.unlock();
        }
        this._isPlaying = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int PlayAudio(int lengthInBytes) {
        this._playLock.lock();
        try {
            if (this._audioTrack == null) {
                int n = -2;
                return n;
            }
            if (this._doPlayInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception e) {
                    this.DoLog("Set play thread priority failed: " + e.getMessage());
                }
                this._doPlayInit = false;
            }
            int written = 0;
            this._playBuffer.get(this._tempBufPlay);
            written = this._audioTrack.write(this._tempBufPlay, 0, lengthInBytes);
            this._playBuffer.rewind();
            this._bufferedPlaySamples += written >> 1;
            int pos = this._audioTrack.getPlaybackHeadPosition();
            if (pos < this._playPosition) {
                this._playPosition = 0;
            }
            this._bufferedPlaySamples -= pos - this._playPosition;
            this._playPosition = pos;
            if (written != lengthInBytes) {
                int n = -1;
                return n;
            }
        }
        finally {
            this._playLock.unlock();
        }
        return this._bufferedPlaySamples;
    }

    private int SetPlayoutSpeaker(boolean loudspeakerOn) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            this.DoLogErr("Could not change audio routing - no audio manager");
            return -1;
        }
        int apiLevel = Build.VERSION.SDK_INT;
        if (3 == apiLevel || 4 == apiLevel) {
            if (loudspeakerOn) {
                this._audioManager.setMode(0);
            } else {
                this._audioManager.setMode(2);
            }
        } else if ((Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung")) && (5 == apiLevel || 6 == apiLevel || 7 == apiLevel)) {
            if (loudspeakerOn) {
                this._audioManager.setMode(2);
                this._audioManager.setSpeakerphoneOn(loudspeakerOn);
            } else {
                this._audioManager.setSpeakerphoneOn(loudspeakerOn);
                this._audioManager.setMode(0);
            }
        } else {
            this._audioManager.setSpeakerphoneOn(loudspeakerOn);
        }
        return 0;
    }

    private int SetPlayoutVolume(int level) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int retVal = -1;
        if (this._audioManager != null) {
            this._audioManager.setStreamVolume(0, level, 0);
            retVal = 0;
        }
        return retVal;
    }

    private int GetPlayoutVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int level = -1;
        if (this._audioManager != null) {
            level = this._audioManager.getStreamVolume(0);
        }
        return level;
    }

    private void DoLog(String msg) {
        Log.d((String)"WebRTC AD java", (String)msg);
    }

    private void DoLogErr(String msg) {
        Log.e((String)"WebRTC AD java", (String)msg);
    }
}

