/*
 * Decompiled with CFR 0.152.
 */
package com.yuntongxun.ecsdk.core.voip;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import com.yuntongxun.ecsdk.core.voip.CaptureCapabilityAndroid;
import com.yuntongxun.ecsdk.core.voip.VideoCaptureAndroid;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class VideoCaptureDeviceInfoAndroid {
    Context context;
    private static final String TAG = "WEBRTC";
    String currentDeviceUniqueId;
    int id;
    List<AndroidVideoCaptureDevice> deviceList;

    public static VideoCaptureDeviceInfoAndroid CreateVideoCaptureDeviceInfoAndroid(int in_id, Context in_context) {
        VideoCaptureDeviceInfoAndroid self = new VideoCaptureDeviceInfoAndroid(in_id, in_context);
        if (self != null && self.Init() == 0) {
            return self;
        }
        return null;
    }

    private VideoCaptureDeviceInfoAndroid(int in_id, Context in_context) {
        this.id = in_id;
        this.context = in_context;
        this.deviceList = new ArrayList<AndroidVideoCaptureDevice>();
    }

    private int Init() {
        Camera camera = null;
        try {
            if (Build.VERSION.SDK_INT > 8) {
                for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                    AndroidVideoCaptureDevice newDevice = new AndroidVideoCaptureDevice();
                    Camera.CameraInfo info = new Camera.CameraInfo();
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                    newDevice.index = i;
                    newDevice.orientation = info.orientation;
                    if (info.facing == 0) {
                        newDevice.deviceUniqueName = "Camera " + i + ", Facing back, Orientation " + info.orientation;
                    } else {
                        newDevice.deviceUniqueName = "Camera " + i + ", Facing front, Orientation " + info.orientation;
                        newDevice.frontCameraType = FrontFacingCameraType.Android23;
                    }
                    camera = Camera.open((int)i);
                    Camera.Parameters parameters = camera.getParameters();
                    this.AddDeviceInfo(newDevice, parameters);
                    camera.release();
                    camera = null;
                    this.deviceList.add(newDevice);
                }
            }
        }
        catch (Exception ex) {
            return -1;
        }
        this.VerifyCapabilities();
        return 0;
    }

    private void AddDeviceInfo(AndroidVideoCaptureDevice newDevice, Camera.Parameters parameters) {
        List sizes = parameters.getSupportedPreviewSizes();
        List frameRates = parameters.getSupportedPreviewFrameRates();
        int maxFPS = 0;
        for (Integer frameRate : frameRates) {
            if (frameRate <= maxFPS) continue;
            maxFPS = frameRate;
        }
        newDevice.captureCapabilies = new CaptureCapabilityAndroid[sizes.size()];
        for (int i = 0; i < sizes.size(); ++i) {
            Camera.Size s = (Camera.Size)sizes.get(i);
            newDevice.captureCapabilies[i] = new CaptureCapabilityAndroid();
            newDevice.captureCapabilies[i].height = s.height;
            newDevice.captureCapabilies[i].width = s.width;
            newDevice.captureCapabilies[i].maxFPS = maxFPS;
        }
    }

    private void VerifyCapabilities() {
        if (Build.DEVICE.equals("GT-I9000") || Build.DEVICE.equals("crespo")) {
            CaptureCapabilityAndroid specificCapability = new CaptureCapabilityAndroid();
            specificCapability.width = 352;
            specificCapability.height = 288;
            specificCapability.maxFPS = 15;
            this.AddDeviceSpecificCapability(specificCapability);
            specificCapability = new CaptureCapabilityAndroid();
            specificCapability.width = 176;
            specificCapability.height = 144;
            specificCapability.maxFPS = 15;
            this.AddDeviceSpecificCapability(specificCapability);
            specificCapability = new CaptureCapabilityAndroid();
            specificCapability.width = 320;
            specificCapability.height = 240;
            specificCapability.maxFPS = 15;
            this.AddDeviceSpecificCapability(specificCapability);
        }
        if (Build.MANUFACTURER.equals("motorola") && Build.DEVICE.equals("umts_sholes")) {
            for (AndroidVideoCaptureDevice device : this.deviceList) {
                for (CaptureCapabilityAndroid capability : device.captureCapabilies) {
                    capability.maxFPS = 15;
                }
            }
        }
    }

    private void AddDeviceSpecificCapability(CaptureCapabilityAndroid specificCapability) {
        for (AndroidVideoCaptureDevice device : this.deviceList) {
            boolean foundCapability = false;
            for (CaptureCapabilityAndroid capability : device.captureCapabilies) {
                if (capability.width != specificCapability.width || capability.height != specificCapability.height) continue;
                foundCapability = true;
                break;
            }
            if (foundCapability) continue;
            CaptureCapabilityAndroid[] newCaptureCapabilies = new CaptureCapabilityAndroid[device.captureCapabilies.length + 1];
            for (int i = 0; i < device.captureCapabilies.length; ++i) {
                newCaptureCapabilies[i + 1] = device.captureCapabilies[i];
            }
            newCaptureCapabilies[0] = specificCapability;
            device.captureCapabilies = newCaptureCapabilies;
        }
    }

    public int NumberOfDevices() {
        return this.deviceList.size();
    }

    public String GetDeviceUniqueName(int deviceNumber) {
        if (deviceNumber < 0 || deviceNumber >= this.deviceList.size()) {
            return null;
        }
        return this.deviceList.get((int)deviceNumber).deviceUniqueName;
    }

    public CaptureCapabilityAndroid[] GetCapabilityArray(String deviceUniqueId) {
        for (AndroidVideoCaptureDevice device : this.deviceList) {
            if (!device.deviceUniqueName.equals(deviceUniqueId)) continue;
            return device.captureCapabilies;
        }
        return null;
    }

    public int GetOrientation(String deviceUniqueId) {
        for (AndroidVideoCaptureDevice device : this.deviceList) {
            if (!device.deviceUniqueName.equals(deviceUniqueId)) continue;
            return device.orientation;
        }
        return -1;
    }

    public VideoCaptureAndroid AllocateCamera(int id, long context, String deviceUniqueId) {
        try {
            Camera camera = null;
            AndroidVideoCaptureDevice deviceToUse = null;
            block6: for (AndroidVideoCaptureDevice device : this.deviceList) {
                if (!device.deviceUniqueName.equals(deviceUniqueId)) continue;
                deviceToUse = device;
                switch (device.frontCameraType) {
                    case GalaxyS: {
                        camera = this.AllocateGalaxySFrontCamera();
                        continue block6;
                    }
                    case HTCEvo: {
                        camera = this.AllocateEVOFrontFacingCamera();
                        continue block6;
                    }
                }
                if (Build.VERSION.SDK_INT > 8) {
                    camera = Camera.open((int)device.index);
                    continue;
                }
                camera = Camera.open();
            }
            if (camera == null) {
                return null;
            }
            return new VideoCaptureAndroid(id, context, camera, deviceToUse);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Camera.Parameters SearchOldFrontFacingCameras(AndroidVideoCaptureDevice newDevice) throws SecurityException, IllegalArgumentException, NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Camera camera = Camera.open();
        Camera.Parameters parameters = camera.getParameters();
        String cameraId = parameters.get("camera-id");
        if (cameraId != null && cameraId.equals("1")) {
            try {
                parameters.set("camera-id", 2);
                camera.setParameters(parameters);
                parameters = camera.getParameters();
                newDevice.frontCameraType = FrontFacingCameraType.GalaxyS;
                newDevice.orientation = 0;
                camera.release();
                return parameters;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        camera.release();
        File file = new File("/system/framework/com.htc.hardware.twinCamDevice.jar");
        boolean exists = file.exists();
        if (!exists) {
            file = new File("/system/framework/com.sprint.hardware.twinCamDevice.jar");
            exists = file.exists();
        }
        if (exists) {
            newDevice.frontCameraType = FrontFacingCameraType.HTCEvo;
            newDevice.orientation = 0;
            Camera evCamera = this.AllocateEVOFrontFacingCamera();
            parameters = evCamera.getParameters();
            evCamera.release();
            return parameters;
        }
        return null;
    }

    private Camera AllocateEVOFrontFacingCamera() throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        File mFilesDir;
        String classPath = null;
        File file = new File("/system/framework/com.htc.hardware.twinCamDevice.jar");
        classPath = "com.htc.hardware.twinCamDevice.FrontFacingCamera";
        boolean exists = file.exists();
        if (!exists) {
            file = new File("/system/framework/com.sprint.hardware.twinCamDevice.jar");
            classPath = "com.sprint.hardware.twinCamDevice.FrontFacingCamera";
            exists = file.exists();
        }
        if (!exists) {
            return null;
        }
        String dexOutputDir = "";
        if (this.context == null || (mFilesDir = new File(dexOutputDir = this.context.getFilesDir().getAbsolutePath(), "dexfiles")).exists() || !mFilesDir.mkdirs()) {
            // empty if block
        }
        dexOutputDir = dexOutputDir + "/dexfiles";
        DexClassLoader loader = new DexClassLoader(file.getAbsolutePath(), dexOutputDir, null, ClassLoader.getSystemClassLoader());
        Method method = loader.loadClass(classPath).getDeclaredMethod("getFrontFacingCamera", null);
        Camera camera = (Camera)method.invoke((Object)null, (Object[])null);
        return camera;
    }

    private Camera AllocateGalaxySFrontCamera() {
        Camera camera = Camera.open();
        Camera.Parameters parameters = camera.getParameters();
        parameters.set("camera-id", 2);
        camera.setParameters(parameters);
        return camera;
    }

    public class AndroidVideoCaptureDevice {
        public String deviceUniqueName;
        public CaptureCapabilityAndroid[] captureCapabilies;
        public FrontFacingCameraType frontCameraType = FrontFacingCameraType.None;
        public int orientation;
        public int index = 0;

        AndroidVideoCaptureDevice() {
        }
    }

    public static enum FrontFacingCameraType {
        None,
        GalaxyS,
        HTCEvo,
        Android23;

    }
}

