/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.CCP.phone.NativeInterface;
import com.hisun.phone.core.voice.DeviceListener;
import com.hisun.phone.core.voice.model.CCPParameters;
import com.hisun.phone.core.voice.model.NetworkStatistic;
import com.hisun.phone.core.voice.util.CheckApnTypeUtils;
import com.hisun.phone.core.voice.util.Log4Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VoiceUtil {
    public static final String CCP_DEFAULT_PACKAGE_NAME = "com.ccp.phone";
    public static final SimpleDateFormat TimestampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final TimeZone tz = TimeZone.getTimeZone("GMT+8:00");
    public static final Random rnd = new Random();
    private static String deviceNo = null;
    private static int mNetworkType = 0;
    private static final HashMap<String, String> sVersion = new HashMap();
    public static final String XMLHeader = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\t\n";
    private static String property = System.getProperty("line.separator");
    private static MessageDigest md;

    public static int creatRandom(int t) {
        return Math.abs(rnd.nextInt(t));
    }

    public static String getPropertyLine() {
        return property;
    }

    private VoiceUtil() {
    }

    public static String getRandomDeviceNo() {
        return VoiceUtil.md5(VoiceUtil.formatTimestamp(System.currentTimeMillis()) + VoiceUtil.getRandomNumber(6));
    }

    public static String getIMEI(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm == null || TextUtils.isEmpty((CharSequence)tm.getDeviceId())) {
            return "";
        }
        return tm.getDeviceId();
    }

    public static String getLocalMacAddressMd5(Context context) {
        return VoiceUtil.md5(VoiceUtil.getLocalMacAddress(context));
    }

    public static String getLocalMacAddress(Context context) {
        WifiManager wifi = (WifiManager)context.getSystemService("wifi");
        if (wifi == null || wifi.getConnectionInfo() == null || TextUtils.isEmpty((CharSequence)wifi.getConnectionInfo().getMacAddress())) {
            return "";
        }
        return wifi.getConnectionInfo().getMacAddress();
    }

    public static String getLastwords(String srcText, String p) {
        try {
            String[] array = TextUtils.split((String)srcText, (String)p);
            int index = array.length - 1 < 0 ? 0 : array.length - 1;
            return array[index];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] split(String original, String regex) {
        return VoiceUtil.split(original, regex, false);
    }

    public static String[] split(String original, String regex, boolean isTogether) {
        try {
            int startIndex = original.indexOf(regex);
            int index = 0;
            if (startIndex < 0) {
                return new String[]{original};
            }
            ArrayList<String> v = new ArrayList<String>();
            while (startIndex < original.length() && startIndex != -1) {
                String temp = original.substring(index, startIndex);
                v.add(temp);
                index = startIndex + regex.length();
                startIndex = original.indexOf(regex, startIndex + regex.length());
            }
            if (original.indexOf(regex, original.length() - regex.length()) < 0) {
                String last = original.substring(index);
                if (isTogether) {
                    last = regex + last;
                }
                v.add(last);
            }
            return v.toArray(new String[v.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String md5(String c) {
        if (md == null) {
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        if (md != null) {
            md.update(c.getBytes());
            return VoiceUtil.byte2hex(md.digest());
        }
        return "";
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
            if (n >= b.length - 1) continue;
            hs = new StringBuffer(String.valueOf(hs)).toString();
        }
        return hs.toUpperCase();
    }

    public static String formatTimestamp(long time) {
        return TimestampFormat.format(new Date(time));
    }

    public static boolean checkIPAddr(String ip) {
        if (ip == null || ip.length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        Matcher matcher = pattern.matcher(ip);
        return matcher.matches();
    }

    public static String getStandardMDN(String number) {
        if (number == null || number.length() == 0) {
            return null;
        }
        if (number.startsWith("0086") || number.startsWith("+86")) {
            return number;
        }
        return "0086" + number;
    }

    public static boolean isP2LCallNumnber(String number) {
        if (TextUtils.isEmpty((CharSequence)number)) {
            number = "";
        }
        return number.startsWith("0086") || number.startsWith("+86");
    }

    public static String getRandomNumber(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    public static String getFileNameNoEx(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static SIMProvider getSIMProvider(Context context) {
        try {
            SIMProvider providersName = SIMProvider.UNKNOWN;
            TelephonyManager mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
            String imsi = mTelephonyManager.getSubscriberId();
            if (imsi.startsWith("46000") || imsi.startsWith("46002")) {
                providersName = SIMProvider.CMCC;
            } else if (imsi.startsWith("46001")) {
                providersName = SIMProvider.UNICOM;
            } else if (imsi.startsWith("46003")) {
                providersName = SIMProvider.TELECOM;
            }
            Log4Util.i("SDK_DEVICE", "SIM Provider is: " + providersName.name());
            return providersName;
        }
        catch (Exception e) {
            Log4Util.i("SDK_DEVICE", "VoiceUtil.getSIMProvider " + e.getLocalizedMessage());
            return SIMProvider.UNKNOWN;
        }
    }

    public static String createDeviceNo(Context context) {
        try {
            if (deviceNo == null) {
                deviceNo = VoiceUtil.getLocalMacAddressMd5(context);
            }
            return deviceNo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return VoiceUtil.getRandomDeviceNo();
        }
    }

    public static String getTextReceiveDate(String time) {
        StringBuffer sbBuffer = new StringBuffer();
        sbBuffer.append(time.substring(0, 4) + "-");
        sbBuffer.append(time.substring(4, 6) + "-");
        sbBuffer.append(time.substring(6, 8) + " ");
        sbBuffer.append(time.substring(8, 10) + ":");
        sbBuffer.append(time.substring(10, 12) + ":");
        sbBuffer.append(time.substring(12, time.length()));
        return sbBuffer.toString();
    }

    public static String getPackageName(Context context) {
        String packageName = null;
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            packageName = info.packageName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty(packageName)) {
            packageName = CCP_DEFAULT_PACKAGE_NAME;
        }
        return packageName;
    }

    public static boolean isHeighVersion(int version) {
        return Build.VERSION.SDK_INT >= version;
    }

    public static String getDate(long time) {
        try {
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(time);
            return simpleFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isAvaiableSpace(int sizeMb) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            String sdcard = Environment.getExternalStorageDirectory().getPath();
            StatFs statFs = new StatFs(sdcard);
            long blockSize = statFs.getBlockSize();
            long blocks = statFs.getAvailableBlocks();
            long availableSpare = blocks * blockSize / 0x100000L;
            Log4Util.v("SDK_DEVICE", "The current sdcard of free space :" + availableSpare);
            return (long)sizeMb <= availableSpare;
        }
        Log4Util.v("SDK_DEVICE", "The current is not loaded sdcard");
        return false;
    }

    public static DeviceListener.APN checkNetworkAPNType(Context context) {
        return CheckApnTypeUtils.checkNetworkAPNType(context);
    }

    public static void setNetWorkType(int type) {
        mNetworkType = type;
    }

    public static boolean isNetWorkTypeWIFI() {
        return mNetworkType == 2;
    }

    public static int getNetWorkType() {
        return mNetworkType;
    }

    public static boolean isExistExternalStore() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getExternalStorePath() {
        if (VoiceUtil.isExistExternalStore()) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return null;
    }

    public static InputStream string2InputStream(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            return new ByteArrayInputStream(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeUrl(CCPParameters parameters) {
        if (parameters == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int loc = 0; loc < parameters.size(); ++loc) {
            String _key = parameters.getKey(loc);
            if ("Authorization".equals(_key)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            String _value = parameters.getValue(_key);
            if (_value == null) {
                Log4Util.i("SDK_DEVICE", "VoiceUtil.encodeUrl key:" + _key + " 's value is null");
            } else {
                try {
                    sb.append(URLEncoder.encode(parameters.getKey(loc), "UTF-8") + "=" + URLEncoder.encode(parameters.getValue(loc), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            Log4Util.i("SDK_DEVICE", "VoiceUtil.encodeUrl : " + sb.toString());
        }
        return sb.toString();
    }

    public static String encodeParameters(CCPParameters params) {
        if (params == null || VoiceUtil.isBundleEmpty(params)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int j = 0;
        for (int loc = 0; loc < params.size(); ++loc) {
            String key = params.getKey(loc);
            if (j != 0) {
                buf.append("&");
            }
            try {
                buf.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(params.getValue(key), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++j;
        }
        return buf.toString();
    }

    public static String buildRequestBody(CCPParameters params) {
        if (params == null || VoiceUtil.isBundleEmpty(params) || TextUtils.isEmpty((CharSequence)params.getParamerTagKey())) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (!"2013-03-22".equals("2013-12-26")) {
            buf.append(XMLHeader);
        }
        buf.append("<" + params.getParamerTagKey() + ">\t\n");
        for (int loc = 0; loc < params.size(); ++loc) {
            String key = params.getKey(loc);
            if ("Authorization".equals(key)) continue;
            if (!TextUtils.isEmpty((CharSequence)key) && key.equals(params.getParamerTagKey())) {
                buf.append(params.getValue(key));
                continue;
            }
            buf.append("\t<" + key + ">").append(params.getValue(key)).append("</" + key + ">\t\n");
        }
        buf.append("</" + params.getParamerTagKey() + ">\t\n");
        String requestBody = buf.toString();
        Log4Util.i("SDK_DEVICE", "doRequestUrl SDK request Body :\t\n" + requestBody);
        return requestBody;
    }

    private static boolean isBundleEmpty(CCPParameters bundle) {
        return bundle == null || bundle.size() == 0;
    }

    public static NetworkStatistic parserTrafficStats(String trafficStats) {
        try {
            int _duration = trafficStats.indexOf("<duration>");
            int _duration_ext = trafficStats.indexOf("</duration>");
            int _send = trafficStats.indexOf("<sendwifi>");
            int _send_ext = trafficStats.indexOf("</sendwifi>");
            int _recv = trafficStats.indexOf("<recvwifi>");
            int _recv_ext = trafficStats.indexOf("</recvwifi>");
            String duration = trafficStats.substring(_duration + 10, _duration_ext);
            String txBytes = trafficStats.substring(_send + 10, _send_ext);
            String rxBytes = trafficStats.substring(_recv + 10, _recv_ext);
            Log4Util.d("SDK_DEVICE", "call trafficStats duration:" + duration + " , txBytes :" + txBytes + " , rxBytes:" + rxBytes);
            return new NetworkStatistic(Long.parseLong(duration), Long.parseLong(txBytes), Long.parseLong(rxBytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new NetworkStatistic(0L, 0L, 0L);
        }
    }

    static void getSDKVersion() {
        String _version = VoiceUtil.getSoFullVersion();
        String[] _versions = _version.split("#");
        if (_versions == null) {
            return;
        }
        sVersion.put("version", _versions[0]);
        sVersion.put("platform", _versions[1]);
        sVersion.put("ARMVersion", _versions[2]);
        if (_versions[3].startsWith("voice")) {
            sVersion.put("audioSwitch", _versions[3].split("=")[1]);
        }
        if (_versions[4].startsWith("video")) {
            sVersion.put("videoSwitch", _versions[4].split("=")[1]);
        }
        sVersion.put("compileDate", _versions[5]);
        sVersion.put("full", _version);
    }

    public static String getVersoinString(String prefix) {
        if (sVersion.isEmpty()) {
            VoiceUtil.getSDKVersion();
        }
        return sVersion.get(prefix);
    }

    static String getSoFullVersion() {
        return NativeInterface.getVersion();
    }

    static {
        TimestampFormat.setTimeZone(tz);
        md = null;
    }

    public static enum SIMProvider {
        CMCC,
        UNICOM,
        TELECOM,
        UNKNOWN;

    }
}

