/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.util;

import android.util.Log;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class UDPSocketUtil {
    public static final String TAG = UDPSocketUtil.class.getSimpleName();
    public static final int INTERVAL = 20;
    private int timeout = 60000;
    private DatagramSocket socket;
    private boolean isReceiverStop = false;
    private boolean isSenderStop = false;
    private int localPort = 0;
    private Thread senderThread;
    private Thread receiverThread;
    public InetAddress ServerAddress;
    public int ServerPort;
    private final ConcurrentHashMap<String, Long> sendPacketMap = new ConcurrentHashMap();
    private int sendPacketCount = 0;
    private int recePacketCount = 0;
    private long minDelay = 32767L;
    private long maxDelay = 0L;
    private long sumDelay = 0L;
    private long starttime = 0L;
    private long endtime = 0L;
    private final byte[] sendBuffer = new byte[0];
    private final DatagramPacket dataPacket = new DatagramPacket(this.sendBuffer, 0);
    public static final SimpleDateFormat sequenceFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final String HOLDPLACE = UDPSocketUtil.nextHexString(49);
    public static int K = 1;
    public static final long seed = System.currentTimeMillis();
    private Runnable mSenderRunnable = new Runnable(){

        @Override
        public void run() {
            while (!UDPSocketUtil.this.isSenderStop && UDPSocketUtil.this.sendPacketCount < 1000) {
                try {
                    long t = System.currentTimeMillis();
                    String sendPacket = UDPSocketUtil.getSequenceFormat(t);
                    if (sendPacket == null) continue;
                    String messageid = sendPacket;
                    UDPSocketUtil.this.sendPacketMap.put(messageid, t);
                    Log.w((String)TAG, (String)(UDPSocketUtil.this.getFullTag("SenderRunnable") + "get send packet: \r\n" + messageid + "\r\n"));
                    byte[] buffer = messageid.getBytes();
                    UDPSocketUtil.this.dataPacket.setData(buffer);
                    UDPSocketUtil.this.dataPacket.setAddress(UDPSocketUtil.this.ServerAddress);
                    UDPSocketUtil.this.dataPacket.setPort(UDPSocketUtil.this.ServerPort);
                    UDPSocketUtil.this.socket.send(UDPSocketUtil.this.dataPacket);
                    Log.i((String)TAG, (String)(UDPSocketUtil.this.getFullTag("SenderRunnable") + "send over."));
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
                UDPSocketUtil.this.sendPacketCount++;
            }
            if (UDPSocketUtil.this.sendPacketCount == 1000) {
                UDPSocketUtil.this.stop();
                if (UDPSocketUtil.this.mListener != null) {
                    UDPSocketUtil.this.mListener.onSocketLayerComplete();
                }
            }
        }
    };
    private final byte[] receiveBuffer = new byte[4096];
    private Runnable mReceiverRunnable = new Runnable(){

        @Override
        public void run() {
            while (!UDPSocketUtil.this.isReceiverStop) {
                try {
                    DatagramPacket receivePacket = new DatagramPacket(UDPSocketUtil.this.receiveBuffer, UDPSocketUtil.this.receiveBuffer.length, Inet4Address.getLocalHost(), UDPSocketUtil.this.localPort);
                    UDPSocketUtil.this.socket.receive(receivePacket);
                    int receiveLength = receivePacket.getLength();
                    Log.w((String)TAG, (String)(UDPSocketUtil.this.getFullTag("ReceiverRunnable") + "received " + receiveLength + " bytes data from server."));
                    if (receiveLength <= 0) continue;
                    UDPSocketUtil.this.recePacketCount++;
                    byte[] b = new byte[receiveLength];
                    System.arraycopy(UDPSocketUtil.this.receiveBuffer, 0, b, 0, receiveLength);
                    byte[] data = (byte[])b.clone();
                    UDPSocketUtil.this.receive(data);
                }
                catch (SocketTimeoutException ste) {
                    Log.w((String)TAG, (String)(UDPSocketUtil.this.getFullTag("ReceiverRunnable") + "udp receiver thread wait " + UDPSocketUtil.this.timeout + "ms timeout."));
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    private onSocketLayerListener mListener;

    public UDPSocketUtil() {
        try {
            this.ServerAddress = InetAddress.getByName("42.121.115.160");
            this.ServerPort = 2009;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.init();
    }

    private void init() {
        try {
            if (this.socket == null) {
                this.socket = new DatagramSocket();
                this.localPort = this.socket.getLocalPort();
                Log.w((String)TAG, (String)(this.getFullTag("LocalPort") + this.localPort));
                this.socket.setSoTimeout(this.timeout);
                this.printSocket();
            } else {
                Log.w((String)TAG, (String)"Socket already init.");
            }
        }
        catch (SocketException se) {
            se.printStackTrace();
        }
        this.sendPacketCount = 0;
        this.recePacketCount = 0;
        this.minDelay = 32767L;
        this.maxDelay = 0L;
        this.sumDelay = 0L;
        this.starttime = 0L;
        this.endtime = 0L;
    }

    private void initWorkThread() {
        if (this.receiverThread == null) {
            this.receiverThread = new Thread(this.mReceiverRunnable);
        }
        this.receiverThread.start();
        if (this.senderThread == null) {
            this.senderThread = new Thread(this.mSenderRunnable);
        }
        this.senderThread.start();
    }

    public void start() {
        this.init();
        this.isReceiverStop = false;
        this.isSenderStop = false;
        this.initWorkThread();
        this.starttime = System.currentTimeMillis();
    }

    public void stop() {
        try {
            this.isReceiverStop = true;
            this.isSenderStop = true;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.senderThread != null && this.senderThread.isAlive()) {
                this.senderThread.interrupt();
            }
            if (this.receiverThread != null && this.receiverThread.isAlive()) {
                this.receiverThread.interrupt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.senderThread = null;
        this.receiverThread = null;
        this.endtime = System.currentTimeMillis();
        this.destroy();
    }

    static int nextInt(int n) {
        Random rand = new Random(seed);
        return Math.abs(rand.nextInt()) % n;
    }

    static String nextHexString(int len) {
        byte[] buff = new byte[len];
        for (int i = 0; i < len; ++i) {
            int n = UDPSocketUtil.nextInt(16);
            buff[i] = (byte)(n < 10 ? 48 + n : 87 + n);
        }
        return new String(buff);
    }

    static String getSequenceFormat(long t) {
        Date d = new Date(t);
        String date = sequenceFormat.format(d);
        return date + "$" + K++ + "%" + HOLDPLACE + "@" + t;
    }

    private boolean isExistInSendMapping(String packetKey) {
        if (this.sendPacketMap == null || packetKey == null) {
            return false;
        }
        if (this.sendPacketMap.containsKey(packetKey) && this.sendPacketMap.get(packetKey) != null) {
            long value = this.sendPacketMap.get(packetKey);
            long dt = System.currentTimeMillis() - value;
            this.sumDelay += dt;
            if (dt < this.minDelay) {
                this.minDelay = dt;
            }
            if (dt > this.maxDelay) {
                this.maxDelay = dt;
            }
            return true;
        }
        return false;
    }

    private void remove(String messageid) {
        this.sendPacketMap.remove(messageid);
    }

    private void receive(byte[] data) {
        try {
            String msgid = new String(data, 0, data.length);
            Log.i((String)TAG, (String)(this.getFullTag("receive") + "received content: \r\n" + msgid + "\r\n"));
            if (this.isExistInSendMapping(msgid)) {
                this.remove(msgid);
                Log.i((String)TAG, (String)(this.getFullTag("receive") + "remove key <" + msgid + "> from <sendPacketMap>."));
            } else {
                Log.w((String)TAG, (String)(this.getFullTag("receive") + "sendPacketMap key <" + msgid + "> not exist."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)e.toString());
        }
    }

    void printSocket() {
        if (this.socket != null) {
            Log.e((String)TAG, (String)"--------------------------------------------------------------------");
            Log.w((String)TAG, (String)("Socket - LocalPort: " + this.socket.getLocalPort()));
            Log.w((String)TAG, (String)("Socket - RemotePort: " + this.socket.getPort()));
            Log.w((String)TAG, (String)("Socket - isBind: " + this.socket.isBound()));
            Log.w((String)TAG, (String)("Socket - isClosed: " + this.socket.isClosed()));
            Log.w((String)TAG, (String)("Socket - isConnected: " + this.socket.isConnected()));
            Log.e((String)TAG, (String)"--------------------------------------------------------------------");
        }
    }

    private String getFullTag(String lastName) {
        return "[" + lastName + "] ";
    }

    private void destroy() {
        if (this.socket != null) {
            this.socket.disconnect();
            this.socket.close();
            this.socket = null;
        }
        this.sendPacketMap.clear();
        this.mListener = null;
    }

    public long getMinDelay() {
        return this.minDelay;
    }

    public void setMinDelay(long minDelay) {
        this.minDelay = minDelay;
    }

    public long getMaxDelay() {
        return this.maxDelay;
    }

    public void setMaxDelay(long maxDelay) {
        this.maxDelay = maxDelay;
    }

    public long getStarttime() {
        return this.starttime;
    }

    public void setStarttime(long starttime) {
        this.starttime = starttime;
    }

    public long getEndtime() {
        return this.endtime;
    }

    public void setEndtime(long endtime) {
        this.endtime = endtime;
    }

    public int getSendPacketCount() {
        return this.sendPacketCount;
    }

    public void setSendPacketCount(int sendPacketCount) {
        this.sendPacketCount = sendPacketCount;
    }

    public int getRecePacketCount() {
        return this.recePacketCount;
    }

    public void setRecePacketCount(int recePacketCount) {
        this.recePacketCount = recePacketCount;
    }

    public long getSumDelay() {
        return this.sumDelay;
    }

    public void setSumDelay(long sumDelay) {
        this.sumDelay = sumDelay;
    }

    public void setonSocketLayerListener(onSocketLayerListener listener) {
        this.mListener = listener;
    }

    public static interface onSocketLayerListener {
        public void onSocketLayerComplete();
    }
}

