/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.sound;

import android.content.Context;
import com.hisun.phone.core.voice.multimedia.MediaManager;
import com.hisun.phone.core.voice.sound.PlayManager;
import com.hisun.phone.core.voice.sound.SoundPoolLoadThread;
import com.hisun.phone.core.voice.util.Log4Util;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class SoundPool {
    private final Map<Integer, Sound> sounds = new HashMap<Integer, Sound>();
    private final Queue<LoadRequest> loadQueue = new LinkedList<LoadRequest>();
    private Thread loadThread;
    private int lastSoundId;
    public static final int INVALID_STREAM_ID = 0;
    private final Listener listener;
    private PlayManager mPlayManager = null;
    private boolean vibrate = true;

    public SoundPool(Listener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int load(Context context, String resName, String path) {
        int soundId;
        SoundPool soundPool = this;
        synchronized (soundPool) {
            ++this.lastSoundId;
            soundId = this.lastSoundId++;
            if (soundId == 0) {
                soundId = this.lastSoundId;
            }
        }
        Sound sound = new Sound(soundId);
        LoadRequest req = new LoadRequest(sound, context, resName, path);
        Object object = this.sounds;
        synchronized (object) {
            this.sounds.put(soundId, sound);
        }
        object = this.loadQueue;
        synchronized (object) {
            this.loadQueue.offer(req);
        }
        return this.startLoadThread(context, soundId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startLoadThread(Context context, int soundId) {
        SoundPool soundPool = this;
        synchronized (soundPool) {
            if (!(soundId == 0 || this.loadThread != null && this.loadThread.isAlive())) {
                this.loadThread = new SoundPoolLoadThread(this.loadQueue, this.listener);
                this.loadThread.start();
            }
        }
        return soundId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reLoad(Context context, MediaManager.StockSound stockSound, String path) {
        LoadRequest req = null;
        int soundid = stockSound.getSoundId();
        Sound sound = null;
        Object object = this.sounds;
        synchronized (object) {
            sound = this.sounds.get(stockSound.getSoundId());
        }
        if (sound == null) {
            soundid = ++this.lastSoundId;
            sound = new Sound(soundid);
        }
        req = new LoadRequest(sound, context, stockSound.getResName(), path);
        object = this.loadQueue;
        synchronized (object) {
            this.loadQueue.offer(req);
        }
        return this.startLoadThread(context, stockSound.getSoundId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(int soundId) {
        Object object = this.loadQueue;
        synchronized (object) {
            for (LoadRequest req : this.loadQueue) {
                if (req.sound.soundId != soundId) continue;
                this.loadQueue.remove(req);
                break;
            }
        }
        object = this.sounds;
        synchronized (object) {
            this.sounds.remove(soundId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int play(Context context, int soundId, boolean loop, long duration) {
        Sound sound = null;
        Object object = this.sounds;
        synchronized (object) {
            sound = this.sounds.get(soundId);
        }
        if (sound == null || sound.path == null || sound.state == Sound.State.FAILED) {
            return 0;
        }
        Log4Util.d("[SoundPool] play = " + (Object)((Object)sound.state));
        object = this;
        synchronized (object) {
            try {
                if (this.mPlayManager == null || !this.mPlayManager.isPlaying()) {
                    this.mPlayManager = new PlayManager(context);
                    this.mPlayManager.playMedia(loop, duration, this.vibrate, sound, this.listener);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.listener.onPlayComplete(sound.soundId);
            }
        }
        return sound.soundId;
    }

    public void setIncomingVibrate(boolean vibrate) {
        this.vibrate = vibrate;
    }

    public void stop() {
        if (this.mPlayManager != null) {
            this.mPlayManager.stopMedia();
            this.mPlayManager = null;
        }
    }

    public void release() {
        if (this.loadThread != null && this.loadThread.isAlive()) {
            this.loadThread.interrupt();
            try {
                this.loadThread.join(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.loadThread = null;
        }
        if (this.sounds != null) {
            this.sounds.clear();
        }
        if (this.mPlayManager != null) {
            this.mPlayManager.stopMedia();
        }
        this.loadQueue.clear();
    }

    protected void finalize() {
        this.release();
    }

    public static interface Listener {
        public void onLoadComplete(int var1);

        public void onPlayComplete(int var1);

        public void onLoadFailed(int var1);
    }

    static class Sound {
        final int soundId;
        State state = State.UNLOADED;
        String path = null;

        Sound(int soundId) {
            this.soundId = soundId;
        }

        static enum State {
            UNLOADED,
            READY,
            FAILED;

        }
    }

    static class LoadRequest {
        final Sound sound;
        final Context context;
        final String resName;
        final String path;

        LoadRequest(Sound sound, Context context, String resName, String path) {
            this.sound = sound;
            this.context = context;
            this.resName = resName;
            this.path = path;
        }
    }
}

