/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.net;

import android.text.TextUtils;
import com.hisun.phone.core.voice.exception.CCPException;
import com.hisun.phone.core.voice.exception.CCPHttpException;
import com.hisun.phone.core.voice.model.CCPParameters;
import com.hisun.phone.core.voice.util.CheckApnTypeUtils;
import com.hisun.phone.core.voice.util.Cryptos;
import com.hisun.phone.core.voice.util.Log4Util;
import com.hisun.phone.core.voice.util.VoiceUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class HttpManager {
    private static final String TAG = "HttpManager";
    public static final String HTTPMETHOD_GET = "GET";
    public static final String HTTPMETHOD_POST = "POST";
    private static final String BOUNDARY = HttpManager.getBoundry();
    private static final String MP_BOUNDARY = "--" + BOUNDARY;
    private static final String END_MP_BOUNDARY = "--" + BOUNDARY + "--";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static int sslPort = 0;
    public static final int SKIP_CACHE_NUM = 128;
    private static final int SET_CONNECTION_TIMEOUT = 45000;
    private static final int SET_SOCKET_TIMEOUT = 30000;

    static HttpClient getNewHttpClient() {
        return HttpManager.newHttpClient();
    }

    static HttpClient newHttpClient() {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            SSLSocketFactoryEx sf = new SSLSocketFactoryEx(trustStore);
            sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)10000);
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)sf, sslPort <= 0 ? 8883 : sslPort));
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)45000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)30000);
            return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
        }
        catch (Exception e) {
            Log4Util.e("SDK_DEVICE", e.toString());
            return new DefaultHttpClient();
        }
    }

    private static String stringFromInputStream(InputStream is) throws IOException {
        char[] buf = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, "UTF-8");
        int bin = 0;
        while ((bin = ((Reader)in).read(buf, 0, buf.length)) >= 0) {
            out.append(buf, 0, bin);
        }
        ((Reader)in).close();
        return out.toString();
    }

    public static String httpGet(String url, HashMap<String, String> headers) throws Exception {
        HttpClient httpClient = HttpManager.getNewHttpClient();
        HttpGet request = new HttpGet(url);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            request.setHeader(key, value);
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Log4Util.d(TAG, "httpGet success.");
                return HttpManager.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    public static String httpPost(String url, HashMap<String, String> headers, String requestBody) throws Exception {
        HttpResponse response;
        HttpClient httpClient = HttpManager.getNewHttpClient();
        HttpPost httpRequest = new HttpPost(url);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            httpRequest.setHeader(key, value);
        }
        if (requestBody != null) {
            ByteArrayEntity entity = new ByteArrayEntity(requestBody.getBytes());
            Log4Util.d("SDK_DEVICE", requestBody);
            httpRequest.setEntity((HttpEntity)entity);
        }
        if ((response = httpClient.execute((HttpUriRequest)httpRequest)) != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            Log4Util.d("SDK_DEVICE", "httpPost request return " + statusCode);
            if (statusCode == 200) {
                return HttpManager.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    public static String httpPost(String url) throws Exception {
        HttpPost httpRequest;
        HttpClient httpClient = HttpManager.getNewHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)(httpRequest = new HttpPost(url)));
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            Log4Util.d("SDK_DEVICE", "httpPost request return " + statusCode);
            if (statusCode == 200) {
                return HttpManager.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    public static String httpUploadFile(String url, HashMap<String, String> headers, byte[] requestBody) throws Exception {
        HttpClient httpClient = HttpManager.getNewHttpClient();
        HttpPost httpRequest = new HttpPost(url);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            httpRequest.setHeader(key, value);
        }
        ByteArrayEntity entity = new ByteArrayEntity(requestBody);
        Log4Util.d("SDK_DEVICE", requestBody.toString());
        httpRequest.setEntity((HttpEntity)entity);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            Log4Util.w("SDK_DEVICE", "httpPost request return " + statusCode);
            if (statusCode == 200) {
                return HttpManager.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    public static int getSSLPort() {
        return sslPort;
    }

    public static void setSSLPort(int port) {
        sslPort = port;
        Log4Util.d("SDK_DEVICE", "HttpHelper ssl port: " + sslPort);
    }

    public static boolean httpDowload(String url, String svaePath) throws Exception {
        HttpClient httpClient = HttpManager.getNewHttpClient();
        HttpGet request = new HttpGet(url);
        String fileName = url.substring(url.lastIndexOf("/") + 1, url.length());
        if (fileName == null) {
            throw new Exception("This download url is invalid.");
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Log4Util.w(TAG, "dowload file from " + url + " success.");
                return HttpManager.saveFromInputStream(response.getEntity().getContent(), svaePath);
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    public static int httpDowloadFile(String url, String svaePath) throws Exception {
        HttpClient httpClient = HttpManager.getNewHttpClient();
        HttpGet request = new HttpGet(url);
        String fileName = url.substring(url.lastIndexOf("/") + 1, url.length());
        if (fileName == null) {
            throw new Exception("This download url is invalid.");
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Log4Util.w(TAG, "dowload file from " + url + " success.");
                boolean result = HttpManager.saveFromInputStream(response.getEntity().getContent(), svaePath);
                return result ? 0 : 170011;
            }
            if (statusCode == 404) {
                return 170017;
            }
            Log4Util.d("SDK_DEVICE", "Got error code " + statusCode + " from server.");
            return statusCode;
        }
        throw new Exception("Unable to connect to server.");
    }

    private static boolean saveFromInputStream(InputStream content, String fileName) {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            byte[] b = new byte[131072];
            int len = 0;
            while ((len = content.read(b)) != -1) {
                out.write(b, 0, len);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String httpPut(String url, HashMap<String, String> headers, String requestBody) throws Exception {
        HttpClient httpClient = HttpManager.getNewHttpClient();
        HttpPut httpRequest = new HttpPut(url);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            httpRequest.setHeader(key, value);
        }
        ByteArrayEntity entity = new ByteArrayEntity(requestBody.getBytes());
        Log4Util.d("SDK_DEVICE", requestBody);
        httpRequest.setEntity((HttpEntity)entity);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            Log4Util.w("SDK_DEVICE", "HttpPut request return " + statusCode);
            if (statusCode == 200) {
                return HttpManager.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    public static String doRequestPostUrl(String url, CCPParameters params) throws CCPException {
        return HttpManager.doRequestUrl(url, HTTPMETHOD_POST, params);
    }

    public static String doRequestUrl(String url, String method, CCPParameters params) throws CCPException {
        return HttpManager.doRequestUrl(url, method, params, null, false);
    }

    public static String doRequestUrl(String url, String method, CCPParameters params, boolean encrypt) throws CCPException {
        return HttpManager.doRequestUrl(url, method, params, null, encrypt);
    }

    public static String doRequestUrl(String url, String method, CCPParameters params, String file, boolean encrypt) throws CCPException {
        String result = "";
        try {
            HttpClient client = HttpManager.getNewHttpClient();
            HttpDelete request = null;
            ByteArrayOutputStream bos = null;
            client.getParams().setParameter("http.route.default-proxy", (Object)CheckApnTypeUtils.getHttpHost());
            if (method.equals(HTTPMETHOD_GET)) {
                if (params.size() > 1) {
                    url = url + "?" + VoiceUtil.encodeUrl(params);
                }
                Log4Util.w("SDK_DEVICE", "doRequestUrl SDK request Url : \t\n" + url);
                HttpGet get = new HttpGet(url);
                request = get;
            } else if (method.equals(HTTPMETHOD_POST)) {
                String _sig = params.getValue("sig");
                if (!TextUtils.isEmpty((CharSequence)_sig)) {
                    params.remove("sig");
                    url = url + "?sig=" + _sig;
                }
                Log4Util.w("SDK_DEVICE", "doRequestUrl SDK request Url : \t\n" + url);
                HttpPost post = new HttpPost(url);
                request = post;
                byte[] data = null;
                String _contentType = params.getValue("content-type");
                bos = new ByteArrayOutputStream();
                if (!TextUtils.isEmpty((CharSequence)file)) {
                    HttpManager.paramToUpload(bos, params);
                    post.setHeader("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                    HttpManager.imageContentToUpload(bos, file);
                } else {
                    if (_contentType != null) {
                        params.remove("content-type");
                        post.setHeader("Content-Type", _contentType);
                    } else {
                        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                    String postParam = VoiceUtil.buildRequestBody(params);
                    if (encrypt) {
                        postParam = Cryptos.toBase64QES("06dc87af5f37a004da50ceeb32a1b9c7", postParam);
                    }
                    data = postParam.getBytes("UTF-8");
                    bos.write(data);
                }
                data = bos.toByteArray();
                bos.close();
                ByteArrayEntity formEntity = new ByteArrayEntity(data);
                post.setEntity((HttpEntity)formEntity);
            } else if (method.equals("DELETE")) {
                request = new HttpDelete(url);
            }
            HttpManager.buildHttpRequestHeader(params, request);
            HttpResponse response = client.execute((HttpUriRequest)request);
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode != 200) {
                result = HttpManager.readHttpResponse(response);
                throw new CCPHttpException(result, statusCode);
            }
            result = HttpManager.readHttpResponse(response);
            return result;
        }
        catch (ConnectTimeoutException e) {
            throw new CCPHttpException(e.getMessage(), 170019);
        }
        catch (IOException e) {
            throw new CCPHttpException(e.getMessage(), 170005);
        }
        catch (Exception e) {
            throw new CCPException();
        }
    }

    private static void buildHttpRequestHeader(CCPParameters params, HttpUriRequest request) {
        String _authorization = params.getValue("Authorization");
        if (!TextUtils.isEmpty((CharSequence)_authorization)) {
            request.setHeader("Accept", "application/xml");
            request.setHeader("Content-Type", "application/xml;charset=utf-8");
            request.setHeader("Authorization", _authorization);
        }
    }

    public static String doUploadFile(String url, String method, CCPParameters params, String file) throws CCPException {
        String result = "";
        try {
            HttpClient client = HttpManager.getNewHttpClient();
            HttpPost request = null;
            ByteArrayOutputStream bos = null;
            client.getParams().setParameter("http.route.default-proxy", (Object)CheckApnTypeUtils.getHttpHost());
            if (method.equals(HTTPMETHOD_GET)) {
                url = url + "?" + VoiceUtil.encodeUrl(params);
                HttpGet get = new HttpGet(url);
                request = get;
            } else if (method.equals(HTTPMETHOD_POST)) {
                HttpPost post;
                request = post = new HttpPost(url);
                byte[] data = null;
                String _contentType = params.getValue("content-type");
                bos = new ByteArrayOutputStream();
                if (!TextUtils.isEmpty((CharSequence)file)) {
                    HttpManager.paramToUpload(bos, params);
                    post.setHeader("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                    HttpManager.fileToUpload(bos, file);
                } else {
                    if (_contentType != null) {
                        params.remove("content-type");
                        post.setHeader("Content-Type", _contentType);
                    } else {
                        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                    String postParam = VoiceUtil.encodeParameters(params);
                    data = postParam.getBytes("UTF-8");
                    bos.write(data);
                }
                data = bos.toByteArray();
                bos.close();
                ByteArrayEntity formEntity = new ByteArrayEntity(data);
                post.setEntity((HttpEntity)formEntity);
            } else if (method.equals("DELETE")) {
                request = new HttpDelete(url);
            }
            HttpResponse response = client.execute((HttpUriRequest)request);
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode != 200) {
                result = HttpManager.readHttpResponse(response);
                throw new CCPHttpException(result, statusCode);
            }
            result = HttpManager.readHttpResponse(response);
            return result;
        }
        catch (IOException e) {
            throw new CCPException(e);
        }
    }

    private static void paramToUpload(OutputStream baos, CCPParameters params) throws CCPException {
        String key = "";
        for (int loc = 0; loc < params.size(); ++loc) {
            key = params.getKey(loc);
            StringBuilder temp = new StringBuilder(10);
            temp.setLength(0);
            temp.append(MP_BOUNDARY).append("\r\n");
            temp.append("content-disposition: form-data; name=\"").append(key).append("\"\r\n\r\n");
            temp.append(params.getValue(key)).append("\r\n");
            byte[] res = temp.toString().getBytes();
            try {
                baos.write(res);
                continue;
            }
            catch (IOException e) {
                throw new CCPException(e);
            }
        }
    }

    private static void imageContentToUpload(OutputStream out, String imgpath) throws CCPException {
        if (imgpath == null) {
            return;
        }
        StringBuilder temp = new StringBuilder();
        temp.append(MP_BOUNDARY).append("\r\n");
        temp.append("Content-Disposition: form-data; name=\"pic\"; filename=\"").append("news_image").append("\"\r\n");
        String filetype = "image/png";
        temp.append("Content-Type: ").append(filetype).append("\r\n\r\n");
        byte[] res = temp.toString().getBytes();
        FileInputStream input = null;
        try {
            int count;
            out.write(res);
            input = new FileInputStream(imgpath);
            byte[] buffer = new byte[51200];
            while ((count = input.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
            out.write("\r\n".getBytes());
            out.write(("\r\n" + END_MP_BOUNDARY).getBytes());
        }
        catch (IOException e) {
            throw new CCPException(e);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new CCPException(e);
                }
            }
        }
    }

    private static void fileToUpload(OutputStream out, String filepath) throws CCPException {
        if (filepath == null) {
            return;
        }
        StringBuilder temp = new StringBuilder();
        temp.append(MP_BOUNDARY).append("\r\n");
        temp.append("content-disposition: form-data; name=\"file\"; filename=\"").append(filepath).append("\"\r\n");
        temp.append("Content-Type: application/octet-stream; charset=utf-8\r\n\r\n");
        byte[] res = temp.toString().getBytes();
        FileInputStream input = null;
        try {
            int count;
            out.write(res);
            input = new FileInputStream(filepath);
            byte[] buffer = new byte[51200];
            while ((count = input.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
            out.write("\r\n".getBytes());
            out.write(("\r\n" + END_MP_BOUNDARY).getBytes());
        }
        catch (IOException e) {
            throw new CCPException(e);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new CCPException(e);
                }
            }
        }
    }

    private static String readHttpResponse(HttpResponse response) {
        String result = "";
        HttpEntity entity = response.getEntity();
        try {
            InputStream inputStream = entity.getContent();
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            Header header = response.getFirstHeader("Content-Encoding");
            if (header != null && header.getValue().toLowerCase().indexOf("gzip") > -1) {
                inputStream = new GZIPInputStream(inputStream);
            }
            int readBytes = 0;
            byte[] sBuffer = new byte[512];
            while ((readBytes = inputStream.read(sBuffer)) != -1) {
                content.write(sBuffer, 0, readBytes);
            }
            result = new String(content.toByteArray(), "UTF-8");
            Log4Util.w("SDK_DEVICE", "Response body :\r\n" + result + "\r\n");
            return result;
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    static String getBoundry() {
        StringBuffer _sb = new StringBuffer();
        for (int t = 1; t < 12; ++t) {
            long time = System.currentTimeMillis() + (long)t;
            if (time % 3L == 0L) {
                _sb.append((char)time % 9);
                continue;
            }
            if (time % 3L == 1L) {
                _sb.append((char)(65L + time % 26L));
                continue;
            }
            _sb.append((char)(97L + time % 26L));
        }
        return _sb.toString();
    }

    static class SSLSocketFactoryEx
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        public SSLSocketFactoryEx(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

