/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.multimedia.Suppressor;

import android.media.AudioRecord;
import android.os.Build;
import com.hisun.phone.core.voice.multimedia.Suppressor.CCPAcousticEchoCanceler;
import com.hisun.phone.core.voice.multimedia.Suppressor.CCPAutomaticGainControl;
import com.hisun.phone.core.voice.multimedia.Suppressor.CCPNoiseSuppressor;
import com.hisun.phone.core.voice.util.Log4Util;
import com.hisun.phone.core.voice.util.VoiceUtil;

public class AudioPreProcess {
    private CCPAcousticEchoCanceler mEchoCanceler = null;
    private CCPAutomaticGainControl mGainControl = null;
    private CCPNoiseSuppressor mNoiseSuppressor = null;
    private volatile boolean isEnable = false;

    public boolean init(AudioRecord audioRecord) {
        Log4Util.i("SDK_DEVICE", "[AudioPreProcess - init] The current SDK version number " + Build.VERSION.SDK_INT);
        if (VoiceUtil.isHeighVersion(16)) {
            if (audioRecord == null) {
                Log4Util.i("SDK_DEVICE", "[AudioPreProcess - init] AudioRecord is " + audioRecord);
            } else {
                this.mEchoCanceler = new CCPAcousticEchoCanceler(audioRecord);
                if (this.mEchoCanceler != null && this.mEchoCanceler.isAvailable() && !this.isEnable) {
                    this.mEchoCanceler.setEnable();
                    this.isEnable = true;
                }
                if (this.mGainControl != null && this.mGainControl.isAvailable() && this.isEnable) {
                    this.mGainControl.setEnable();
                    this.isEnable = true;
                }
                if (this.mNoiseSuppressor != null && this.mNoiseSuppressor.isAvailable() && this.isEnable) {
                    this.mNoiseSuppressor.setEnable();
                    this.isEnable = true;
                }
            }
        }
        return this.isEnable;
    }
}

