/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import com.CCP.phone.CCPCallEvent;
import com.CCP.phone.CameraInfo;
import com.CCP.phone.NativeInterface;
import com.hisun.phone.core.voice.AbstractDispatcher;
import com.hisun.phone.core.voice.Device;
import com.hisun.phone.core.voice.model.DownloadInfo;
import com.hisun.phone.core.voice.model.setup.UserAgentConfig;
import com.hisun.phone.core.voice.model.videoconference.VideoPartnerPortrait;
import com.hisun.phone.core.voice.net.HttpManager;
import com.hisun.phone.core.voice.opts.ConferenceOptions;
import com.hisun.phone.core.voice.util.Log4Util;
import com.hisun.phone.core.voice.util.VoiceUtil;
import java.io.Serializable;
import java.util.ArrayList;

public final class CallControlManager
extends AbstractDispatcher {
    private static CallControlManager instance;
    private static final int EVENT_MESSAGE = 0;
    public static final int EVENT_CONNECT = 1;
    private static final int EVENT_DISCONNECT = 2;
    private static final int EVENT_CALL = 3;
    private static final int EVENT_DTMF_RECEIVED = 4;
    private static final int EVENT_GET_CAPABILITY_TOKEN = 5;
    private static final int EVENT_LOG_INFO = 6;
    private static final int EVENT_MESSAGE_REPORT = 7;
    private static final int EVENT_GENERAL = 8;
    private static final int EVENT_STATE_CALL_VIDEO_RATIO = 18;
    @Deprecated
    private static final int EVENT_DELIVER_VIDEO_FRAME = 10;
    private static final int EVENT_RECORD_CALL_VOICE = 11;
    private static final int EVENT_AUDIO_DATA_PROCESS = 12;
    private static final int EVENT_TRANSFER_STATE_STATE_SUCCESS = 13;
    private static final int EVENT_ORIGINAL_AUDIO_DATA_PROCESS = 14;
    private static final int EVENT_REQUEST_VIDEO_RESULT = 15;
    private static final int EVENT_ENABLE_SRTP = 16;
    private static final int EVENT_STOP_VIDEO_RESPONSE = 17;
    private static final int GENERAL_EVENT_STATE_EARLYMEDIA = 0;
    private static final int GENERAL_EVENT_STATE_MESSAGE_COMMAND = 1;
    private static final int GENERAL_EVENT_STATE_REMOTE_VIDEO_RATIO = 2;
    private static final int GENERAL_EVENT_STATE_MEDIA_INIT_FAILED = 3;
    private static final int GENERAL_EVENT_STATE_AUDIOD_ESTINATION = 4;
    private static final int GENERAL_EVENT_STATE_VIDEOD_ESTINATION = 5;
    private static final int CALL_STATE_MAKE_CALL_FAILED = 1;
    private static final int CALL_STATE_CALL_INCOMING = 2;
    private static final int CALL_STATE_CALL_ALERTING = 3;
    private static final int CALL_STATE_CALL_ANSWERED = 4;
    private static final int CALL_STATE_CALL_PAUSED = 5;
    private static final int CALL_STATE_CALL_REMOTE_PAUSED = 6;
    private static final int CALL_STATE_CALL_RELEASED = 7;
    private static final int CALL_STATE_CALL_TRANSFERRED = 8;
    private static final int CALL_STATE_CALL_VIDEO = 9;
    private static final int CALL_STATE_CALL_PROCEEDING = 10;
    private static final int CALL_STATE_CALL_VIDEO_UPDATE_REQUEST = 11;
    private static final int CALL_STATE_CALL_VIDEO_UPDATE_RESPONSE = 12;

    private CallControlManager(Context context) {
        super(context);
        Log4Util.v("SDK_DEVICE", "constructor thread: " + Thread.currentThread().getName());
        this.setTraceFlag(true);
        NativeInterface.setCallBackParams(this, "eventCallBack", "(ILjava/lang/String;[BI)Ljava/lang/Object;");
        NativeInterface.setAudioContext(context);
        NativeInterface.initialize();
        NativeInterface.setLogLevel(2);
        NativeInterface.AmrNBCreateEnc();
        NativeInterface.AmrNBEncoderInit(0);
        NativeInterface.setDtxEnabled(true);
        NativeInterface.setAudioConfig(Device.AudioType.AUDIO_EC.getValue(), true, Device.AudioMode.kEcConference.getValue());
    }

    public static CallControlManager initialize(Context context) {
        if (instance == null) {
            instance = new CallControlManager(context);
        }
        return instance;
    }

    void init(CCPCallEvent listener, UserAgentConfig userAgent) throws Exception {
        Log4Util.d("SDK_DEVICE", "init thread: " + Thread.currentThread().getName());
        this.setSSLPort(userAgent.getUa_port());
        this.setListener(listener);
        this.setUserAgentConfig(userAgent);
        this.setUserData(1, userAgent.getUa());
        Log4Util.e("SDK_DEVICE", "get storage path: " + Environment.getExternalStorageDirectory().getAbsolutePath() + " canwrite:" + Environment.getExternalStorageDirectory().canWrite());
        if (!userAgent.getPassword().isEmpty()) {
            NativeInterface.connectToCCP(userAgent.getUa_server(), userAgent.getUa_port(), userAgent.getSid(), userAgent.getPassword(), "");
        } else {
            this.doQuerySoftSwitchAddress(userAgent.getPrivateCloud(), userAgent.getSid(), userAgent.getSubaccountid(), userAgent.getSubpassword());
        }
    }

    public Object eventCallBack(int event, String id, byte[] message, int state) {
        if (message != null) {
            Log4Util.d("SDK_DEVICE", "[CallControllerManager - eventCallBack] event\uff1a " + event + " , length : " + message.length + " ,state: " + state);
        }
        try {
            Log4Util.d("SDK_DEVICE", "[CallControllerManager - eventCallBack]  event: " + event + ", id: " + id + ", message: " + (message != null ? new String(message) : null) + ", state: " + state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (event) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 12: {
                return this.OnCallProcessDataEvent(message, state);
            }
            case 14: {
                this.OnProcessOriginalDataEvent(message);
                break;
            }
            case 15: {
                this.getListener().onRequestConferenceMemberVideoFailed(state, id, new String(message));
                break;
            }
            case 17: {
                this.getListener().onCancelConferenceMemberVideo(state, id, new String(message));
                break;
            }
            case 16: {
                this.getListener().OnTriggerSrtp(id, state == 1);
                break;
            }
            case 13: {
                this.getListener().onTransferStateSucceed(id, state == 1);
                break;
            }
            default: {
                if (message == null) {
                    this.callbackEvent(event, id, null, state);
                    return null;
                }
                this.callbackEvent(event, id, new String(message), state);
            }
        }
        return null;
    }

    public void _eventCallBack(int event, String id, String message, int state) {
        Log4Util.d("SDK_DEVICE", "[CallControllerManager - eventCallBack]  event: " + event + ", id: " + id + ", message: " + message + ", state: " + state);
        switch (event) {
            case 6: {
                if (this.getListener() == null) break;
                break;
            }
            case 5: {
                Log4Util.d("SDK_DEVICE", "[CallControllerManager - eventCallBack]  event: " + event + ", id: " + id + ", message: " + message + ", state: " + state);
                break;
            }
            default: {
                this.callbackEvent(event, id, message, state);
            }
        }
    }

    private void callbackEvent(int event, String id, String message, int state) {
        try {
            switch (event) {
                case 0: {
                    this.getListener().onTextMessageReceived(id, message);
                    break;
                }
                case 1: {
                    if (state == 0) {
                        this.getListener().onConnected();
                        this.checkSimState();
                        break;
                    }
                    this.getListener().onConnectError(state);
                    break;
                }
                case 2: {
                    this.getListener().onDisconnect();
                    break;
                }
                case 3: {
                    this.onCallEvent(id, message, state);
                    break;
                }
                case 4: {
                    this.getListener().onDtmfReceived(id, (char)state);
                    break;
                }
                case 7: {
                    if (TextUtils.isEmpty((CharSequence)message)) {
                        this.getListener().onMessageSendReport(id, state);
                        break;
                    }
                    this.getListener().onMessageSendReport(id, VoiceUtil.getTextReceiveDate(message), state);
                    break;
                }
                case 8: {
                    this.onGeneralEvent(id, message, state);
                    break;
                }
                case 18: {
                    if (this.getListener() == null) {
                        return;
                    }
                    this.getListener().onCallVideoRatioChanged(id, message.substring(message.indexOf("0:") + 1, message.length()), state);
                    break;
                }
                case 11: {
                    if (this.getListener() == null) break;
                    this.getListener().onCallRecord(id, message, state);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onGeneralEvent(String callid, String message, int state) throws Exception {
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                byte[] data = new byte[8];
                System.arraycopy(message.getBytes(), 0, data, 0, data.length);
                message = this.formatXml(message);
                this.getListener().onPushMessageArrived(message);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.getListener().onCallMediaInitFailed(callid, Integer.parseInt(message.substring(0, message.indexOf(":"))));
                break;
            }
            case 4: 
            case 5: {
                this.getListener().onFirewallPolicyEnabled();
                break;
            }
        }
    }

    private void onCallEvent(String callid, String message, int state) throws Exception {
        switch (state) {
            case 1: {
                this.getListener().onMakeCallFailed(callid, Integer.parseInt(message));
                break;
            }
            case 2: 
            case 9: {
                this.getListener().onIncomingCallReceived(state == 9 ? Device.CallType.VIDEO : Device.CallType.VOICE, callid, message);
                break;
            }
            case 3: {
                this.getListener().onCallAlerting(callid);
                break;
            }
            case 4: {
                this.getListener().onCallAnswered(callid);
                break;
            }
            case 5: {
                this.getListener().onCallPaused(callid);
                break;
            }
            case 6: {
                this.getListener().onCallPausedByRemote(callid);
                break;
            }
            case 7: {
                this.getListener().onCallReleased(callid);
                break;
            }
            case 8: {
                this.getListener().onCallTransfered(callid, message);
                break;
            }
            case 10: {
                this.getListener().onCallProceeding(callid);
                break;
            }
            case 11: {
                this.getListener().onCallMediaUpdateRequest(callid, Integer.parseInt(message));
                break;
            }
            case 12: {
                this.getListener().onCallMediaUpdateResponse(callid, Integer.parseInt(message));
                break;
            }
        }
    }

    private Object OnCallProcessDataEvent(byte[] message, int state) {
        long currentTimeMillis = System.currentTimeMillis();
        byte[] onCallProcessData = this.getListener().onCallProcessData(message, state);
        Log4Util.v("SDK_DEVICE", "[CallControlManager - OnCallProcessDataEvent]CallProcess time:" + (System.currentTimeMillis() - currentTimeMillis) + "mils");
        if (onCallProcessData == null) {
            return message;
        }
        return onCallProcessData;
    }

    private void OnProcessOriginalDataEvent(byte[] b) {
        this.getListener().onProcessOriginalData(b);
    }

    String formatXml(String message) {
        String rMessage = message.substring(message.indexOf("<"), message.length());
        return rMessage;
    }

    boolean checkNormalSoftAddress() {
        return VoiceUtil.checkIPAddr(this.getSoftSwitchAddress()) && this.getSoftSwitchPort() > 0;
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            instance = null;
            NativeInterface.disConnectToCCP();
            this.unInitialize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void unInitialize() {
        NativeInterface.unInitialize();
        NativeInterface.AmrNBFreeEnc();
    }

    public void setNetworkType(int type, boolean connected, boolean reconnect) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setNetworkType] type: " + type + ", connected: " + connected + ", reconnect: " + reconnect);
        NativeInterface.setNetworkType(type, connected, reconnect);
    }

    public void setLogLevel(int level) {
        NativeInterface.setLogLevel(level);
    }

    public int setUserName(String name) {
        return NativeInterface.setUserName(name);
    }

    private void setSSLPort(int port) {
        HttpManager.setSSLPort(port);
    }

    public int setUserData(int type, String userData) {
        return NativeInterface.setUserData(type, userData);
    }

    public String getUserData(int type) {
        return NativeInterface.getUserData(type);
    }

    public int setVideoView(String account, Object view, Object localview) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setVideoView] hubintest");
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setVideoView] account: " + account + " view: " + view.getClass().getSimpleName());
        return NativeInterface.setVideoView(account, localview);
    }

    public int selectCamera(int cameraIndex, int capabilityIndex, int fps, int rotate, boolean force) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - selectCamera] cameraIndex: " + cameraIndex + ", capabilityIndex: " + capabilityIndex + ", fps: " + fps + ", rotate: " + rotate + " , force:" + force);
        return NativeInterface.selectCamera(cameraIndex, capabilityIndex, fps, rotate, force);
    }

    public CameraInfo[] getCameraInfo() {
        return NativeInterface.getCameraInfo();
    }

    public int setCodecEnabled(int type, boolean enabled) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setCodecEnabled] type: " + type + ", enabled: " + enabled);
        return NativeInterface.setCodecEnabled(type, enabled);
    }

    public boolean getCodecEnabled(int type) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - getCodecEnabled] type: " + type);
        return NativeInterface.getCodecEnabled(type);
    }

    public int setSrtpEnabled(boolean srtp, boolean userMode, int cryptType, String key) {
        return NativeInterface.setSrtpEnabled(false, srtp, userMode, cryptType, key);
    }

    public String makeCall(int callType, String accountSid) {
        if (!this.getVersionSupport(callType)) {
            this.getListener().onMakeCallFailed(accountSid, 170007);
            return accountSid;
        }
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - makeCall] sid: " + accountSid + " , callType " + (callType == Device.CallType.VOICE.getValue() ? Device.CallType.VOICE : Device.CallType.VIDEO));
        return NativeInterface.makeCall(callType, accountSid);
    }

    public void releaseCall(String callid, int reason) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - releaseCall] callid: " + callid);
        NativeInterface.releaseCall(callid, reason);
    }

    public void acceptCall(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - acceptCall] callid: " + callid);
        NativeInterface.acceptCall(callid);
    }

    public void rejectCall(String callid, int reason) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - rejectCall] callid: " + callid);
        NativeInterface.rejectCall(callid, reason);
    }

    public void pauseCall(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - pauseCall] callid: " + callid);
        NativeInterface.pauseCall(callid);
    }

    public int resumeCall(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - resumeCall] callid: " + callid);
        return NativeInterface.resumeCall(callid);
    }

    public int transferCall(String callid, String destionation, int callType) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - transferCall] callid: " + callid + ", destionation:" + destionation + " , callType " + callType);
        return NativeInterface.transferCall(callid, destionation, callType);
    }

    public int cancelCall(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - cancelCall] callid: " + callid);
        return NativeInterface.cancelCall(callid);
    }

    public int startRecord(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - startRecord] callid: " + callid);
        return NativeInterface.startRecord(callid);
    }

    public int stopRecord(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - stopRecord] callid: " + callid);
        return NativeInterface.stopRecord(callid);
    }

    public int acceptCallByMediaType(String callid, int type) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - acceptCallByMediaType] callid: " + callid + ", type: " + type);
        return NativeInterface.acceptCallByMediaType(callid, type);
    }

    public int updateCallMedia(String callid, int request) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - updateCallMedia] callid: " + callid + ", request: " + request);
        return NativeInterface.updateCallMedia(callid, request);
    }

    public int answerCallMediaUpdate(String callid, int action) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - answerCallMediaUpdate] callid: " + callid + ", action:" + action);
        return NativeInterface.answerCallMediaUpdate(callid, action);
    }

    public int getCallMediaType(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - getCallMediaType] callid: " + callid);
        return NativeInterface.getCallMeidaType(callid);
    }

    public int setScreenShareActivity(String callid, View view) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setScreenShareActivity] callid: " + callid);
        return NativeInterface.setScreenShareActivity(callid, view);
    }

    public int setAudioConfigEnabled(int type, boolean enabled, int mode) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setAudioConfigEnabled] type: " + type + ", enable:" + enabled + ", mode:" + mode);
        return NativeInterface.setAudioConfig(type, enabled, mode);
    }

    public boolean getAudioConfig(int type) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - getAudioConfig] type: " + type);
        return NativeInterface.getAudioConfig(type);
    }

    public int getAudioConfigMode(int type) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - getAudioConfigMode] type: " + type);
        return NativeInterface.getAudioConfigMode(type);
    }

    public void setVideoBitRates(int bitrates) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setVideoBitRates] bitrates: " + bitrates);
        NativeInterface.setVideoBitRates(bitrates);
    }

    public int startRtpDump(String callid, int mediaType, String fileName, int direction) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - stopRtpDump] callid: " + callid + ", mediaType:" + mediaType + ", fileName:" + fileName + ", direction:" + direction);
        return NativeInterface.startRtpDump(callid, mediaType, fileName, direction);
    }

    public int stopRtpDump(String callid, int mediaType, int direction) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - stopRtpDump] callid: " + callid + ", mediaType:" + mediaType + ", direction:" + direction);
        return NativeInterface.stopRtpDump(callid, mediaType, direction);
    }

    public int getCallState(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - getCallState] callid: " + callid);
        return NativeInterface.getCallState(callid);
    }

    public String getCurrentCall() {
        String currentCallId = NativeInterface.getCurrentCall();
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - getCurrentCall] callid: " + currentCallId);
        return currentCallId;
    }

    public int sendDTMF(String callid, char dtmf) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - sendDTMF] callid: " + callid + " ,dtmf:" + dtmf);
        return NativeInterface.sendDTMF(callid, dtmf);
    }

    public String getNetworkStatistic(String callid) {
        return NativeInterface.getNetworkStatistic(callid);
    }

    public String sendTextMessage(String receiver, String message, String userdata) {
        return NativeInterface.sendTextMessage(receiver, message, userdata);
    }

    public static void setPrivateCloud(String companyID, String restAddr, boolean nativeCheck) {
        NativeInterface.setPrivateCloud(companyID, restAddr, nativeCheck);
    }

    public String getUniqueID() {
        return NativeInterface.GetUniqueID();
    }

    public int SetStunServer(String server) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - SetStunServer] server: " + server);
        return NativeInterface.SetStunServer(server);
    }

    public int setStunServer(String server, int port) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - SetStunServer] server: " + server + " , port :" + port);
        return NativeInterface.SetStunServer(server, port);
    }

    public int setFirewallPolicy(int policy) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - SetFirewallPolicy] policy: " + policy);
        return NativeInterface.SetFirewallPolicy(policy);
    }

    public String getVersion() {
        return NativeInterface.getVersion();
    }

    private boolean getVersionSupport(int callType) {
        try {
            String version = this.getVersion();
            if (TextUtils.isEmpty((CharSequence)version)) {
                return true;
            }
            String[] split = version.split("#");
            String[] str = null;
            block6: for (int i = 0; i < split.length; ++i) {
                switch (callType) {
                    case 0: {
                        if (!split[i].startsWith("voice")) continue block6;
                        str = split[i].split("=");
                        continue block6;
                    }
                    case 1: {
                        if (!split[i].startsWith("video")) continue block6;
                        str = split[i].split("=");
                        continue block6;
                    }
                }
            }
            return Boolean.valueOf((String)str[1]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getCallStatistics(int type) {
        return NativeInterface.getCallStatistics(type);
    }

    public int setShieldMosaic(boolean flag) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - SetShieldMosaic] flag: " + flag);
        return NativeInterface.SetShieldMosaic(flag);
    }

    public int setStartBitRateAfterP2PSucceed(int rate) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - SetStartBitRateAfterP2PSucceed] rate: " + rate);
        return NativeInterface.SetStartBitRateAfterP2PSucceed(rate);
    }

    public int disConnectToCCP() {
        return NativeInterface.disConnectToCCP();
    }

    public Object getLocalVideoSnapshot(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - getLocalVideoSnapshot] callid: " + callid);
        return NativeInterface.getLocalVideoSnapshot(callid);
    }

    public Object getRemoteVideoSnapshot(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - getRemoteVideoSnapshot] callid: " + callid);
        return NativeInterface.getRemoteVideoSnapshot(callid);
    }

    public int startRecordVoice(String callid, String fileName) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - startRecordVoice] callid: " + callid + " , fileName :" + fileName);
        return NativeInterface.startRecordVoice(callid, fileName);
    }

    public int stopRecordVoice(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - stopRecordVoice] callid: " + callid);
        return NativeInterface.stopRecordVoice(callid);
    }

    public int startRecordVoip(String callid, String fileName) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - startRecordVoip] callid: " + callid + " , fileName :" + fileName);
        return NativeInterface.startRecordVoip(callid, fileName);
    }

    public int stopRecordVoip(String callid) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - stopRecordVoip] callid: " + callid);
        return NativeInterface.stopRecordVoip(callid);
    }

    public void setTraceFlag(boolean enabled) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setTraceFlag] enabled: " + enabled);
        NativeInterface.setTraceFlag(enabled);
    }

    public int checkUserOnline(String account) {
        return NativeInterface.checkUserOnline(account);
    }

    public int setMute(boolean on) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setMute] on/off: " + on);
        return NativeInterface.setMute(on);
    }

    public int enableLoudsSpeaker(boolean enable) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - enableLoudsSpeaker] enable: " + enable);
        return NativeInterface.enableLoudsSpeaker(enable);
    }

    public boolean getMuteStatus() {
        return NativeInterface.getMuteStatus();
    }

    public boolean getLoudsSpeakerStatus() {
        return NativeInterface.getLoudsSpeakerStatus();
    }

    public int setProcessDataEnabled(String callid, boolean enabled) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setProcessDataEnabled] callid: " + callid + " , enabled:" + enabled);
        return NativeInterface.setProcessDataEnabled(callid, enabled);
    }

    public int setProcessOriginalDataEnabled(String callid, boolean enabled) {
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - setProcessOriginalDataEnabled] callid: " + callid + " , enabled:" + enabled);
        return NativeInterface.setProcessOriginalDataEnabled(callid, enabled);
    }

    public int setKeepAliveTimeout(int wifi, int mobile) {
        return NativeInterface.setKeepAliveTimeout(wifi, mobile);
    }

    public int setRing(String filename) {
        return NativeInterface.setRing(filename);
    }

    public int setRingback(String filename) {
        return NativeInterface.setRingback(filename);
    }

    public int AmrNBEncode(byte[] input, int len, byte[] output, int mode) {
        return NativeInterface.AmrNBEncode(input, len, output, mode);
    }

    public int registerAudioDevice() {
        return NativeInterface.registerAudioDevice();
    }

    public int deregisterAudioDevice() {
        return NativeInterface.deregisterAudioDevice();
    }

    public int setNetworkGroupId(String groupId) {
        return NativeInterface.SetNetworkGroupId(groupId);
    }

    public void makeCallBack(String selfPhoneNumber, String destPhoneNumber, String srcSerNum, String destSerNum) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.selfphone", selfPhoneNumber);
        b.putString("com.ccp.phone.destphone", destPhoneNumber);
        b.putString("com.ccp.phone.srcSerNum", srcSerNum);
        b.putString("com.ccp.phone.destSerNum", destSerNum);
        msg.obj = b;
        msg.arg1 = 1;
        this.sendHandleMessage(msg);
    }

    public void startInterphone(String[] members, String type, String appid) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putStringArray("com.ccp.phone.members", members);
        b.putString("com.ccp.phone.type", type);
        b.putString("com.ccp.phone.appId", appid);
        msg.obj = b;
        msg.arg1 = 7;
        this.sendHandleMessage(msg);
    }

    public void controlMIC(String confNo) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.confNo", confNo);
        msg.obj = b;
        msg.arg1 = 8;
        this.sendHandleMessage(msg);
    }

    public void releaseMic(String confNo) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.confNo", confNo);
        msg.obj = b;
        msg.arg1 = 9;
        this.sendHandleMessage(msg);
    }

    public void queryMembersWithInterphone(String confNo) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.confNo", confNo);
        msg.obj = b;
        msg.arg1 = 10;
        this.sendHandleMessage(msg);
    }

    public void startChatroom(String appid, String roomName, int square, String keywords, String pwd, int isAutoClose, int voiceMod, int isAutoDelete) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appid);
        b.putString("com.ccp.phone.roomName", roomName);
        b.putInt("com.ccp.phone.square", square);
        b.putString("com.ccp.phone.keywords", keywords);
        b.putString("com.ccp.phone.pwd", pwd);
        b.putInt("com.ccp.phone.flag", isAutoClose);
        b.putInt("com.ccp.phone.flag.isAutoDelete", isAutoDelete);
        b.putInt("com.ccp.phone.voiceMod", voiceMod);
        msg.obj = b;
        msg.arg1 = 11;
        this.sendHandleMessage(msg);
    }

    public void dismissChatroom(String appId, String roomNo) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.roomNo", roomNo);
        msg.obj = b;
        msg.arg1 = 20;
        this.sendHandleMessageAtFront(msg);
    }

    public void removeMemberFromChatroom(String appId, String roomNo, String member) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.roomNo", roomNo);
        b.putString("com.ccp.phone.member", member);
        msg.obj = b;
        msg.arg1 = 21;
        this.sendHandleMessage(msg);
    }

    public void setChatroomMemberSpeakOpt(String appId, String roomNo, String member, int opt) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.roomNo", roomNo);
        b.putString("com.ccp.phone.member", member);
        b.putInt("com.ccp.phone.speak_opt", opt);
        msg.obj = b;
        msg.arg1 = 31;
        this.sendHandleMessage(msg);
    }

    public void queryChatRooms(String appId, String keywords) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.keywords", keywords);
        msg.obj = b;
        msg.arg1 = 12;
        this.sendHandleMessage(msg);
    }

    public void inviteMembersJoinChatroom(String[] members, String roomNo, String appId) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putStringArray("com.ccp.phone.members", members);
        b.putString("com.ccp.phone.roomNo", roomNo);
        b.putString("com.ccp.phone.appId", appId);
        msg.obj = b;
        msg.arg1 = 13;
        this.sendHandleMessage(msg);
    }

    public void queryMembersWithChatroom(String chatRoomId) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.roomNo", chatRoomId);
        msg.obj = b;
        msg.arg1 = 14;
        this.sendHandleMessage(msg);
    }

    public void sendMediaMsg(String uniqueID, String fileName, String receiver, String userData) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.fileName", fileName);
        b.putString("com.ccp.phone.receiver", receiver);
        b.putString("com.ccp.phone.uniqueID", uniqueID);
        b.putString("com.ccp.phone.userData", userData);
        msg.obj = b;
        msg.arg1 = 15;
        Log4Util.d("SDK_DEVICE", "sendMediaMsg\r\n");
        this.sendHandleMessage(msg);
    }

    public void confirmDownloadMediaMessage(String[] msgIds) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putStringArray("com.ccp.phone.msgIds", msgIds);
        msg.obj = b;
        msg.arg1 = 19;
        this.sendHandleMessage(msg);
    }

    public void downloadAttachmentFiles(ArrayList<DownloadInfo> dLoadList) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putSerializable("com.ccp.phone.downloadParameters", dLoadList);
        msg.obj = b;
        msg.arg1 = 17;
        this.sendHandleMessage(msg);
    }

    public void UploadMediaChunked(String uniqueID, String fileName, String receiver, String userData) {
        this.doUploadMediaChunked(uniqueID, fileName, receiver, userData);
    }

    public void CCPdownloadFiles(ArrayList<DownloadInfo> dLoadList) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putSerializable("com.ccp.phone.downloadParameters", dLoadList);
        msg.obj = b;
        msg.arg1 = 28;
        this.sendHandleMessage(msg);
    }

    public void DownloadVideoConferencePortraits(ArrayList<VideoPartnerPortrait> portraitsList) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putSerializable("com.ccp.phone.downloadParameters.PORTRAIT", portraitsList);
        msg.obj = b;
        msg.what = 28;
        msg.arg1 = 28;
        this.sendHandleMessage(msg);
    }

    @Override
    public void setStunServer(String server) {
        if (!TextUtils.isEmpty((CharSequence)server)) {
            try {
                String[] split = server.split(":");
                if (split != null && split.length == 2) {
                    this.setStunServer(split[0], Integer.parseInt(split[1]));
                } else {
                    this.SetStunServer(server);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void startVideoConference(String appId, String conferenceName, int square, String keywords, String conferencePwd, int isAutoClose, int voiceMod, int isAutoDelete) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.roomName", conferenceName);
        b.putInt("com.ccp.phone.square", square);
        b.putString("com.ccp.phone.keywords", keywords);
        b.putString("com.ccp.phone.pwd", conferencePwd);
        b.putInt("com.ccp.phone.flag", isAutoClose);
        b.putInt("com.ccp.phone.flag.isAutoDelete", isAutoDelete);
        b.putInt("com.ccp.phone.voiceMod", voiceMod);
        msg.obj = b;
        msg.arg1 = 22;
        this.sendHandleMessage(msg);
    }

    public void startVideoConference(String appId, String conferenceName, String conferencePwd, ConferenceOptions options) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.roomName", conferenceName);
        b.putString("com.ccp.phone.pwd", conferencePwd);
        b.putSerializable("com.ccp.phone.conf_options", (Serializable)options);
        msg.obj = b;
        msg.arg1 = 32;
        this.sendHandleMessage(msg);
    }

    public void queryMembersInVideoConference(String conferenceId) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.videoconf.conferenceId", conferenceId);
        msg.obj = b;
        msg.what = 24;
        msg.arg1 = 24;
        this.sendHandleMessage(msg);
    }

    public void queryVideoConferences(String appId, String keywords) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.keywords", keywords);
        msg.obj = b;
        msg.what = 23;
        msg.arg1 = 23;
        this.sendHandleMessage(msg);
    }

    public void dismissVideoConference(String appId, String conferenceId) {
        this.removeVideoConferenceHandleMessage();
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.videoconf.conferenceId", conferenceId);
        msg.obj = b;
        msg.what = 26;
        msg.arg1 = 26;
        this.sendHandleMessageAtFront(msg);
    }

    public void handleVideoPublishOperate(String appId, String conferenceId, boolean publish) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.videoconf.conferenceId", conferenceId);
        b.putBoolean("com.ccp.phone.video_publish", publish);
        msg.obj = b;
        msg.what = 33;
        msg.arg1 = 33;
        this.sendHandleMessageAtFront(msg);
    }

    public void removeMemberFromVideoConference(String appId, String conferenceId, String member) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.videoconf.conferenceId", conferenceId);
        b.putString("com.ccp.phone.member", member);
        msg.obj = b;
        msg.what = 25;
        msg.arg1 = 25;
        this.sendHandleMessage(msg);
    }

    public void switchRealScreenToVoip(String appId, String conferenceId, String voip) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.appId", appId);
        b.putString("com.ccp.phone.videoconf.conferenceId", conferenceId);
        b.putString("com.ccp.phone.voip", voip);
        msg.obj = b;
        msg.what = 27;
        msg.arg1 = 27;
        this.sendHandleMessage(msg);
    }

    public void GetPortraitsFromVideoConference(String conferenceId) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.videoconf.conferenceId", conferenceId);
        msg.obj = b;
        msg.what = 29;
        msg.arg1 = 29;
        this.sendHandleMessage(msg);
    }

    public void SendLocalPortrait(String fileName, String conferenceId) {
        Message msg = this.getHandleMessage();
        Bundle b = new Bundle();
        b.putString("com.ccp.phone.fileName", fileName);
        b.putString("com.ccp.phone.videoconf.conferenceId", conferenceId);
        msg.obj = b;
        msg.what = 30;
        msg.arg1 = 30;
        this.sendHandleMessage(msg);
    }

    public void removeVideoConferenceHandleMessage() {
        for (int what = 23; what <= 30; ++what) {
            this.removeHandleMessages(what);
        }
    }
}

