/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.utils.socket.websocket.request;

import com.useasy.callsdk.utils.socket.java_websocket.client.WebSocketClient;
import com.useasy.callsdk.utils.socket.java_websocket.framing.PingFrame;
import com.useasy.callsdk.utils.socket.java_websocket.framing.PongFrame;
import com.useasy.callsdk.utils.socket.websocket.request.Request;
import com.useasy.callsdk.utils.socket.websocket.request.RequestFactory;
import java.util.ArrayDeque;
import java.util.Queue;

public class PongRequest
implements Request<PingFrame> {
    private static Queue<PongFrame> PONG_POOL = new ArrayDeque<PongFrame>(7);
    private PingFrame pingFrame;

    PongRequest() {
    }

    @Override
    public void setRequestData(PingFrame data) {
        this.pingFrame = data;
    }

    @Override
    public PingFrame getRequestData() {
        return this.pingFrame;
    }

    @Override
    public void send(WebSocketClient client) {
        PongFrame pongFrame = this.getPongFrame();
        if (this.pingFrame != null) {
            pongFrame.setPayload(this.pingFrame.getPayloadData());
            this.pingFrame = null;
        } else {
            pongFrame.setPayload(null);
        }
        client.sendFrame(pongFrame);
        this.offerPongFrame(pongFrame);
    }

    @Override
    public void release() {
        RequestFactory.releasePongRequest(this);
    }

    public String toString() {
        return String.format("[@PongRequest%s,PingFrame:%s]", this.hashCode(), this.pingFrame == null ? "null" : this.pingFrame.toString());
    }

    private PongFrame getPongFrame() {
        PongFrame pongFrame = PONG_POOL.poll();
        if (pongFrame == null) {
            pongFrame = new PongFrame();
        }
        return pongFrame;
    }

    private void offerPongFrame(PongFrame pongFrame) {
        this.pingFrame = null;
        PONG_POOL.offer(pongFrame);
    }
}

