/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.utils.socket.websocket.dispatcher;

import com.useasy.callsdk.utils.socket.websocket.dispatcher.EngineThread;
import com.useasy.callsdk.utils.socket.websocket.dispatcher.IResponseDispatcher;
import com.useasy.callsdk.utils.socket.websocket.dispatcher.ResponseDelivery;
import com.useasy.callsdk.utils.socket.websocket.response.ErrorResponse;
import com.useasy.callsdk.utils.socket.websocket.response.Response;
import java.util.ArrayDeque;
import java.util.Queue;

public class ResponseProcessEngine {
    private EngineThread mThread = new EngineThread();

    public ResponseProcessEngine() {
        this.mThread.start();
    }

    public void onMessageReceive(Response message, IResponseDispatcher dispatcher, ResponseDelivery delivery) {
        if (message == null || dispatcher == null || delivery == null) {
            return;
        }
        EngineEntity entity = EngineEntity.obtain();
        entity.dispatcher = dispatcher;
        entity.delivery = delivery;
        entity.isError = false;
        entity.response = message;
        entity.errorResponse = null;
        this.mThread.add(entity);
    }

    public void onSendDataError(ErrorResponse errorResponse, IResponseDispatcher dispatcher, ResponseDelivery delivery) {
        if (errorResponse == null || dispatcher == null || delivery == null) {
            return;
        }
        EngineEntity entity = EngineEntity.obtain();
        entity.dispatcher = dispatcher;
        entity.delivery = delivery;
        entity.isError = true;
        entity.errorResponse = errorResponse;
        entity.response = null;
        this.mThread.add(entity);
    }

    static class EngineEntity {
        private static Queue<EngineEntity> ENTITY_POOL = new ArrayDeque<EngineEntity>(10);
        boolean isError;
        Response response;
        ErrorResponse errorResponse;
        IResponseDispatcher dispatcher;
        ResponseDelivery delivery;

        EngineEntity() {
        }

        static EngineEntity obtain() {
            EngineEntity engineEntity = ENTITY_POOL.poll();
            if (engineEntity == null) {
                engineEntity = new EngineEntity();
            }
            return engineEntity;
        }

        static void release(EngineEntity entity) {
            ENTITY_POOL.offer(entity);
        }
    }
}

