/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.utils.socket.websocket.dispatcher;

import android.text.TextUtils;
import com.useasy.callsdk.utils.socket.java_websocket.framing.Framedata;
import com.useasy.callsdk.utils.socket.websocket.SocketListener;
import com.useasy.callsdk.utils.socket.websocket.dispatcher.ResponseDelivery;
import com.useasy.callsdk.utils.socket.websocket.response.ErrorResponse;
import com.useasy.callsdk.utils.socket.websocket.util.ThreadUtil;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class MainThreadResponseDelivery
implements ResponseDelivery {
    private static final Object LISTENER_BLOCK = new Object();
    private static Queue<CallbackRunnable> RUNNABLE_POOL;
    private final List<SocketListener> mSocketListenerList = new ArrayList<SocketListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(SocketListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.mSocketListenerList.contains(listener)) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                this.mSocketListenerList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(SocketListener listener) {
        if (listener == null || this.isEmpty()) {
            return;
        }
        if (this.mSocketListenerList.contains(listener)) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                this.mSocketListenerList.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnected() {
        if (this.isEmpty()) {
            return;
        }
        if (ThreadUtil.checkMainThread()) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                for (SocketListener listener : this.mSocketListenerList) {
                    listener.onConnected();
                }
            }
        } else {
            CallbackRunnable callbackRunnable = this.getRunnable();
            callbackRunnable.type = RUNNABLE_TYPE.CONNECTED;
            callbackRunnable.mSocketListenerList = this.mSocketListenerList;
            ThreadUtil.runOnMainThread(callbackRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectFailed(Throwable cause) {
        if (this.isEmpty()) {
            return;
        }
        if (ThreadUtil.checkMainThread()) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                for (SocketListener listener : this.mSocketListenerList) {
                    listener.onConnectFailed(cause);
                }
            }
        } else {
            CallbackRunnable callbackRunnable = this.getRunnable();
            callbackRunnable.type = RUNNABLE_TYPE.CONNECT_FAILED;
            callbackRunnable.connectErrorCause = cause;
            callbackRunnable.mSocketListenerList = this.mSocketListenerList;
            ThreadUtil.runOnMainThread(callbackRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnect() {
        if (this.isEmpty()) {
            return;
        }
        if (ThreadUtil.checkMainThread()) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                for (SocketListener listener : this.mSocketListenerList) {
                    listener.onDisconnect();
                }
            }
        } else {
            CallbackRunnable callbackRunnable = this.getRunnable();
            callbackRunnable.type = RUNNABLE_TYPE.DISCONNECT;
            callbackRunnable.mSocketListenerList = this.mSocketListenerList;
            ThreadUtil.runOnMainThread(callbackRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSendDataError(ErrorResponse errorResponse) {
        if (this.isEmpty() || errorResponse == null) {
            return;
        }
        if (ThreadUtil.checkMainThread()) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                for (SocketListener listener : this.mSocketListenerList) {
                    listener.onSendDataError(errorResponse);
                }
            }
        } else {
            CallbackRunnable callbackRunnable = this.getRunnable();
            callbackRunnable.type = RUNNABLE_TYPE.SEND_ERROR;
            callbackRunnable.errorResponse = errorResponse;
            callbackRunnable.mSocketListenerList = this.mSocketListenerList;
            ThreadUtil.runOnMainThread(callbackRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void onMessage(String message, T data) {
        if (this.isEmpty() || message == null) {
            return;
        }
        if (ThreadUtil.checkMainThread()) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                for (SocketListener listener : this.mSocketListenerList) {
                    listener.onMessage(message, data);
                }
            }
        } else {
            CallbackRunnable callbackRunnable = this.getRunnable();
            callbackRunnable.type = RUNNABLE_TYPE.STRING_MSG;
            callbackRunnable.textResponse = message;
            callbackRunnable.formattedData = data;
            callbackRunnable.mSocketListenerList = this.mSocketListenerList;
            ThreadUtil.runOnMainThread(callbackRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void onMessage(ByteBuffer bytes, T data) {
        if (this.isEmpty() || bytes == null) {
            return;
        }
        if (ThreadUtil.checkMainThread()) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                for (SocketListener listener : this.mSocketListenerList) {
                    listener.onMessage(bytes, data);
                }
            }
        } else {
            CallbackRunnable callbackRunnable = this.getRunnable();
            callbackRunnable.type = RUNNABLE_TYPE.BYTE_BUFFER_MSG;
            callbackRunnable.byteResponse = bytes;
            callbackRunnable.formattedData = data;
            callbackRunnable.mSocketListenerList = this.mSocketListenerList;
            ThreadUtil.runOnMainThread(callbackRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPing(Framedata framedata) {
        if (this.isEmpty()) {
            return;
        }
        if (ThreadUtil.checkMainThread()) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                for (SocketListener listener : this.mSocketListenerList) {
                    listener.onPing(framedata);
                }
            }
        } else {
            CallbackRunnable callbackRunnable = this.getRunnable();
            callbackRunnable.type = RUNNABLE_TYPE.PING;
            callbackRunnable.framedataResponse = framedata;
            callbackRunnable.mSocketListenerList = this.mSocketListenerList;
            ThreadUtil.runOnMainThread(callbackRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPong(Framedata framedata) {
        if (this.isEmpty()) {
            return;
        }
        if (ThreadUtil.checkMainThread()) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                for (SocketListener listener : this.mSocketListenerList) {
                    listener.onPong(framedata);
                }
            }
        } else {
            CallbackRunnable callbackRunnable = this.getRunnable();
            callbackRunnable.type = RUNNABLE_TYPE.PONG;
            callbackRunnable.framedataResponse = framedata;
            callbackRunnable.mSocketListenerList = this.mSocketListenerList;
            ThreadUtil.runOnMainThread(callbackRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (!this.mSocketListenerList.isEmpty()) {
            Object object = LISTENER_BLOCK;
            synchronized (object) {
                this.mSocketListenerList.clear();
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mSocketListenerList.isEmpty();
    }

    private CallbackRunnable getRunnable() {
        CallbackRunnable runnable;
        if (RUNNABLE_POOL == null) {
            RUNNABLE_POOL = new ArrayDeque<CallbackRunnable>(5);
        }
        if ((runnable = RUNNABLE_POOL.poll()) == null) {
            runnable = new CallbackRunnable();
        }
        return runnable;
    }

    private static class CallbackRunnable<T>
    implements Runnable {
        List<SocketListener> mSocketListenerList;
        ErrorResponse errorResponse;
        Throwable connectErrorCause;
        String textResponse;
        ByteBuffer byteResponse;
        Framedata framedataResponse;
        T formattedData;
        RUNNABLE_TYPE type = RUNNABLE_TYPE.NON;

        private CallbackRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.type == RUNNABLE_TYPE.NON || this.mSocketListenerList == null || this.mSocketListenerList.isEmpty()) {
                    return;
                }
                if (this.type == RUNNABLE_TYPE.CONNECT_FAILED && this.connectErrorCause == null) {
                    return;
                }
                if (this.type == RUNNABLE_TYPE.SEND_ERROR && this.errorResponse == null) {
                    return;
                }
                if (this.type == RUNNABLE_TYPE.STRING_MSG && TextUtils.isEmpty((CharSequence)this.textResponse)) {
                    return;
                }
                if (this.type == RUNNABLE_TYPE.BYTE_BUFFER_MSG && this.byteResponse == null) {
                    return;
                }
                if (this.type == RUNNABLE_TYPE.PING && this.framedataResponse == null) {
                    return;
                }
                if (this.type == RUNNABLE_TYPE.PONG && this.framedataResponse == null) {
                    return;
                }
                Object object = LISTENER_BLOCK;
                synchronized (object) {
                    switch (this.type) {
                        case CONNECTED: {
                            for (SocketListener listener : this.mSocketListenerList) {
                                listener.onConnected();
                            }
                            break;
                        }
                        case CONNECT_FAILED: {
                            for (SocketListener listener : this.mSocketListenerList) {
                                listener.onConnectFailed(this.connectErrorCause);
                            }
                            break;
                        }
                        case DISCONNECT: {
                            for (SocketListener listener : this.mSocketListenerList) {
                                listener.onDisconnect();
                            }
                            break;
                        }
                        case SEND_ERROR: {
                            for (SocketListener listener : this.mSocketListenerList) {
                                listener.onSendDataError(this.errorResponse);
                            }
                            break;
                        }
                        case STRING_MSG: {
                            for (SocketListener listener : this.mSocketListenerList) {
                                listener.onMessage(this.textResponse, this.formattedData);
                            }
                            break;
                        }
                        case BYTE_BUFFER_MSG: {
                            for (SocketListener listener : this.mSocketListenerList) {
                                listener.onMessage(this.byteResponse, this.formattedData);
                            }
                            break;
                        }
                        case PING: {
                            for (SocketListener listener : this.mSocketListenerList) {
                                listener.onPing(this.framedataResponse);
                            }
                            break;
                        }
                        case PONG: {
                            for (SocketListener listener : this.mSocketListenerList) {
                                listener.onPong(this.framedataResponse);
                            }
                            break;
                        }
                    }
                    this.mSocketListenerList = null;
                    this.errorResponse = null;
                    this.connectErrorCause = null;
                    this.textResponse = null;
                    this.byteResponse = null;
                    this.framedataResponse = null;
                    this.formattedData = null;
                }
            }
            finally {
                RUNNABLE_POOL.offer(this);
            }
        }
    }

    static enum RUNNABLE_TYPE {
        NON,
        CONNECTED,
        CONNECT_FAILED,
        DISCONNECT,
        SEND_ERROR,
        STRING_MSG,
        BYTE_BUFFER_MSG,
        PING,
        PONG;

    }
}

