/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.utils.socket.websocket;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import com.useasy.callsdk.utils.Loger;
import com.useasy.callsdk.utils.socket.websocket.NetworkChangedReceiver;
import com.useasy.callsdk.utils.socket.websocket.WebSocketEngine;
import com.useasy.callsdk.utils.socket.websocket.WebSocketManager;
import com.useasy.callsdk.utils.socket.websocket.WebSocketSetting;
import com.useasy.callsdk.utils.socket.websocket.dispatcher.ResponseProcessEngine;
import com.useasy.callsdk.utils.socket.websocket.util.PermissionUtil;
import java.util.HashMap;
import java.util.Map;

public class WebSocketHandler {
    private static final String TAG = "WebSocketHandler";
    private static WebSocketEngine webSocketEngine;
    private static ResponseProcessEngine responseProcessEngine;
    private static WebSocketManager defaultWebSocket;
    private static final Object WS_MAP_BLOCK;
    private static Map<String, WebSocketManager> mWebSocketMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebSocketManager init(WebSocketSetting setting) {
        if (defaultWebSocket == null) {
            Class<WebSocketHandler> clazz = WebSocketHandler.class;
            synchronized (WebSocketHandler.class) {
                if (webSocketEngine == null) {
                    webSocketEngine = new WebSocketEngine();
                }
                if (responseProcessEngine == null) {
                    responseProcessEngine = new ResponseProcessEngine();
                }
                if (defaultWebSocket == null) {
                    defaultWebSocket = new WebSocketManager(setting, webSocketEngine, responseProcessEngine);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            Loger.d(TAG, "Default WebSocketManager exists!do not start again!");
        }
        return defaultWebSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebSocketManager initGeneralWebSocket(String key, WebSocketSetting setting) {
        WebSocketHandler.checkEngineNullAndInit();
        WebSocketHandler.checkWebSocketMapNullAndInit();
        Object object = WS_MAP_BLOCK;
        synchronized (object) {
            if (mWebSocketMap.containsKey(key)) {
                Loger.d(TAG, "WebSocketManager exists!do not start again!");
                return mWebSocketMap.get(key);
            }
            WebSocketManager wsm = new WebSocketManager(setting, webSocketEngine, responseProcessEngine);
            mWebSocketMap.put(key, wsm);
            return wsm;
        }
    }

    public static WebSocketManager getDefault() {
        return defaultWebSocket;
    }

    public static void setnull() {
        defaultWebSocket = null;
    }

    public static WebSocketManager getWebSocket(String key) {
        WebSocketHandler.checkWebSocketMapNullAndInit();
        if (mWebSocketMap.containsKey(key)) {
            return mWebSocketMap.get(key);
        }
        return null;
    }

    public static Map<String, WebSocketManager> getAllWebSocket() {
        WebSocketHandler.checkWebSocketMapNullAndInit();
        return mWebSocketMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebSocketManager removeWebSocket(String key) {
        WebSocketHandler.checkWebSocketMapNullAndInit();
        if (mWebSocketMap.containsKey(key)) {
            WebSocketManager removed = mWebSocketMap.get(key);
            Object object = WS_MAP_BLOCK;
            synchronized (object) {
                mWebSocketMap.remove(key);
            }
            return removed;
        }
        return null;
    }

    public static void registerNetworkChangedReceiver(Context context) {
        if (PermissionUtil.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            try {
                NetworkChangedReceiver networkChangedReceiver = new NetworkChangedReceiver();
                context.unregisterReceiver((BroadcastReceiver)networkChangedReceiver);
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                context.registerReceiver((BroadcastReceiver)networkChangedReceiver, filter);
            }
            catch (Exception e) {
                Loger.d(TAG, "\u7f51\u7edc\u76d1\u542c\u5e7f\u64ad\u6ce8\u518c\u5931\u8d25\uff1a", e);
            }
        } else {
            Loger.d(TAG, "\u672a\u83b7\u53d6\u5230\u7f51\u7edc\u72b6\u6001\u6743\u9650\uff0c\u5e7f\u64ad\u76d1\u542c\u5668\u65e0\u6cd5\u6ce8\u518c");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkEngineNullAndInit() {
        if (webSocketEngine != null && responseProcessEngine != null) return;
        Class<WebSocketHandler> clazz = WebSocketHandler.class;
        synchronized (WebSocketHandler.class) {
            if (webSocketEngine == null) {
                webSocketEngine = new WebSocketEngine();
            }
            if (responseProcessEngine != null) return;
            responseProcessEngine = new ResponseProcessEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkWebSocketMapNullAndInit() {
        if (mWebSocketMap == null) {
            Object object = WS_MAP_BLOCK;
            synchronized (object) {
                if (mWebSocketMap == null) {
                    mWebSocketMap = new HashMap<String, WebSocketManager>();
                }
            }
        }
    }

    static {
        WS_MAP_BLOCK = new HashMap();
    }
}

