/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/useasy/callsdk/utils/PermissionHelper;", "", "()V", "hasRecordAudioPermission", "", "context", "Landroid/content/Context;", "isPermissionGranted", "grantResults", "", "requestRecordAudioPermission", "activity", "Landroid/app/Activity;", "requestCode", "", "callsdk_release"})
public final class PermissionHelper {
    @NotNull
    public static final PermissionHelper INSTANCE;

    @JvmStatic
    public static final boolean hasRecordAudioPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT >= 23 ? ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO") == 0 : true;
    }

    @JvmStatic
    public static final boolean requestRecordAudioPermission(@NotNull Activity activity, int requestCode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (PermissionHelper.hasRecordAudioPermission((Context)activity)) {
            bl = true;
        } else {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.RECORD_AUDIO"}, (int)requestCode);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isPermissionGranted(@NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        int[] nArray = grantResults;
        boolean bl = false;
        int[] nArray2 = nArray;
        boolean bl2 = false;
        return !(nArray2.length == 0) && grantResults[0] == 0;
    }

    private PermissionHelper() {
    }

    static {
        PermissionHelper permissionHelper;
        INSTANCE = permissionHelper = new PermissionHelper();
    }
}

