/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.utils;

import android.util.Base64;
import com.useasy.callsdk.utils.Loger;
import com.useasy.callsdk.utils.Utils;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lcom/useasy/callsdk/utils/LoginHelper;", "", "()V", "parsePassword", "", "pk", "password", "rsaEncrypt", "str", "publicKey", "callsdk_release"})
public final class LoginHelper {
    @NotNull
    public static final LoginHelper INSTANCE;

    @NotNull
    public final String parsePassword(@NotNull String pk, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)pk, (String)"pk");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String md5 = Utils.INSTANCE.getMD5(password);
        byte[] byArray = Base64.decode((String)pk, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.decode(pk, Base64.DEFAULT)");
        byte[] decode = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String decodeStr = new String(decode, charset2);
        String key = URLDecoder.decode(decodeStr, StandardCharsets.UTF_8.toString());
        Loger.dTag("LoginHelper", "key: " + key);
        String string = key;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
        return this.rsaEncrypt(md5, string);
    }

    @NotNull
    public final String rsaEncrypt(@NotNull String str, @NotNull String publicKey) {
        String string;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        try {
            byte[] decoded = Base64.decode((String)StringsKt.replace$default((String)publicKey, (char)' ', (char)'+', (boolean)false, (int)4, null), (int)0);
            PublicKey publicKey2 = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            if (publicKey2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
            }
            RSAPublicKey pubKey = (RSAPublicKey)publicKey2;
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, pubKey);
            String string2 = str;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            byte[] byArray = string2.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] encryptedBytes = cipher.doFinal(byArray);
            String string3 = Base64.encodeToString((byte[])encryptedBytes, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.encodeToString(en\u2026tedBytes, Base64.NO_WRAP)");
            string = string3;
        }
        catch (Exception e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    private LoginHelper() {
    }

    static {
        LoginHelper loginHelper;
        INSTANCE = loginHelper = new LoginHelper();
    }
}

