/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.utils;

import android.util.Log;
import androidx.annotation.IntRange;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Loger {
    public static final int V = 2;
    public static final int D = 3;
    public static final int I = 4;
    public static final int W = 5;
    public static final int E = 6;
    public static final int A = 7;
    private static final char[] T = new char[]{'V', 'D', 'I', 'W', 'E', 'A'};
    private static final int FILE = 16;
    private static final int JSON = 32;
    private static final int XML = 48;
    private static ExecutorService sExecutor;
    private static String sDefaultDir;
    private static String sDir;
    private static String sFilePrefix;
    private static boolean sLogSwitch;
    private static boolean sLog2ConsoleSwitch;
    private static String sGlobalTag;
    private static boolean sTagIsSpace;
    private static boolean sLogHeadSwitch;
    private static boolean sLog2FileSwitch;
    private static boolean sLogBorderSwitch;
    private static int sConsoleFilter;
    private static int sFileFilter;
    private static int sStackDeep;
    private static final String FILE_SEP;
    private static final String LINE_SEP;
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String SPLIT_BORDER = "\u255f\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String LEFT_BORDER = "\u2551 ";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final int MAX_LEN = 4000;
    private static final Format FORMAT;
    private static final String NULL = "null";
    private static final String ARGS = "args";
    private static final Config CONFIG;

    private Loger() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Config getConfig() {
        return CONFIG;
    }

    public static void v(Object ... contents) {
        Loger.log(2, sGlobalTag, contents);
    }

    public static void vTag(String tag, Object ... contents) {
        Loger.log(2, tag, contents);
    }

    public static void d(Object ... contents) {
        Loger.log(3, sGlobalTag, contents);
    }

    public static void dTag(String tag, Object ... contents) {
        Loger.log(3, tag, contents);
    }

    public static void i(Object ... contents) {
        Loger.log(4, sGlobalTag, contents);
    }

    public static void iTag(String tag, Object ... contents) {
        Loger.log(4, tag, contents);
    }

    public static void w(Object ... contents) {
        Loger.log(5, sGlobalTag, contents);
    }

    public static void wTag(String tag, Object ... contents) {
        Loger.log(5, tag, contents);
    }

    public static void e(Object ... contents) {
        Loger.log(6, sGlobalTag, contents);
    }

    public static void eTag(String tag, Object ... contents) {
        Loger.log(6, tag, contents);
    }

    public static void a(Object ... contents) {
        Loger.log(7, sGlobalTag, contents);
    }

    public static void aTag(String tag, Object ... contents) {
        Loger.log(7, tag, contents);
    }

    public static void file(Object content) {
        Loger.log(19, sGlobalTag, content);
    }

    public static void file(int type, Object content) {
        Loger.log(0x10 | type, sGlobalTag, content);
    }

    public static void file(String tag, Object content) {
        Loger.log(19, tag, content);
    }

    public static void file(int type, String tag, Object content) {
        Loger.log(0x10 | type, tag, content);
    }

    public static void json(String content) {
        Loger.log(35, sGlobalTag, content);
    }

    public static void json(int type, String content) {
        Loger.log(0x20 | type, sGlobalTag, content);
    }

    public static void json(String tag, String content) {
        Loger.log(35, tag, content);
    }

    public static void json(int type, String tag, String content) {
        Loger.log(0x20 | type, tag, content);
    }

    public static void xml(String content) {
        Loger.log(51, sGlobalTag, content);
    }

    public static void xml(int type, String content) {
        Loger.log(0x30 | type, sGlobalTag, content);
    }

    public static void xml(String tag, String content) {
        Loger.log(51, tag, content);
    }

    public static void xml(int type, String tag, String content) {
        Loger.log(0x30 | type, tag, content);
    }

    private static void log(int type, String tag, Object ... contents) {
        if (!sLogSwitch || !sLog2ConsoleSwitch && !sLog2FileSwitch) {
            return;
        }
        int type_low = type & 0xF;
        int type_high = type & 0xF0;
        if (type_low < sConsoleFilter && type_low < sFileFilter) {
            return;
        }
        TagHead tagHead = Loger.processTagAndHead(tag);
        String body = Loger.processBody(type_high, contents);
        if (sLog2ConsoleSwitch && type_low >= sConsoleFilter && type_high != 16) {
            Loger.print2Console(type_low, tagHead.tag, tagHead.consoleHead, body);
        }
        if ((sLog2FileSwitch || type_high == 16) && type_low >= sFileFilter) {
            Loger.print2File(type_low, tagHead.tag, tagHead.fileHead + body);
        }
    }

    private static TagHead processTagAndHead(String tag) {
        if (!sTagIsSpace && !sLogHeadSwitch) {
            tag = sGlobalTag;
        } else {
            String className;
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            StackTraceElement targetElement = stackTrace[3];
            String fileName = targetElement.getFileName();
            if (fileName == null) {
                int index;
                className = targetElement.getClassName();
                String[] classNameInfo = className.split("\\.");
                if (classNameInfo.length > 0) {
                    className = classNameInfo[classNameInfo.length - 1];
                }
                if ((index = className.indexOf(36)) != -1) {
                    className = className.substring(0, index);
                }
                fileName = className + ".java";
            } else {
                int index = fileName.indexOf(46);
                String string = className = index == -1 ? fileName : fileName.substring(0, index);
            }
            if (sTagIsSpace) {
                String string = tag = Loger.isSpace(tag) ? className : tag;
            }
            if (sLogHeadSwitch) {
                String tName = Thread.currentThread().getName();
                String head = new Formatter().format("%s, %s(%s:%d)", tName, targetElement.getMethodName(), fileName, targetElement.getLineNumber()).toString();
                String fileHead = " [" + head + "]: ";
                if (sStackDeep <= 1) {
                    return new TagHead(tag, new String[]{head}, fileHead);
                }
                String[] consoleHead = new String[Math.min(sStackDeep, stackTrace.length - 3)];
                consoleHead[0] = head;
                int spaceLen = tName.length() + 2;
                String space = new Formatter().format("%" + spaceLen + "s", "").toString();
                int len = consoleHead.length;
                for (int i = 1; i < len; ++i) {
                    targetElement = stackTrace[i + 3];
                    consoleHead[i] = new Formatter().format("%s%s(%s:%d)", space, targetElement.getMethodName(), targetElement.getFileName(), targetElement.getLineNumber()).toString();
                }
                return new TagHead(tag, consoleHead, fileHead);
            }
        }
        return new TagHead(tag, null, ": ");
    }

    private static String processBody(int type, Object ... contents) {
        String body = NULL;
        if (contents != null) {
            if (contents.length == 1) {
                Object object = contents[0];
                if (object != null) {
                    body = object.toString();
                }
                if (type == 32) {
                    body = Loger.formatJson(body);
                } else if (type == 48) {
                    body = Loger.formatXml(body);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                int len = contents.length;
                for (int i = 0; i < len; ++i) {
                    Object content = contents[i];
                    sb.append(ARGS).append("[").append(i).append("]").append(" = ").append(content == null ? NULL : content.toString()).append(LINE_SEP);
                }
                body = sb.toString();
            }
        }
        return body;
    }

    private static String formatJson(String json) {
        try {
            if (json.startsWith("{")) {
                json = new JSONObject(json).toString(4);
            } else if (json.startsWith("[")) {
                json = new JSONArray(json).toString(4);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    private static String formatXml(String xml) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(xmlInput, xmlOutput);
            xml = xmlOutput.getWriter().toString().replaceFirst(">", ">" + LINE_SEP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    private static void print2Console(int type, String tag, String[] head, String msg) {
        Loger.printBorder(type, tag, true);
        Loger.printHead(type, tag, head);
        Loger.printMsg(type, tag, msg);
        Loger.printBorder(type, tag, false);
    }

    private static void printBorder(int type, String tag, boolean isTop) {
        if (sLogBorderSwitch) {
            Log.println((int)type, (String)tag, (String)(isTop ? TOP_BORDER : BOTTOM_BORDER));
        }
    }

    private static void printHead(int type, String tag, String[] head) {
        if (head != null) {
            for (String aHead : head) {
                Log.println((int)type, (String)tag, (String)(sLogBorderSwitch ? LEFT_BORDER + aHead : aHead));
            }
            if (sLogBorderSwitch) {
                Log.println((int)type, (String)tag, (String)SPLIT_BORDER);
            }
        }
    }

    private static void printMsg(int type, String tag, String msg) {
        int len = msg.length();
        int countOfSub = len / 4000;
        if (countOfSub > 0) {
            int index = 0;
            for (int i = 0; i < countOfSub; ++i) {
                Loger.printSubMsg(type, tag, msg.substring(index, index + 4000));
                index += 4000;
            }
            if (index != len) {
                Loger.printSubMsg(type, tag, msg.substring(index, len));
            }
        } else {
            Loger.printSubMsg(type, tag, msg);
        }
    }

    private static void printSubMsg(int type, String tag, String msg) {
        String[] lines;
        if (!sLogBorderSwitch) {
            Log.println((int)type, (String)tag, (String)msg);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines = msg.split(LINE_SEP)) {
            Log.println((int)type, (String)tag, (String)(LEFT_BORDER + line));
        }
    }

    private static void print2File(int type, final String tag, String msg) {
        Date now = new Date(System.currentTimeMillis());
        String format = FORMAT.format(now);
        String date = format.substring(0, 5);
        String time = format.substring(6);
        final String fullPath = (sDir == null ? sDefaultDir : sDir) + sFilePrefix + "-" + date + ".txt";
        if (!Loger.createOrExistsFile(fullPath)) {
            Log.e((String)tag, (String)("log to " + fullPath + " failed!"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        String content = "";
        try {
            sb.append(time).append(T[type - 2]).append("/").append(tag).append(msg).append(LINE_SEP);
            content = sb.toString();
        }
        catch (Exception error) {
            content = "OutOfMemoryError";
        }
        final String finalContent = content;
        Loger.execute(new Runnable(){

            @Override
            public void run() {
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new FileWriter(fullPath, true));
                    bw.write(finalContent);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)tag, (String)("log to " + fullPath + " failed!"));
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static boolean createOrExistsFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!Loger.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void execute(Runnable runnable) {
        if (sExecutor == null) {
            sExecutor = Executors.newSingleThreadExecutor();
        }
        sExecutor.execute(runnable);
    }

    static {
        sFilePrefix = "util";
        sLogSwitch = true;
        sLog2ConsoleSwitch = true;
        sGlobalTag = null;
        sTagIsSpace = true;
        sLogHeadSwitch = true;
        sLog2FileSwitch = true;
        sLogBorderSwitch = true;
        sConsoleFilter = 2;
        sFileFilter = 2;
        sStackDeep = 1;
        FILE_SEP = System.getProperty("file.separator");
        LINE_SEP = System.getProperty("line.separator");
        FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS ", Locale.getDefault());
        CONFIG = new Config();
    }

    private static class TagHead {
        String tag;
        String[] consoleHead;
        String fileHead;

        TagHead(String tag, String[] consoleHead, String fileHead) {
            this.tag = tag;
            this.consoleHead = consoleHead;
            this.fileHead = fileHead;
        }
    }

    public static class Config {
        public Config setLogSwitch(boolean logSwitch) {
            sLogSwitch = logSwitch;
            return this;
        }

        public Config setConsoleSwitch(boolean consoleSwitch) {
            sLog2ConsoleSwitch = consoleSwitch;
            return this;
        }

        public Config setGlobalTag(String tag) {
            if (Loger.isSpace(tag)) {
                sGlobalTag = "";
                sTagIsSpace = true;
            } else {
                sGlobalTag = tag;
                sTagIsSpace = false;
            }
            return this;
        }

        public Config setLogHeadSwitch(boolean logHeadSwitch) {
            sLogHeadSwitch = logHeadSwitch;
            return this;
        }

        public Config setLog2FileSwitch(boolean log2FileSwitch) {
            sLog2FileSwitch = log2FileSwitch;
            return this;
        }

        public Config setDir(String dir) {
            if (Loger.isSpace(dir)) {
                sDir = null;
            } else {
                sDir = dir.endsWith(FILE_SEP) ? dir : dir + FILE_SEP;
            }
            return this;
        }

        public Config setDir(File dir) {
            sDir = dir == null ? null : dir.getAbsolutePath() + FILE_SEP;
            return this;
        }

        public Config setFilePrefix(String filePrefix) {
            if (Loger.isSpace(filePrefix)) {
                sFilePrefix = "util";
            } else {
                sFilePrefix = filePrefix;
            }
            return this;
        }

        public Config setBorderSwitch(boolean borderSwitch) {
            sLogBorderSwitch = borderSwitch;
            return this;
        }

        public Config setConsoleFilter(int consoleFilter) {
            sConsoleFilter = consoleFilter;
            return this;
        }

        public Config setFileFilter(int fileFilter) {
            sFileFilter = fileFilter;
            return this;
        }

        public Config setStackDeep(@IntRange(from=1L) int stackDeep) {
            sStackDeep = stackDeep;
            return this;
        }

        public String toString() {
            return "switch: " + sLogSwitch + LINE_SEP + "console: " + sLog2ConsoleSwitch + LINE_SEP + "tag: " + (sTagIsSpace ? Loger.NULL : sGlobalTag) + LINE_SEP + "head: " + sLogHeadSwitch + LINE_SEP + "file: " + sLog2FileSwitch + LINE_SEP + "dir: " + (sDir == null ? sDefaultDir : sDir) + LINE_SEP + "filePrefix" + sFilePrefix + LINE_SEP + "border: " + sLogBorderSwitch + LINE_SEP + "consoleFilter: " + T[sConsoleFilter - 2] + LINE_SEP + "fileFilter: " + T[sFileFilter - 2] + LINE_SEP + "stackDeep: " + sStackDeep;
        }
    }
}

