/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.utils;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;

public class AudioUtils {
    private static int lastModel = -10;

    public static void changeToSpeaker(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setMode(3);
        audioManager.stopBluetoothSco();
        audioManager.setBluetoothScoOn(false);
        audioManager.setSpeakerphoneOn(true);
    }

    public static void changeToHeadset(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setMode(3);
        audioManager.startBluetoothSco();
        audioManager.setBluetoothScoOn(true);
        audioManager.setSpeakerphoneOn(false);
    }

    public static void changeToReceiver(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setSpeakerphoneOn(false);
        if (Build.VERSION.SDK_INT >= 11) {
            audioManager.setMode(3);
        } else {
            audioManager.setMode(2);
        }
    }

    public static void dispose(Context context, AudioManager.OnAudioFocusChangeListener focusRequest) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setMode(lastModel);
        if (audioManager.isBluetoothScoOn()) {
            audioManager.setBluetoothScoOn(false);
            audioManager.stopBluetoothSco();
        }
        audioManager.unloadSoundEffects();
        if (null != focusRequest) {
            audioManager.abandonAudioFocus(focusRequest);
        }
    }

    public static void getModel(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        lastModel = audioManager.getMode();
    }

    public static void changeToNomal(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setMode(0);
    }

    public static boolean isWiredHeadsetOn(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager.isWiredHeadsetOn();
    }

    public static boolean isBluetoothA2dpOn(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager.isBluetoothA2dpOn();
    }

    public static void choiceAudioModel(Context context) {
        if (AudioUtils.isWiredHeadsetOn(context)) {
            AudioUtils.changeToReceiver(context);
        } else if (AudioUtils.isBluetoothA2dpOn(context)) {
            AudioUtils.changeToHeadset(context);
        } else {
            AudioUtils.changeToSpeaker(context);
        }
    }

    public static void pauseMusic(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        AudioManager.OnAudioFocusChangeListener focusRequest = focusChange -> {};
        audioManager.requestAudioFocus(focusRequest, 3, 1);
    }
}

