/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.page.call;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Vibrator;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class RingPlayer {
    public static final String TAG = "RingPlayer";
    public final Context mContext;
    private AudioManager mAudioManager;
    private Vibrator mVibrator;
    private MediaPlayer mMediaPlayer;
    private int mRingPlayerErrState;
    private boolean mIsSpkStatusChanged = false;
    private int mRingMode = 0;
    private boolean mIsSpeakerOn = false;
    public boolean isStart = false;
    long mStartTimeMillis;
    private OnRingLooperCallback mRingLooper;
    private CallRingTone mCallRingTone = new CallRingTone();
    private OnRingPlayerCompleteListener mPlayerCompleteListener;
    private OnHangUpRingPlayerCompleteListener mOnHangUpRingPlayerCompleteListener;
    private int mStreamType;
    Handler mHandler = new Handler(Looper.getMainLooper());
    AssetFileDescriptor fileDescriptor;

    public void setOnRingPlayerCompleteListener(OnRingPlayerCompleteListener listener) {
        this.mPlayerCompleteListener = listener;
    }

    public void setOnHangUpRingPlayerCompleteListener(OnHangUpRingPlayerCompleteListener listener) {
        this.mOnHangUpRingPlayerCompleteListener = listener;
    }

    public RingPlayer(Context context) {
        this.mContext = context;
        if (this.mContext != null) {
            if (this.mAudioManager == null) {
                this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
            }
            this.mVibrator = (Vibrator)this.mContext.getSystemService("vibrator");
        }
    }

    public boolean isSilent() {
        return this.mAudioManager.getRingerMode() == 0 || this.mAudioManager.getRingerMode() == 1;
    }

    public void startVibrate() {
        int ringerMode = this.mAudioManager.getRingerMode();
        int vibrateSetting = this.mAudioManager.getVibrateSetting(0);
        if (ringerMode == 1 || ringerMode == 2 && vibrateSetting == 1) {
            this.mVibrator = (Vibrator)this.mContext.getSystemService("vibrator");
            if (this.mVibrator == null) {
                return;
            }
            this.mVibrator.vibrate(new long[]{1000L, 1000L, 1000L, 1000L}, 0);
        }
    }

    public void startVibrateOnce() {
        int ringerMode = this.mAudioManager.getRingerMode();
        int vibrateSetting = this.mAudioManager.getVibrateSetting(0);
        if (ringerMode == 1 || ringerMode == 2 && vibrateSetting == 1) {
            this.mVibrator = (Vibrator)this.mContext.getSystemService("vibrator");
            if (this.mVibrator == null) {
                return;
            }
            this.mVibrator.vibrate(300L);
        }
    }

    public void startPlayCustomRing(CallRing callRing, int streamType) {
        this.startPlayCustomRing(callRing, 1L, streamType);
    }

    public boolean startPlayCustomRing(CallRing callRing, long delayMillis, int streamType) {
        if (!this.isEnableRing(callRing)) {
            Log.d((String)TAG, (String)"not enable play ringTone .");
            return false;
        }
        String ringUri = this.getRingUri(callRing);
        boolean silent = this.isSilent();
        switch (Scheme.ofUri(ringUri)) {
            case ASSETS: {
                return this.playRingStreamFromAssets(ringUri, callRing, delayMillis, streamType, silent);
            }
            case CONTENT: {
                return this.playRingStreamFromContent(ringUri, callRing, delayMillis, streamType, silent);
            }
            case RAW: {
                return this.playRingStreamFromRaw(ringUri, callRing, delayMillis, streamType, silent);
            }
            case FILE: {
                return this.playRingStreamFromFile(ringUri, callRing, delayMillis, streamType, silent);
            }
        }
        return false;
    }

    public boolean startPlayCustomUri(String ringUri, CallRing callRing, long delayMillis, int streamType) {
        boolean silent = this.isSilent();
        return this.playRingStreamFromAssets(ringUri, callRing, delayMillis, streamType, silent);
    }

    private boolean playRingStreamFromAssets(String ringUri, CallRing callRing, long delayMillis, int streamType, boolean silent) {
        String url = Scheme.ASSETS.crop(ringUri);
        try {
            this.fileDescriptor = this.mContext.getAssets().openFd(url);
            if (callRing != CallRing.INCOMING && callRing != CallRing.HANGUP) {
                boolean looping;
                boolean bl = looping = callRing == CallRing.OUTGOING;
                if (callRing == CallRing.OUTGOING) {
                    this.isStart = true;
                    return this.startPlayCustomRing(this.fileDescriptor, null, delayMillis, !silent, streamType);
                }
                return this.startRingBackTone(this.fileDescriptor, null, true, streamType, looping);
            }
            if (callRing == CallRing.HANGUP) {
                return this.startPlayHangUpRing(this.fileDescriptor, null, delayMillis, !silent, streamType);
            }
            return this.startPlayCustomRing(this.fileDescriptor, null, delayMillis, !silent, streamType);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"get Exception on startPlayCustomRing");
            return false;
        }
    }

    private boolean playRingStreamFromContent(String ringUri, CallRing callRing, long delayMillis, int streamType, boolean silent) {
        try {
            Uri uri = Uri.parse((String)ringUri);
            if (callRing != CallRing.INCOMING && callRing != CallRing.HANGUP) {
                boolean looping = callRing == CallRing.OUTGOING;
                return this.startRingBackTone(null, uri, true, streamType, looping);
            }
            if (callRing == CallRing.HANGUP) {
                this.startPlayHangUpRing(null, uri, delayMillis, !silent, streamType);
            }
            return this.startPlayCustomRing(null, uri, delayMillis, !silent, streamType);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"get Exception on startPlayCustomRing");
            return false;
        }
    }

    private boolean playRingStreamFromRaw(String ringUri, CallRing callRing, long delayMillis, int streamType, boolean silent) {
        int resource = 0;
        try {
            resource = Integer.parseInt(Scheme.RAW.crop(ringUri));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (callRing != CallRing.INCOMING && callRing != CallRing.HANGUP) {
            boolean looping = callRing == CallRing.OUTGOING;
            return this.startRingBackTone(resource, true, streamType, looping);
        }
        if (callRing == CallRing.HANGUP) {
            this.startPlayHangUpRing(resource, delayMillis, !silent, streamType);
        }
        return this.startPlayCustomRing(resource, delayMillis, !silent, streamType);
    }

    private boolean playRingStreamFromFile(String ringUri, CallRing callRing, long delayMillis, int streamType, boolean silent) {
        String _ringUri = Scheme.FILE.crop(ringUri);
        if (callRing != CallRing.INCOMING && callRing != CallRing.HANGUP) {
            boolean looping = callRing == CallRing.OUTGOING;
            return this.startRingBackTone(null, Uri.fromFile((File)new File(_ringUri)), true, streamType, looping);
        }
        if (callRing == CallRing.HANGUP) {
            this.startPlayHangUpRing(null, Uri.fromFile((File)new File(_ringUri)), delayMillis, !silent, streamType);
        }
        return this.startPlayCustomRing(null, Uri.fromFile((File)new File(_ringUri)), delayMillis, !silent, streamType);
    }

    public boolean startPlayCustomRing(int resource, long delayMillis, boolean initVolume, int streamType) {
        Uri uri = Uri.parse((String)("android.resource://" + this.mContext.getPackageName() + "/" + resource));
        return this.startPlayCustomRing(null, uri, delayMillis, initVolume, streamType);
    }

    public boolean startPlayHangUpRing(int resource, long delayMillis, boolean initVolume, int streamType) {
        Uri uri = Uri.parse((String)("android.resource://" + this.mContext.getPackageName() + "/" + resource));
        return this.startPlayHangUpRing(null, uri, delayMillis, initVolume, streamType);
    }

    private boolean startPlayCustomRing(final AssetFileDescriptor descriptor, final Uri resource, final long delayMillis, final boolean ring, final int streamType) {
        this.mStartTimeMillis = System.currentTimeMillis();
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.reset();
        try {
            this.mStreamType = streamType;
            if (descriptor != null) {
                this.mMediaPlayer.setDataSource(descriptor.getFileDescriptor(), descriptor.getStartOffset(), descriptor.getLength());
            } else {
                this.mMediaPlayer.setDataSource(this.mContext, resource);
            }
            this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    try {
                        if (descriptor != null && !RingPlayer.this.isStart) {
                            descriptor.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (RingPlayer.this.mMediaPlayer != null) {
                        try {
                            RingPlayer.this.mMediaPlayer.stop();
                            RingPlayer.this.mMediaPlayer.release();
                        }
                        catch (Exception e) {
                            Log.w((String)RingPlayer.TAG, (String)"PlayCustomRing MediaPlayer onCompletion Exception");
                            Log.e((String)RingPlayer.TAG, (String)"PlayCustomRing MediaPlayer OnCompletionListener, ");
                        }
                        finally {
                            RingPlayer.this.mMediaPlayer = null;
                        }
                    }
                    if (System.currentTimeMillis() - RingPlayer.this.mStartTimeMillis > 70000L) {
                        RingPlayer.this.mRingPlayerErrState = 4;
                    }
                    if (RingPlayer.this.isStart) {
                        RingPlayer.this.mRingLooper = new OnRingLooperCallback(descriptor, resource, delayMillis, ring, streamType);
                        RingPlayer.this.mHandler.postDelayed((Runnable)RingPlayer.this.mRingLooper, delayMillis);
                    }
                }
            });
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean onError(MediaPlayer mp, int what, int extra) {
                    try {
                        if (descriptor != null) {
                            descriptor.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (RingPlayer.this.mMediaPlayer != null) {
                        try {
                            RingPlayer.this.mMediaPlayer.stop();
                            RingPlayer.this.mMediaPlayer.release();
                        }
                        catch (Exception e) {
                            Log.w((String)RingPlayer.TAG, (String)"PlayCustomRing MediaPlayer OnErrorListener Exception");
                            Log.e((String)RingPlayer.TAG, (String)"PlayCustomRing MediaPlayer OnErrorListener, ");
                        }
                        finally {
                            RingPlayer.this.mMediaPlayer = null;
                        }
                    }
                    RingPlayer.this.mRingPlayerErrState = 1;
                    return false;
                }
            });
            this.mMediaPlayer.setAudioStreamType(this.mStreamType);
            if (ring) {
                this.mMediaPlayer.setVolume(0.6f, 0.6f);
                this.mMediaPlayer.setLooping(false);
                this.mMediaPlayer.prepare();
                this.mMediaPlayer.start();
            } else {
                this.mMediaPlayer.setLooping(false);
                this.mMediaPlayer.prepare();
                this.mMediaPlayer.start();
            }
            if (System.currentTimeMillis() - this.mStartTimeMillis > 2000L) {
                this.mRingPlayerErrState = 3;
            }
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"new MediaPlayer failed, ");
            return false;
        }
    }

    private boolean startPlayHangUpRing(final AssetFileDescriptor descriptor, Uri resource, long delayMillis, boolean ring, int streamType) {
        this.mStartTimeMillis = System.currentTimeMillis();
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.reset();
        try {
            this.mStreamType = streamType;
            if (descriptor != null) {
                this.mMediaPlayer.setDataSource(descriptor.getFileDescriptor(), descriptor.getStartOffset(), descriptor.getLength());
            } else {
                this.mMediaPlayer.setDataSource(this.mContext, resource);
            }
            this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    try {
                        if (descriptor != null) {
                            descriptor.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)RingPlayer.TAG, (String)"PlayHangUpRing MediaPlayer onCompletion");
                    if (RingPlayer.this.mMediaPlayer != null) {
                        try {
                            Log.d((String)RingPlayer.TAG, (String)"PlayHangUpRing MediaPlayer onCompletion stop mediaplayer");
                            RingPlayer.this.mMediaPlayer.stop();
                            RingPlayer.this.mMediaPlayer.release();
                        }
                        catch (Exception e) {
                            Log.d((String)RingPlayer.TAG, (String)"PlayHangUpRing MediaPlayer OnCompletionListener Exception");
                            Log.e((String)RingPlayer.TAG, (String)"PlayHangUpRing MediaPlayer OnCompletionListener, ");
                        }
                        finally {
                            RingPlayer.this.mMediaPlayer = null;
                            if (RingPlayer.this.mOnHangUpRingPlayerCompleteListener != null) {
                                RingPlayer.this.mOnHangUpRingPlayerCompleteListener.onHangUpRingPlayerComplete();
                                RingPlayer.this.mOnHangUpRingPlayerCompleteListener = null;
                            }
                        }
                    }
                    if (System.currentTimeMillis() - RingPlayer.this.mStartTimeMillis > 70000L) {
                        RingPlayer.this.mRingPlayerErrState = 4;
                    }
                    Log.d((String)RingPlayer.TAG, (String)"RingPlayer setOnCompletionListener onCompletion");
                    if (RingPlayer.this.mOnHangUpRingPlayerCompleteListener != null) {
                        RingPlayer.this.mOnHangUpRingPlayerCompleteListener.onHangUpRingPlayerComplete();
                        RingPlayer.this.mOnHangUpRingPlayerCompleteListener = null;
                    }
                }
            });
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean onError(MediaPlayer mp, int what, int extra) {
                    try {
                        if (descriptor != null) {
                            descriptor.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (RingPlayer.this.mMediaPlayer != null) {
                        try {
                            RingPlayer.this.mMediaPlayer.stop();
                            RingPlayer.this.mMediaPlayer.release();
                        }
                        catch (Exception e) {
                            Log.w((String)RingPlayer.TAG, (String)"PlayHangUpRing MediaPlayer OnErrorListener Exception");
                            Log.e((String)RingPlayer.TAG, (String)"PlayHangUpRing MediaPlayer OnErrorListener, ");
                        }
                        finally {
                            RingPlayer.this.mMediaPlayer = null;
                            if (RingPlayer.this.mOnHangUpRingPlayerCompleteListener != null) {
                                RingPlayer.this.mOnHangUpRingPlayerCompleteListener.onHangUpRingPlayerComplete();
                                RingPlayer.this.mOnHangUpRingPlayerCompleteListener = null;
                            }
                        }
                    }
                    if (RingPlayer.this.mOnHangUpRingPlayerCompleteListener != null) {
                        RingPlayer.this.mOnHangUpRingPlayerCompleteListener.onHangUpRingPlayerComplete();
                        RingPlayer.this.mOnHangUpRingPlayerCompleteListener = null;
                    }
                    RingPlayer.this.mRingPlayerErrState = 1;
                    return false;
                }
            });
            this.mMediaPlayer.setAudioStreamType(this.mStreamType);
            if (ring) {
                this.mMediaPlayer.setVolume(0.6f, 0.6f);
                this.mMediaPlayer.setLooping(false);
                this.mMediaPlayer.prepare();
                this.mMediaPlayer.start();
            } else if (this.mOnHangUpRingPlayerCompleteListener != null) {
                this.mOnHangUpRingPlayerCompleteListener.onHangUpRingPlayerComplete();
                this.mOnHangUpRingPlayerCompleteListener = null;
            }
            this.startVibrateOnce();
            if (System.currentTimeMillis() - this.mStartTimeMillis > 2000L) {
                this.mRingPlayerErrState = 3;
            }
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"new MediaPlayer failed, ");
            if (this.mOnHangUpRingPlayerCompleteListener != null) {
                this.mOnHangUpRingPlayerCompleteListener.onHangUpRingPlayerComplete();
                this.mOnHangUpRingPlayerCompleteListener = null;
            }
            return false;
        }
    }

    public void startRingBackTone(int resource, boolean initVolume, int streamType) {
        Uri uri = Uri.parse((String)("android.resource://" + this.mContext.getPackageName() + "/" + resource));
        this.startRingBackTone(null, uri, initVolume, streamType, true);
    }

    public boolean startRingBackTone(int resource, boolean initVolume, int streamType, boolean looping) {
        Uri uri = Uri.parse((String)("android.resource://" + this.mContext.getPackageName() + "/" + resource));
        return this.startRingBackTone(null, uri, initVolume, streamType, looping);
    }

    private boolean startRingBackTone(AssetFileDescriptor descriptor, Uri resource, boolean ring, int streamType, boolean looping) {
        this.mStartTimeMillis = System.currentTimeMillis();
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.reset();
        try {
            this.mStreamType = streamType;
            if (descriptor != null) {
                this.mMediaPlayer.setDataSource(descriptor.getFileDescriptor(), descriptor.getStartOffset(), descriptor.getLength());
            } else {
                this.mMediaPlayer.setDataSource(this.mContext, resource);
            }
            this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    if (RingPlayer.this.mMediaPlayer != null) {
                        try {
                            RingPlayer.this.mMediaPlayer.stop();
                            RingPlayer.this.mMediaPlayer.release();
                        }
                        catch (Exception e) {
                            Log.w((String)RingPlayer.TAG, (String)"RingBackTone MediaPlayer OnCompletionListener Exception");
                            Log.e((String)RingPlayer.TAG, (String)"RingBackTone MediaPlayer OnCompletionListener, ");
                        }
                        finally {
                            RingPlayer.this.mMediaPlayer = null;
                        }
                    }
                    if (System.currentTimeMillis() - RingPlayer.this.mStartTimeMillis > 70000L) {
                        RingPlayer.this.mRingPlayerErrState = 4;
                    }
                    if (RingPlayer.this.mPlayerCompleteListener != null) {
                        RingPlayer.this.mPlayerCompleteListener.onRingPlayerComplete();
                        RingPlayer.this.mPlayerCompleteListener = null;
                    }
                }
            });
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean onError(MediaPlayer mp, int what, int extra) {
                    if (RingPlayer.this.mMediaPlayer != null) {
                        try {
                            RingPlayer.this.mMediaPlayer.stop();
                            RingPlayer.this.mMediaPlayer.release();
                        }
                        catch (Exception e) {
                            Log.w((String)RingPlayer.TAG, (String)"RingBackTone MediaPlayer OnErrorListener Exception");
                            Log.e((String)RingPlayer.TAG, (String)"RingBackTone MediaPlayer OnErrorListener, ");
                        }
                        finally {
                            RingPlayer.this.mMediaPlayer = null;
                        }
                    }
                    RingPlayer.this.mRingPlayerErrState = 1;
                    return false;
                }
            });
            this.setSpeakerStatus(true);
            this.mMediaPlayer.setAudioStreamType(this.mStreamType);
            if (ring) {
                this.mMediaPlayer.setVolume(0.6f, 0.6f);
                this.mMediaPlayer.setLooping(looping);
                this.mMediaPlayer.prepare();
                this.mMediaPlayer.start();
            }
            if (System.currentTimeMillis() - this.mStartTimeMillis > 2000L) {
                this.mRingPlayerErrState = 3;
            }
            this.isStart = true;
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"new MediaPlayer failed, ");
            if (this.mPlayerCompleteListener != null) {
                this.mPlayerCompleteListener.onRingPlayerComplete();
                this.mPlayerCompleteListener = null;
            }
            return false;
        }
    }

    public final boolean isCallIdea() {
        return !this.isStart;
    }

    public int getRingPlayerState() {
        Log.d((String)TAG, (String)("RingPlayer  mRingPlayerErrState: %d" + this.mRingPlayerErrState));
        return this.mRingPlayerErrState;
    }

    public void setSpeakerStatus(boolean isSpeakerOn) {
        Log.d((String)TAG, (String)("setSpeakerStatus, isSpeakerOn: %b, mIsSpkStatusChanged: %b" + isSpeakerOn + this.mIsSpkStatusChanged));
        if (!this.mIsSpkStatusChanged) {
            this.mRingMode = this.mAudioManager.getMode();
            this.mIsSpeakerOn = this.mAudioManager.isSpeakerphoneOn();
        }
        Log.e((String)TAG, (String)("setSpeakerStatus mode is" + this.mAudioManager.getMode()));
    }

    public void stop() {
        Log.d((String)TAG, (String)("stop isStarted: %b" + this.isStart));
        if (this.mVibrator != null) {
            this.mVibrator.cancel();
            this.mVibrator = null;
        }
        if (this.fileDescriptor != null) {
            try {
                this.fileDescriptor.close();
                this.fileDescriptor = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.mMediaPlayer != null) {
            try {
                Log.d((String)TAG, (String)"RingPlayer stop ");
                this.mMediaPlayer.stop();
                this.mMediaPlayer.release();
                this.mMediaPlayer = null;
                if (this.mRingLooper != null) {
                    this.mHandler.removeCallbacks((Runnable)this.mRingLooper);
                }
            }
            catch (Exception e) {
                if (this.mMediaPlayer != null) {
                    try {
                        this.mMediaPlayer.release();
                    }
                    catch (Exception e1) {
                        Log.e((String)TAG, (String)"get Exception MediaPlayer stop mMediaPlayer.release()");
                    }
                }
                Log.d((String)TAG, (String)"RingPlayer stop Exception");
                Log.e((String)TAG, (String)"get Exception MediaPlayer stop");
            }
            finally {
                this.mMediaPlayer = null;
            }
        }
        try {
            this.isStart = false;
            if (this.mIsSpkStatusChanged) {
                this.mAudioManager.setSpeakerphoneOn(this.mIsSpeakerOn);
                this.mAudioManager.setMode(this.mRingMode);
            }
            if (Build.BRAND.equalsIgnoreCase("Freescale") && !Build.MODEL.equalsIgnoreCase("XE1109S") && !Build.MODEL.equalsIgnoreCase("XE1103H")) {
                this.mAudioManager.setMode(-1);
            }
            this.mIsSpkStatusChanged = false;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"RingPlayer stop Exception2");
        }
        this.mMediaPlayer = null;
    }

    public void setMode() {
        if (Build.MODEL.equalsIgnoreCase("XE1109S") || Build.MODEL.equalsIgnoreCase("XE1103H")) {
            Log.e((String)TAG, (String)"set mode 0 for car device");
            Log.e((String)TAG, (String)"oncallrelease");
            this.mAudioManager.setMode(0);
        } else if (this.mAudioManager != null) {
            this.mAudioManager.setMode(-1);
        }
    }

    public void setCallRingToneUri(boolean enabled, String ringType, String ringUrl) {
        if (this.mCallRingTone == null) {
            this.mCallRingTone = new CallRingTone();
        }
        if ("InComing".equals(ringType)) {
            this.mCallRingTone.inComingEnabled = enabled;
            this.mCallRingTone.inComingUri = ringUrl;
            this.mCallRingTone.setting = true;
        }
        if ("OutGoing".equals(ringType)) {
            this.mCallRingTone.outGoingEnabled = enabled;
            this.mCallRingTone.outGoingUri = ringUrl;
            this.mCallRingTone.setting = true;
        }
        if ("Disconnect".equals(ringType)) {
            this.mCallRingTone.DisconnectEnabled = enabled;
            this.mCallRingTone.DisconnectUri = ringUrl;
            this.mCallRingTone.setting = true;
        }
        if ("Ring_silent".equals(ringType)) {
            this.stop();
        }
        if ("HangUp".equals(ringType)) {
            this.mCallRingTone.hangupEnabled = enabled;
            this.mCallRingTone.hangupUri = ringUrl;
            this.mCallRingTone.setting = true;
        }
    }

    public boolean isEnableRing(CallRing callRing) {
        if (this.mCallRingTone == null) {
            return true;
        }
        switch (callRing) {
            case INCOMING: {
                return this.mCallRingTone.inComingEnabled;
            }
            case OUTGOING: {
                return this.mCallRingTone.outGoingEnabled;
            }
            case BUSY: {
                return this.mCallRingTone.DisconnectEnabled;
            }
            case HANGUP: {
                return this.mCallRingTone.hangupEnabled;
            }
        }
        return false;
    }

    public String getRingUri(CallRing callRing) {
        switch (callRing) {
            case INCOMING: {
                if (Build.BRAND.equalsIgnoreCase("Freescale") && (Build.MODEL.equalsIgnoreCase("XE1109S") || Build.MODEL.equalsIgnoreCase("XE1103H"))) {
                    return "assets://incoming.ogg";
                }
                return this.mCallRingTone.inComingUri;
            }
            case OUTGOING: {
                if (Build.BRAND.equalsIgnoreCase("Freescale")) {
                    return "assets://outgoing.ogg";
                }
                return this.mCallRingTone.outGoingUri;
            }
            case BUSY: {
                if (Build.BRAND.equalsIgnoreCase("Freescale")) {
                    return "assets://busy.ogg";
                }
                return this.mCallRingTone.DisconnectUri;
            }
            case HANGUP: {
                if (Build.BRAND.equalsIgnoreCase("Freescale")) {
                    return "assets://playend.mp3";
                }
                return this.mCallRingTone.hangupUri;
            }
        }
        return null;
    }

    public boolean isCallRing() {
        return this.mMediaPlayer != null && this.isStart;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public static enum CallRing {
        INCOMING,
        OUTGOING,
        BUSY,
        HANGUP;

    }

    public static class CallRingTone {
        boolean setting = false;
        boolean inComingEnabled = true;
        boolean outGoingEnabled = true;
        boolean DisconnectEnabled = true;
        boolean hangupEnabled = false;
        String inComingUri = "assets://incoming.ogg";
        String outGoingUri = "assets://outgoing.ogg";
        String DisconnectUri = "assets://busy.ogg";
        String hangupUri = "assets://playend.mp3";
    }

    public static enum Scheme {
        FILE("file"),
        CONTENT("content"),
        ASSETS("assets"),
        RAW("raw"),
        UNKNOWN("");

        private String scheme;
        private String uriPrefix;

        private Scheme(String scheme) {
            this.scheme = scheme;
            this.uriPrefix = scheme + "://";
        }

        public static Scheme ofUri(String uri) {
            if (uri != null) {
                for (Scheme s : Scheme.values()) {
                    if (!s.belongsTo(uri)) continue;
                    return s;
                }
            }
            return UNKNOWN;
        }

        private boolean belongsTo(String uri) {
            return uri.toLowerCase(Locale.US).startsWith(this.uriPrefix);
        }

        public String wrap(String path) {
            return this.uriPrefix + path;
        }

        public String crop(String uri) {
            if (!this.belongsTo(uri)) {
                throw new IllegalArgumentException(String.format("URI [%1$s] doesn't have expected scheme [%2$s]", uri, this.scheme));
            }
            return uri.substring(this.uriPrefix.length());
        }
    }

    public static interface OnHangUpRingPlayerCompleteListener {
        public void onHangUpRingPlayerComplete();
    }

    public static interface OnRingPlayerCompleteListener {
        public void onRingPlayerComplete();
    }

    private final class OnRingLooperCallback
    implements Runnable {
        private AssetFileDescriptor _fileDescriptor;
        private Uri _resource;
        private long _delayMillis;
        private boolean _initVolume;
        private int _streamType;

        public OnRingLooperCallback(AssetFileDescriptor descriptor, Uri resource, long delayMillis, boolean initVolume, int streamType) {
            this._fileDescriptor = descriptor;
            this._resource = resource;
            this._delayMillis = delayMillis;
            this._initVolume = initVolume;
            this._streamType = streamType;
        }

        @Override
        public void run() {
            RingPlayer.this.startPlayCustomRing(this._fileDescriptor, this._resource, this._delayMillis, this._initVolume, this._streamType);
        }
    }
}

