/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.manager;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.useasy.callsdk.bean.AccountBean;
import com.useasy.callsdk.bean.AgentBean;
import com.useasy.callsdk.bean.LoginInfo;
import com.useasy.callsdk.listener.SocketMessageListener;
import com.useasy.callsdk.manager.CallManager;
import com.useasy.callsdk.manager.LoginManager;
import com.useasy.callsdk.manager.SocketManager;
import com.useasy.callsdk.utils.DeviceUtils;
import com.useasy.callsdk.utils.Loger;
import com.useasy.callsdk.utils.SPUtils;
import com.useasy.callsdk.utils.SocketConnectionState;
import com.useasy.callsdk.utils.socket.AppSocketManager;
import com.useasy.callsdk.utils.socket.websocket.SimpleListener;
import com.useasy.callsdk.utils.socket.websocket.WebSocketHandler;
import com.useasy.callsdk.utils.socket.websocket.WebSocketManager;
import com.useasy.callsdk.utils.socket.websocket.WebSocketSetting;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0002J\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\nJ\u0010\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/useasy/callsdk/manager/SocketManager;", "", "()V", "isSocketConnected", "", "messageListener", "Lcom/useasy/callsdk/listener/SocketMessageListener;", "socketListener", "Lcom/useasy/callsdk/utils/socket/websocket/SimpleListener;", "connectSocket", "", "disconnectSocket", "extractJsonFromMessage", "", "message", "handleKicked", "handleMessage", "messageType", "messageData", "handleSocketMessage", "isConnected", "onSocketConnectFailed", "error", "onSocketConnected", "onSocketDisconnected", "setMessageListener", "listener", "callsdk_release"})
public final class SocketManager {
    private static SocketMessageListener messageListener;
    private static boolean isSocketConnected;
    private static SimpleListener socketListener;
    @NotNull
    public static final SocketManager INSTANCE;

    public final void setMessageListener(@Nullable SocketMessageListener listener) {
        messageListener = listener;
    }

    public final void connectSocket() {
        try {
            LoginInfo loginInfo = LoginManager.INSTANCE.getLoginInfo();
            if (loginInfo == null) {
                Loger.eTag("SocketManager", "LoginInfo is null, cannot connect socket");
                return;
            }
            String wsUrl = SPUtils.getString("WS_HOST", "");
            if (TextUtils.isEmpty((CharSequence)wsUrl)) {
                Loger.eTag("SocketManager", "WS_HOST is empty, cannot connect socket");
                return;
            }
            String wsToken = SPUtils.getString("wsToken", "");
            String timestamp = SPUtils.getString("timestamp", "");
            if (TextUtils.isEmpty((CharSequence)wsToken) || TextUtils.isEmpty((CharSequence)timestamp)) {
                Loger.eTag("SocketManager", "WS_TOKEN or WS_TIMESTAMP is empty, cannot connect socket");
                return;
            }
            Loger.dTag("SocketManager", "\u51c6\u5907\u8fde\u63a5 Socket: " + wsUrl);
            this.disconnectSocket();
            String wsExtra = "{\"loginType\":\"WEBRTC\",\"channelType\":\"APP\",\"ability\":[\"call\"]}";
            StringBuilder sb = new StringBuilder();
            StringBuilder stringBuilder = sb.append("agentId=");
            Object object = loginInfo.getAgent();
            if (object == null || (object = ((AgentBean)object).get_id()) == null) {
                object = "";
            }
            stringBuilder.append((String)object);
            StringBuilder stringBuilder2 = sb.append("&agentNumber=");
            Object object2 = loginInfo.getAgent();
            if (object2 == null || (object2 = ((AgentBean)object2).getAgentNumber()) == null) {
                object2 = "";
            }
            stringBuilder2.append((String)object2);
            StringBuilder stringBuilder3 = sb.append("&accountId=");
            Object object3 = loginInfo.getAccount();
            if (object3 == null || (object3 = ((AccountBean)object3).get_id()) == null) {
                object3 = "";
            }
            stringBuilder3.append((String)object3);
            sb.append("&token=").append(wsToken);
            sb.append("&wsExtra=").append(URLEncoder.encode(wsExtra, StandardCharsets.UTF_8.toString()));
            sb.append("&timestamp=").append(timestamp);
            sb.append("&clientType=").append(2);
            sb.append("&EIO=4");
            sb.append("&transport=websocket");
            sb.append("&loginDevice=").append(DeviceUtils.INSTANCE.getLoginDevice());
            String connectUrl = "wss://" + wsUrl + "/socket.io/?" + sb;
            Loger.dTag("SocketManager", "WebSocket URL: " + connectUrl);
            WebSocketSetting setting = new WebSocketSetting();
            setting.setConnectUrl(connectUrl);
            setting.setConnectTimeout(15000);
            setting.setConnectionLostTimeout(30);
            setting.setReconnectFrequency(10);
            setting.setReconnectWithNetworkChanged(true);
            socketListener = new SimpleListener(){

                public void onConnected() {
                    WebSocketManager client;
                    Loger.dTag("SocketManager", "Socket \u8fde\u63a5\u6210\u529f");
                    SocketManager.access$setSocketConnected$p(SocketManager.INSTANCE, true);
                    SocketConnectionState.IS_SOCKET_CONNECTED = true;
                    AppSocketManager.getInstance().setLogin(true);
                    AppSocketManager.getInstance().setKicked(false);
                    WebSocketManager webSocketManager = client = AppSocketManager.getInstance().getAppSocketClient();
                    if (webSocketManager != null) {
                        webSocketManager.sendPing();
                    }
                    new Handler(Looper.getMainLooper()).post((Runnable)connectSocket.onConnected.1.INSTANCE);
                }

                public void onConnectFailed(@NotNull Throwable e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Loger.eTag("SocketManager", "Socket \u8fde\u63a5\u5931\u8d25: " + e.getMessage());
                    SocketManager.access$setSocketConnected$p(SocketManager.INSTANCE, false);
                    new Handler(Looper.getMainLooper()).post(new Runnable(e){
                        final /* synthetic */ Throwable $e;

                        public final void run() {
                            SocketManager.INSTANCE.onSocketConnectFailed(this.$e.getMessage());
                        }
                        {
                            this.$e = throwable;
                        }
                    });
                }

                public void onDisconnect() {
                    Loger.dTag("SocketManager", "Socket \u8fde\u63a5\u65ad\u5f00");
                    SocketManager.access$setSocketConnected$p(SocketManager.INSTANCE, false);
                    SocketConnectionState.IS_SOCKET_CONNECTED = false;
                    AppSocketManager.getInstance().setLogin(false);
                    new Handler(Looper.getMainLooper()).post((Runnable)connectSocket.onDisconnect.1.INSTANCE);
                }

                public <T> void onMessage(@NotNull String message, T data) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    Loger.dTag("SocketManager", "\u6536\u5230 Socket \u6d88\u606f: " + message);
                    SocketManager.access$handleSocketMessage(SocketManager.INSTANCE, message);
                }
            };
            WebSocketManager manager = WebSocketHandler.initGeneralWebSocket("AppSocketService", setting);
            manager.addListener(socketListener);
            manager.start();
        }
        catch (Exception e) {
            Loger.eTag("SocketManager", "\u8fde\u63a5 Socket \u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            this.onSocketConnectFailed(e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleSocketMessage(String message) {
        try {
            if (TextUtils.isEmpty((CharSequence)message)) {
                return;
            }
            if (Intrinsics.areEqual((Object)"2", (Object)message)) {
                v0 = client = AppSocketManager.getInstance().getAppSocketClient();
                if (v0 != null) {
                    v0.send("3");
                }
                return;
            }
            if (StringsKt.startsWith$default((String)message, (String)"40", (boolean)false, (int)2, null)) {
                jsonStr = this.extractJsonFromMessage(message);
                var3_6 = jsonStr;
                var4_9 = false;
                if (var3_6.length() > 0) {
                    try {
                        jsonObject = new JSONObject(jsonStr);
                        v1 = sid = jsonObject.optString("sid", "");
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"sid");
                        var5_13 = v1;
                        var6_15 = false;
                        if (var5_13.length() > 0) {
                            Loger.dTag("SocketManager", new Object[]{"Socket.io connected, sid: " + sid});
                        }
                    }
                    catch (Exception e) {
                        Loger.eTag("SocketManager", new Object[]{"\u89e3\u6790\u8fde\u63a5\u786e\u8ba4\u6d88\u606f\u5931\u8d25: " + e.getMessage()});
                    }
                }
                return;
            }
            jsonStr = this.extractJsonFromMessage(message);
            e = jsonStr;
            sid = false;
            if (e.length() == 0) {
                Loger.wTag("SocketManager", new Object[]{"\u65e0\u6cd5\u63d0\u53d6 JSON \u5b57\u7b26\u4e32: " + message});
                return;
            }
            jsonArray = new JSONArray(jsonStr);
            if (jsonArray.length() == 0) {
                return;
            }
            v2 = type = jsonArray.getString(0);
            if (v2 == null) ** GOTO lbl-1000
            var5_14 = v2;
            tmp = -1;
            switch (var5_14.hashCode()) {
                case 3045982: {
                    if (!var5_14.equals("call")) break;
                    tmp = 1;
                    break;
                }
                case 3364: {
                    if (!var5_14.equals("im")) break;
                    tmp = 2;
                    break;
                }
                case 96891546: {
                    if (!var5_14.equals("event")) break;
                    tmp = 3;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    if (jsonArray.length() > 1) {
                        callObj = jsonArray.getJSONObject(1);
                        try {
                            dataObj = callObj.optJSONObject("data");
                            if (dataObj != null && Intrinsics.areEqual((Object)"hangup", (Object)(eventType = dataObj.optString("eventType", "")))) {
                                callId = dataObj.optString("callId", "");
                                Loger.dTag("SocketManager", new Object[]{"\u68c0\u6d4b\u5230 hangup \u6d88\u606f, callId: " + callId});
                                v3 = callId;
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"callId");
                                var10_23 = v3;
                                var11_24 = false;
                                CallManager.INSTANCE.handleHangupFromSocket(var10_23.length() > 0 != false ? callId : null);
                            }
                        }
                        catch (Exception e) {
                            Loger.eTag("SocketManager", new Object[]{"\u89e3\u6790 hangup \u6d88\u606f\u5931\u8d25: " + e.getMessage()});
                        }
                        new Handler(Looper.getMainLooper()).post(new Runnable(callObj){
                            final /* synthetic */ JSONObject $callObj;

                            public final void run() {
                                block0: {
                                    SocketMessageListener socketMessageListener = SocketManager.access$getMessageListener$p(SocketManager.INSTANCE);
                                    if (socketMessageListener == null) break block0;
                                    socketMessageListener.onMessage("CALL", this.$callObj.toString());
                                }
                            }
                            {
                                this.$callObj = jSONObject;
                            }
                        });
                    }
                    break;
                }
                case 3: {
                    if (jsonArray.length() > 1) {
                        eventObj = jsonArray.getJSONObject(1);
                        subType = eventObj.optString("subType", "");
                        if (Intrinsics.areEqual((Object)"KICK_OFF", (Object)subType)) {
                            this.handleKicked();
                        } else {
                            new Handler(Looper.getMainLooper()).post(new Runnable(eventObj){
                                final /* synthetic */ JSONObject $eventObj;

                                public final void run() {
                                    block0: {
                                        SocketMessageListener socketMessageListener = SocketManager.access$getMessageListener$p(SocketManager.INSTANCE);
                                        if (socketMessageListener == null) break block0;
                                        socketMessageListener.onMessage("EVENT", this.$eventObj.toString());
                                    }
                                }
                                {
                                    this.$eventObj = jSONObject;
                                }
                            });
                        }
                    }
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    Loger.wTag("SocketManager", new Object[]{"\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b: " + type});
                    new Handler(Looper.getMainLooper()).post(new Runnable(message){
                        final /* synthetic */ String $message;

                        public final void run() {
                            block0: {
                                SocketMessageListener socketMessageListener = SocketManager.access$getMessageListener$p(SocketManager.INSTANCE);
                                if (socketMessageListener == null) break block0;
                                socketMessageListener.onMessage("UNKNOWN", this.$message);
                            }
                        }
                        {
                            this.$message = string;
                        }
                    });
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        catch (Exception var2_5) {
            // empty catch block
        }
    }

    private final String extractJsonFromMessage(String message) {
        String string;
        Pattern pattern = Pattern.compile("\\{.*\\}|\\[.*\\]");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            String string2 = matcher.group();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group()");
        } else {
            string = "";
        }
        return string;
    }

    public final void disconnectSocket() {
        try {
            WebSocketManager client = AppSocketManager.getInstance().getAppSocketClient();
            if (client != null && client.isConnect()) {
                client.send("quit\n");
                client.disConnect();
                client.destroy();
            }
            WebSocketHandler.removeWebSocket("AppSocketService");
            AppSocketManager.getInstance().setLogin(false);
            isSocketConnected = false;
            socketListener = null;
            Loger.dTag("SocketManager", "\u65ad\u5f00 Socket \u8fde\u63a5");
        }
        catch (Exception e) {
            Loger.eTag("SocketManager", "\u65ad\u5f00 Socket \u8fde\u63a5\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private final void handleKicked() {
        block0: {
            Loger.eTag("SocketManager", "\u6536\u5230\u88ab\u8e22\u6d88\u606f");
            isSocketConnected = false;
            this.disconnectSocket();
            SocketMessageListener socketMessageListener = messageListener;
            if (socketMessageListener == null) break block0;
            socketMessageListener.onKicked();
        }
    }

    private final void handleMessage(String messageType, String messageData) {
        block0: {
            Loger.dTag("SocketManager", "\u6536\u5230 Socket \u6d88\u606f: " + messageType);
            SocketMessageListener socketMessageListener = messageListener;
            if (socketMessageListener == null) break block0;
            socketMessageListener.onMessage(messageType, messageData);
        }
    }

    public final void onSocketConnected() {
        block0: {
            isSocketConnected = true;
            Loger.dTag("SocketManager", "Socket \u8fde\u63a5\u6210\u529f");
            SocketMessageListener socketMessageListener = messageListener;
            if (socketMessageListener == null) break block0;
            socketMessageListener.onSocketConnected();
        }
    }

    public final void onSocketDisconnected() {
        block0: {
            isSocketConnected = false;
            Loger.dTag("SocketManager", "Socket \u8fde\u63a5\u65ad\u5f00");
            SocketMessageListener socketMessageListener = messageListener;
            if (socketMessageListener == null) break block0;
            socketMessageListener.onSocketDisconnected();
        }
    }

    public final void onSocketConnectFailed(@Nullable String error) {
        block0: {
            isSocketConnected = false;
            Loger.eTag("SocketManager", "Socket \u8fde\u63a5\u5931\u8d25: " + error);
            SocketMessageListener socketMessageListener = messageListener;
            if (socketMessageListener == null) break block0;
            socketMessageListener.onSocketConnectFailed(error);
        }
    }

    public final boolean isConnected() {
        return isSocketConnected;
    }

    private SocketManager() {
    }

    static {
        SocketManager socketManager;
        INSTANCE = socketManager = new SocketManager();
    }

    public static final /* synthetic */ boolean access$isSocketConnected$p(SocketManager $this) {
        SocketManager socketManager = $this;
        return isSocketConnected;
    }

    public static final /* synthetic */ void access$setSocketConnected$p(SocketManager $this, boolean bl) {
        SocketManager socketManager = $this;
        isSocketConnected = bl;
    }

    public static final /* synthetic */ void access$handleSocketMessage(SocketManager $this, String message) {
        $this.handleSocketMessage(message);
    }

    public static final /* synthetic */ SocketMessageListener access$getMessageListener$p(SocketManager $this) {
        SocketManager socketManager = $this;
        return messageListener;
    }

    public static final /* synthetic */ void access$setMessageListener$p(SocketManager $this, SocketMessageListener socketMessageListener) {
        SocketManager socketManager = $this;
        messageListener = socketMessageListener;
    }
}

