/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.manager;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import com.useasy.callsdk.CallSDK;
import com.useasy.callsdk.NativeCallInterface;
import com.useasy.callsdk.bean.SipParams;
import com.useasy.callsdk.impl.NativeCallInterfaceImpl;
import com.useasy.callsdk.listener.CallEventCallback;
import com.useasy.callsdk.listener.CallStateListener;
import com.useasy.callsdk.manager.CallManager;
import com.useasy.callsdk.utils.AudioUtils;
import com.useasy.callsdk.utils.Loger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006J\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0019\u001a\u00020\u0006J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\u000eJ\u0018\u0010!\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\"\u001a\u00020\fJ\u0018\u0010#\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0006J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u000e\u0010)\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/useasy/callsdk/manager/CallManager;", "", "()V", "currentCallStateListener", "Lcom/useasy/callsdk/listener/CallStateListener;", "isCallInitialized", "", "nativeCallInterface", "Lcom/useasy/callsdk/NativeCallInterface;", "pendingSipParams", "Lcom/useasy/callsdk/bean/SipParams;", "acceptCall", "", "callId", "", "createCallEventCallbackAdapter", "Lcom/useasy/callsdk/listener/CallEventCallback;", "listener", "sipParams", "enableLoudsSpeaker", "context", "Landroid/content/Context;", "enable", "getCurrentCall", "getLoudsSpeakerStatus", "getMuteStatus", "handleCallState", "", "state", "handleHangupFromSocket", "initCall", "makeCall", "phoneNumber", "releaseCall", "reason", "sendDTMF", "dtmf", "", "setMute", "mute", "startCallAfterConnected", "unInitializeCall", "callsdk_release"})
public final class CallManager {
    private static final NativeCallInterface nativeCallInterface;
    private static boolean isCallInitialized;
    private static SipParams pendingSipParams;
    private static CallStateListener currentCallStateListener;
    @NotNull
    public static final CallManager INSTANCE;

    public final int initCall(@NotNull Context context, @NotNull SipParams sipParams, @NotNull CallStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sipParams, (String)"sipParams");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        currentCallStateListener = listener;
        if (isCallInitialized) {
            Loger.dTag("CallManager", "Call already initialized, reconnect with new SIP params");
            return nativeCallInterface.connectToCCP(sipParams);
        }
        pendingSipParams = sipParams;
        CallEventCallback callback = this.createCallEventCallbackAdapter(listener, sipParams);
        nativeCallInterface.init();
        nativeCallInterface.setStunServer("stun.freeswitch.org");
        nativeCallInterface.setTraceFlag(true);
        nativeCallInterface.setCallBackParams(callback);
        nativeCallInterface.setAudioContext(context);
        nativeCallInterface.initialize();
        nativeCallInterface.setLogLevel(2);
        nativeCallInterface.amrNBCreateEnc();
        nativeCallInterface.amrNBEncoderInit(0);
        nativeCallInterface.setDtxEnabled(true);
        int result = nativeCallInterface.connectToCCP(sipParams);
        if (result == 0) {
            isCallInitialized = true;
        }
        return result;
    }

    private final CallEventCallback createCallEventCallbackAdapter(CallStateListener listener, SipParams sipParams) {
        return new CallEventCallback(sipParams, listener){
            final /* synthetic */ SipParams $sipParams;
            final /* synthetic */ CallStateListener $listener;

            @Nullable
            public Object onCallEvent(int event, @Nullable String id, @Nullable byte[] message, int state) {
                Loger.dTag("CallManager", "onCallEvent: " + event + ", " + id + ", " + (message != null ? Integer.valueOf(message.length) : null) + ", " + state);
                switch (event) {
                    case 1: {
                        if (state == 0) {
                            CallManager.access$startCallAfterConnected(CallManager.INSTANCE, this.$sipParams);
                            this.$listener.onConnected();
                            break;
                        }
                        this.$listener.onDisconnected();
                        break;
                    }
                    case 2: {
                        this.$listener.onDisconnected();
                        break;
                    }
                    case 3: {
                        CallManager.access$handleCallState(CallManager.INSTANCE, this.$listener, id, state);
                        break;
                    }
                    case 8: {
                        this.$listener.onCallReleased(id);
                        break;
                    }
                    case 4: {
                        if (message != null) {
                            byte[] byArray = message;
                            boolean bl = false;
                            boolean bl2 = false;
                            byte[] it = byArray;
                            boolean bl3 = false;
                            byte[] byArray2 = it;
                            boolean bl4 = false;
                            byte[] byArray3 = byArray2;
                            boolean bl5 = false;
                            if (!(!(byArray3.length == 0))) break;
                            char dtmf = (char)it[0];
                            this.$listener.onDtmfReceived(id, dtmf);
                        }
                        break;
                    }
                    case 18: {
                        break;
                    }
                }
                return null;
            }
            {
                this.$sipParams = $captured_local_variable$0;
                this.$listener = $captured_local_variable$1;
            }
        };
    }

    private final void startCallAfterConnected(SipParams sipParams) {
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(sipParams){
            final /* synthetic */ SipParams $sipParams;

            public final void run() {
                String phoneNum = this.$sipParams.getPhoneNum();
                CharSequence charSequence = phoneNum;
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    String callId = CallManager.INSTANCE.makeCall(phoneNum);
                    Loger.dTag("CallManager", "Auto makeCall callId: " + callId);
                    if (callId != null) {
                        this.$sipParams.setCallId(callId);
                        CallSDK.setCurrentCallId(callId);
                        CallSDK.setMute(false);
                    }
                }
                CallManager.access$setPendingSipParams$p(CallManager.INSTANCE, null);
            }
            {
                this.$sipParams = sipParams;
            }
        }, 200L);
    }

    private final void handleCallState(CallStateListener listener, String callId, int state) {
        switch (state) {
            case 1: {
                listener.onCallFailed(callId);
                break;
            }
            case 2: {
                listener.onIncomingCall(callId);
                break;
            }
            case 4: {
                listener.onCallAnswered(callId);
                break;
            }
            case 10: {
                listener.onCallProceeding(callId);
                break;
            }
            case 7: {
                listener.onCallReleased(callId);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
        }
    }

    @Nullable
    public final String makeCall(@NotNull String phoneNumber) {
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        return nativeCallInterface.makeCall(phoneNumber);
    }

    public final int releaseCall(@Nullable String callId, int reason) {
        return nativeCallInterface.releaseCall(callId, reason);
    }

    public final boolean getMuteStatus() {
        return nativeCallInterface.getMuteStatus();
    }

    public final int setMute(boolean mute) {
        return nativeCallInterface.setMute(mute);
    }

    public final int sendDTMF(@Nullable String callId, char dtmf) {
        return nativeCallInterface.sendDTMF(callId, dtmf);
    }

    @Nullable
    public final String getCurrentCall() {
        return nativeCallInterface.getCurrentCall();
    }

    public final int acceptCall(@Nullable String callId) {
        return nativeCallInterface.acceptCall(callId);
    }

    public final int enableLoudsSpeaker(@NotNull Context context, boolean enable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        audioManager.setMode(3);
        audioManager.setSpeakerphoneOn(enable);
        return 0;
    }

    public final boolean getLoudsSpeakerStatus(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        audioManager.setMode(3);
        return audioManager.isSpeakerphoneOn();
    }

    public final int unInitializeCall(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int result = nativeCallInterface.unInitialize();
        if (result == 0) {
            isCallInitialized = false;
        }
        currentCallStateListener = null;
        AudioUtils.dispose(context, unInitializeCall.1.INSTANCE);
        return result;
    }

    public final void handleHangupFromSocket(@Nullable String callId) {
        Loger.dTag("CallManager", "\u6536\u5230 WebSocket hangup \u6d88\u606f, callId: " + callId);
        CallStateListener callStateListener = currentCallStateListener;
        if (callStateListener != null) {
            CallStateListener callStateListener2 = callStateListener;
            boolean bl = false;
            boolean bl2 = false;
            CallStateListener listener = callStateListener2;
            boolean bl3 = false;
            new Handler(Looper.getMainLooper()).post(new Runnable(listener, callId){
                final /* synthetic */ CallStateListener $listener;
                final /* synthetic */ String $callId$inlined;
                {
                    this.$listener = callStateListener;
                    this.$callId$inlined = string;
                }

                public final void run() {
                    this.$listener.onCallReleased(this.$callId$inlined);
                }
            });
        } else {
            CallManager callManager = this;
            boolean bl = false;
            boolean bl4 = false;
            CallManager $this$run = callManager;
            boolean bl5 = false;
            Loger.wTag("CallManager", "\u6ca1\u6709\u6ce8\u518c CallStateListener\uff0c\u65e0\u6cd5\u56de\u8c03 onCallReleased");
        }
    }

    private CallManager() {
    }

    static {
        CallManager callManager;
        INSTANCE = callManager = new CallManager();
        nativeCallInterface = new NativeCallInterfaceImpl();
    }

    public static final /* synthetic */ void access$startCallAfterConnected(CallManager $this, SipParams sipParams) {
        $this.startCallAfterConnected(sipParams);
    }

    public static final /* synthetic */ void access$handleCallState(CallManager $this, CallStateListener listener, String callId, int state) {
        $this.handleCallState(listener, callId, state);
    }

    public static final /* synthetic */ SipParams access$getPendingSipParams$p(CallManager $this) {
        CallManager callManager = $this;
        return pendingSipParams;
    }

    public static final /* synthetic */ void access$setPendingSipParams$p(CallManager $this, SipParams sipParams) {
        CallManager callManager = $this;
        pendingSipParams = sipParams;
    }
}

