/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.http;

import android.util.Log;
import com.useasy.callsdk.CallSDK;
import com.useasy.callsdk.config.SDKConfig;
import com.useasy.callsdk.http.HttpManager;
import com.useasy.callsdk.listener.OnResponseListener;
import com.useasy.callsdk.utils.DeviceUtils;
import com.useasy.callsdk.utils.HttpParser;
import com.useasy.callsdk.utils.Loger;
import com.useasy.callsdk.utils.LoginHelper;
import com.useasy.callsdk.utils.SPUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 72\u00020\u0001:\u00017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0004J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\"\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010&\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J \u0010(\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010)\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010*\u001a\u00020\u00132\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010.\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u00101\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u00103\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/useasy/callsdk/http/HttpManager;", "", "()V", "baseUrl", "", "client", "Lokhttp3/OkHttpClient;", "buildGetRequest", "Lokhttp3/Request;", "url", "buildGetRequestWithoutAuth", "buildPostRequest", "body", "Lokhttp3/RequestBody;", "buildPostRequestWithoutAuth", "createJsonBody", "json", "Lorg/json/JSONObject;", "dialOutInfo", "", "phoneNum", "agentId", "agentNumber", "accountId", "listener", "Lcom/useasy/callsdk/listener/OnResponseListener;", "executeRequest", "request", "executeRequestWithoutAuth", "getAuthHeaders", "Lokhttp3/Headers;", "getBaseUrl", "getCloudConfig", "username", "getFullAgent", "getLoginInfo", "getWebRtcInfo", "getWsToken", "login", "password", "loginInner", "queryDisplayNumberList", "queryNumberGroupList", "page", "", "pageSize", "riskQuery", "unregisterDeviceToken", "token", "updateAgentNumberGroup", "numberGroupId", "updateAgentSelectNumber", "selectNumber", "updateBaseUrl", "newBaseUrl", "Companion", "callsdk_release"})
public final class HttpManager {
    private final OkHttpClient client;
    private volatile String baseUrl;
    private static volatile HttpManager instance;
    @NotNull
    public static final Companion Companion;

    public final void updateBaseUrl(@NotNull String newBaseUrl) {
        Intrinsics.checkNotNullParameter((Object)newBaseUrl, (String)"newBaseUrl");
        this.baseUrl = newBaseUrl;
        Loger.dTag("HttpManager", "BaseUrl updated to: " + this.baseUrl);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    private final Headers getAuthHeaders() {
        String loginToken = SPUtils.getString("loginToken", "");
        String sessionId = SPUtils.getString("sessionId", "");
        int clientType = SPUtils.getInt("clientType", 2);
        return new Headers.Builder().add("Connection", "keep-alive").add("logintoken", loginToken).add("sessionid", sessionId).add("clienttype", String.valueOf(clientType)).add("Accept-Language", "zh-CN").build();
    }

    private final Request buildGetRequest(String url) {
        return new Request.Builder().url(url).headers(this.getAuthHeaders()).get().build();
    }

    private final Request buildPostRequest(String url, RequestBody body) {
        return new Request.Builder().url(url).headers(this.getAuthHeaders()).post(body).build();
    }

    private final Request buildGetRequestWithoutAuth(String url) {
        return new Request.Builder().url(url).get().build();
    }

    private final Request buildPostRequestWithoutAuth(String url, RequestBody body) {
        return new Request.Builder().url(url).post(body).build();
    }

    private final void executeRequest(Request request, OnResponseListener listener) {
        this.client.newCall(request).enqueue(new Callback(listener){
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                String responseBody;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                ResponseBody responseBody2 = response2.body();
                String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                if (response2.isSuccessful() && responseBody != null) {
                    if (HttpParser.INSTANCE.getSuccess(responseBody)) {
                        this.$listener.onSuccess(responseBody);
                    } else {
                        String errorMsg = HttpParser.INSTANCE.getMessage(responseBody);
                        this.$listener.onFailed(errorMsg);
                    }
                } else {
                    this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                }
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    private final void executeRequestWithoutAuth(Request request, OnResponseListener listener) {
        this.client.newCall(request).enqueue(new Callback(listener){
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                String responseBody;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                ResponseBody responseBody2 = response2.body();
                String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                if (response2.isSuccessful() && responseBody != null) {
                    if (HttpParser.INSTANCE.getSuccess(responseBody)) {
                        this.$listener.onSuccess(responseBody);
                    } else {
                        String errorMsg = HttpParser.INSTANCE.getMessage(responseBody);
                        this.$listener.onFailed(errorMsg);
                    }
                } else {
                    this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                }
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    private final RequestBody createJsonBody(JSONObject json) {
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
        return RequestBody.Companion.create(string, MediaType.Companion.get("application/json"));
    }

    public final void login(@NotNull String username, @NotNull String password, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.getCloudConfig(username, new OnResponseListener(this, username, password, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ String $username;
            final /* synthetic */ String $password;
            final /* synthetic */ OnResponseListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                HttpManager.access$loginInner(this.this$0, this.$username, this.$password, this.$listener);
            }

            public void onFailed(@Nullable String failStr) {
                this.$listener.onFailed(failStr);
            }
            {
                this.this$0 = this$0;
                this.$username = $captured_local_variable$1;
                this.$password = $captured_local_variable$2;
                this.$listener = $captured_local_variable$3;
            }
        });
    }

    private final void getCloudConfig(String username, OnResponseListener listener) {
        String string;
        if (StringsKt.contains$default((CharSequence)username, (CharSequence)"@", (boolean)false, (int)2, null)) {
            String string2 = username;
            int n = StringsKt.indexOf$default((CharSequence)username, (String)"@", (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = username;
        }
        String accountName = string;
        String url = this.baseUrl + "/api/platform/public/cloudConfig?accountName=" + accountName;
        Request request = this.buildGetRequestWithoutAuth(url);
        this.client.newCall(request).enqueue(new Callback(this, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "getCloudConfig failed: " + e.getMessage());
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                String responseBody;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                ResponseBody responseBody2 = response2.body();
                String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                if (response2.isSuccessful() && responseBody != null) {
                    if (HttpParser.INSTANCE.getSuccess(responseBody)) {
                        try {
                            String baseURL;
                            String data = HttpParser.INSTANCE.getData(responseBody);
                            JSONObject jsonObject = new JSONObject(data);
                            String server = jsonObject.optString("server", "");
                            String string2 = baseURL = jsonObject.optString("baseURL", "");
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"baseURL");
                            CharSequence charSequence = string2;
                            boolean bl = false;
                            if (charSequence.length() > 0) {
                                if (!StringsKt.contains$default((CharSequence)baseURL, (CharSequence)"https://", (boolean)false, (int)2, null)) {
                                    baseURL = "https://" + baseURL;
                                }
                                String string3 = baseURL;
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"baseURL");
                                HttpManager.access$setBaseUrl$p(this.this$0, string3);
                                Loger.dTag("HttpManager", "Updated baseUrl: " + HttpManager.access$getBaseUrl$p(this.this$0));
                            }
                            this.$listener.onSuccess(data);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            this.$listener.onFailed("getCloudConfig failed: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("getCloudConfig failed: " + HttpParser.INSTANCE.getMessage(responseBody));
                    }
                } else {
                    this.$listener.onFailed("getCloudConfig failed: " + response2.code());
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    private final void loginInner(String username, String password, OnResponseListener listener) {
        String url = this.baseUrl + "/api/platform/public/loginPre";
        Request request = this.buildGetRequestWithoutAuth(url);
        this.client.newCall(request).enqueue(new Callback(this, listener, password, username){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ OnResponseListener $listener;
            final /* synthetic */ String $password;
            final /* synthetic */ String $username;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                String responseBody;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                ResponseBody responseBody2 = response2.body();
                String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                if (response2.isSuccessful() && responseBody != null) {
                    if (HttpParser.INSTANCE.getSuccess(responseBody)) {
                        try {
                            String pk;
                            String data = HttpParser.INSTANCE.getData(responseBody);
                            JSONObject jsonObject = new JSONObject(data);
                            String string2 = pk = jsonObject.optString("pk", "");
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pk");
                            CharSequence charSequence = string2;
                            boolean bl = false;
                            if (charSequence.length() == 0) {
                                this.$listener.onFailed("\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
                                return;
                            }
                            Loger.dTag("HttpManager", "pk: " + pk);
                            String encryptedPassword = LoginHelper.INSTANCE.parsePassword(pk, this.$password);
                            JSONObject jSONObject = new JSONObject();
                            boolean bl2 = false;
                            boolean bl3 = false;
                            JSONObject $this$apply = jSONObject;
                            boolean bl4 = false;
                            $this$apply.put("loginName", (Object)this.$username);
                            $this$apply.put("clientType", 2);
                            $this$apply.put("password", (Object)encryptedPassword);
                            $this$apply.put("loginDevice", (Object)DeviceUtils.INSTANCE.getLoginDevice());
                            JSONObject loginJson = jSONObject;
                            RequestBody requestBody = HttpManager.access$createJsonBody(this.this$0, loginJson);
                            Request loginRequest = HttpManager.access$buildPostRequestWithoutAuth(this.this$0, HttpManager.access$getBaseUrl$p(this.this$0) + "/api/platform/public/login", requestBody);
                            HttpManager.access$getClient$p(this.this$0).newCall(loginRequest).enqueue(new Callback(this){
                                final /* synthetic */ loginInner.1 this$0;

                                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    this.this$0.$listener.onFailed(e.getMessage());
                                }

                                public void onResponse(@NotNull Call call, @NotNull Response response2) {
                                    String loginResponseBody;
                                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                                    ResponseBody responseBody = response2.body();
                                    String string = loginResponseBody = responseBody != null ? responseBody.string() : null;
                                    if (response2.isSuccessful() && loginResponseBody != null) {
                                        if (HttpParser.INSTANCE.getSuccess(loginResponseBody)) {
                                            try {
                                                String loginData = HttpParser.INSTANCE.getData(loginResponseBody);
                                                Loger.dTag("HttpManager", "login data: " + loginData);
                                                JSONObject loginDataObj = new JSONObject(loginData);
                                                String accountId = loginDataObj.optString("accountId", "");
                                                String sessionId = loginDataObj.optString("sessionId", "");
                                                String loginToken = loginDataObj.optString("loginToken", "");
                                                int clientType = loginDataObj.optInt("clientType", 2);
                                                String string2 = loginToken;
                                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"loginToken");
                                                SPUtils.put("loginToken", string2);
                                                String string3 = sessionId;
                                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sessionId");
                                                SPUtils.put("sessionId", string3);
                                                SPUtils.put("clientType", clientType);
                                                String string4 = accountId;
                                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"accountId");
                                                SPUtils.put("accountId", string4);
                                                this.this$0.this$0.getLoginInfo(this.this$0.$listener);
                                            }
                                            catch (JSONException e) {
                                                e.printStackTrace();
                                                this.this$0.$listener.onFailed("\u89e3\u6790\u767b\u5f55\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                                            }
                                        } else {
                                            String errorMsg = HttpParser.INSTANCE.getMessage(loginResponseBody);
                                            this.this$0.$listener.onFailed(errorMsg);
                                        }
                                    } else {
                                        this.this$0.$listener.onFailed("\u767b\u5f55\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                                    }
                                }
                                {
                                    this.this$0 = this$0;
                                }
                            });
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            this.$listener.onFailed("\u89e3\u6790\u516c\u94a5\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                        }
                    } else {
                        String errorMsg = HttpParser.INSTANCE.getMessage(responseBody);
                        this.$listener.onFailed(errorMsg);
                    }
                } else {
                    this.$listener.onFailed("\u83b7\u53d6\u516c\u94a5\u5931\u8d25: " + response2.code());
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
                this.$password = $captured_local_variable$2;
                this.$username = $captured_local_variable$3;
            }
        });
    }

    public final void unregisterDeviceToken(@NotNull String token, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("deviceToken", (Object)token);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/platform/action/apppush/remove", requestBody);
        this.executeRequest(request, listener);
    }

    public final void dialOutInfo(@NotNull String phoneNum, @NotNull String agentId, @NotNull String agentNumber, @NotNull String accountId, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)phoneNum, (String)"phoneNum");
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)agentNumber, (String)"agentNumber");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("loginType", (Object)"PSTN");
        $this$apply.put("customerNumber", (Object)phoneNum);
        $this$apply.put("agentId", (Object)agentId);
        $this$apply.put("agentNumber", (Object)agentNumber);
        $this$apply.put("accountId", (Object)accountId);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/call/api/call/call/out", requestBody);
        this.client.newCall(request).enqueue(new Callback(listener){
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block5: {
                    String responseBody;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody2 = response2.body();
                    String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                    if (response2.isSuccessful() && responseBody != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseBody);
                            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                                this.$listener.onSuccess(responseBody);
                                break block5;
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u62e8\u53f7\u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onFailed("\u89e3\u6790\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                    }
                }
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public final void getWebRtcInfo(@NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Request request = this.buildGetRequest(this.baseUrl + "/api/call/api/sip/webrtc/config/query/");
        this.client.newCall(request).enqueue(new Callback(listener){
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody = response2.body();
                    String responseBody2 = responseBody != null ? responseBody.string() : null;
                    Log.d((String)"getWebRtcInfo", (String)("responseBody: " + responseBody2));
                    if (response2.isSuccessful() && responseBody2 != null) {
                        try {
                            boolean bl;
                            CharSequence charSequence;
                            JSONObject jsonObject = new JSONObject(responseBody2);
                            String dataStr = null;
                            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                                String string = dataStr = jsonObject.optString("data", "");
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataStr");
                                charSequence = string;
                                bl = false;
                                if (charSequence.length() == 0 && jsonObject.has("registerUrl")) {
                                    dataStr = responseBody2;
                                }
                            } else if (jsonObject.has("registerUrl") || jsonObject.has("sip")) {
                                dataStr = responseBody2;
                            }
                            if (dataStr != null) {
                                charSequence = dataStr;
                                bl = false;
                                if (charSequence.length() > 0) {
                                    SPUtils.put("webRtcSipInfo", dataStr);
                                    this.$listener.onSuccess(responseBody2);
                                    break block10;
                                }
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u83b7\u53d6 WebRTC \u914d\u7f6e\u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onFailed("\u89e3\u6790\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                    }
                }
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public final void getLoginInfo(@NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Request request = this.buildGetRequest(this.baseUrl + "/api/platform/action/loginInfo");
        this.client.newCall(request).enqueue(new Callback(listener){
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block10: {
                    String responseBody;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody2 = response2.body();
                    String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                    if (response2.isSuccessful() && responseBody != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseBody);
                            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                                String dataStr;
                                String string2 = dataStr = jsonObject.optString("data", "");
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dataStr");
                                CharSequence charSequence = string2;
                                boolean bl = false;
                                if (charSequence.length() > 0) {
                                    try {
                                        JSONObject dataObj = new JSONObject(dataStr);
                                        JSONArray pushServerArray = dataObj.optJSONArray("pushServer");
                                        if (pushServerArray != null && pushServerArray.length() > 0) {
                                            String wsUrl;
                                            JSONObject pushServerObj = pushServerArray.getJSONObject(0);
                                            String string3 = wsUrl = pushServerObj.optString("url", "");
                                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wsUrl");
                                            CharSequence charSequence2 = string3;
                                            boolean bl2 = false;
                                            if (charSequence2.length() > 0) {
                                                SPUtils.put("WS_HOST", wsUrl);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                this.$listener.onSuccess(responseBody);
                                break block10;
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onFailed("\u89e3\u6790\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                    }
                }
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public final void getWsToken(@NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Request request = this.buildGetRequest(this.baseUrl + "/api/platform/action/refreshWsToken/");
        this.client.newCall(request).enqueue(new Callback(listener){
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block8: {
                    String responseBody;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody2 = response2.body();
                    String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                    if (response2.isSuccessful() && responseBody != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseBody);
                            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                                String dataStr;
                                String string2 = dataStr = jsonObject.optString("data", "");
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dataStr");
                                CharSequence charSequence = string2;
                                boolean bl = false;
                                if (charSequence.length() > 0) {
                                    JSONObject dataObj = new JSONObject(dataStr);
                                    String wsToken = dataObj.optString("wsToken", "");
                                    String timestamp = dataObj.optString("timestamp", "");
                                    String string3 = wsToken;
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wsToken");
                                    CharSequence charSequence2 = string3;
                                    boolean bl2 = false;
                                    if (charSequence2.length() > 0) {
                                        String string4 = timestamp;
                                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"timestamp");
                                        charSequence2 = string4;
                                        bl2 = false;
                                        if (charSequence2.length() > 0) {
                                            SPUtils.put("wsToken", wsToken);
                                            SPUtils.put("timestamp", timestamp);
                                        }
                                    }
                                }
                                this.$listener.onSuccess(responseBody);
                                break block8;
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u83b7\u53d6 WebSocket Token \u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onFailed("\u89e3\u6790\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                    }
                }
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public final void riskQuery(@NotNull String phoneNum, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)phoneNum, (String)"phoneNum");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("number", (Object)phoneNum);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/call/api/risk/query", requestBody);
        this.client.newCall(request).enqueue(new Callback(listener){
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onSuccess("\u98ce\u9669\u67e5\u8be2\u5931\u8d25\uff0c\u4f46\u5141\u8bb8\u7ee7\u7eed\u62e8\u6253");
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block5: {
                    String responseBody;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody2 = response2.body();
                    String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                    if (response2.isSuccessful() && responseBody != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseBody);
                            boolean success = jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false);
                            String code = jsonObject.optString("code", "");
                            if (success && Intrinsics.areEqual((Object)code, (Object)"200")) {
                                this.$listener.onSuccess(responseBody);
                                break block5;
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u98ce\u9669\u67e5\u8be2\u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onSuccess("\u98ce\u9669\u67e5\u8be2\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u5141\u8bb8\u7ee7\u7eed\u62e8\u6253");
                        }
                    } else {
                        this.$listener.onSuccess("\u98ce\u9669\u67e5\u8be2\u5931\u8d25\uff0c\u4f46\u5141\u8bb8\u7ee7\u7eed\u62e8\u6253");
                    }
                }
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public final void queryNumberGroupList(int page, int pageSize, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("page", page);
        $this$apply.put("pageSize", pageSize);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/call/web/call/action/config/number/group/v1/query", requestBody);
        this.executeRequest(request, listener);
    }

    public static /* synthetic */ void queryNumberGroupList$default(HttpManager httpManager, int n, int n2, OnResponseListener onResponseListener, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = 999;
        }
        httpManager.queryNumberGroupList(n, n2, onResponseListener);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAgentNumberGroup(@NotNull String agentId, @NotNull String numberGroupId, @NotNull OnResponseListener listener) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)numberGroupId, (String)"numberGroupId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply2 = jSONObject;
        boolean bl3 = false;
        $this$apply2.put("_id", (Object)agentId);
        JSONObject jSONObject2 = new JSONObject();
        boolean bl4 = false;
        boolean bl5 = false;
        JSONObject jSONObject3 = jSONObject2;
        String string = "agentCallConfig";
        JSONObject jSONObject4 = $this$apply2;
        boolean bl6 = false;
        $this$apply.put("numberGroup", (Object)numberGroupId);
        Unit unit = Unit.INSTANCE;
        jSONObject4.put(string, (Object)jSONObject2);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/platform/action/agent/update", requestBody);
        this.executeRequest(request, listener);
    }

    public final void queryDisplayNumberList(@NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String url = this.baseUrl + "/api/call/web/config/number/display/cache";
        Request request = this.buildGetRequest(url);
        this.executeRequest(request, listener);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAgentSelectNumber(@NotNull String agentId, @NotNull String selectNumber, @NotNull OnResponseListener listener) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)selectNumber, (String)"selectNumber");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply2 = jSONObject;
        boolean bl3 = false;
        $this$apply2.put("_id", (Object)agentId);
        JSONObject jSONObject2 = new JSONObject();
        boolean bl4 = false;
        boolean bl5 = false;
        JSONObject jSONObject3 = jSONObject2;
        String string = "agentCallConfig";
        JSONObject jSONObject4 = $this$apply2;
        boolean bl6 = false;
        $this$apply.put("selectNumber", (Object)selectNumber);
        Unit unit = Unit.INSTANCE;
        jSONObject4.put(string, (Object)jSONObject2);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/platform/action/agent/update", requestBody);
        this.executeRequest(request, listener);
    }

    public final void getFullAgent(@NotNull String agentId, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String url = this.baseUrl + "/api/platform/action/agent/getFullAgent?agentId=" + agentId;
        Request request = this.buildGetRequest(url);
        this.executeRequest(request, listener);
    }

    private HttpManager() {
        SDKConfig config = CallSDK.getConfig();
        this.baseUrl = config.getBaseUrl();
        this.client = new OkHttpClient.Builder().connectTimeout(config.getConnectTimeout(), TimeUnit.SECONDS).readTimeout(config.getReadTimeout(), TimeUnit.SECONDS).writeTimeout(config.getWriteTimeout(), TimeUnit.SECONDS).build();
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$loginInner(HttpManager $this, String username, String password, OnResponseListener listener) {
        $this.loginInner(username, password, listener);
    }

    public static final /* synthetic */ String access$getBaseUrl$p(HttpManager $this) {
        return $this.baseUrl;
    }

    public static final /* synthetic */ void access$setBaseUrl$p(HttpManager $this, String string) {
        $this.baseUrl = string;
    }

    public static final /* synthetic */ RequestBody access$createJsonBody(HttpManager $this, JSONObject json) {
        return $this.createJsonBody(json);
    }

    public static final /* synthetic */ Request access$buildPostRequestWithoutAuth(HttpManager $this, String url, RequestBody body) {
        return $this.buildPostRequestWithoutAuth(url, body);
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p(HttpManager $this) {
        return $this.client;
    }

    public /* synthetic */ HttpManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/useasy/callsdk/http/HttpManager$Companion;", "", "()V", "instance", "Lcom/useasy/callsdk/http/HttpManager;", "getInstance", "callsdk_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final HttpManager getInstance() {
            HttpManager httpManager = instance;
            if (httpManager == null) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    boolean bl3 = false;
                    HttpManager httpManager2 = instance;
                    if (httpManager2 == null) {
                        HttpManager httpManager3 = new HttpManager(null);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        HttpManager it = httpManager3;
                        boolean bl6 = false;
                        instance = it;
                        httpManager2 = httpManager3;
                    }
                    HttpManager httpManager4 = httpManager2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl19 : MonitorExitStatement: MONITOREXIT : this
                    httpManager = httpManager4;
                }
            }
            return httpManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

