/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk;

import android.content.Context;
import com.useasy.callsdk.bean.AgentConfig;
import com.useasy.callsdk.bean.DisplayNumber;
import com.useasy.callsdk.bean.NumberGroupListResponse;
import com.useasy.callsdk.bean.SipParams;
import com.useasy.callsdk.config.Environment;
import com.useasy.callsdk.config.SDKConfig;
import com.useasy.callsdk.http.HttpManager;
import com.useasy.callsdk.listener.AgentConfigListener;
import com.useasy.callsdk.listener.CallStateListener;
import com.useasy.callsdk.listener.DisplayNumberListListener;
import com.useasy.callsdk.listener.InitListener;
import com.useasy.callsdk.listener.LoginListener;
import com.useasy.callsdk.listener.NumberGroupListListener;
import com.useasy.callsdk.listener.OnResponseListener;
import com.useasy.callsdk.listener.SocketMessageListener;
import com.useasy.callsdk.manager.CallManager;
import com.useasy.callsdk.manager.LoginManager;
import com.useasy.callsdk.manager.SocketManager;
import com.useasy.callsdk.utils.AudioUtils;
import com.useasy.callsdk.utils.Loger;
import com.useasy.callsdk.utils.ResponseParser;
import com.useasy.callsdk.utils.SPUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\nH\u0007J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u0010\u0014\u001a\u00020\bH\u0007J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u001a\u001a\u00020\bH\u0007J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u001fH\u0007J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\bH\u0007J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\bH\u0007J\u001c\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020'H\u0007J$\u0010(\u001a\u00020\f2\b\b\u0002\u0010)\u001a\u00020\u001d2\b\b\u0002\u0010*\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020+H\u0007J\b\u0010,\u001a\u00020\u001dH\u0007J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0004H\u0007J\u001a\u0010-\u001a\u00020\u001d2\b\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u00100\u001a\u000201H\u0007J\u0012\u00102\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\bH\u0007J\u0010\u00105\u001a\u00020\f2\u0006\u00106\u001a\u000207H\u0007J\u0010\u00108\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J \u00109\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010;\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/useasy/callsdk/CallSDK;", "", "()V", "currentCallId", "", "initListener", "Lcom/useasy/callsdk/listener/InitListener;", "isInitialized", "", "sdkConfig", "Lcom/useasy/callsdk/config/SDKConfig;", "checkInitialized", "", "getAgentConfig", "agentId", "listener", "Lcom/useasy/callsdk/listener/AgentConfigListener;", "getConfig", "getCurrentCall", "getCurrentCallId", "getMuteStatus", "init", "context", "Landroid/content/Context;", "config", "isLoudSpeakerOn", "isMuteOn", "logout", "makeCall", "", "phoneNumber", "Lcom/useasy/callsdk/listener/CallStateListener;", "openLoudSpeaker", "open", "openMute", "parseSipParamsFromWebRtcInfo", "Lcom/useasy/callsdk/bean/SipParams;", "responseStr", "queryDisplayNumberList", "Lcom/useasy/callsdk/listener/DisplayNumberListListener;", "queryNumberGroupList", "page", "pageSize", "Lcom/useasy/callsdk/listener/NumberGroupListListener;", "releaseCall", "sendDTMF", "dtmfNumber", "callId", "dtmf", "", "setCurrentCallId", "setMute", "mute", "switchEnvironment", "environmentType", "Lcom/useasy/callsdk/config/Environment$Type;", "unInitializeCall", "updateAgentNumberGroup", "numberGroupId", "updateAgentSelectNumber", "selectNumber", "callsdk_release"})
public final class CallSDK {
    private static boolean isInitialized;
    private static SDKConfig sdkConfig;
    private static InitListener initListener;
    private static String currentCallId;
    @NotNull
    public static final CallSDK INSTANCE;

    @JvmStatic
    public static final void init(@NotNull Context context, @NotNull SDKConfig config, @NotNull InitListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        sdkConfig = config;
        initListener = listener;
        isInitialized = true;
        SPUtils.init(context);
        Loger.getConfig().setLogSwitch(config.getEnableLog()).setConsoleSwitch(config.getEnableLog());
        Loger.dTag("CallSDK", "SDK initialized, enableLog: " + config.getEnableLog());
        SocketManager.INSTANCE.setMessageListener(new SocketMessageListener(){

            public void onKicked() {
                block0: {
                    Loger.dTag("CallSDK", "Kicked");
                    InitListener initListener = CallSDK.access$getInitListener$p(CallSDK.INSTANCE);
                    if (initListener == null) break block0;
                    initListener.onKicked();
                }
            }

            public void onMessage(@NotNull String messageType, @Nullable String messageData) {
                Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
                SocketMessageListener.DefaultImpls.onMessage(this, messageType, messageData);
            }

            public void onSocketConnected() {
                SocketMessageListener.DefaultImpls.onSocketConnected(this);
            }

            public void onSocketDisconnected() {
                SocketMessageListener.DefaultImpls.onSocketDisconnected(this);
            }

            public void onSocketConnectFailed(@Nullable String error) {
                SocketMessageListener.DefaultImpls.onSocketConnectFailed(this, error);
            }
        });
        LoginManager.INSTANCE.login(config.getUsername(), config.getPassword(), new LoginListener(){

            public void onSuccess() {
                block0: {
                    Loger.dTag("CallSDK", "init success");
                    InitListener initListener = CallSDK.access$getInitListener$p(CallSDK.INSTANCE);
                    if (initListener == null) break block0;
                    initListener.onInitSuccess();
                }
            }

            public void onFailed(@Nullable String errorMsg) {
                block0: {
                    Loger.dTag("CallSDK", "Login failed: " + errorMsg);
                    InitListener initListener = CallSDK.access$getInitListener$p(CallSDK.INSTANCE);
                    if (initListener == null) break block0;
                    initListener.onInitFailed(errorMsg);
                }
            }
        });
    }

    @JvmStatic
    public static final void logout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        INSTANCE.checkInitialized();
        CallManager.INSTANCE.unInitializeCall(context);
        LoginManager.INSTANCE.logout();
    }

    @JvmStatic
    public static final void queryNumberGroupList(int page, int pageSize, @NotNull NumberGroupListListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        HttpManager.Companion.getInstance().queryNumberGroupList(page, pageSize, new OnResponseListener(listener){
            final /* synthetic */ NumberGroupListListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    NumberGroupListResponse parsed = ResponseParser.INSTANCE.parseNumberGroupListResponse(responseStr);
                    this.$listener.onSuccess(parsed);
                }
                catch (Exception e) {
                    this.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + e.getMessage());
                }
            }

            public void onFailed(@Nullable String failStr) {
                this.$listener.onFailed(failStr);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public static /* synthetic */ void queryNumberGroupList$default(int n, int n2, NumberGroupListListener numberGroupListListener, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = 999;
        }
        CallSDK.queryNumberGroupList(n, n2, numberGroupListListener);
    }

    @JvmStatic
    public static final void queryDisplayNumberList(@NotNull DisplayNumberListListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        HttpManager.Companion.getInstance().queryDisplayNumberList(new OnResponseListener(listener){
            final /* synthetic */ DisplayNumberListListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    List<DisplayNumber> numbers = ResponseParser.INSTANCE.parseDisplayNumberListResponse(responseStr);
                    this.$listener.onSuccess(numbers);
                }
                catch (Exception e) {
                    this.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + e.getMessage());
                }
            }

            public void onFailed(@Nullable String failStr) {
                this.$listener.onFailed(failStr);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @JvmStatic
    public static final void updateAgentNumberGroup(@NotNull String agentId, @NotNull String numberGroupId, @NotNull AgentConfigListener listener) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)numberGroupId, (String)"numberGroupId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        HttpManager.Companion.getInstance().updateAgentNumberGroup(agentId, numberGroupId, new OnResponseListener(listener){
            final /* synthetic */ AgentConfigListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    AgentConfig config = ResponseParser.INSTANCE.parseAgentConfig(responseStr);
                    this.$listener.onSuccess(config);
                }
                catch (Exception e) {
                    this.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + e.getMessage());
                }
            }

            public void onFailed(@Nullable String failStr) {
                this.$listener.onFailed(failStr);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @JvmStatic
    public static final void updateAgentSelectNumber(@NotNull String agentId, @NotNull String selectNumber, @NotNull AgentConfigListener listener) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)selectNumber, (String)"selectNumber");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        HttpManager.Companion.getInstance().updateAgentSelectNumber(agentId, selectNumber, new OnResponseListener(listener){
            final /* synthetic */ AgentConfigListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    AgentConfig config = ResponseParser.INSTANCE.parseAgentConfig(responseStr);
                    this.$listener.onSuccess(config);
                }
                catch (Exception e) {
                    this.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + e.getMessage());
                }
            }

            public void onFailed(@Nullable String failStr) {
                this.$listener.onFailed(failStr);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @JvmStatic
    public static final void getAgentConfig(@NotNull String agentId, @NotNull AgentConfigListener listener) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        HttpManager.Companion.getInstance().getFullAgent(agentId, new OnResponseListener(listener){
            final /* synthetic */ AgentConfigListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    AgentConfig config = ResponseParser.INSTANCE.parseAgentConfig(responseStr);
                    this.$listener.onSuccess(config);
                }
                catch (Exception e) {
                    this.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + e.getMessage());
                }
            }

            public void onFailed(@Nullable String failStr) {
                this.$listener.onFailed(failStr);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    private final void checkInitialized() {
        if (!isInitialized) {
            throw (Throwable)new IllegalStateException("CallSDK not initialized. Call CallSDK.init() first.");
        }
    }

    @JvmStatic
    @NotNull
    public static final SDKConfig getConfig() {
        INSTANCE.checkInitialized();
        SDKConfig sDKConfig = sdkConfig;
        Intrinsics.checkNotNull((Object)sDKConfig);
        return sDKConfig;
    }

    @JvmStatic
    public static final void switchEnvironment(@NotNull Environment.Type environmentType) {
        Intrinsics.checkNotNullParameter((Object)((Object)environmentType), (String)"environmentType");
        INSTANCE.checkInitialized();
        String newBaseUrl = Environment.INSTANCE.getUrl(environmentType);
        HttpManager.Companion.getInstance().updateBaseUrl(newBaseUrl);
        SDKConfig sDKConfig = sdkConfig;
        Intrinsics.checkNotNull((Object)sDKConfig);
        SDKConfig currentConfig = sDKConfig;
        sdkConfig = SDKConfig.copy$default(currentConfig, null, null, newBaseUrl, false, 0L, 0L, 0L, 123, null);
        Loger.dTag("CallSDK", "Environment switched to: " + (Object)((Object)environmentType) + ", baseUrl: " + newBaseUrl);
    }

    @JvmStatic
    public static final void setCurrentCallId(@Nullable String callId) {
        INSTANCE.checkInitialized();
        currentCallId = callId;
        Loger.dTag("CallSDK", "Current call ID set to: " + callId);
    }

    @JvmStatic
    @Nullable
    public static final String getCurrentCallId() {
        INSTANCE.checkInitialized();
        String string = currentCallId;
        if (string == null) {
            string = CallSDK.getCurrentCall();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final int sendDTMF(@NotNull String dtmfNumber) {
        int n;
        String callId;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)dtmfNumber, (String)"dtmfNumber");
                INSTANCE.checkInitialized();
                CharSequence charSequence = dtmfNumber;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    Loger.wTag("CallSDK", "DTMF number is empty");
                    return -1;
                }
                callId = CallSDK.getCurrentCallId();
                if (callId == null) break block4;
                CharSequence charSequence2 = callId;
                n = 0;
                if (charSequence2.length() > 0) break block5;
            }
            Loger.wTag("CallSDK", "No active call to send DTMF");
            return -1;
        }
        char dtmfChar = dtmfNumber.charAt(0);
        int result = CallSDK.sendDTMF(callId, dtmfChar);
        Loger.dTag("CallSDK", "Send DTMF result: " + result + ", callId: " + callId + ", dtmf: " + dtmfChar);
        int n2 = n;
        return n2;
    }

    @JvmStatic
    public static final int openLoudSpeaker(@NotNull Context context, boolean open) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        INSTANCE.checkInitialized();
        int result = CallManager.INSTANCE.enableLoudsSpeaker(context, open);
        Loger.dTag("CallSDK", "Set loudspeaker result: " + result + ", open: " + open);
        return result;
    }

    @JvmStatic
    public static final boolean isLoudSpeakerOn(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.getLoudsSpeakerStatus(context);
    }

    @JvmStatic
    public static final int openMute(boolean open) {
        INSTANCE.checkInitialized();
        int result = CallSDK.setMute(open);
        Loger.dTag("CallSDK", "Set mute result: " + result + ", open: " + open);
        return result;
    }

    @JvmStatic
    public static final boolean isMuteOn() {
        INSTANCE.checkInitialized();
        return CallSDK.getMuteStatus();
    }

    @JvmStatic
    public static final int unInitializeCall(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.unInitializeCall(context);
    }

    @JvmStatic
    public static final int makeCall(@NotNull Context context, @NotNull String phoneNumber, @NotNull CallStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        AudioUtils.pauseMusic(context);
        HttpManager.Companion.getInstance().getWebRtcInfo(new OnResponseListener(phoneNumber, context, listener){
            final /* synthetic */ String $phoneNumber;
            final /* synthetic */ Context $context;
            final /* synthetic */ CallStateListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                SipParams sipParams = CallSDK.access$parseSipParamsFromWebRtcInfo(CallSDK.INSTANCE, responseStr, this.$phoneNumber);
                if (sipParams != null) {
                    int result = CallManager.INSTANCE.initCall(this.$context, sipParams, this.$listener);
                    if (result != 0) {
                        this.$listener.onCallFailed(null);
                    }
                } else {
                    this.$listener.onCallFailed(null);
                }
            }

            public void onFailed(@Nullable String failStr) {
                this.$listener.onCallFailed(null);
            }
            {
                this.$phoneNumber = $captured_local_variable$0;
                this.$context = $captured_local_variable$1;
                this.$listener = $captured_local_variable$2;
            }
        });
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private final SipParams parseSipParamsFromWebRtcInfo(String responseStr, String phoneNumber) {
        var3_3 = responseStr;
        var4_5 = false;
        var5_7 = false;
        if (var3_3 == null || var3_3.length() == 0) {
            return null;
        }
        try {
            jsonObject = new JSONObject(responseStr);
            dataStr = null;
            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                v0 = dataStr = jsonObject.optString("data", "");
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"dataStr");
                var5_8 = v0;
                var6_10 = false;
                if (var5_8.length() == 0 && jsonObject.has("registerUrl")) {
                    dataStr = responseStr;
                }
            } else if (jsonObject.has("registerUrl") || jsonObject.has("sip")) {
                dataStr = responseStr;
            }
            var5_9 = dataStr;
            var6_10 = false;
            var7_12 = false;
            if (var5_9 == null || var5_9.length() == 0) {
                Loger.wTag("CallSDK", new Object[]{"No valid data in WebRTC info response"});
                return null;
            }
            dataObject = new JSONObject(dataStr);
            sip = dataObject.optString("sip");
            ctPassword = dataObject.optString("ctPassword");
            if (!dataObject.has("extranalUrl")) ** GOTO lbl-1000
            v1 = dataObject.optString("extranalUrl");
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"dataObject.optString(\"extranalUrl\")");
            var9_14 = v1;
            var10_15 = false;
            if (!(var9_14.length() == 0)) {
                v2 = dataObject.optString("extranalUrl");
            } else lbl-1000:
            // 2 sources

            {
                v2 = dataObject.optString("registerUrl");
            }
            v3 = extranalUrl = v2;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"extranalUrl");
            var9_14 = v3;
            var10_15 = false;
            if (var9_14.length() == 0) {
                Loger.wTag("CallSDK", new Object[]{"extranalUrl is empty"});
                return null;
            }
            addrParts = StringsKt.split$default((CharSequence)extranalUrl, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            if (addrParts.size() < 2) {
                Loger.wTag("CallSDK", new Object[]{"Invalid extranalUrl format: " + extranalUrl});
                return null;
            }
            addr = (String)addrParts.get(0);
            v4 = StringsKt.toIntOrNull((String)((String)addrParts.get(1)));
            if (v4 == null) {
                var12_18 = this;
                var13_20 = false;
                var14_22 = false;
                $this$run = var12_18;
                $i$a$-run-CallSDK$parseSipParamsFromWebRtcInfo$port$1 = false;
                Loger.wTag("CallSDK", new Object[]{"Invalid port: " + (String)addrParts.get(1)});
                return null;
            }
            port = v4;
            var12_19 = new SipParams();
            var13_21 = false;
            var14_23 = false;
            $this$apply = var12_19;
            $i$a$-apply-CallSDK$parseSipParamsFromWebRtcInfo$1 = false;
            $this$apply.setPhoneNum(phoneNumber);
            $this$apply.setAddr(addr);
            $this$apply.setPort(port);
            $this$apply.setSipScret(ctPassword);
            $this$apply.setSipName(sip);
            return var12_19;
        }
        catch (Exception e) {
            Loger.eTag("CallSDK", new Object[]{"Parse SIP params error: " + e.getMessage()});
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    public static final int releaseCall() {
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.releaseCall(CallSDK.getCurrentCallId(), 0);
    }

    @JvmStatic
    public static final boolean getMuteStatus() {
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.getMuteStatus();
    }

    @JvmStatic
    public static final int setMute(boolean mute) {
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.setMute(mute);
    }

    @JvmStatic
    public static final int sendDTMF(@Nullable String callId, char dtmf) {
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.sendDTMF(callId, dtmf);
    }

    @JvmStatic
    @Nullable
    public static final String getCurrentCall() {
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.getCurrentCall();
    }

    private CallSDK() {
    }

    static {
        CallSDK callSDK;
        INSTANCE = callSDK = new CallSDK();
    }

    public static final /* synthetic */ InitListener access$getInitListener$p(CallSDK $this) {
        CallSDK callSDK = $this;
        return initListener;
    }

    public static final /* synthetic */ void access$setInitListener$p(CallSDK $this, InitListener initListener) {
        CallSDK callSDK = $this;
        CallSDK.initListener = initListener;
    }

    public static final /* synthetic */ SipParams access$parseSipParamsFromWebRtcInfo(CallSDK $this, String responseStr, String phoneNumber) {
        return $this.parseSipParamsFromWebRtcInfo(responseStr, phoneNumber);
    }
}

