//
//  Call.swift
//  JJPhoneDemo
//
//

import Foundation

/// 通话状态
enum CallStatus: String {
    case calling = "calling"           // 正在呼叫
    case connecting = "connecting"      // 振铃中
    case connected = "connected"        // 已接通
    case disconnected = "disconnected"  // 已断开
    case failed = "failed"              // 呼叫失败
}

/// 通话类型
enum CallType: String {
    case outgoing = "outgoing"  // 呼出
    case incoming = "incoming" // 呼入
}

/// 通话模型
class Call {
    var id: String = UUID().uuidString
    var phoneNumber: String = ""
    var displayName: String = ""
    var callType: CallType = .outgoing
    var status: CallStatus = .calling
    var startTime: Date = Date()
    var endTime: Date?
    var duration: TimeInterval = 0
    
    /// 格式化显示的电话号码
    var formattedPhoneNumber: String {
        return phoneNumber.isEmpty ? "未知号码" : phoneNumber
    }
    
    /// 格式化显示的名称
    var displayNameOrNumber: String {
        return displayName.isEmpty ? formattedPhoneNumber : displayName
    }
    
    /// 格式化通话时长
    var formattedDuration: String {
        let totalSeconds = Int(duration)
        let hours = totalSeconds / 3600
        let minutes = (totalSeconds % 3600) / 60
        let seconds = totalSeconds % 60
        
        if hours > 0 {
            return String(format: "%02d:%02d:%02d", hours, minutes, seconds)
        } else {
            return String(format: "%02d:%02d", minutes, seconds)
        }
    }
    
    /// 格式化开始时间
    var formattedStartTime: String {
        let formatter = DateFormatter()
        formatter.dateFormat = "yyyy-MM-dd HH:mm:ss"
        return formatter.string(from: startTime)
    }
}


