//
//  AppLogger.swift
//  JJPhoneDemo
//
//  统一的应用日志入口，便于后续替换为 OSLog 或接入外部日志系统
//

import Foundation

enum LogLevel: String {
    case debug = "DEBUG"
    case info = "INFO"
    case warning = "WARN"
    case error = "ERROR"
}

enum AppLogger {
    
    /// 是否在控制台输出调试日志（可根据构建配置或开关控制）
    private static let isDebugLoggingEnabled: Bool = true
    
    static func log(_ message: String,
                    level: LogLevel = .debug,
                    category: String = "App") {
        guard isDebugLoggingEnabled || level == .error || level == .warning else { return }
        let prefix = "[\(category)] [\(level.rawValue)]"
        print("\(prefix) \(message)")
    }
    
    static func debug(_ message: String, category: String = "App") {
        log(message, level: .debug, category: category)
    }
    
    static func info(_ message: String, category: String = "App") {
        log(message, level: .info, category: category)
    }
    
    static func warning(_ message: String, category: String = "App") {
        log(message, level: .warning, category: category)
    }
    
    static func error(_ message: String, category: String = "App") {
        log(message, level: .error, category: category)
    }
}


