package com.useasy.callsdk.demo.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.useasy.callsdk.bean.NumberGroup
import com.useasy.callsdk.demo.R

/**
 * 外显号码组列表适配器
 */
class NumberGroupAdapter(
    private val numberGroups: List<NumberGroup>,
    private val selectedGroupId: String? = null,
    private val onItemClick: (NumberGroup) -> Unit
) : RecyclerView.Adapter<NumberGroupAdapter.ViewHolder>() {

    private var currentSelectedId: String? = selectedGroupId

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val tvGroupName: TextView = itemView.findViewById(R.id.tv_group_name)
        val ivSelected: ImageView = itemView.findViewById(R.id.iv_selected)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view = LayoutInflater.from(parent.context)
            .inflate(R.layout.item_number_group, parent, false)
        return ViewHolder(view)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val group = numberGroups[position]
        holder.tvGroupName.text = group.groupName ?: group.id ?: "未命名号码组"
        
        // 显示选中状态
        val isSelected = group.id == currentSelectedId
        holder.ivSelected.visibility = if (isSelected) View.VISIBLE else View.GONE
        
        holder.itemView.setOnClickListener {
            currentSelectedId = group.id
            notifyDataSetChanged()
            onItemClick(group)
        }
    }

    override fun getItemCount(): Int = numberGroups.size

    fun getSelectedGroupId(): String? = currentSelectedId
}

