package com.useasy.callsdk.utils

import android.Manifest
import android.app.Activity
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat

/**
 * 权限帮助类
 */
object PermissionHelper {
    
    /**
     * 检查是否有录音权限
     */
    @JvmStatic
    fun hasRecordAudioPermission(context: Context): Boolean {
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            ContextCompat.checkSelfPermission(
                context,
                Manifest.permission.RECORD_AUDIO
            ) == PackageManager.PERMISSION_GRANTED
        } else {
            true
        }
    }
    
    /**
     * 请求录音权限
     * @param activity Activity 实例
     * @param requestCode 请求码
     * @return true 如果已经授权，false 如果需要申请
     */
    @JvmStatic
    fun requestRecordAudioPermission(activity: Activity, requestCode: Int): Boolean {
        return if (hasRecordAudioPermission(activity)) {
            true
        } else {
            ActivityCompat.requestPermissions(
                activity,
                arrayOf(Manifest.permission.RECORD_AUDIO),
                requestCode
            )
            false
        }
    }
    
    /**
     * 检查权限申请结果
     * @param grantResults 权限申请结果数组
     * @return true 如果权限已授予
     */
    @JvmStatic
    fun isPermissionGranted(grantResults: IntArray): Boolean {
        return grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED
    }
}

