package com.useasy.callsdk.demo

import android.app.Activity
import android.app.Application

/**
 * Demo Application
 */
class DemoApplication : Application() {

    companion object {
        @JvmStatic
        var instance: DemoApplication? = null
            private set
    }

    private val activityStack = mutableListOf<Activity>()

    override fun onCreate() {
        super.onCreate()
        instance = this
    }

    /**
     * 添加 Activity 到栈中
     */
    fun addActivity(activity: Activity) {
        activityStack.add(activity)
    }

    /**
     * 从栈中移除 Activity
     */
    fun removeActivity(activity: Activity) {
        activityStack.remove(activity)
    }

    /**
     * 关闭所有 Activity
     */
    fun finishAllActivities() {
        activityStack.forEach { it.finish() }
        activityStack.clear()
    }
}
