/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.socket.websocket;

import android.text.TextUtils;
import com.useasy.callsdk.socket.java_websocket.WebSocket;
import com.useasy.callsdk.socket.java_websocket.client.WebSocketClient;
import com.useasy.callsdk.socket.java_websocket.drafts.Draft;
import com.useasy.callsdk.socket.java_websocket.drafts.Draft_6455;
import com.useasy.callsdk.socket.java_websocket.exceptions.WebsocketNotConnectedException;
import com.useasy.callsdk.socket.java_websocket.framing.Framedata;
import com.useasy.callsdk.socket.java_websocket.handshake.ServerHandshake;
import com.useasy.callsdk.socket.websocket.SocketWrapperListener;
import com.useasy.callsdk.socket.websocket.WebSocketSetting;
import com.useasy.callsdk.socket.websocket.request.Request;
import com.useasy.callsdk.socket.websocket.response.Response;
import com.useasy.callsdk.socket.websocket.response.ResponseFactory;
import com.useasy.callsdk.utils.Loger;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;

public class WebSocketWrapper {
    private static final String TAG = "WSWrapper";
    private WebSocketSetting mSetting;
    private SocketWrapperListener mSocketListener;
    private WebSocketClient mWebSocket;
    private int connectStatus = 0;
    private boolean needClose = false;
    private boolean destroyed = false;

    WebSocketWrapper(WebSocketSetting setting, SocketWrapperListener socketListener) {
        this.mSetting = setting;
        this.mSocketListener = socketListener;
    }

    void connect() {
        block12: {
            if (this.destroyed) {
                return;
            }
            this.needClose = false;
            if (this.connectStatus == 0) {
                this.connectStatus = 1;
                try {
                    if (this.mWebSocket == null) {
                        int connectTimeOut;
                        if (TextUtils.isEmpty((CharSequence)this.mSetting.getConnectUrl())) {
                            throw new RuntimeException("WebSocket connect url is empty!");
                        }
                        Draft draft = this.mSetting.getDraft();
                        if (draft == null) {
                            draft = new Draft_6455();
                        }
                        if ((connectTimeOut = this.mSetting.getConnectTimeout()) <= 0) {
                            connectTimeOut = 0;
                        }
                        this.mWebSocket = new MyWebSocketClient(new URI(this.mSetting.getConnectUrl()), draft, this.mSetting.getHttpHeaders(), connectTimeOut);
                        Loger.d(TAG, "WebSocket start connect...");
                        if (this.mSetting.getProxy() != null) {
                            this.mWebSocket.setProxy(this.mSetting.getProxy());
                        }
                        this.mWebSocket.connect();
                        this.mWebSocket.setConnectionLostTimeout(this.mSetting.getConnectionLostTimeout());
                        if (this.needClose) {
                            this.disConnect();
                        }
                        this.checkDestroy();
                    } else {
                        Loger.d(TAG, "WebSocket reconnecting...");
                        this.mWebSocket.reconnect();
                        if (this.needClose) {
                            this.disConnect();
                        }
                        this.checkDestroy();
                    }
                }
                catch (Throwable e) {
                    this.connectStatus = 0;
                    Loger.d(TAG, "WebSocket connect failed:", e);
                    if (this.mSocketListener == null) break block12;
                    this.mSocketListener.onConnectFailed(e);
                }
            }
        }
    }

    void reconnect() {
        this.needClose = false;
        if (this.connectStatus == 0) {
            this.connect();
        }
    }

    void disConnect() {
        this.needClose = true;
        if (this.connectStatus == 2) {
            Loger.d(TAG, "WebSocket disconnecting...");
            if (this.mWebSocket != null) {
                this.mWebSocket.close();
            }
            Loger.d(TAG, "WebSocket disconnected");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void send(Request request) {
        if (this.mWebSocket == null) {
            return;
        }
        if (request == null) {
            Loger.d(TAG, "send data is null!");
            return;
        }
        if (this.connectStatus == 2) {
            try {
                request.send(this.mWebSocket);
                Loger.d(TAG, "send success:" + request.toString());
                return;
            }
            catch (WebsocketNotConnectedException e) {
                this.connectStatus = 0;
                Loger.d(TAG, "ws is disconnected, send failed:" + request.toString(), e);
                if (this.mSocketListener == null) return;
                this.mSocketListener.onSendDataError(request, 0, e);
                this.mSocketListener.onDisconnect();
                return;
            }
            catch (Throwable e) {
                this.connectStatus = 0;
                Loger.d(TAG, "Exception,send failed:" + request.toString(), e);
                if (this.mSocketListener == null) return;
                this.mSocketListener.onSendDataError(request, 1, e);
                return;
            }
            finally {
                request.release();
            }
        } else {
            Loger.d(TAG, "WebSocket not connect,send failed:" + request.toString());
            if (this.mSocketListener == null) return;
            this.mSocketListener.onSendDataError(request, 0, null);
        }
    }

    int getConnectState() {
        return this.connectStatus;
    }

    void destroy() {
        this.destroyed = true;
        this.disConnect();
        if (this.connectStatus == 0) {
            this.mWebSocket = null;
        }
        this.releaseResource();
    }

    private void checkDestroy() {
        if (this.destroyed) {
            try {
                if (this.mWebSocket != null && !this.mWebSocket.isClosed()) {
                    this.mWebSocket.close();
                }
                this.releaseResource();
                this.connectStatus = 0;
            }
            catch (Throwable e) {
                Loger.d(TAG, "checkDestroy(WebSocketClient)", e);
            }
        }
    }

    private void releaseResource() {
        if (this.mSocketListener != null) {
            this.mSocketListener = null;
        }
    }

    private void onWSCallbackOpen(ServerHandshake handshakeData) {
        if (this.destroyed) {
            this.checkDestroy();
            return;
        }
        this.connectStatus = 2;
        Loger.d(TAG, "WebSocket connect success");
        if (this.needClose) {
            this.disConnect();
        } else if (this.mSocketListener != null) {
            this.mSocketListener.onConnected();
        }
    }

    private void onWSCallbackMessage(String message) {
        if (this.destroyed) {
            this.checkDestroy();
            return;
        }
        this.connectStatus = 2;
        if (this.mSocketListener != null) {
            Response<String> response2 = ResponseFactory.createTextResponse();
            response2.setResponseData(message);
            Loger.d(TAG, "WebSocket received message:" + response2.toString());
            this.mSocketListener.onMessage(response2);
        }
    }

    private void onWSCallbackMessage(ByteBuffer bytes) {
        if (this.destroyed) {
            this.checkDestroy();
            return;
        }
        this.connectStatus = 2;
        if (this.mSocketListener != null) {
            Response<ByteBuffer> response2 = ResponseFactory.createByteBufferResponse();
            response2.setResponseData(bytes);
            this.mSocketListener.onMessage(response2);
        }
    }

    private void onWSCallbackWebsocketPing(Framedata f) {
        if (this.destroyed) {
            this.checkDestroy();
            return;
        }
        this.connectStatus = 2;
        if (this.mSocketListener != null) {
            Response<Framedata> response2 = ResponseFactory.createPingResponse();
            response2.setResponseData(f);
            Loger.d(TAG, "WebSocket received ping:" + response2.toString());
            this.mSocketListener.onMessage(response2);
        }
    }

    private void onWSCallbackWebsocketPong(Framedata f) {
        if (this.destroyed) {
            this.checkDestroy();
            return;
        }
        this.connectStatus = 2;
        if (this.mSocketListener != null) {
            Response<Framedata> response2 = ResponseFactory.createPongResponse();
            response2.setResponseData(f);
            Loger.d(TAG, "WebSocket received pong:" + response2.toString());
            this.mSocketListener.onMessage(response2);
        }
    }

    private void onWSCallbackClose(int code, String reason, boolean remote) {
        this.connectStatus = 0;
        Loger.d(TAG, String.format("WebSocket closed!code=%s,reason:%s,remote:%s", code, reason, remote));
        if (this.mSocketListener != null) {
            this.mSocketListener.onDisconnect();
        }
        this.checkDestroy();
    }

    private void onWSCallbackError(Exception ex) {
        if (this.destroyed) {
            this.checkDestroy();
            return;
        }
        Loger.d(TAG, "WebSocketClient#onError(Exception)", ex);
    }

    private class MyWebSocketClient
    extends WebSocketClient {
        public MyWebSocketClient(URI serverUri) {
            super(serverUri);
        }

        public MyWebSocketClient(URI serverUri, Draft protocolDraft) {
            super(serverUri, protocolDraft);
        }

        public MyWebSocketClient(URI serverUri, Map<String, String> httpHeaders) {
            super(serverUri, httpHeaders);
        }

        public MyWebSocketClient(URI serverUri, Draft protocolDraft, Map<String, String> httpHeaders) {
            super(serverUri, protocolDraft, httpHeaders);
        }

        public MyWebSocketClient(URI serverUri, Draft protocolDraft, Map<String, String> httpHeaders, int connectTimeout) {
            super(serverUri, protocolDraft, httpHeaders, connectTimeout);
        }

        @Override
        public void onOpen(ServerHandshake handshakeData) {
            WebSocketWrapper.this.onWSCallbackOpen(handshakeData);
        }

        @Override
        public void onMessage(String message) {
            WebSocketWrapper.this.onWSCallbackMessage(message);
        }

        @Override
        public void onMessage(ByteBuffer bytes) {
            WebSocketWrapper.this.onWSCallbackMessage(bytes);
        }

        @Override
        public void onWebsocketPing(WebSocket conn, Framedata f) {
            super.onWebsocketPing(conn, f);
            WebSocketWrapper.this.onWSCallbackWebsocketPing(f);
        }

        @Override
        public void onWebsocketPong(WebSocket conn, Framedata f) {
            super.onWebsocketPong(conn, f);
            WebSocketWrapper.this.onWSCallbackWebsocketPong(f);
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
            WebSocketWrapper.this.onWSCallbackClose(code, reason, remote);
        }

        @Override
        public void onError(Exception ex) {
            WebSocketWrapper.this.onWSCallbackError(ex);
        }
    }
}

