/*
 * Decompiled with CFR 0.152.
 */
package com.yuntongxun.ecsdk.voip.video;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.hisun.phone.core.voice.util.Log4Util;
import com.yuntongxun.ecsdk.voip.video.ECOpenGlRender;
import java.lang.ref.WeakReference;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

public class ECOpenGlView
extends GLSurfaceView {
    private static final String TAG = "OPENGLVIEW";
    private int mGlVersion = 1;
    private WeakReference<GLSurfaceView.Renderer> mRenders;
    long mPtr = -1L;
    private String mRenderUser;
    AspectMode mAspectMode;
    protected RenderType mRenderType;

    public ECOpenGlView(Context context) {
        this(context, null);
    }

    public ECOpenGlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mGlVersion = ECOpenGlRender.getOpenGLVersion(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.initOpenGlView();
        this.mRenderType = RenderType.RENDER_REMOTE;
        this.initRenderer(new ECOpenGlRender(this, this.mRenderType.ordinal()));
        this.setRenderMode(0);
    }

    private void initOpenGlView() {
        block3: {
            try {
                this.getHolder().setType(2);
            }
            catch (Exception e) {
                if (this.setSurfaceType(1)) break block3;
                this.setSurfaceType(0);
            }
        }
        if (this.mGlVersion == 2) {
            this.setEGLContextFactory(new ContextFactory());
            this.setEGLConfigChooser(new ConfigChooser());
        }
    }

    private boolean setSurfaceType(int type) {
        try {
            this.getHolder().setType(type);
            return true;
        }
        catch (Exception e) {
            Log4Util.e(TAG, e + "get Exception on setSurfaceType");
            return false;
        }
    }

    public void setGlType(RenderType type) {
        this.mRenderType = type;
        this.initZOrderAttribute(type == RenderType.RENDER_PREVIEW);
    }

    private void initZOrderAttribute(boolean isPreview) {
        ECOpenGlRender mRender = (ECOpenGlRender)this.mRenders.get();
        if (mRender == null || mRender.mSurfaceReady) {
            Log4Util.e(TAG, "setGlType fail, mRender null or surfaceReady ");
            return;
        }
        if (!isPreview) {
            return;
        }
        if (Build.MODEL.equals("Nexus 6")) {
            this.setZOrderOnTop(true);
        } else {
            this.setZOrderMediaOverlay(true);
        }
    }

    public void setGlViewSize(int width, int height) {
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, height));
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    public void setGlUser(String account) {
        this.mRenderUser = account;
    }

    public String getGlUser() {
        return this.mRenderUser;
    }

    private void initRenderer(ECOpenGlRender renderer) {
        if (this.mRenders != null) {
            Log4Util.e(TAG, "glRender has init.");
            return;
        }
        this.setEGLContextClientVersion(this.mGlVersion);
        this.mRenders = new WeakReference<ECOpenGlRender>(renderer);
        Log4Util.i(TAG, "initRenderer " + renderer + " , glVersion " + this.mGlVersion);
        super.setRenderer((GLSurfaceView.Renderer)renderer);
    }

    public void setAspectMode(AspectMode mode) {
        this.mAspectMode = mode;
    }

    public ECOpenGlRender getRenderer() {
        if (this.mRenders == null) {
            return null;
        }
        return (ECOpenGlRender)this.mRenders.get();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        Log4Util.i(TAG, "surfaceChanged, format: " + format + ", w: " + w + ", h: " + h);
        super.surfaceChanged(holder, format, w, h);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        super.surfaceCreated(holder);
        Log4Util.i(TAG, "surfaceCreated");
        ECOpenGlRender mRender = (ECOpenGlRender)this.mRenders.get();
        if (mRender == null) {
            return;
        }
        this.mPtr = mRender.Create();
        if (this.mPtr == -1L) {
            return;
        }
        Log4Util.i(TAG, "surfaceCreated glRender init");
        mRender.mSurfaceReady = true;
        mRender.mWidth = 0;
        mRender.mHeight = 0;
        mRender.requestRender();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log4Util.i(TAG, "surfaceDestroyed");
        ECOpenGlRender mRender = (ECOpenGlRender)this.mRenders.get();
        if (mRender != null) {
            mRender.mSurfaceReady = false;
            if (this.mPtr != -1L) {
                mRender.Uninit(this.mPtr);
            }
            mRender.mWidth = 0;
            mRender.mHeight = 0;
            mRender.mGlInitReady = false;
        }
        super.surfaceDestroyed(holder);
    }

    public static boolean UseOpenGL2(Object renderWindow) {
        return renderWindow != null && ECOpenGlView.class.isInstance(renderWindow);
    }

    public static enum RenderType {
        RENDER_PREVIEW,
        RENDER_REMOTE;

    }

    private static class ContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private ContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig eglConfig) {
            Log4Util.w(ECOpenGlView.TAG, "creating OpenGL ES 2.0 context");
            Log4Util.v(ECOpenGlView.TAG, "Before eglCreateContext " + egl);
            int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            EGLContext context = egl.eglCreateContext(display, eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
            Log4Util.v(ECOpenGlView.TAG, "After eglCreateContext " + egl);
            return context;
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12324, EGL_OPENGL_ES2_BIT, 12323, EGL_OPENGL_ES2_BIT, 12322, EGL_OPENGL_ES2_BIT, 12352, EGL_OPENGL_ES2_BIT, 12344};
        int mRedSize = 5;
        int mGreenSize = 6;
        int mBlueSize = 5;
        int mAlphaSize = 0;
        int mDepthSize = 0;
        int mStencilSize = 0;
        private int[] mValue = new int[1];

        private ConfigChooser() {
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, s_configAttribs2, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, s_configAttribs2, configs, numConfigs, num_config);
            return this.chooseConfig(egl, display, configs);
        }

        EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultAttrib) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultAttrib;
        }
    }

    public static enum AspectMode {
        FIT,
        CROP,
        FILL;

    }
}

