/*
 * Decompiled with CFR 0.152.
 */
package com.yuntongxun.ecsdk.core.voip;

import android.content.Context;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;

class WebRtcAudioRecord {
    private AudioRecord _audioRecord = null;
    private Context _context;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufRec;
    private final ReentrantLock _recLock = new ReentrantLock();
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private int _bufferedRecSamples = 0;
    private AcousticEchoCanceler _aec = null;
    private boolean _useBuiltInAEC = false;
    final String logTag = "WebRtcAudioRecord-Java";

    private static boolean runningOnJellyBeanOrHigher() {
        return Build.VERSION.SDK_INT >= 16;
    }

    WebRtcAudioRecord() {
        try {
            this._recBuffer = ByteBuffer.allocateDirect(960);
        }
        catch (Exception e) {
            this.DoLog(e.getMessage());
        }
        this._tempBufRec = new byte[960];
    }

    public static boolean BuiltInAECIsAvailable() {
        if (!WebRtcAudioRecord.runningOnJellyBeanOrHigher()) {
            return false;
        }
        return AcousticEchoCanceler.isAvailable();
    }

    private int EnableBuiltInAEC(boolean enable) {
        this.DoLog("EnableBuiltInAEC(" + enable + ')');
        if (!WebRtcAudioRecord.runningOnJellyBeanOrHigher()) {
            return -1;
        }
        this._useBuiltInAEC = enable;
        if (this._aec != null) {
            int ret = this._aec.setEnabled(enable);
            if (ret != 0) {
                this.DoLogErr("AcousticEchoCanceler.setEnabled failed");
                return -1;
            }
            this.DoLog("AcousticEchoCanceler.getEnabled: " + this._aec.getEnabled());
        }
        return 0;
    }

    private int InitRecording(int audioSource, int sampleRate) {
        this.DoLog("InitRecording");
        audioSource = 7;
        int minRecBufSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)16, (int)2);
        int recBufSize = minRecBufSize * 2;
        this._bufferedRecSamples = sampleRate / 200;
        if (this._aec != null) {
            this._aec.release();
            this._aec = null;
        }
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        try {
            this._audioRecord = new AudioRecord(audioSource, sampleRate, 16, 2, recBufSize);
        }
        catch (Exception e) {
            this.DoLog(e.getMessage());
            return -1;
        }
        if (this._audioRecord.getState() != 1) {
            return -1;
        }
        this.DoLog("AcousticEchoCanceler.isAvailable: " + WebRtcAudioRecord.BuiltInAECIsAvailable());
        if (!WebRtcAudioRecord.BuiltInAECIsAvailable()) {
            return this._bufferedRecSamples;
        }
        this._aec = AcousticEchoCanceler.create((int)this._audioRecord.getAudioSessionId());
        if (this._aec == null) {
            this.DoLogErr("AcousticEchoCanceler.create failed");
            return -1;
        }
        int ret = this._aec.setEnabled(this._useBuiltInAEC);
        if (ret != 0) {
            this.DoLogErr("AcousticEchoCanceler.setEnabled failed");
            return -1;
        }
        AudioEffect.Descriptor descriptor = this._aec.getDescriptor();
        this.DoLog("AcousticEchoCanceler name: " + descriptor.name + ", implementor: " + descriptor.implementor + ", uuid: " + descriptor.uuid);
        this.DoLog("AcousticEchoCanceler.getEnabled: " + this._aec.getEnabled());
        return this._bufferedRecSamples;
    }

    private int StartRecording() {
        this.DoLog("StartRecording");
        try {
            this._audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return -1;
        }
        this._isRecording = true;
        return 0;
    }

    private int StopRecording() {
        this.DoLog("StopRecording");
        this._recLock.lock();
        try {
            if (this._audioRecord.getRecordingState() == 3) {
                try {
                    this._audioRecord.stop();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    int n = -1;
                    this._doRecInit = true;
                    this._recLock.unlock();
                    return n;
                }
            }
            if (this._aec != null) {
                this._aec.release();
                this._aec = null;
            }
            this._audioRecord.release();
            this._audioRecord = null;
        }
        finally {
            this._doRecInit = true;
            this._recLock.unlock();
        }
        this._isRecording = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int RecordAudio(int lengthInBytes) {
        this._recLock.lock();
        try {
            if (this._audioRecord == null) {
                int n = -2;
                return n;
            }
            if (this._doRecInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception e) {
                    this.DoLog("Set rec thread priority failed: " + e.getMessage());
                }
                this._doRecInit = false;
            }
            int readBytes = 0;
            this._recBuffer.rewind();
            readBytes = this._audioRecord.read(this._tempBufRec, 0, lengthInBytes);
            this._recBuffer.put(this._tempBufRec);
            if (readBytes != lengthInBytes) {
                int n = -1;
                return n;
            }
        }
        catch (Exception e) {
            this.DoLogErr("RecordAudio try failed: " + e.getMessage());
        }
        finally {
            this._recLock.unlock();
        }
        return this._bufferedRecSamples;
    }

    private void DoLog(String msg) {
        Log.d((String)"WebRtcAudioRecord-Java", (String)msg);
    }

    private void DoLogErr(String msg) {
        Log.e((String)"WebRtcAudioRecord-Java", (String)msg);
    }
}

