/*
 * Decompiled with CFR 0.152.
 */
package com.yuntongxun.ecsdk.core.voip;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Process;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.hisun.phone.core.voice.DeviceImpl;
import com.hisun.phone.core.voice.util.Log4Util;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ViESurfaceRenderer
implements SurfaceHolder.Callback {
    public static final boolean DEBUG = false;
    private static final String TAG = "console";
    private Bitmap bitmap = null;
    private ByteBuffer byteBuffer = null;
    private SurfaceHolder surfaceHolder;
    private Rect srcRect = new Rect();
    private Rect dstRect = new Rect();
    private float dstTopScale = 0.0f;
    private float dstBottomScale = 1.0f;
    private float dstLeftScale = 0.0f;
    private float dstRightScale = 1.0f;

    public ViESurfaceRenderer(String account) {
        Log4Util.w(TAG, "hubintest ViESurfaceRenderer account:" + account);
        SurfaceView view = DeviceImpl.getVideoView(account);
        this.surfaceHolder = view.getHolder();
        if (this.surfaceHolder == null) {
            return;
        }
        this.surfaceCreated(this.surfaceHolder);
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
    }

    private void changeDestRect(int dstWidth, int dstHeight) {
        this.dstRect.right = (int)((float)this.dstRect.left + this.dstRightScale * (float)dstWidth);
        this.dstRect.bottom = (int)((float)this.dstRect.top + this.dstBottomScale * (float)dstHeight);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int in_width, int in_height) {
        this.changeDestRect(in_width, in_height);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            Rect dst = this.surfaceHolder.getSurfaceFrame();
            if (dst != null) {
                this.changeDestRect(dst.right - dst.left, dst.bottom - dst.top);
            }
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public Bitmap CreateBitmap(int width, int height) {
        if (this.bitmap == null) {
            try {
                Process.setThreadPriority((int)-4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        this.srcRect.left = 0;
        this.srcRect.top = 0;
        this.srcRect.bottom = height;
        this.srcRect.right = width;
        this.dstRect.bottom = height;
        this.dstRect.right = width;
        return this.bitmap;
    }

    public ByteBuffer CreateByteBuffer(int width, int height) {
        this.bitmap = this.CreateBitmap(width, height);
        this.byteBuffer = ByteBuffer.allocateDirect(width * height * 2);
        return this.byteBuffer;
    }

    public void SetCoordinates(float left, float top, float right, float bottom) {
        this.dstLeftScale = left;
        this.dstTopScale = top;
        this.dstRightScale = right;
        this.dstBottomScale = bottom;
    }

    private void saveBitmapToJPEG(int width, int height) {
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        this.bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteOutStream);
        try {
            FileOutputStream output = new FileOutputStream(String.format("/sdcard/render_%d.jpg", System.currentTimeMillis()));
            output.write(byteOutStream.toByteArray());
            output.flush();
            output.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void DrawByteBuffer() {
        if (this.byteBuffer == null) {
            return;
        }
        this.byteBuffer.rewind();
        this.bitmap.copyPixelsFromBuffer((Buffer)this.byteBuffer);
        this.DrawBitmap();
    }

    public void DrawBitmap() {
        if (this.bitmap == null) {
            return;
        }
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            canvas.drawColor(0xFFFFFF);
            canvas.drawBitmap(this.bitmap, this.srcRect, this.dstRect, null);
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }
}

