/*
 * Decompiled with CFR 0.152.
 */
package com.yuntongxun.ecsdk.core.voip;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;

class AudioManagerAndroid {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;

    private AudioManagerAndroid(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        if (Build.VERSION.SDK_INT >= 17) {
            String framesPerBuffer;
            String sampleRateString = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (sampleRateString != null) {
                this.mNativeOutputSampleRate = Integer.parseInt(sampleRateString);
            }
            if ((framesPerBuffer = audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(framesPerBuffer);
            }
        }
        this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }
}

