/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.util;

import android.text.TextUtils;
import com.hisun.phone.core.voice.Device;
import com.hisun.phone.core.voice.model.chatroom.Chatroom;
import com.hisun.phone.core.voice.model.videoconference.VideoConference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConferenceUtils {
    public static HashMap<String, String> mConferenceMap = new HashMap();
    static Object mLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void procesConferenceNo(Device.RunningType type, String confNo) {
        Object object = mLock;
        synchronized (object) {
            if (type == Device.RunningType.RunningType_Interphone) {
                mConferenceMap.put(confNo, confNo);
                return;
            }
            if (type == Device.RunningType.RunningType_ChatRoom || type == Device.RunningType.RunningType_VideoConference) {
                String procesConfNo = ConferenceUtils.getConferenceNo(confNo);
                mConferenceMap.put(procesConfNo, confNo);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProcesConferenceNo(String originalConfNo) {
        Object object = mLock;
        synchronized (object) {
            for (Map.Entry<String, String> entry : mConferenceMap.entrySet()) {
                String value = entry.getValue();
                if (TextUtils.isEmpty((CharSequence)value) || !value.equals(originalConfNo)) continue;
                return entry.getKey();
            }
            return originalConfNo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOriginalConferenceNo(String procesConfNo) {
        Object object = mLock;
        synchronized (object) {
            for (Map.Entry<String, String> entry : mConferenceMap.entrySet()) {
                String value = entry.getKey();
                if (TextUtils.isEmpty((CharSequence)value) || !value.equals(procesConfNo)) continue;
                return entry.getValue();
            }
            return procesConfNo;
        }
    }

    public static void releaseConferMapCache() {
        if (!mConferenceMap.isEmpty()) {
            for (Map.Entry<String, String> entry : mConferenceMap.entrySet()) {
                mConferenceMap.remove(entry.getKey());
            }
            mConferenceMap.clear();
        }
    }

    public static List<Chatroom> procesChatrooms(List<Chatroom> chatrooms) {
        if (chatrooms != null && !chatrooms.isEmpty()) {
            for (Chatroom chatroom : chatrooms) {
                String roomNo = chatroom.getRoomNo();
                ConferenceUtils.procesConferenceNo(Device.RunningType.RunningType_ChatRoom, roomNo);
                chatroom.setRoomNo(ConferenceUtils.getProcesConferenceNo(roomNo));
            }
        }
        return chatrooms;
    }

    public static List<VideoConference> procesVideoConferences(List<VideoConference> videoConferences) {
        if (videoConferences != null && !videoConferences.isEmpty()) {
            for (VideoConference videoConference : videoConferences) {
                String roomNo = videoConference.getConferenceId();
                ConferenceUtils.procesConferenceNo(Device.RunningType.RunningType_VideoConference, roomNo);
                videoConference.setConferenceId(ConferenceUtils.getProcesConferenceNo(roomNo));
            }
        }
        return videoConferences;
    }

    public static String getConferenceNo(String conferenceNo) {
        if (TextUtils.isEmpty((CharSequence)conferenceNo) || conferenceNo.length() < 30) {
            return conferenceNo;
        }
        return conferenceNo.substring(0, 30);
    }
}

