/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.util;

import android.content.Context;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.hisun.phone.core.voice.DeviceListener;
import com.hisun.phone.core.voice.util.Log4Util;
import org.apache.http.HttpHost;

public class CheckApnTypeUtils {
    private static Context mContext;
    public static Uri PREFERRED_APN_URI;
    public static final String CTWAP = "ctwap";
    public static final String CMWAP = "cmwap";
    public static final String WAP_3G = "3gwap";
    public static final String UNIWAP = "uniwap";
    public static final int TYPE_NET_WORK_DISABLED = 0;
    public static final int TYPE_CM_CU_WAP = 4;
    public static final int TYPE_CT_WAP = 5;
    public static final int TYPE_OTHER_NET = 6;

    public static int checkNetworkType(Context mContext) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
            NetworkInfo mobNetInfoActivity = connectivityManager.getActiveNetworkInfo();
            if (mobNetInfoActivity == null || !mobNetInfoActivity.isAvailable()) {
                Log4Util.i("SDK_DEVICE", "The network connection is not currently available.");
                return 0;
            }
            int netType = mobNetInfoActivity.getType();
            if (netType == 1) {
                Log4Util.i("SDK_DEVICE", "The current network of type WIFI.");
                return 6;
            }
            if (netType == 0) {
                Cursor c = mContext.getContentResolver().query(PREFERRED_APN_URI, null, null, null, null);
                if (c != null) {
                    c.moveToFirst();
                    String user = c.getString(c.getColumnIndex("user"));
                    if (!TextUtils.isEmpty((CharSequence)user)) {
                        Log4Util.i("SDK_DEVICE", " Internet Agents \ufffd\ufffd" + c.getString(c.getColumnIndex("proxy")));
                        if (user.startsWith(CTWAP)) {
                            Log4Util.i("SDK_DEVICE", "The current network of type : Telecom WAP network ");
                            return 5;
                        }
                    }
                }
                c.close();
                String netMode = mobNetInfoActivity.getExtraInfo();
                Log4Util.i("SDK_DEVICE", "The current network netMode: " + netMode);
                if (netMode != null && ((netMode = netMode.toLowerCase()).equals(CMWAP) || netMode.equals(WAP_3G) || netMode.equals(UNIWAP))) {
                    Log4Util.i("SDK_DEVICE", "The current network of type ,China Mobile or China Unicom wap");
                    return 4;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 6;
        }
        return 6;
    }

    public static DeviceListener.APN checkNetworkAPNType(Context mContext) {
        DeviceListener.APN apn = DeviceListener.APN.UNKNOWN;
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
            NetworkInfo mobNetInfoActivity = connectivityManager.getActiveNetworkInfo();
            if (mobNetInfoActivity.getType() == 1) {
                apn = DeviceListener.APN.WIFI;
            } else if (mobNetInfoActivity.getType() == 0) {
                apn = CheckApnTypeUtils._checkNetworkType(mobNetInfoActivity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            apn = DeviceListener.APN.UNKNOWN;
        }
        return apn;
    }

    public static boolean isChinaMobileUnicomWap(Context mContext) {
        return CheckApnTypeUtils.checkNetworkAPNType(mContext) == DeviceListener.APN.WOWAP && (CheckApnTypeUtils.checkNetworkType(mContext) == 4 || CheckApnTypeUtils.checkNetworkType(mContext) == 5);
    }

    public static boolean _isChinaMobileUnicomWap(Context context) {
        int mobileNetWorkType = CheckApnTypeUtils.getMobileNetWorkType(context);
        return mobileNetWorkType == 5 || mobileNetWorkType == 2 || mobileNetWorkType == 3;
    }

    public static int getMobileNetWorkType(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return -1;
        }
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo == null) {
            return -1;
        }
        if (networkInfo.getType() == 1) {
            return 0;
        }
        if (networkInfo.getExtraInfo() != null) {
            if (networkInfo.getExtraInfo().equalsIgnoreCase("uninet")) {
                return 1;
            }
            if (networkInfo.getExtraInfo().equalsIgnoreCase(UNIWAP)) {
                return 2;
            }
            if (networkInfo.getExtraInfo().equalsIgnoreCase(WAP_3G)) {
                return 3;
            }
            if (networkInfo.getExtraInfo().equalsIgnoreCase("3gnet")) {
                return 4;
            }
            if (networkInfo.getExtraInfo().equalsIgnoreCase(CMWAP)) {
                return 5;
            }
            if (networkInfo.getExtraInfo().equalsIgnoreCase("cmnet")) {
                return 6;
            }
            if (networkInfo.getExtraInfo().equalsIgnoreCase(CTWAP)) {
                return 7;
            }
            if (networkInfo.getExtraInfo().equalsIgnoreCase("ctnet")) {
                return 8;
            }
            if (networkInfo.getExtraInfo().equalsIgnoreCase("LTE")) {
                return 10;
            }
        }
        return 9;
    }

    private static DeviceListener.APN _checkNetworkType(NetworkInfo info) {
        try {
            if (info != null && info.isAvailable() && info.getState() == NetworkInfo.State.CONNECTED) {
                switch (info.getType()) {
                    case 1: {
                        return DeviceListener.APN.WIFI;
                    }
                    case 0: {
                        switch (info.getSubtype()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 7: {
                                return DeviceListener.APN.WOWAP;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 12: {
                                return DeviceListener.APN.WONET;
                            }
                            case 0: {
                                return DeviceListener.APN.UNKNOWN;
                            }
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return DeviceListener.APN.INTERNET;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return DeviceListener.APN.UNKNOWN;
        }
        return DeviceListener.APN.UNKNOWN;
    }

    public static HttpHost getHttpHost() {
        HttpHost proxy = null;
        Cursor mCursor = null;
        if (null != mContext) {
            mCursor = mContext.getContentResolver().query(PREFERRED_APN_URI, null, null, null, null);
        }
        if (mCursor != null && mCursor.moveToFirst()) {
            String proxyStr = mCursor.getString(mCursor.getColumnIndex("proxy"));
            if (proxyStr != null && proxyStr.trim().length() > 0) {
                proxy = new HttpHost(proxyStr, 80);
            }
            mCursor.close();
        }
        return proxy;
    }

    static {
        PREFERRED_APN_URI = Uri.parse((String)"content://telephony/carriers/preferapn");
    }
}

