/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.util;

import android.os.Handler;
import android.os.Looper;
import com.hisun.phone.core.voice.util.CallCommandHandler;
import com.hisun.phone.core.voice.util.Log4Util;

public final class CallCommandHandlerImpl
extends Thread
implements CallCommandHandler {
    private Looper looper;
    private Handler callHandler;

    CallCommandHandlerImpl() {
        this.start();
    }

    @Override
    public void destroy() {
        try {
            if (this.looper != null) {
                this.looper.quit();
            }
            this.callHandler = null;
            this.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void postCommand(Runnable command) {
        if (this.callHandler != null && CallCommandHandlerImpl.currentThread().isAlive()) {
            this.callHandler.post(command);
            Log4Util.d("SDK_DEVICE", "[CallCommandHandlerImpl - postCommand] post command finish.");
        }
    }

    public void postCommand(Runnable command, long delay) {
        if (this.callHandler != null && CallCommandHandlerImpl.currentThread().isAlive()) {
            this.callHandler.postDelayed(command, delay);
            Log4Util.d("SDK_DEVICE", "[CallCommandHandlerImpl - postCommand] post command finish.");
        }
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setName("CallCommandHandlerImpl");
            Log4Util.d("SDK_DEVICE", "[CallCommandHandlerImpl - run] thread already running: " + Thread.currentThread().getName());
            Looper.prepare();
            this.looper = Looper.myLooper();
            this.callHandler = new Handler();
            Looper.loop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.destroy();
            Log4Util.d("SDK_DEVICE", "CallCommandHandlerImpl thread was destroyed.");
        }
    }

    @Override
    public Handler getCommandHandler() {
        if (this.callHandler == null) {
            Log4Util.e("SDK_DEVICE", "[CallCommandHandlerImpl - getCommandHandler] can't get command handler, it's null, recreate it?");
        }
        return this.callHandler;
    }
}

