/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.sound;

import com.hisun.phone.core.voice.sound.PlayManager;
import com.hisun.phone.core.voice.sound.SoundPool;
import com.hisun.phone.core.voice.util.Log4Util;
import java.io.File;
import java.util.Queue;

public class SoundPoolLoadThread
extends Thread {
    private final Queue<SoundPool.LoadRequest> loadQueue;
    private final SoundPool.Listener listener;

    SoundPoolLoadThread(Queue<SoundPool.LoadRequest> loadQueue, SoundPool.Listener listener) {
        this.loadQueue = loadQueue;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            SoundPool.LoadRequest req = null;
            Queue<SoundPool.LoadRequest> queue = this.loadQueue;
            synchronized (queue) {
                req = this.loadQueue.poll();
            }
            if (req == null) break;
            try {
                boolean success = false;
                String path = null;
                if (req.path != null && req.path.trim().length() > 0) {
                    success = PlayManager.isExistFile(req.path);
                    path = req.path;
                } else {
                    success = PlayManager.saveAudioFile(req.context, req.resName);
                    path = PlayManager.getAudioFilePath(req.context, req.resName);
                }
                if (success) {
                    req.sound.state = SoundPool.Sound.State.READY;
                    req.sound.path = path;
                    File file = new File(path);
                    if (file.exists() && file.length() > 0L) {
                        if (this.listener != null) {
                            this.listener.onLoadComplete(req.sound.soundId);
                        }
                    } else if (this.listener != null) {
                        this.listener.onLoadFailed(req.sound.soundId);
                    }
                } else {
                    req.sound.state = SoundPool.Sound.State.FAILED;
                    req.sound.path = null;
                    if (this.listener != null) {
                        this.listener.onLoadFailed(req.sound.soundId);
                    }
                }
                Log4Util.d("[XSoundPoolLoadThread] load finish " + (Object)((Object)req.sound.state));
            }
            catch (Exception e) {
                Log4Util.e("Failed to load sound with ID " + req.resName + ": " + e.getMessage());
                req.sound.state = SoundPool.Sound.State.FAILED;
                if (this.listener == null) continue;
                this.listener.onLoadFailed(req.sound.soundId);
            }
        }
    }
}

