/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.sound;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Vibrator;
import android.text.TextUtils;
import com.hisun.phone.core.voice.CallControlManager;
import com.hisun.phone.core.voice.multimedia.MediaManager;
import com.hisun.phone.core.voice.sound.SoundPool;
import com.hisun.phone.core.voice.util.AdaptationTools;
import com.hisun.phone.core.voice.util.Log4Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PlayManager {
    private static final String EXTNAME = ".ogg";
    AudioManager manager = null;
    private MediaPlayer mMediaPlayer = null;
    private SoundPool.Listener listener = null;
    private SoundPool.Sound xSound = null;
    private Context context;
    private Handler mHandler;
    private boolean openspeaker;
    private static final long DURATIME = 60000L;
    private Runnable run = new Runnable(){

        @Override
        public void run() {
            PlayManager.this.reset();
        }
    };
    private Vibrator vi = null;

    public PlayManager(Context context) {
        this.context = context;
        this.mHandler = CallControlManager.initialize(context).getServiceHandler();
        this.manager = (AudioManager)context.getSystemService("audio");
        if (this.manager != null) {
            this.openspeaker = this.manager.isSpeakerphoneOn();
        }
    }

    public void playMedia(boolean loop, final long duration, boolean vibrate, SoundPool.Sound sound, SoundPool.Listener ener) {
        this.listener = ener;
        this.xSound = sound;
        int streamType = 0;
        if (sound.path == null || sound.path.trim().length() <= 0) {
            return;
        }
        try {
            Log4Util.d("[PlayManager] playMedia duration " + duration + "ms  " + sound.path);
            Uri defalultUri = null;
            Log4Util.d("SDK_DEVICE", "Sound file :" + PlayManager.getAudioFilePath(this.context, MediaManager.StockSound.INCOMING.getResName()));
            String audioFilePath = PlayManager.getAudioFilePath(this.context, MediaManager.StockSound.INCOMING.getResName());
            if (!sound.path.endsWith(audioFilePath)) {
                if (!AdaptationTools.DeviceIsMi108()) {
                    this.closeSpeaker(this.manager);
                }
            } else {
                streamType = 2;
                defalultUri = RingtoneManager.getDefaultUri((int)1);
                this.openSpeaker(this.manager);
            }
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
                this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    public void onPrepared(MediaPlayer mp) {
                        mp.start();
                        long d = duration;
                        if (d <= 0L) {
                            d = 60000L;
                        }
                        PlayManager.this.mHandler.postDelayed(PlayManager.this.run, d);
                    }
                });
                this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        PlayManager.this.reset();
                    }
                });
                float streamMaxVolume = this.manager.getStreamMaxVolume(2);
                float streamVolume = this.manager.getStreamVolume(2);
                this.mMediaPlayer.setScreenOnWhilePlaying(true);
                this.mMediaPlayer.setVolume(streamVolume / streamMaxVolume, streamVolume / streamMaxVolume);
            }
            this.mMediaPlayer.reset();
            this.mMediaPlayer.setAudioStreamType(streamType);
            if (defalultUri != null) {
                this.mMediaPlayer.setDataSource(this.context, defalultUri);
                if (this.isVibrate()) {
                    this.startVibrate(duration);
                }
            } else {
                this.mMediaPlayer.setDataSource(sound.path);
            }
            this.mMediaPlayer.setLooping(loop);
            this.mMediaPlayer.prepare();
        }
        catch (Exception e) {
            this.resetAudio();
            e.printStackTrace();
        }
    }

    private void closeSpeaker(AudioManager audioManager) {
        try {
            if (audioManager != null) {
                audioManager.setMode(2);
                if (audioManager.isSpeakerphoneOn()) {
                    audioManager.setSpeakerphoneOn(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reset() {
        this.resetAudio();
        this.stopMedia();
        this.stopVibrate();
        if (this.listener != null && this.xSound != null) {
            this.listener.onPlayComplete(this.xSound.soundId);
            this.xSound = null;
        }
    }

    public void stopMedia() {
        Log4Util.d("[PlayManager]: media stop!");
        this.stopVibrate();
        try {
            if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.release();
                this.mMediaPlayer = null;
            }
            this.resetAudio();
            if (this.mHandler != null) {
                this.mHandler.removeCallbacks(this.run);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public boolean isPlaying() {
        return this.mMediaPlayer != null && this.mMediaPlayer.isPlaying();
    }

    public boolean isVibrate() {
        int ringerMode = this.manager.getRingerMode();
        return ringerMode == 1;
    }

    public static void playOgg(Context context, String path) {
        Uri soundUri = Uri.parse((String)path);
        if (soundUri != null) {
            Ringtone sfx = RingtoneManager.getRingtone((Context)context, (Uri)soundUri);
            if (sfx != null) {
                sfx.setStreamType(1);
                sfx.play();
            } else {
                Log4Util.d("playSounds: failed to load ringtone from uri: " + soundUri);
            }
        } else {
            Log4Util.d("playSounds: could not parse Uri: " + soundUri);
        }
    }

    public static boolean saveAudioFile(Context context, String filename) throws IOException {
        String path = PlayManager.getAudioFilePath(context, filename);
        File file = new File(path);
        if (!file.exists() || file.length() <= 0L) {
            try {
                return PlayManager.createAudioFile(context, file.getName(), file.getName());
            }
            catch (Exception e) {
                throw new IOException("save filename IOException");
            }
        }
        return true;
    }

    public static String getAudioFilePath(Context context, String filename) {
        return context.getFilesDir() + "/" + filename + EXTNAME;
    }

    public static boolean isExistFile(String path) {
        File file = new File(path);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createAudioFile(Context context, String filename, String path) throws IOException {
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        boolean success = false;
        byte[] buffer = new byte[1024];
        int size = -1;
        try {
            fos = context.openFileOutput(path, 1);
            InputStream inStream = context.getAssets().open(filename);
            if (inStream != null) {
                bis = new BufferedInputStream(inStream);
                while ((size = bis.read(buffer)) != -1) {
                    fos.write(buffer, 0, size);
                }
                success = true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IOException("filename not found!!");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("filename write IOException!!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return success;
    }

    private void openSpeaker(AudioManager audioManager) {
        try {
            if (audioManager != null) {
                audioManager.setMode(0);
                if (!audioManager.isSpeakerphoneOn()) {
                    audioManager.setSpeakerphoneOn(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetAudio() {
        if (this.manager != null) {
            if (!TextUtils.isEmpty((CharSequence)Build.MANUFACTURER) && Build.MANUFACTURER.toLowerCase().indexOf("XINWEI".toLowerCase()) >= 0) {
                this.manager.setSpeakerphoneOn(this.openspeaker);
                return;
            }
            this.manager.setMode(0);
            this.manager.setSpeakerphoneOn(this.openspeaker);
        }
    }

    public void startVibrate(long duration) {
        if (this.vi == null) {
            this.vi = (Vibrator)this.context.getSystemService("vibrator");
        }
        long[] pattern = new long[]{1000L, 1000L, 1000L, 1000L};
        this.vi.vibrate(pattern, 0);
    }

    public void stopVibrate() {
        if (this.vi != null) {
            this.vi.cancel();
            this.vi = null;
        }
    }
}

