/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.net;

import android.text.TextUtils;
import com.hisun.phone.core.voice.exception.CCPXmlParserException;
import com.hisun.phone.core.voice.model.Response;
import com.hisun.phone.core.voice.model.UploadImessage;
import com.hisun.phone.core.voice.model.call.CallBackState;
import com.hisun.phone.core.voice.model.chatroom.ChatRoomList;
import com.hisun.phone.core.voice.model.chatroom.ChatRoomMemberList;
import com.hisun.phone.core.voice.model.chatroom.Chatroom;
import com.hisun.phone.core.voice.model.chatroom.ChatroomDismissMsg;
import com.hisun.phone.core.voice.model.chatroom.ChatroomExitMsg;
import com.hisun.phone.core.voice.model.chatroom.ChatroomJoinMsg;
import com.hisun.phone.core.voice.model.chatroom.ChatroomMember;
import com.hisun.phone.core.voice.model.chatroom.ChatroomMemberForbidOpt;
import com.hisun.phone.core.voice.model.chatroom.ChatroomMsg;
import com.hisun.phone.core.voice.model.chatroom.ChatroomRemoveMemberMsg;
import com.hisun.phone.core.voice.model.im.IMAttachedMsg;
import com.hisun.phone.core.voice.model.im.IMCooperMsg;
import com.hisun.phone.core.voice.model.im.IMDismissGroupMsg;
import com.hisun.phone.core.voice.model.im.IMInviterJoinGroupReplyMsg;
import com.hisun.phone.core.voice.model.im.IMInviterMsg;
import com.hisun.phone.core.voice.model.im.IMJoinGroupMsg;
import com.hisun.phone.core.voice.model.im.IMProposerMsg;
import com.hisun.phone.core.voice.model.im.IMQuitGroupMsg;
import com.hisun.phone.core.voice.model.im.IMRemoveMemeberMsg;
import com.hisun.phone.core.voice.model.im.IMReplyJoinGroupMsg;
import com.hisun.phone.core.voice.model.im.IMTextMsg;
import com.hisun.phone.core.voice.model.im.NewMediaMsgList;
import com.hisun.phone.core.voice.model.interphone.InterphoneControlMic;
import com.hisun.phone.core.voice.model.interphone.InterphoneControlMicMsg;
import com.hisun.phone.core.voice.model.interphone.InterphoneExitMsg;
import com.hisun.phone.core.voice.model.interphone.InterphoneInviteMsg;
import com.hisun.phone.core.voice.model.interphone.InterphoneJoinMsg;
import com.hisun.phone.core.voice.model.interphone.InterphoneMember;
import com.hisun.phone.core.voice.model.interphone.InterphoneMemberList;
import com.hisun.phone.core.voice.model.interphone.InterphoneMsg;
import com.hisun.phone.core.voice.model.interphone.InterphoneOverMsg;
import com.hisun.phone.core.voice.model.interphone.InterphoneReleaseMicMsg;
import com.hisun.phone.core.voice.model.setup.SoftSwitch;
import com.hisun.phone.core.voice.model.setup.SubAccount;
import com.hisun.phone.core.voice.model.videoconference.VideoConference;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceDismissMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceExitMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceJoinMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceList;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceMember;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceMemberList;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceRemoveMemberMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceSwitch;
import com.hisun.phone.core.voice.model.videoconference.VideoPartnerPortrait;
import com.hisun.phone.core.voice.model.videoconference.VideoPartnerPortraitList;
import com.hisun.phone.core.voice.util.VoiceUtil;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class ApiParser {
    public static final int KEY_SOFTSWITCH_ADDRESS = 980100;
    public static final int KEY_NETWORK_CALLBACK = 980101;
    public static final int KEY_SUBACCOUNT = 980102;
    public static final int KEY_PARSER_STATUSCODE = 980106;
    public static final int KEY_MESSAGE_ARRIVED = 980107;
    public static final int KEY_STARTINTERPHONE = 980108;
    public static final int KEY_CONTROLMIC = 980109;
    public static final int KEY_RELEASEMIC = 980110;
    public static final int KEY_INTERPHONE_MEMBER_LIST = 980111;
    public static final int KEY_STARTCHATROOM = 980112;
    public static final int KEY_QUERY_CHATROOM_LIST = 980113;
    public static final int KEY_INVITE_CHATROOM = 980114;
    public static final int KEY_CHATROOM_MEMBER_LIST = 980115;
    public static final int KEY_SEND_MEIDAMSG = 980116;
    public static final int KEY_MEDIAMSG_INFO = 980117;
    public static final int KEY_TEXT_MESSAGE_ARRIVED = 980118;
    public static final int KEY_DISMISS_CHATROOM = 980119;
    public static final int KEY_REMOVE_MEMBER_CHATROOM = 980120;
    public static final int KEY_DISMISS_VIDEOCONFENERCE = 980121;
    public static final int KEY_REMOVE_MEMBER_VIDEOCONFENERCE = 980122;
    public static final int KEY_SWITCH_VIDEOCONFENERCE = 980123;
    public static final int KEY_START_VIDEOCONFENERCE = 980124;
    public static final int KEY_QUERY_VIDEOCONFENERCE_LIST = 980125;
    public static final int KEY_INVITE_VIDEOCONFENERCE = 980126;
    public static final int KEY_VIDEOCONFENERCE_MEMBER_LIST = 980127;
    public static final int KEY_VIDEOCONFENERCE_PORTRAIT = 980128;
    public static final int KEY_NETWORK_GROUPID = 980129;
    public static final int KEY_CHATROOM_SPEAK_OPREATE = 980130;
    public static final int KEY_REQUEST_DEFAULT = 980131;
    private static int VAR_INTERPHONE_INVITE = 201;
    private static int VAR_INTERPHONE_JOIN = 202;
    private static int VAR_INTERPHONE_EXIT = 203;
    private static int VAR_INTERPHONE_OVER = 204;
    private static int VAR_INTERPHONE_CONTROL_MIC = 205;
    private static int VAR_INTERPHONE_RELEASE_MIC = 206;
    private static int VAR_CHATROOM_JOIN = 301;
    private static int VAR_CHATROOM_EXIT = 302;
    private static int VAR_CHATROOM_DISMISS = 303;
    private static int VAR_CHATROOM_REMOVEMEMBER = 304;
    private static int VAR_CHATROOM_SPEAK_OPT = 305;
    private static int VAR_APPLY_JOIN_GROUP_MSG = 401;
    private static int VAR_ACCEPT_OR_REJECT_JOIN_GROUP_MSG = 402;
    private static int VAR_INVITE_JOIN_GROUP_MSG = 403;
    private static int VAR_DELETE_FROM_GROUP_MSG = 404;
    private static int VAR_EXIT_FROM_GROUP_MSG = 405;
    private static int VAR_DELETE_GROUP_MSG = 406;
    private static int VAR_INVITE_JOIN_GROUP_UNVALIDATION_MSG = 407;
    private static int VAR_REPLY_GROUP_APPLY = 408;
    private static int VAR_RECEIVE_INSTANCE_MSG = 501;
    private static int VAR_RECEIVE_INSTANCE_MSG_JJ = 901;
    private static int VAR_VIDEO_CONFERENCE_JOIN = 601;
    private static int VAR_VIDEO_CONFERENCE_EXIT = 602;
    private static int VAR_VIDEO_CONFERENCE_DISMISS = 603;
    private static int VAR_VIDEO_CONFERENCE_REMOVEMEMBER = 604;
    private static int VAR_VIDEO_CONFERENCE_SWITCH = 605;

    private ApiParser() {
    }

    public static Response doParser(int parseType, InputStream is) throws CCPXmlParserException {
        if (is == null) {
            throw new IllegalArgumentException("resource is null.");
        }
        XmlPullParser xmlParser = null;
        Response response = null;
        try {
            xmlParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlParser.setInput(is, null);
            xmlParser.nextTag();
            String rootName = xmlParser.getName();
            if (!ApiParser.isRootNode(rootName)) {
                throw new IllegalArgumentException("xml root node is invalid.");
            }
            if (parseType == 980107) {
                int var = ApiParser.parseReceiveMsgVar(xmlParser);
                response = ApiParser.getResponseByVar(var);
                ApiParser.parseReceiveMsg(xmlParser, response, var);
            } else {
                response = ApiParser.getResponseByKey(parseType);
                xmlParser.require(2, null, rootName);
                while (xmlParser.nextTag() != 3) {
                    String text;
                    String tagName = xmlParser.getName();
                    if (tagName != null && (tagName.equals("statusCode") || tagName.equals("statuscode"))) {
                        response.statusCode = text = xmlParser.nextText();
                        continue;
                    }
                    if (tagName != null && tagName.equals("statusMsg")) {
                        response.statusMsg = text = xmlParser.nextText();
                        continue;
                    }
                    if (parseType == 980100) {
                        ApiParser.parseSoftSwitchBody(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980129) {
                        ApiParser.parseNetworkGroupId(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980101) {
                        ApiParser.parseCallBackBody(xmlParser, (CallBackState)response);
                        continue;
                    }
                    if (parseType == 980102) {
                        ApiParser.parseSubAccountBody(xmlParser, (SubAccount)response);
                        continue;
                    }
                    if (parseType == 980108) {
                        ApiParser.parseStartInterPhone(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980109) {
                        ApiParser.parseControlMIC(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980111) {
                        ApiParser.parseInterPhoneMemberList(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980112) {
                        ApiParser.parseStartChatRoom(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980115) {
                        ApiParser.parseChatRoomMemberList(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980113) {
                        ApiParser.parseChatRoomList(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980116) {
                        ApiParser.parseMultiMedia(xmlParser, (UploadImessage)response);
                        continue;
                    }
                    if (parseType == 980117) {
                        ApiParser.parseReceiveMediaMsgList(xmlParser, (NewMediaMsgList)response);
                        continue;
                    }
                    if (parseType == 980118) {
                        ApiParser.parseReceiveGroupMessage(xmlParser, (IMTextMsg)response);
                        continue;
                    }
                    if (parseType == 980124) {
                        ApiParser.parseStartVideoConference(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980127) {
                        ApiParser.parseVideoConferenceMemberList(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980125) {
                        ApiParser.parseVideoConferenceList(xmlParser, response);
                        continue;
                    }
                    if (parseType == 980128) {
                        ApiParser.parseVideoConferencePortraitList(xmlParser, response);
                        continue;
                    }
                    xmlParser.nextText();
                }
                xmlParser.require(3, null, rootName);
                xmlParser.next();
                xmlParser.require(1, null, null);
            }
            ApiParser.print(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (response != null) {
                response.released();
                response = null;
            }
            throw new CCPXmlParserException("ApiParser.doParser parse xml occur errors:" + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    is = null;
                }
            }
            xmlParser = null;
        }
        return response;
    }

    private static void parseNetworkGroupId(XmlPullParser xmlParser, Response response) throws XmlPullParserException, IOException, Exception {
        while (xmlParser.nextTag() != 3) {
            String tagName = xmlParser.getName();
            SoftSwitch ss = (SoftSwitch)response;
            if (tagName.equals("nwgid")) {
                String text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                ss.setNetworkGroupId(text.trim());
                continue;
            }
            xmlParser.nextText();
        }
    }

    private static Response getResponseByKey(int key) {
        if (key == 980101) {
            return new CallBackState();
        }
        if (key == 980102) {
            return new SubAccount();
        }
        if (key == 980108) {
            return new InterphoneMsg();
        }
        if (key == 980111) {
            return new InterphoneMemberList();
        }
        if (key == 980109) {
            return new InterphoneControlMic();
        }
        if (key == 980100 || key == 980129) {
            return new SoftSwitch();
        }
        if (key == 980112) {
            return new ChatroomMsg();
        }
        if (key == 980115) {
            return new ChatRoomMemberList();
        }
        if (key == 980113) {
            return new ChatRoomList();
        }
        if (key == 980116) {
            return new UploadImessage();
        }
        if (key == 980117) {
            return new NewMediaMsgList();
        }
        if (key == 980118) {
            return new IMTextMsg();
        }
        if (key == 980124) {
            return new VideoConferenceMsg();
        }
        if (key == 980127) {
            return new VideoConferenceMemberList();
        }
        if (key == 980125) {
            return new VideoConferenceList();
        }
        if (key == 980128) {
            return new VideoPartnerPortraitList();
        }
        return new Response();
    }

    private static Response getResponseByVar(int key) {
        if (key == VAR_INTERPHONE_INVITE) {
            return new InterphoneInviteMsg();
        }
        if (key == VAR_INTERPHONE_JOIN) {
            return new InterphoneJoinMsg();
        }
        if (key == VAR_INTERPHONE_EXIT) {
            return new InterphoneExitMsg();
        }
        if (key == VAR_INTERPHONE_OVER) {
            return new InterphoneOverMsg();
        }
        if (key == VAR_INTERPHONE_CONTROL_MIC) {
            return new InterphoneControlMicMsg();
        }
        if (key == VAR_INTERPHONE_RELEASE_MIC) {
            return new InterphoneReleaseMicMsg();
        }
        if (key == VAR_CHATROOM_JOIN) {
            return new ChatroomJoinMsg();
        }
        if (key == VAR_CHATROOM_EXIT) {
            return new ChatroomExitMsg();
        }
        if (key == VAR_CHATROOM_DISMISS) {
            return new ChatroomDismissMsg();
        }
        if (key == VAR_CHATROOM_REMOVEMEMBER) {
            return new ChatroomRemoveMemberMsg();
        }
        if (key == VAR_CHATROOM_SPEAK_OPT) {
            return new ChatroomMemberForbidOpt();
        }
        if (key == VAR_APPLY_JOIN_GROUP_MSG) {
            return new IMProposerMsg();
        }
        if (key == VAR_ACCEPT_OR_REJECT_JOIN_GROUP_MSG) {
            return new IMReplyJoinGroupMsg();
        }
        if (key == VAR_REPLY_GROUP_APPLY) {
            return new IMInviterJoinGroupReplyMsg();
        }
        if (key == VAR_INVITE_JOIN_GROUP_MSG) {
            return new IMInviterMsg();
        }
        if (key == VAR_DELETE_FROM_GROUP_MSG) {
            return new IMRemoveMemeberMsg();
        }
        if (key == VAR_EXIT_FROM_GROUP_MSG) {
            return new IMQuitGroupMsg();
        }
        if (key == VAR_DELETE_GROUP_MSG) {
            return new IMDismissGroupMsg();
        }
        if (key == VAR_INVITE_JOIN_GROUP_UNVALIDATION_MSG) {
            return new IMJoinGroupMsg();
        }
        if (key == VAR_RECEIVE_INSTANCE_MSG) {
            return new IMAttachedMsg();
        }
        if (key == VAR_RECEIVE_INSTANCE_MSG_JJ) {
            return new IMCooperMsg();
        }
        if (key == VAR_VIDEO_CONFERENCE_JOIN) {
            return new VideoConferenceJoinMsg();
        }
        if (key == VAR_VIDEO_CONFERENCE_EXIT) {
            return new VideoConferenceExitMsg();
        }
        if (key == VAR_VIDEO_CONFERENCE_DISMISS) {
            return new VideoConferenceDismissMsg();
        }
        if (key == VAR_VIDEO_CONFERENCE_REMOVEMEMBER) {
            return new VideoConferenceRemoveMemberMsg();
        }
        if (key == VAR_VIDEO_CONFERENCE_SWITCH) {
            return new VideoConferenceSwitch();
        }
        return new Response();
    }

    private static void print(Response r) {
        if (r != null) {
            r.print();
        }
    }

    private static boolean isRootNode(String rootName) {
        return rootName != null && (rootName.equalsIgnoreCase("Response") || rootName.equalsIgnoreCase("VoiceMessage") || rootName.equalsIgnoreCase("InstanceMessage"));
    }

    private static void parseCallBackBody(XmlPullParser xmlParser, CallBackState response) throws Exception {
        while (xmlParser.nextTag() != 3) {
            String text;
            String tagName = xmlParser.getName();
            if (tagName.equals("callSid")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.callSid = text;
                continue;
            }
            if (tagName.equals("dateCreated")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.dateCreated = text;
                continue;
            }
            xmlParser.nextText();
        }
    }

    private static void parseSoftSwitchBody(XmlPullParser xmlParser, Response response) throws Exception {
        while (xmlParser.nextTag() != 3) {
            String text;
            String tagName = xmlParser.getName();
            SoftSwitch ss = (SoftSwitch)response;
            if (!TextUtils.isEmpty((CharSequence)tagName) && "clpss".equals(tagName.toLowerCase())) {
                SoftSwitch.Clpss clpss = new SoftSwitch.Clpss();
                while (xmlParser.nextTag() != 3) {
                    ApiParser.parseSoftSwitchClpssBody(xmlParser, clpss);
                }
                ss.addSoftClpsses(clpss);
                continue;
            }
            if (tagName.equals("p2p")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                ss.setP2PServerPort(text.trim());
                continue;
            }
            if (tagName.equals("control")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                ss.setControl(text.trim());
                continue;
            }
            if (tagName.equals("nwgid")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                ss.setNetworkGroupId(text.trim());
                continue;
            }
            xmlParser.nextText();
        }
    }

    private static void parseSoftSwitchClpssBody(XmlPullParser xmlParser, SoftSwitch.Clpss clpss) throws Exception {
        String tagName = xmlParser.getName();
        if (tagName.equals("ip")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                clpss.setIp(text);
            }
        } else if (tagName.equals("port")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                clpss.setPort(text);
            }
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseSubAccountBody(XmlPullParser xmlParser, SubAccount response) throws Exception {
        while (xmlParser.nextTag() != 3) {
            String text;
            String tagName = xmlParser.getName();
            if (tagName.equals("subAccountSid")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.accountSid = text.trim();
                continue;
            }
            if (tagName.equals("appId")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.appId = text.trim();
                continue;
            }
            if (tagName.equals("subToken")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.authToken = text.trim();
                continue;
            }
            if (tagName.equals("dateCreated")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.dateCreated = text.trim();
                continue;
            }
            if (tagName.equals("friendlyName")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.friendlyName = text.trim();
                continue;
            }
            if (tagName.equals("parentAccountSid")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.parentAccountSid = text.trim();
                continue;
            }
            if (tagName.equals("voipAccount")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.sipCode = text.trim();
                continue;
            }
            if (tagName.equals("voipPwd")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.sipPwd = text.trim();
                continue;
            }
            if (tagName.equals("status")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.status = text.trim();
                continue;
            }
            if (tagName.equals("type")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.type = text.trim();
                continue;
            }
            if (tagName.equals("uri")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.uri = text.trim();
                continue;
            }
            if (tagName.equals("SubresourceUris")) {
                xmlParser.require(2, null, "SubresourceUris");
                while (xmlParser.nextTag() != 3) {
                    tagName = xmlParser.getName();
                    if (tagName.equals("calls")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        SubAccount.SubresourceUris.calls = text.trim();
                        continue;
                    }
                    if (tagName.equals("conferences")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        SubAccount.SubresourceUris.conferences = text.trim();
                        continue;
                    }
                    if (!tagName.equals("smsMessages") || (text = xmlParser.nextText()) == null || text.equals("")) continue;
                    SubAccount.SubresourceUris.smsMessages = text.trim();
                }
                xmlParser.require(3, null, "SubresourceUris");
                continue;
            }
            xmlParser.nextText();
        }
    }

    private static void parseStartInterPhone(XmlPullParser xmlParser, Response response) throws Exception {
        String tagName = xmlParser.getName();
        InterphoneMsg interphone = (InterphoneMsg)response;
        if (tagName != null && tagName.equals("interphoneId")) {
            String text;
            interphone.interphoneId = text = xmlParser.nextText();
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseControlMIC(XmlPullParser xmlParser, Response response) throws Exception {
        InterphoneControlMic mic = (InterphoneControlMic)response;
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("voipAccount")) {
            String text;
            mic.speaker = text = xmlParser.nextText();
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseInterPhoneMemberList(XmlPullParser xmlParser, Response response) throws Exception {
        InterphoneMemberList list = (InterphoneMemberList)response;
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("count")) {
            String text;
            list.count = text = xmlParser.nextText();
        } else if (tagName != null && tagName.equals("member")) {
            InterphoneMember member = new InterphoneMember();
            while (xmlParser.next() != 3) {
                String text;
                tagName = xmlParser.getName();
                if (tagName != null && tagName.equals("voipAccount")) {
                    member.voipId = text = xmlParser.nextText();
                    continue;
                }
                if (tagName != null && tagName.equals("type")) {
                    member.type = text = xmlParser.nextText();
                    continue;
                }
                if (tagName != null && tagName.equals("online")) {
                    member.online = text = xmlParser.nextText();
                    continue;
                }
                if (tagName != null && tagName.equals("mic")) {
                    member.mic = text = xmlParser.nextText();
                    continue;
                }
                xmlParser.nextText();
            }
            list.interphoneMemberList.add(member);
        }
    }

    private static void parseStartChatRoom(XmlPullParser xmlParser, Response response) throws Exception {
        String tagName = xmlParser.getName();
        ChatroomMsg chatRoom = (ChatroomMsg)response;
        if (tagName != null && tagName.equals("roomId")) {
            String text = xmlParser.nextText();
            chatRoom.setRoomNo(text);
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseChatRoomMemberList(XmlPullParser xmlParser, Response response) throws Exception {
        ChatRoomMemberList list = (ChatRoomMemberList)response;
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("count")) {
            String text;
            list.count = text = xmlParser.nextText();
        } else if (tagName != null && tagName.equals("member")) {
            ChatroomMember member = new ChatroomMember();
            while (xmlParser.next() != 3) {
                String text;
                tagName = xmlParser.getName();
                if (tagName != null && tagName.equals("number")) {
                    text = xmlParser.nextText();
                    member.setNumber(text);
                    continue;
                }
                if (tagName != null && tagName.equals("type")) {
                    text = xmlParser.nextText();
                    member.setType(text);
                    continue;
                }
                if (tagName != null && tagName.equals("forbid")) {
                    ChatroomMsg.ForbidOptions options;
                    text = xmlParser.nextText();
                    if (TextUtils.isEmpty((CharSequence)text) || text.length() < 2) continue;
                    String listenOpt = text.substring(0, 1);
                    String speakOpt = text.substring(1, 2);
                    try {
                        options = new ChatroomMsg.ForbidOptions(Integer.parseInt(speakOpt), Integer.parseInt(listenOpt));
                    }
                    catch (NumberFormatException e) {
                        options = new ChatroomMsg.ForbidOptions(1, 1);
                    }
                    member.setOptions(options);
                    continue;
                }
                xmlParser.nextText();
            }
            list.chatRoomInfos.add(member);
        }
    }

    private static void parseChatRoomList(XmlPullParser xmlParser, Response response) throws Exception {
        ChatRoomList list = (ChatRoomList)response;
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("count")) {
            String text;
            list.count = text = xmlParser.nextText();
        } else if (tagName != null && tagName.equals("ChatRoom")) {
            Chatroom cRoomInfo = new Chatroom();
            while (xmlParser.next() != 3) {
                String text;
                tagName = xmlParser.getName();
                if (tagName != null && tagName.equals("roomId")) {
                    text = xmlParser.nextText();
                    cRoomInfo.setRoomNo(text);
                    continue;
                }
                if (tagName != null && tagName.equals("roomName")) {
                    text = xmlParser.nextText();
                    cRoomInfo.setRoomName(text);
                    continue;
                }
                if (tagName != null && tagName.equals("creator")) {
                    text = xmlParser.nextText();
                    cRoomInfo.setCreator(text);
                    continue;
                }
                if (tagName != null && tagName.equals("square")) {
                    text = xmlParser.nextText();
                    cRoomInfo.setSquare(text);
                    continue;
                }
                if (tagName != null && tagName.equals("joined")) {
                    text = xmlParser.nextText();
                    cRoomInfo.setJoined(text);
                    continue;
                }
                if (tagName != null && tagName.equals("validate")) {
                    text = xmlParser.nextText();
                    cRoomInfo.setValidate(text);
                    continue;
                }
                if (tagName != null && tagName.equals("keywords")) {
                    text = xmlParser.nextText();
                    cRoomInfo.setKeywords(text);
                    continue;
                }
                xmlParser.nextText();
            }
            list.chatroomInfos.add(cRoomInfo);
        }
    }

    private static int parseReceiveMsgVar(XmlPullParser xmlParser) throws Exception {
        int var = 0;
        String tagName = xmlParser.getName();
        if (tagName != null && (tagName.equals("VoiceMessage") || tagName.equals("InstanceMessage"))) {
            var = Integer.parseInt(xmlParser.getAttributeValue(null, "var"));
        }
        return var;
    }

    private static void parseReceiveMsg(XmlPullParser xmlParser, Response response, int var) throws Exception {
        String tagName = xmlParser.getName();
        if (tagName != null && (tagName.equals("VoiceMessage") || tagName.equals("InstanceMessage"))) {
            while (xmlParser.nextTag() != 3) {
                String text;
                Response msg;
                if (var == VAR_INTERPHONE_INVITE) {
                    tagName = xmlParser.getName();
                    msg = (InterphoneInviteMsg)response;
                    if (tagName != null && tagName.equals("interphoneId")) {
                        ((InterphoneInviteMsg)msg).interphoneId = text = xmlParser.nextText();
                        continue;
                    }
                    if (tagName != null && tagName.equals("dateCreated")) {
                        ((InterphoneInviteMsg)msg).dateCreated = text = xmlParser.nextText();
                        continue;
                    }
                    if (tagName != null && tagName.equals("from")) {
                        ((InterphoneInviteMsg)msg).from = text = xmlParser.nextText();
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_INTERPHONE_JOIN) {
                    tagName = xmlParser.getName();
                    msg = (InterphoneJoinMsg)response;
                    if (tagName != null && tagName.equals("interphoneId")) {
                        ((InterphoneJoinMsg)msg).interphoneId = text = xmlParser.nextText();
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        text = xmlParser.nextText();
                        if (text == null) continue;
                        ((InterphoneJoinMsg)msg).whos = text.split(",");
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_INTERPHONE_EXIT) {
                    tagName = xmlParser.getName();
                    msg = (InterphoneExitMsg)response;
                    if (tagName != null && tagName.equals("interphoneId")) {
                        ((InterphoneExitMsg)msg).interphoneId = text = xmlParser.nextText();
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        text = xmlParser.nextText();
                        if (text == null) continue;
                        ((InterphoneExitMsg)msg).whos = text.split(",");
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_INTERPHONE_OVER) {
                    tagName = xmlParser.getName();
                    msg = (InterphoneOverMsg)response;
                    if (tagName != null && tagName.equals("interphoneId")) {
                        ((InterphoneOverMsg)msg).interphoneId = text = xmlParser.nextText();
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_INTERPHONE_CONTROL_MIC) {
                    tagName = xmlParser.getName();
                    msg = (InterphoneControlMicMsg)response;
                    if (tagName != null && tagName.equals("interphoneId")) {
                        ((InterphoneControlMicMsg)msg).interphoneId = text = xmlParser.nextText();
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        ((InterphoneControlMicMsg)msg).who = text = xmlParser.nextText();
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_INTERPHONE_RELEASE_MIC) {
                    tagName = xmlParser.getName();
                    msg = (InterphoneReleaseMicMsg)response;
                    if (tagName != null && tagName.equals("interphoneId")) {
                        ((InterphoneReleaseMicMsg)msg).interphoneId = text = xmlParser.nextText();
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        ((InterphoneReleaseMicMsg)msg).who = text = xmlParser.nextText();
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_CHATROOM_JOIN) {
                    tagName = xmlParser.getName();
                    msg = (ChatroomJoinMsg)response;
                    if (tagName != null && tagName.equals("chatroomId")) {
                        text = xmlParser.nextText();
                        ((ChatroomMsg)msg).setRoomNo(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        text = xmlParser.nextText();
                        if (text == null) continue;
                        ((ChatroomJoinMsg)msg).setWhos(text.split(","));
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_CHATROOM_EXIT) {
                    tagName = xmlParser.getName();
                    msg = (ChatroomExitMsg)response;
                    if (tagName != null && tagName.equals("chatroomId")) {
                        text = xmlParser.nextText();
                        ((ChatroomMsg)msg).setRoomNo(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        text = xmlParser.nextText();
                        if (text == null) continue;
                        ((ChatroomExitMsg)msg).setWhos(text.split(","));
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_CHATROOM_DISMISS) {
                    tagName = xmlParser.getName();
                    msg = (ChatroomDismissMsg)response;
                    if (tagName != null && tagName.equals("chatroomId")) {
                        text = xmlParser.nextText();
                        ((ChatroomMsg)msg).setRoomNo(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_CHATROOM_REMOVEMEMBER) {
                    tagName = xmlParser.getName();
                    msg = (ChatroomRemoveMemberMsg)response;
                    if (tagName != null && tagName.equals("chatroomId")) {
                        text = xmlParser.nextText();
                        ((ChatroomMsg)msg).setRoomNo(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        text = xmlParser.nextText();
                        ((ChatroomRemoveMemberMsg)msg).setWho(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_CHATROOM_SPEAK_OPT) {
                    tagName = xmlParser.getName();
                    ChatroomMemberForbidOpt forbidOpt = (ChatroomMemberForbidOpt)response;
                    if (tagName != null && tagName.equals("roomId")) {
                        text = xmlParser.nextText();
                        forbidOpt.setRoomNo(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        text = xmlParser.nextText();
                        forbidOpt.setMember(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("forbid")) {
                        ChatroomMsg.ForbidOptions options;
                        text = xmlParser.nextText();
                        if (TextUtils.isEmpty((CharSequence)text) || text.length() < 2) continue;
                        String listenOpt = text.substring(0, 1);
                        String speakOpt = text.substring(1, 2);
                        try {
                            options = new ChatroomMsg.ForbidOptions(Integer.parseInt(speakOpt), Integer.parseInt(listenOpt));
                        }
                        catch (NumberFormatException e) {
                            options = new ChatroomMsg.ForbidOptions(1, 1);
                        }
                        forbidOpt.setOptions(options);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_APPLY_JOIN_GROUP_MSG || var == VAR_INVITE_JOIN_GROUP_UNVALIDATION_MSG) {
                    tagName = xmlParser.getName();
                    msg = null;
                    msg = var == VAR_APPLY_JOIN_GROUP_MSG ? (IMProposerMsg)response : (IMJoinGroupMsg)response;
                    if (tagName != null && tagName.equals("groupId")) {
                        text = xmlParser.nextText();
                        ((IMProposerMsg)msg).setGroupId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("proposer")) {
                        text = xmlParser.nextText();
                        ((IMProposerMsg)msg).setProposer(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("dateCreated")) {
                        text = xmlParser.nextText();
                        ((IMProposerMsg)msg).setDateCreated(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("declared")) {
                        text = xmlParser.nextText();
                        ((IMProposerMsg)msg).setDeclared(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_REPLY_GROUP_APPLY) {
                    tagName = xmlParser.getName();
                    msg = (IMInviterJoinGroupReplyMsg)response;
                    if (tagName != null && tagName.equals("groupId")) {
                        text = xmlParser.nextText();
                        ((IMInviterJoinGroupReplyMsg)msg).setGroupId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("declared")) {
                        text = xmlParser.nextText();
                        ((IMInviterJoinGroupReplyMsg)msg).setDeclared(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("inviter")) {
                        text = xmlParser.nextText();
                        ((IMInviterJoinGroupReplyMsg)msg).setAdmin(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("confirm")) {
                        text = xmlParser.nextText();
                        ((IMInviterJoinGroupReplyMsg)msg).setConfirm(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("member")) {
                        text = xmlParser.nextText();
                        ((IMInviterJoinGroupReplyMsg)msg).setMember(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_ACCEPT_OR_REJECT_JOIN_GROUP_MSG) {
                    tagName = xmlParser.getName();
                    msg = (IMReplyJoinGroupMsg)response;
                    if (tagName != null && tagName.equals("groupId")) {
                        text = xmlParser.nextText();
                        ((IMReplyJoinGroupMsg)msg).setGroupId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("admin")) {
                        text = xmlParser.nextText();
                        ((IMReplyJoinGroupMsg)msg).setAdmin(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("confirm")) {
                        text = xmlParser.nextText();
                        ((IMReplyJoinGroupMsg)msg).setConfirm(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("member")) {
                        text = xmlParser.nextText();
                        ((IMReplyJoinGroupMsg)msg).setMember(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_INVITE_JOIN_GROUP_MSG) {
                    tagName = xmlParser.getName();
                    msg = (IMInviterMsg)response;
                    if (tagName != null && tagName.equals("groupId")) {
                        text = xmlParser.nextText();
                        ((IMInviterMsg)msg).setGroupId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("admin")) {
                        text = xmlParser.nextText();
                        ((IMInviterMsg)msg).setAdmin(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("confirm")) {
                        text = xmlParser.nextText();
                        ((IMInviterMsg)msg).setConfirm(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("declared")) {
                        text = xmlParser.nextText();
                        ((IMInviterMsg)msg).setDeclared(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_DELETE_FROM_GROUP_MSG) {
                    tagName = xmlParser.getName();
                    msg = (IMRemoveMemeberMsg)response;
                    if (tagName != null && tagName.equals("groupId")) {
                        text = xmlParser.nextText();
                        ((IMRemoveMemeberMsg)msg).setGroupId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("member")) {
                        text = xmlParser.nextText();
                        ((IMRemoveMemeberMsg)msg).setWho(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_REPLY_GROUP_APPLY) continue;
                if (var == VAR_EXIT_FROM_GROUP_MSG) {
                    tagName = xmlParser.getName();
                    msg = (IMQuitGroupMsg)response;
                    if (tagName != null && tagName.equals("groupId")) {
                        text = xmlParser.nextText();
                        ((IMQuitGroupMsg)msg).setGroupId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("member")) {
                        text = xmlParser.nextText();
                        ((IMQuitGroupMsg)msg).setMember(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_DELETE_GROUP_MSG) {
                    tagName = xmlParser.getName();
                    msg = (IMDismissGroupMsg)response;
                    if (tagName != null && tagName.equals("groupId")) {
                        text = xmlParser.nextText();
                        ((IMDismissGroupMsg)msg).setGroupId(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_RECEIVE_INSTANCE_MSG || var == VAR_RECEIVE_INSTANCE_MSG_JJ) {
                    tagName = xmlParser.getName();
                    msg = null;
                    msg = var == VAR_RECEIVE_INSTANCE_MSG_JJ ? (IMCooperMsg)response : (IMAttachedMsg)response;
                    if (tagName != null && tagName.equals("msgId")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        ((IMAttachedMsg)msg).setMsgId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("dateCreated")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        ((IMAttachedMsg)msg).setDateCreated(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("message")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("") || var != VAR_RECEIVE_INSTANCE_MSG_JJ) continue;
                        ((IMCooperMsg)response).setMessage(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("sender")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        ((IMAttachedMsg)msg).setSender(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("receiver")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        ((IMAttachedMsg)msg).setReceiver(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("fileExt")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        ((IMAttachedMsg)msg).setExt(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("type")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        if (var == VAR_RECEIVE_INSTANCE_MSG_JJ) {
                            ((IMAttachedMsg)msg).setChunked(false);
                            ((IMCooperMsg)response).setType(Integer.parseInt(text));
                            continue;
                        }
                        ((IMAttachedMsg)msg).setChunked("1".equals(text));
                        continue;
                    }
                    if (tagName != null && tagName.equals("fileSize")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        ((IMAttachedMsg)msg).setFileSize(Integer.parseInt(text));
                        continue;
                    }
                    if (tagName != null && tagName.equals("fileUrl")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        ((IMAttachedMsg)msg).setFileUrl(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("userData")) {
                        text = xmlParser.nextText();
                        if (text == null || text.equals("")) continue;
                        ((IMAttachedMsg)msg).setUserData(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_VIDEO_CONFERENCE_JOIN) {
                    tagName = xmlParser.getName();
                    msg = (VideoConferenceJoinMsg)response;
                    if (tagName != null && tagName.equals("roomId")) {
                        text = xmlParser.nextText();
                        ((VideoConferenceMsg)msg).setConferenceId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        text = xmlParser.nextText();
                        if (text == null) continue;
                        ((VideoConferenceJoinMsg)msg).setWhos(text.split(","));
                        continue;
                    }
                    if (tagName != null && tagName.equals("videoState")) {
                        try {
                            ((VideoConferenceJoinMsg)msg).setPublishStatus(Integer.parseInt(xmlParser.nextText()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (tagName != null && tagName.equals("videoSource")) {
                        try {
                            text = xmlParser.nextText();
                            if (TextUtils.isEmpty((CharSequence)text) || text.indexOf(":") == -1) continue;
                            String[] split = text.split(":");
                            ((VideoConferenceJoinMsg)msg).setIp(split[0]);
                            ((VideoConferenceJoinMsg)msg).setPort(Integer.parseInt(split[1]));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_VIDEO_CONFERENCE_EXIT) {
                    tagName = xmlParser.getName();
                    msg = (VideoConferenceExitMsg)response;
                    if (tagName != null && tagName.equals("roomId")) {
                        text = xmlParser.nextText();
                        ((VideoConferenceMsg)msg).setConferenceId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        text = xmlParser.nextText();
                        if (text == null) continue;
                        ((VideoConferenceExitMsg)msg).setWhos(text.split(","));
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_VIDEO_CONFERENCE_DISMISS) {
                    tagName = xmlParser.getName();
                    msg = (VideoConferenceDismissMsg)response;
                    if (tagName != null && tagName.equals("roomId")) {
                        text = xmlParser.nextText();
                        ((VideoConferenceMsg)msg).setConferenceId(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var == VAR_VIDEO_CONFERENCE_REMOVEMEMBER) {
                    tagName = xmlParser.getName();
                    msg = (VideoConferenceRemoveMemberMsg)response;
                    if (tagName != null && tagName.equals("roomId")) {
                        text = xmlParser.nextText();
                        ((VideoConferenceMsg)msg).setConferenceId(text);
                        continue;
                    }
                    if (tagName != null && tagName.equals("who")) {
                        text = xmlParser.nextText();
                        ((VideoConferenceRemoveMemberMsg)msg).setWho(text);
                        continue;
                    }
                    xmlParser.nextText();
                    continue;
                }
                if (var != VAR_VIDEO_CONFERENCE_SWITCH) continue;
                tagName = xmlParser.getName();
                msg = (VideoConferenceSwitch)response;
                if (tagName != null && tagName.equals("roomId")) {
                    text = xmlParser.nextText();
                    ((VideoConferenceMsg)msg).setConferenceId(text);
                    continue;
                }
                if (tagName != null && tagName.equals("who")) {
                    text = xmlParser.nextText();
                    ((VideoConferenceSwitch)msg).setWho(text);
                    continue;
                }
                xmlParser.nextText();
            }
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseReceiveGroupMessage(XmlPullParser xmlParser, IMTextMsg response) throws XmlPullParserException, IOException {
        String tagName = xmlParser.getName();
        if (tagName.equals("msgid")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                response.setMsgId(text);
            }
        } else if (tagName.equals("sender")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                response.setSender(text);
            }
        } else if (tagName.equals("receiver")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                response.setReceiver(text);
            }
        } else if (tagName.equals("message")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                response.setMessage(text);
            }
        } else if (tagName.equals("userdata")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                response.setUserData(text);
            }
        } else if (tagName.equals("time")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                try {
                    response.setDateCreated(VoiceUtil.getTextReceiveDate(text));
                }
                catch (Exception e) {
                    response.setDateCreated(text);
                }
            }
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseMultiMedia(XmlPullParser xmlParser, UploadImessage response) throws XmlPullParserException, IOException {
        response.mediaMsg = new IMAttachedMsg();
        while (xmlParser.nextTag() != 3) {
            String text;
            String tagName = xmlParser.getName();
            if (tagName.equals("msgId")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.mediaMsg.setMsgId(text);
                continue;
            }
            if (tagName.equals("uploadUrl")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.setUploadUrl(text);
                continue;
            }
            if (tagName.equals("uploadToken")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.setUploadToken(text);
                continue;
            }
            if (tagName != null && tagName.equals("dateCreated")) {
                text = xmlParser.nextText();
                if (text == null || text.equals("")) continue;
                response.mediaMsg.setDateCreated(text);
                continue;
            }
            xmlParser.nextText();
        }
    }

    private static void parseReceiveMediaMsgList(XmlPullParser xmlParser, NewMediaMsgList nMsgList) throws XmlPullParserException, IOException {
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("count")) {
            String text;
            nMsgList.count = text = xmlParser.nextText();
        } else if (tagName != null && tagName.equals("InstanceMessage")) {
            IMAttachedMsg msgInfo = new IMAttachedMsg();
            while (xmlParser.nextTag() != 3) {
                ApiParser.parseReceiveMediaMsg(xmlParser, msgInfo);
            }
            nMsgList.newMsgs.add(msgInfo);
        } else if (tagName != null && tagName.equals("InstanceMessageText")) {
            IMTextMsg msgInfo = new IMTextMsg();
            while (xmlParser.nextTag() != 3) {
                ApiParser.parseReceiveMediaTextMsg(xmlParser, msgInfo);
            }
            nMsgList.newMsgs.add(msgInfo);
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseReceiveMediaTextMsg(XmlPullParser xmlParser, IMTextMsg msgInfo) throws XmlPullParserException, IOException {
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("dateCreated")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setDateCreated(text);
            }
        } else if (tagName != null && tagName.equals("sender")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setSender(text);
            }
        } else if (tagName != null && tagName.equals("receiver")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setReceiver(text);
            }
        } else if (tagName != null && tagName.equals("content")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setMessage(text);
            }
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseReceiveMediaMsg(XmlPullParser xmlParser, IMAttachedMsg msgInfo) throws XmlPullParserException, IOException {
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("msgId")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setMsgId(text);
            }
        } else if (tagName != null && tagName.equals("dateCreated")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setDateCreated(text);
            }
        } else if (tagName != null && tagName.equals("sender")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setSender(text);
            }
        } else if (tagName != null && tagName.equals("receiver")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setReceiver(text);
            }
        } else if (tagName != null && tagName.equals("fileExt")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setExt(text);
            }
        } else if (tagName != null && tagName.equals("fileSize")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setFileSize(Integer.parseInt(text));
            }
        } else if (tagName != null && tagName.equals("fileUrl")) {
            String text = xmlParser.nextText();
            if (text != null && !text.equals("")) {
                msgInfo.setFileUrl(text);
            }
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseStartVideoConference(XmlPullParser xmlParser, Response response) throws Exception {
        String tagName = xmlParser.getName();
        VideoConferenceMsg videoConference = (VideoConferenceMsg)response;
        if (tagName != null && tagName.equals("roomId")) {
            String text = xmlParser.nextText();
            videoConference.setConferenceId(text);
        } else {
            xmlParser.nextText();
        }
    }

    private static void parseVideoConferenceMemberList(XmlPullParser xmlParser, Response response) throws Exception {
        VideoConferenceMemberList list = (VideoConferenceMemberList)response;
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("count")) {
            String text;
            list.count = text = xmlParser.nextText();
        } else if (tagName != null && tagName.equals("member")) {
            VideoConferenceMember member = new VideoConferenceMember();
            while (xmlParser.next() != 3) {
                String text;
                tagName = xmlParser.getName();
                if (tagName != null && tagName.equals("number")) {
                    text = xmlParser.nextText();
                    member.setNumber(text);
                    continue;
                }
                if (tagName != null && tagName.equals("type")) {
                    text = xmlParser.nextText();
                    int type = 0;
                    try {
                        type = Integer.parseInt(text);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    member.setType(type);
                    continue;
                }
                if (tagName != null && tagName.equals("screen")) {
                    text = xmlParser.nextText();
                    int screen = 0;
                    try {
                        screen = Integer.parseInt(text);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    member.setScreen(screen);
                    continue;
                }
                if (tagName != null && tagName.equals("videoState")) {
                    try {
                        member.setPublishStatus(Integer.parseInt(xmlParser.nextText()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (tagName != null && tagName.equals("videoSource")) {
                    try {
                        text = xmlParser.nextText();
                        if (TextUtils.isEmpty((CharSequence)text) || text.indexOf(":") == -1) continue;
                        String[] split = text.split(":");
                        member.setIp(split[0]);
                        member.setPort(Integer.parseInt(split[1]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                xmlParser.nextText();
            }
            list.videoConferenceMembers.add(member);
        }
    }

    private static void parseVideoConferenceList(XmlPullParser xmlParser, Response response) throws Exception {
        VideoConferenceList list = (VideoConferenceList)response;
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("count")) {
            String text;
            list.count = text = xmlParser.nextText();
        } else if (tagName != null && tagName.equals("VideoConf")) {
            VideoConference vConference = new VideoConference();
            while (xmlParser.next() != 3) {
                String text;
                tagName = xmlParser.getName();
                if (tagName != null && tagName.equals("roomId")) {
                    text = xmlParser.nextText();
                    vConference.setConferenceId(text);
                    continue;
                }
                if (tagName != null && tagName.equals("roomName")) {
                    text = xmlParser.nextText();
                    vConference.setConferenceName(text);
                    continue;
                }
                if (tagName != null && tagName.equals("creator")) {
                    text = xmlParser.nextText();
                    vConference.setCreator(text);
                    continue;
                }
                if (tagName != null && tagName.equals("square")) {
                    text = xmlParser.nextText();
                    vConference.setSquare(text);
                    continue;
                }
                if (tagName != null && tagName.equals("joined")) {
                    text = xmlParser.nextText();
                    vConference.setJoinNum(text);
                    continue;
                }
                if (tagName != null && tagName.equals("validate")) {
                    text = xmlParser.nextText();
                    vConference.setValidate(text);
                    continue;
                }
                if (tagName != null && tagName.equals("keywords")) {
                    text = xmlParser.nextText();
                    vConference.setKeywords(text);
                    continue;
                }
                if (tagName != null && tagName.equals("isMultiVideo")) {
                    text = xmlParser.nextText();
                    try {
                        boolean isMulitVideo = "1".equals(text);
                        vConference.setMultiVideo(isMulitVideo);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                xmlParser.nextText();
            }
            list.videoConferences.add(vConference);
        }
    }

    private static void parseVideoConferencePortraitList(XmlPullParser xmlParser, Response response) throws Exception {
        VideoPartnerPortraitList list = (VideoPartnerPortraitList)response;
        String tagName = xmlParser.getName();
        if (tagName != null && tagName.equals("count")) {
            String text;
            list.count = text = xmlParser.nextText();
        } else if (tagName != null && tagName.equals("fileList")) {
            VideoPartnerPortrait vPortrait = new VideoPartnerPortrait();
            while (xmlParser.next() != 3) {
                String text;
                tagName = xmlParser.getName();
                if (tagName != null && tagName.equals("dateUpdate")) {
                    text = xmlParser.nextText();
                    vPortrait.setDateUpdate(text);
                    continue;
                }
                if (tagName != null && tagName.equals("sender")) {
                    text = xmlParser.nextText();
                    vPortrait.setVoip(text);
                    continue;
                }
                if (tagName != null && tagName.equals("fileName")) {
                    text = xmlParser.nextText();
                    vPortrait.setFileName(text);
                    continue;
                }
                if (tagName != null && tagName.equals("fileUrl")) {
                    text = xmlParser.nextText();
                    vPortrait.setFileUrl(text);
                    continue;
                }
                xmlParser.nextText();
            }
            list.videoPartnerPortraits.add(vPortrait);
        }
    }
}

