/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.multimedia;

import android.content.Context;
import com.hisun.phone.core.voice.sound.SoundPool;
import com.hisun.phone.core.voice.util.Log4Util;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public final class MediaManager
implements SoundPool.Listener {
    private static MediaManager sInstance;
    private final Context context;
    private SoundPool soundPool;
    private final Queue<PlaybackItem> playQueue = new LinkedList<PlaybackItem>();
    private PlaybackItem lastRunningItem;
    private final Map<Integer, PlaybackItem> soundsInFlight = new HashMap<Integer, PlaybackItem>();
    private int lastPlaybackId = 0;

    public static MediaManager getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("MediaManager has not been created yet");
        }
        return sInstance;
    }

    public static MediaManager initialize(Context context) {
        if (sInstance != null) {
            throw new IllegalStateException("MediaManager has already been initalized");
        }
        sInstance = new MediaManager(context);
        return sInstance;
    }

    public void destroy() {
        if (this.soundPool != null) {
            this.soundPool.release();
        }
        if (this.playQueue != null) {
            this.playQueue.clear();
        }
        if (this.soundsInFlight != null) {
            this.soundsInFlight.clear();
        }
        sInstance = null;
    }

    private MediaManager(Context context) {
        this.context = context;
        this.loadAssets();
    }

    private void loadAssets() {
        this.soundPool = new SoundPool(this);
        for (StockSound sound : StockSound.values()) {
            sound.setSoundId(this.soundPool.load(this.context, sound.getResName(), null));
        }
    }

    public synchronized int queueSound(StockSound sound, SoundPlaybackListener listener) {
        return this.queueSound(sound, false, 0L, listener);
    }

    public synchronized int queueSound(StockSound sound, long duration, SoundPlaybackListener listener) {
        return this.queueSound(sound, true, duration, listener);
    }

    private synchronized int queueSound(StockSound sound, boolean loop, long duration, SoundPlaybackListener listener) {
        int playbackId = 0;
        ++this.lastPlaybackId;
        if ((playbackId = this.lastPlaybackId++) == 0) {
            playbackId = this.lastPlaybackId;
        }
        PlaybackItem item = new PlaybackItem(playbackId, sound, loop, duration, listener);
        Log4Util.d("[MediaManager] queueSound = " + sound.getResName());
        if (item.sound.isAvailable()) {
            if (this.lastRunningItem == null) {
                this.lastRunningItem = item;
                this.soundsInFlight.put(item.playbackId, item);
                item.sound.soundId = this.soundPool.play(this.context, item.sound.soundId, item.loop, duration);
                Log4Util.w("SDK_DEVICE", "item.sound.soundId:" + item.sound.soundId);
                if (item.sound.soundId == 0) {
                    this.onPlayComplete(item.sound.soundId);
                }
            } else {
                this.playQueue.offer(item);
            }
        }
        return playbackId;
    }

    public synchronized void cancel(int playbackId) {
        PlaybackItem item = this.soundsInFlight.get(playbackId);
        if (item != null) {
            this.soundPool.stop();
            this.handleComplete(item);
        }
        for (PlaybackItem queuedItem : this.playQueue) {
            if (queuedItem.playbackId != playbackId) continue;
            this.playQueue.remove(queuedItem);
            break;
        }
    }

    public void setInComingVibrate(boolean vibrate) {
        if (this.soundPool != null) {
            this.soundPool.setIncomingVibrate(vibrate);
        }
    }

    public void stop() {
        if (this.soundPool != null) {
            this.soundPool.stop();
        }
        this.playQueue.clear();
        this.lastRunningItem = null;
    }

    public void release() {
        if (this.soundPool != null) {
            this.soundPool.release();
            this.soundPool = null;
        }
        this.playQueue.clear();
        this.lastRunningItem = null;
    }

    protected void finalize() {
        this.release();
    }

    private void handleComplete(PlaybackItem item) {
        this.soundsInFlight.remove(item.playbackId);
        if (item == this.lastRunningItem) {
            this.lastRunningItem = this.playQueue.poll();
            if (this.lastRunningItem != null) {
                Log4Util.d("[MediaManager] handleComplete nextsound = " + this.lastRunningItem.sound.resName);
                this.soundsInFlight.put(this.lastRunningItem.playbackId, this.lastRunningItem);
                if (!this.lastRunningItem.sound.isAvailable() && this.lastRunningItem.listener != null) {
                    this.lastRunningItem.listener.onCompletion();
                    this.handleComplete(this.lastRunningItem);
                } else {
                    this.lastRunningItem.sound.soundId = this.soundPool.play(this.context, this.lastRunningItem.sound.soundId, this.lastRunningItem.loop, this.lastRunningItem.duration);
                }
            }
        }
    }

    @Override
    public void onLoadComplete(int soundId) {
        for (StockSound sound : StockSound.values()) {
            if (sound.getSoundId() != soundId) continue;
            sound.setAvailable(true);
            break;
        }
    }

    @Override
    public void onLoadFailed(int soundId) {
        for (StockSound sound : StockSound.values()) {
            if (sound.getSoundId() != soundId) continue;
            sound.setAvailable(false);
            break;
        }
    }

    @Override
    public void onPlayComplete(int soundid) {
        Log4Util.d("[MediaManager] onPlayComplete play finish " + soundid);
        for (Map.Entry<Integer, PlaybackItem> entry : this.soundsInFlight.entrySet()) {
            PlaybackItem item = entry.getValue();
            if (item.sound.soundId != soundid) continue;
            if (item.listener != null) {
                item.listener.onCompletion();
            }
            this.handleComplete(item);
            break;
        }
    }

    public static enum StockSound {
        INCOMING("incoming"),
        OUTGOING("outgoing"),
        BUSY("busy");

        private final String resName;
        private int soundId;
        private boolean available = false;

        private StockSound(String resName) {
            this.resName = resName;
        }

        public String getResName() {
            return this.resName;
        }

        public int getSoundId() {
            return this.soundId;
        }

        public void setSoundId(int soundId) {
            this.soundId = soundId;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public void setAvailable(boolean available) {
            this.available = available;
        }
    }

    public static interface SoundPlaybackListener {
        public void onCompletion();
    }

    private static class PlaybackItem {
        final int playbackId;
        final StockSound sound;
        final boolean loop;
        final SoundPlaybackListener listener;
        final long duration;

        PlaybackItem(int playbackId, StockSound sound, boolean loop, long duration, SoundPlaybackListener listener) {
            this.playbackId = playbackId;
            this.sound = sound;
            this.loop = loop;
            this.duration = duration;
            this.listener = listener;
        }
    }
}

