/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.multimedia;

import android.os.Process;
import com.hisun.phone.core.voice.CCPCallImpl;
import com.hisun.phone.core.voice.CallControlManager;
import com.hisun.phone.core.voice.model.RecordProduct;
import com.hisun.phone.core.voice.model.RecourProductInfo;
import com.hisun.phone.core.voice.multimedia.CCPAudioRecorder;
import com.hisun.phone.core.voice.multimedia.RecordBlockingQueue;
import com.hisun.phone.core.voice.util.Log4Util;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AmrEncoder
implements Runnable {
    private BlockingQueue<byte[]> blockingQueue = new LinkedBlockingQueue<byte[]>();
    private final Object mutex = new Object();
    private int frameSize;
    private byte[] encodData = new byte[1024];
    private byte[] netPackage = new byte[650];
    private volatile boolean isRunning;
    private volatile boolean isCancle;
    private volatile boolean isChunked = false;
    private volatile boolean isSetAmrHead;
    private CallControlManager mControlManager;
    private RandomAccessFile randomAccessWriter;
    private RecourProductInfo info;

    public AmrEncoder(RecourProductInfo info, boolean isChunked) {
        this.isChunked = isChunked;
        this.frameSize = 320;
        this.mControlManager = CCPCallImpl.getInstance().getCallControlManager();
        this.info = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process.setThreadPriority((int)-19);
        int netPackageLength = 0;
        while (this.isRunning()) {
            Object object = this.mutex;
            synchronized (object) {
                while (this.isIdle()) {
                    try {
                        this.mutex.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            object = this.mutex;
            synchronized (object) {
                block31: {
                    try {
                        byte[] temp = new byte[this.frameSize];
                        byte[] rawdata = this.blockingQueue.take();
                        if (rawdata.length > 0) {
                            for (int i = 0; i < rawdata.length / this.frameSize; ++i) {
                                System.arraycopy(rawdata, i * this.frameSize, temp, 0, this.frameSize);
                                int length = this.mControlManager.AmrNBEncode(temp, this.frameSize, this.encodData, 0);
                                if (length > 0) {
                                    System.arraycopy(this.encodData, 1, this.netPackage, netPackageLength, length - 1);
                                    netPackageLength += length - 1;
                                }
                                if (netPackageLength < 650 && this.isRunning) continue;
                                if (!this.isSetAmrHead) {
                                    if (this.isChunked) {
                                        RecordProduct producer = new RecordProduct(RecordProduct.RecordProductType.ProductStart);
                                        RecordBlockingQueue.getInstance().produce(producer);
                                        RecordProduct producerInfo = new RecordProduct(RecordProduct.RecordProductType.ProductInfo);
                                        producerInfo.info = this.info;
                                        RecordBlockingQueue.getInstance().produce(producerInfo);
                                        RecordProduct producerdHead = new RecordProduct(RecordProduct.RecordProductType.ProductData);
                                        producerdHead.data = CCPAudioRecorder.AMR_CODEC_HEAD;
                                        RecordBlockingQueue.getInstance().produce(producerdHead);
                                    }
                                    try {
                                        this.randomAccessWriter = new RandomAccessFile(this.info.fileName, "rw");
                                        this.randomAccessWriter.setLength(0L);
                                        this.randomAccessWriter.write(CCPAudioRecorder.AMR_CODEC_HEAD);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    this.isSetAmrHead = true;
                                }
                                byte[] amrData = new byte[netPackageLength];
                                System.arraycopy(this.netPackage, 0, amrData, 0, netPackageLength);
                                this.buildNetPackage(amrData, amrData.length);
                                netPackageLength = 0;
                            }
                            break block31;
                        }
                        if (netPackageLength > 0 && this.isSetAmrHead) {
                            byte[] amrData = new byte[netPackageLength];
                            System.arraycopy(this.netPackage, 0, amrData, 0, netPackageLength);
                            this.buildNetPackage(amrData, amrData.length);
                            netPackageLength = 0;
                        }
                        try {
                            if (this.randomAccessWriter != null) {
                                this.randomAccessWriter.close();
                                Log4Util.d("SDK_DEVICE", "[AmrEncoder - run ] Read and write files, close reading and writing .");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        netPackageLength = 0;
                        Log4Util.d("SDK_DEVICE", "[AmrEncoder - run] I/O exception occured while closing output file");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            if (this.isSetAmrHead && this.isChunked) {
                if (!this.isCancle) {
                    RecordProduct isOk = new RecordProduct(RecordProduct.RecordProductType.ProductData);
                    isOk.data = CCPAudioRecorder.AMR_STOP;
                    Log4Util.d("SDK_DEVICE", "[AmrEncoder - run] record success , then begin to send end skip. ");
                    RecordBlockingQueue.getInstance().produce(isOk);
                } else {
                    this.doCCPRecordVoiceError();
                }
                RecordProduct producer = new RecordProduct(RecordProduct.RecordProductType.ProductEnd);
                try {
                    RecordBlockingQueue.getInstance().produce(producer);
                    Log4Util.d("SDK_DEVICE", "[AmrEncoder - run] PCM recording audio data end, set up the network send end flag");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Log4Util.d("SDK_DEVICE", "[AmrEncoder - run] PCM AMR code is finished executing, complete the network transmission requests");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log4Util.d("SDK_DEVICE", "[AmrEncoder - run] AmrEncoder code end of execution");
        this.isSetAmrHead = false;
        this.isChunked = false;
    }

    private void doCCPRecordVoiceError() {
        RecordProduct isOk = new RecordProduct(RecordProduct.RecordProductType.ProductData);
        isOk.data = CCPAudioRecorder.AMR_ERROR;
        Log4Util.d("SDK_DEVICE", "[AmrEncoder - run] record complete , cancel the send operation. ");
    }

    private void buildNetPackage(byte[] amrData, int Length) throws InterruptedException, IOException {
        if (this.isChunked) {
            RecordProduct producer = new RecordProduct(RecordProduct.RecordProductType.ProductData);
            producer.data = amrData;
            RecordBlockingQueue.getInstance().produce(producer);
        }
        try {
            this.randomAccessWriter.write(this.netPackage, 0, Length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putData(byte[] data, int size) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                byte[] rawdata = new byte[size];
                System.arraycopy(data, 0, rawdata, 0, size);
                this.blockingQueue.put(rawdata);
                this.mutex.notify();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isIdle() {
        return this.blockingQueue.size() == 0;
    }

    public void setIsCancle(boolean isCancle) {
        this.isCancle = isCancle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean isRunning) {
        Object object = this.mutex;
        synchronized (object) {
            this.isRunning = isRunning;
            if (this.isRunning) {
                this.mutex.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isRunning;
        }
    }
}

