/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hisun.phone.core.voice.Device;
import com.hisun.phone.core.voice.DeviceListener;
import com.hisun.phone.core.voice.model.CloopenReason;
import com.hisun.phone.core.voice.model.chatroom.ChatroomMsg;
import com.hisun.phone.core.voice.model.im.InstanceMsg;
import com.hisun.phone.core.voice.model.interphone.InterphoneMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoPartnerPortrait;
import com.hisun.phone.core.voice.util.Log4Util;
import java.util.ArrayList;
import java.util.List;

public class CallbackHandler
extends Handler {
    public static final int WHAT_REST_CHATROOM = 1;
    public static final int WHAT_REST_INTERPHONE = 2;
    public static final int WHAT_REST_IM = 3;
    public static final int WHAT_REST_VIDEOCONFERENCE = 4;
    public static final int WHAT_VOIP_CALL = 5;
    public static final int WHAT_VOIP_CALL_RECORD = 6;
    public static final int WHAT_DEVICE = 7;
    public static final int WHAT_ON_CONNECT = 8192;
    public static final int WHAT_ON_DISCONNECT = 8193;
    public static final int VOIP_CALL_FAILED = 8194;
    public static final int VOIP_CALL_INCOMING = 8195;
    public static final int VOIP_CALL_ALERTING = 8196;
    public static final int VOIP_CALL_ANSWERED = 8197;
    public static final int VOIP_CALL_PAUSED = 8198;
    public static final int VOIP_CALL_REMOTE_PAUSED = 8199;
    public static final int VOIP_CALL_RELEASED = 8200;
    public static final int VOIP_CALL_TRANSFERRED = 8201;
    public static final int VOIP_CALL_VIDEO = 8202;
    public static final int VOIP_CALL_PROCEEDING = 8203;
    public static final int VOIP_CALL_VIDEO_UPDATE_REQUEST = 8204;
    public static final int VOIP_CALL_VIDEO_UPDATE_RESPONSE = 8205;
    public static final int VOIP_REMOTE_VIDEO_RATIO = 8206;
    public static final int VOIP_MEDIA_INIT_FAILED = 8207;
    public static final int VOIP_MAKECALLBACK = 8208;
    public static final int WHAT_RECEIVE_CHATROOM_MESSAGE = 8209;
    public static final int WHAT_RECEIVE_INTERPHONE_MESSAGE = 8210;
    public static final int WHAT_RECEIVE_INSTANCE_MESSAGE = 8211;
    public static final int WHAT_RECEIVE_VIDEO_CONGERENCE_MESSAGE = 8212;
    public static final int WHAT_START_INTERPHONE = 8213;
    public static final int WHAT_CONTROL_MIC = 8214;
    public static final int WHAT_RELEASE_MIC = 8215;
    public static final int WHAT_QUERY_INTERPHONE_MEMBERS = 8216;
    public static final int WHAT_START_CHATROOM = 8217;
    public static final int WHAT_DISMISS_CHATROOM = 8218;
    public static final int WHAT_REMOVE_MEMBER_CHATROOM = 8219;
    public static final int WHAT_QUERY_CHATROOMS = 8220;
    public static final int WHAT_INVITE_JOIN_CHATROOM = 8221;
    public static final int WHAT_QUERY_CHATROOM_MEMBERS = 8222;
    public static final int WHAT_SEND_MEDIA_MSG = 8223;
    public static final int WHAT_DOWNLOAD_MEDIA_MSG = 8224;
    public static final int WHAT_CONFIRM_DOWNLOAD_MEDIAMESSAGE = 8225;
    public static final int WHAT_START_VIDEOCONFERENCE = 8226;
    public static final int WHAT_QUERY_VIDEOCONFERENCE_MEMBERS = 8227;
    public static final int WHAT_QUERY_VIDEOCONFERENCES = 8228;
    public static final int WHAT_DISMISS_VIDEOCONFERENCE = 8229;
    public static final int WHAT_REMOVE_MEMBER_VIDEOCONFERENCE = 8230;
    public static final int WHAT_SWITCH_REALSCREEN = 8231;
    public static final int WHAT_GET_VIDEO_CONFERENCE_PORPRRAIT = 8232;
    public static final int WHAT_CCP_DOWNLOAD = 8233;
    public static final int WHAT_SEND_LOCAL_VIDEO_PORPRTAIT = 8234;
    public static final int FIREWALL_POLICY_ENABLED = 8235;
    public static final int WHAT_CALL_RECORDING_OVER = 8236;
    public static final int WHAT_CALL_RECORDING_ERROR = 8237;
    public static final int WHAT_TRANSFER_STATE_STATE_SUCCESS = 8238;
    public static final int WHAT_CHATROOM_MEMBER_SPRAK_OPT = 8239;
    public static final int WHAT_VIDEO_PUBLISH = 8240;
    public static final int VIDEOCONF_REMOTE_VIDEO_RATIO = 8241;
    Device.CCPListenerInfo mCCPListenerInfo;

    public CallbackHandler(Device.CCPListenerInfo listener) {
        super(Looper.getMainLooper());
        this.mCCPListenerInfo = listener;
    }

    public void handleMessage(Message msg) {
        if (null == this.getCCPListenerInfo()) {
            return;
        }
        try {
            switch (msg.what) {
                case 1: {
                    if (this.getCCPListenerInfo().mOnChatroomListener == null) {
                        return;
                    }
                    this.handleChatroomCallback(msg);
                }
                case 2: {
                    if (this.getCCPListenerInfo().mOnInterphoneListener == null) {
                        return;
                    }
                    this.handleInterphoneCallback(msg);
                }
                case 3: {
                    if (this.getCCPListenerInfo().mOnIMListener == null) {
                        return;
                    }
                    this.handleInstanceMessageCallback(msg);
                }
                case 4: {
                    if (this.getCCPListenerInfo().mOnVideoConferenceListener == null) {
                        return;
                    }
                    this.handleVideoConferenceCallbcak(msg);
                    break;
                }
                case 5: {
                    if (this.getCCPListenerInfo().mOnVoIPListener == null) {
                        return;
                    }
                    this.handleVoIPCallback(msg);
                    break;
                }
                case 6: {
                    if (this.getCCPListenerInfo().mOnCallRecordListener == null) {
                        return;
                    }
                    this.handleVoIPCallRecordingCallback(msg);
                }
                case 7: {
                    if (this.getCCPListenerInfo().deviceListener == null) {
                        return;
                    }
                    this.handleDeviceCallback(msg);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.handleMessage(msg);
    }

    void handleVoIPCallRecordingCallback(Message msg) {
        switch (msg.arg1) {
            case 8236: {
                this.getCCPListenerInfo().mOnCallRecordListener.onCallRecordDone((String)msg.obj);
                break;
            }
            case 8237: {
                this.getCCPListenerInfo().mOnCallRecordListener.onCallRecordError(msg.arg2);
                break;
            }
        }
    }

    void handleInstanceMessageCallback(Message msg) {
        Bundle bundle = null;
        CloopenReason cloopenReason = null;
        if (msg.obj instanceof Bundle && (bundle = (Bundle)msg.obj).containsKey("com.ccp.phone.cloopenreason")) {
            cloopenReason = (CloopenReason)bundle.getSerializable("com.ccp.phone.cloopenreason");
        }
        switch (msg.arg1) {
            case 8223: {
                InstanceMsg instanceMsg = null;
                if (bundle.containsKey("InstanceMsg")) {
                    instanceMsg = (InstanceMsg)bundle.getSerializable("InstanceMsg");
                }
                this.getCCPListenerInfo().mOnIMListener.onSendInstanceMessage(cloopenReason, instanceMsg);
                break;
            }
            case 8224: {
                String fileName = null;
                if (bundle.containsKey("fileName")) {
                    fileName = bundle.getString("fileName");
                }
                this.getCCPListenerInfo().mOnIMListener.onDownloadAttached(cloopenReason, fileName);
                break;
            }
            case 8225: {
                this.getCCPListenerInfo().mOnIMListener.onConfirmIntanceMessage(cloopenReason);
                break;
            }
            case 8211: {
                InstanceMsg receiveInstanceMsg = null;
                if (bundle.containsKey("InstanceMsg")) {
                    receiveInstanceMsg = (InstanceMsg)bundle.getSerializable("InstanceMsg");
                }
                this.getCCPListenerInfo().mOnIMListener.onReceiveInstanceMessage(receiveInstanceMsg);
                break;
            }
        }
    }

    void handleInterphoneCallback(Message msg) {
        Bundle bundle = null;
        CloopenReason cloopenReason = null;
        if (msg.obj instanceof Bundle && (bundle = (Bundle)msg.obj).containsKey("com.ccp.phone.cloopenreason")) {
            cloopenReason = (CloopenReason)bundle.getSerializable("com.ccp.phone.cloopenreason");
        }
        String confNo = null;
        switch (msg.arg1) {
            case 8213: {
                if (bundle != null && bundle.containsKey("com.ccp.phone.interphone.confNo")) {
                    confNo = bundle.getString("com.ccp.phone.interphone.confNo");
                }
                this.getCCPListenerInfo().mOnInterphoneListener.onInterphoneState(cloopenReason, confNo);
                break;
            }
            case 8214: {
                String speaker = null;
                if (bundle != null && bundle.containsKey("speaker")) {
                    speaker = bundle.getString("speaker");
                }
                this.getCCPListenerInfo().mOnInterphoneListener.onControlMicState(cloopenReason, speaker);
                break;
            }
            case 8215: {
                this.getCCPListenerInfo().mOnInterphoneListener.onReleaseMicState(cloopenReason);
                break;
            }
            case 8216: {
                List members = null;
                if (bundle.containsKey("member")) {
                    ArrayList parcelableArrayList = bundle.getParcelableArrayList("member");
                    members = (List)parcelableArrayList.get(0);
                }
                this.getCCPListenerInfo().mOnInterphoneListener.onInterphoneMembers(cloopenReason, members);
                break;
            }
            case 8210: {
                InterphoneMsg interphoneMsg = null;
                if (bundle.containsKey("InterphoneMsg")) {
                    interphoneMsg = (InterphoneMsg)bundle.getSerializable("InterphoneMsg");
                }
                this.getCCPListenerInfo().mOnInterphoneListener.onReceiveInterphoneMsg(interphoneMsg);
                break;
            }
        }
    }

    void handleChatroomCallback(Message msg) {
        Bundle bundle = null;
        CloopenReason cloopenReason = null;
        if (msg.obj instanceof Bundle && (bundle = (Bundle)msg.obj).containsKey("com.ccp.phone.cloopenreason")) {
            cloopenReason = (CloopenReason)bundle.getSerializable("com.ccp.phone.cloopenreason");
        }
        String confNo = null;
        String member = null;
        switch (msg.arg1) {
            case 8217: {
                if (bundle != null && bundle.containsKey("com.ccp.phone.interphone.confNo")) {
                    confNo = bundle.getString("com.ccp.phone.interphone.confNo");
                }
                this.getCCPListenerInfo().mOnChatroomListener.onChatroomState(cloopenReason, confNo);
                break;
            }
            case 8218: {
                if (bundle != null && bundle.containsKey("com.ccp.phone.interphone.confNo")) {
                    confNo = bundle.getString("com.ccp.phone.interphone.confNo");
                }
                this.getCCPListenerInfo().mOnChatroomListener.onChatroomDismiss(cloopenReason, confNo);
                break;
            }
            case 8219: {
                if (bundle != null && bundle.containsKey("member")) {
                    member = bundle.getString("member");
                }
                this.getCCPListenerInfo().mOnChatroomListener.onChatroomRemoveMember(cloopenReason, member);
                break;
            }
            case 8239: {
                if (bundle != null && bundle.containsKey("member")) {
                    member = bundle.getString("member");
                }
                this.getCCPListenerInfo().mOnChatroomListener.onSetMemberSpeakOpt(cloopenReason, member);
                break;
            }
            case 8220: {
                List chatrooms = null;
                if (bundle.containsKey("chatroomList")) {
                    ArrayList parcelableArrayList = bundle.getParcelableArrayList("chatroomList");
                    chatrooms = (List)parcelableArrayList.get(0);
                }
                this.getCCPListenerInfo().mOnChatroomListener.onChatrooms(cloopenReason, chatrooms);
                break;
            }
            case 8221: {
                if (bundle != null && bundle.containsKey("com.ccp.phone.interphone.confNo")) {
                    confNo = bundle.getString("com.ccp.phone.interphone.confNo");
                }
                this.getCCPListenerInfo().mOnChatroomListener.onChatroomInviteMembers(cloopenReason, confNo);
                break;
            }
            case 8222: {
                List chatroomMembers = null;
                if (bundle.containsKey("chatroomMembers")) {
                    ArrayList parcelableArrayList = bundle.getParcelableArrayList("chatroomMembers");
                    chatroomMembers = (List)parcelableArrayList.get(0);
                }
                this.getCCPListenerInfo().mOnChatroomListener.onChatroomMembers(cloopenReason, chatroomMembers);
                break;
            }
            case 8209: {
                ChatroomMsg chatroomMsg = null;
                if (bundle.containsKey("ChatroomMsg")) {
                    chatroomMsg = (ChatroomMsg)bundle.getSerializable("ChatroomMsg");
                }
                this.getCCPListenerInfo().mOnChatroomListener.onReceiveChatroomMsg(chatroomMsg);
                break;
            }
        }
    }

    private void handleDeviceCallback(Message msg) {
        switch (msg.arg1) {
            case 8192: {
                this.getCCPListenerInfo().deviceListener.onConnected();
                break;
            }
            case 8193: {
                this.getCCPListenerInfo().deviceListener.onDisconnect((DeviceListener.Reason)msg.obj);
                break;
            }
            case 8235: {
                this.getCCPListenerInfo().deviceListener.onFirewallPolicyEnabled();
                break;
            }
        }
    }

    void handleVideoConferenceCallbcak(Message msg) {
        Bundle bundle = null;
        CloopenReason cloopenReason = null;
        if (msg.obj instanceof Bundle && (bundle = (Bundle)msg.obj).containsKey("com.ccp.phone.cloopenreason")) {
            cloopenReason = (CloopenReason)bundle.getSerializable("com.ccp.phone.cloopenreason");
        }
        String confNo = null;
        String member = null;
        switch (msg.arg1) {
            case 8226: {
                if (bundle != null && bundle.containsKey("com.ccp.phone.interphone.confNo")) {
                    confNo = bundle.getString("com.ccp.phone.interphone.confNo");
                }
                this.getCCPListenerInfo().mOnVideoConferenceListener.onVideoConferenceState(cloopenReason, confNo);
                break;
            }
            case 8227: {
                List videoMembers = null;
                if (bundle.containsKey("videoMembers")) {
                    ArrayList parcelableArrayList = bundle.getParcelableArrayList("videoMembers");
                    videoMembers = (List)parcelableArrayList.get(0);
                }
                this.getCCPListenerInfo().mOnVideoConferenceListener.onVideoConferenceMembers(cloopenReason, videoMembers);
                break;
            }
            case 8228: {
                List conferences = null;
                if (bundle.containsKey("conferences")) {
                    ArrayList parcelableArrayList = bundle.getParcelableArrayList("conferences");
                    conferences = (List)parcelableArrayList.get(0);
                }
                this.getCCPListenerInfo().mOnVideoConferenceListener.onVideoConferences(cloopenReason, conferences);
                break;
            }
            case 8229: {
                if (bundle != null && bundle.containsKey("com.ccp.phone.interphone.confNo")) {
                    confNo = bundle.getString("com.ccp.phone.interphone.confNo");
                }
                this.getCCPListenerInfo().mOnVideoConferenceListener.onVideoConferenceDismiss(cloopenReason, confNo);
                break;
            }
            case 8240: {
                if (bundle == null || !bundle.containsKey("type")) break;
                int type = bundle.getInt("type");
                if (type == 0) {
                    this.getCCPListenerInfo().onVideoMemberFrameListener.onPublisVideoFrameRequest(cloopenReason);
                    break;
                }
                this.getCCPListenerInfo().onVideoMemberFrameListener.onStopVideoFrameRequest(cloopenReason);
                break;
            }
            case 8230: {
                if (bundle != null && bundle.containsKey("member")) {
                    member = bundle.getString("member");
                }
                this.getCCPListenerInfo().mOnVideoConferenceListener.onVideoConferenceRemoveMember(cloopenReason, member);
                break;
            }
            case 8231: {
                this.getCCPListenerInfo().mOnVideoConferenceListener.onSwitchRealScreenToVoip(cloopenReason);
                break;
            }
            case 8232: {
                List videoPortraits = null;
                if (bundle.containsKey("videoPortraits")) {
                    ArrayList parcelableArrayList = bundle.getParcelableArrayList("videoPortraits");
                    videoPortraits = (List)parcelableArrayList.get(0);
                }
                this.getCCPListenerInfo().mOnVideoConferenceListener.onGetPortraitsFromVideoConference(cloopenReason, videoPortraits);
                break;
            }
            case 8233: {
                VideoPartnerPortrait portrait = null;
                if (bundle.containsKey("portrait")) {
                    portrait = (VideoPartnerPortrait)bundle.getSerializable("portrait");
                }
                this.getCCPListenerInfo().mOnVideoConferenceListener.onDownloadVideoConferencePortraits(cloopenReason, portrait);
                break;
            }
            case 8234: {
                if (bundle != null && bundle.containsKey("com.ccp.phone.interphone.confNo")) {
                    confNo = bundle.getString("com.ccp.phone.interphone.confNo");
                }
                this.getCCPListenerInfo().mOnVideoConferenceListener.onSendLocalPortrait(cloopenReason, confNo);
                break;
            }
            case 8212: {
                VideoConferenceMsg videoConferenceMsg = null;
                if (bundle.containsKey("VideoConferenceMsg")) {
                    videoConferenceMsg = (VideoConferenceMsg)bundle.getSerializable("VideoConferenceMsg");
                }
                this.getCCPListenerInfo().mOnVideoConferenceListener.onReceiveVideoConferenceMsg(videoConferenceMsg);
                break;
            }
            case 8241: {
                try {
                    String[] split;
                    String paramers = (String)msg.obj;
                    if (TextUtils.isEmpty((CharSequence)paramers) || (split = paramers.split(",")) == null) break;
                    Log4Util.e("VOIP_REMOTE_VIDEO_RATIO == " + split[0] + " " + split[1]);
                    String[] resoluSplit = split[1].split("x");
                    this.getCCPListenerInfo().mOnVideoConferenceListener.onVideoRatioChanged(split[0], Integer.valueOf(resoluSplit[0]), Integer.valueOf(resoluSplit[1]));
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    void handleVoIPCallback(Message msg) {
        Bundle bundle = null;
        String callid = null;
        if (msg.obj instanceof Bundle) {
            bundle = (Bundle)msg.obj;
            if (bundle.containsKey("callid")) {
                callid = bundle.getString("callid");
            }
        } else if (msg.obj instanceof String) {
            callid = (String)msg.obj;
        }
        switch (msg.arg1) {
            case 8203: {
                this.getCCPListenerInfo().mOnVoIPListener.onCallProceeding(callid);
                break;
            }
            case 8196: {
                this.getCCPListenerInfo().mOnVoIPListener.onCallAlerting(callid);
                break;
            }
            case 8197: {
                this.getCCPListenerInfo().mOnVoIPListener.onCallAnswered(callid);
                break;
            }
            case 8198: {
                this.getCCPListenerInfo().mOnVoIPListener.onCallPaused(callid);
                break;
            }
            case 8199: {
                this.getCCPListenerInfo().mOnVoIPListener.onCallPausedByRemote(callid);
                break;
            }
            case 8200: {
                this.getCCPListenerInfo().mOnVoIPListener.onCallReleased(callid);
                break;
            }
            case 8194: {
                DeviceListener.Reason reason = null;
                if (bundle != null && bundle.containsKey("com.ccp.phone.reason")) {
                    reason = (DeviceListener.Reason)((Object)bundle.getSerializable("com.ccp.phone.reason"));
                }
                this.getCCPListenerInfo().mOnVoIPListener.onMakeCallFailed(callid, reason);
                break;
            }
            case 8201: {
                try {
                    String[] split;
                    String paramers = (String)msg.obj;
                    if (TextUtils.isEmpty((CharSequence)paramers) || (split = paramers.split(",")) == null) break;
                    this.getCCPListenerInfo().mOnVoIPListener.onCallTransfered(split[0], split[1]);
                }
                catch (Exception paramers) {}
                break;
            }
            case 8204: {
                this.getCCPListenerInfo().mOnVoIPListener.onCallMediaUpdateRequest(callid, msg.arg2);
                this.getCCPListenerInfo().mOnVoIPListener.onSwitchCallMediaTypeRequest(callid, msg.arg2 == 0 ? Device.CallType.VIDEO : Device.CallType.VOICE);
                break;
            }
            case 8205: {
                this.getCCPListenerInfo().mOnVoIPListener.onCallMediaUpdateResponse((String)msg.obj, msg.arg2);
                this.getCCPListenerInfo().mOnVoIPListener.onSwitchCallMediaTypeResponse(callid, msg.arg2 == 0 ? Device.CallType.VIDEO : Device.CallType.VOICE);
                break;
            }
            case 8206: {
                try {
                    String[] split;
                    String paramers = (String)msg.obj;
                    if (TextUtils.isEmpty((CharSequence)paramers) || (split = paramers.split(",")) == null) break;
                    Log4Util.e("VOIP_REMOTE_VIDEO_RATIO == " + split[0] + " " + split[1]);
                    String[] resoluSplit = split[1].split("x");
                    this.getCCPListenerInfo().mOnVoIPListener.onCallVideoRatioChanged(split[0], Integer.valueOf(resoluSplit[0]), Integer.valueOf(resoluSplit[1]));
                }
                catch (Exception paramers) {}
                break;
            }
            case 8207: {
                this.getCCPListenerInfo().mOnVoIPListener.onCallMediaInitFailed((String)msg.obj, msg.arg2 == 0 ? Device.CallType.VOICE : Device.CallType.VIDEO);
                break;
            }
            case 8208: {
                try {
                    String[] split;
                    String paramers = (String)msg.obj;
                    if (TextUtils.isEmpty((CharSequence)paramers) || (split = paramers.split(",")) == null) break;
                    this.getCCPListenerInfo().mOnVoIPListener.onCallback(msg.arg2, split[0], split[1]);
                }
                catch (Exception paramers) {}
                break;
            }
            case 8238: {
                boolean result = false;
                if (bundle.containsKey("result")) {
                    result = bundle.getBoolean("result");
                }
                this.getCCPListenerInfo().mOnVoIPListener.onTransferStateSucceed(callid, result);
            }
        }
    }

    public void setCCPListenerInfo(Device.CCPListenerInfo listener) {
        this.mCCPListenerInfo = listener;
    }

    Device.CCPListenerInfo getCCPListenerInfo() {
        return this.mCCPListenerInfo;
    }

    public static CloopenReason getCloopenReason(int reason) {
        if (reason == 0) {
            return CallbackHandler.getCloopenReason(reason, "Request 200 /OK");
        }
        if (reason == 170005) {
            return CallbackHandler.getCloopenReason(reason, "\u7f51\u7edc\u8bf7\u6c42\u9519\u8bef, \u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e\u6216\u7a0d\u540e\u91cd\u8bd5");
        }
        if (reason == 170002) {
            return CallbackHandler.getCloopenReason(reason, "\u8bf7\u6c42\u5305\u4f53\u683c\u5f0f\u9519\u8bef");
        }
        if (reason == 170004) {
            return CallbackHandler.getCloopenReason(reason, "\u5bf9\u4e0d\u8d77, \u8bf7\u6c42\u5305\u4f53\u89e3\u6790\u9519\u8bef");
        }
        if (reason == 170001) {
            return new CloopenReason(170001, "\u5ba2\u6237\u7aef\u5f53\u524d\u672a\u5904\u4e8e\u7a7a\u95f2\u72b6\u6001");
        }
        if (reason == 170000) {
            return new CloopenReason(170000, "\u5ba2\u6237\u7aef\u672a\u6ce8\u518c");
        }
        if (reason == 170022) {
            return new CloopenReason(170022, "IM\u6587\u672c\u957f\u5ea6\u8d85\u8fc7\u9650\u5236, \u6700\u5927\u957f\u5ea62000\u5b57\u8282");
        }
        return CallbackHandler.getCloopenReason(reason, "\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    public static CloopenReason getCloopenReason(int reason, String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return CallbackHandler.getCloopenReason(reason);
        }
        return new CloopenReason(reason, message);
    }
}

