/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcelable;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.CCP.phone.NativeInterface;
import com.hisun.phone.core.voice.CCPCallImpl;
import com.hisun.phone.core.voice.CallControlManager;
import com.hisun.phone.core.voice.Device;
import com.hisun.phone.core.voice.DeviceImpl;
import com.hisun.phone.core.voice.DeviceListener;
import com.hisun.phone.core.voice.multimedia.AudioRecordManager;
import com.hisun.phone.core.voice.multimedia.MediaManager;
import com.hisun.phone.core.voice.multimedia.MediaPlayManager;
import com.hisun.phone.core.voice.multimedia.RecordManager;
import com.hisun.phone.core.voice.util.Log4Util;
import com.hisun.phone.core.voice.util.VoiceUtil;
import java.util.ArrayList;
import java.util.List;

public class CCPService
extends Service {
    public static final String CONNECT_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    public static final String CHECK_ACTION = "com.ccp.phone.intent.CHECK_ATTIME_ACTION";
    public static final String ACTION_DEVICES = "action_devices";
    public static final String PHONE_OUTGOING_ACTION = "android.intent.action.NEW_OUTGOING_CALL";
    private final CCPCallBinder binder = new CCPCallBinder();
    private CallControlManager callControlManager;
    private Exception callManagerError;
    private MediaManager mediaManager;
    private AlarmManager alarmManager;
    private InnerCoreReceiver receiver;
    private TelephonyManager mTelephonyManager;
    private PhoneStateListener mPhoneStateListener;
    private ConnectivityManager mConnManager;
    private int lastStartId = -1;
    private volatile DeviceListener.APN apn;
    private volatile DeviceListener.NetworkState networkState;
    private int curNetworkType = -1;
    private int lastConnectedNetworkType = -1;
    private String lastWifiSSID;
    private long lastDisconnectTime = 0L;
    public static final int NETWORK_NONE = 0;
    public static final int NETWORK_LAN = 1;
    public static final int NETWORK_WIFI = 2;
    public static final int NETWORK_GPRS = 3;
    public static final int NETWORK_3G = 4;

    public void onCreate() {
        super.onCreate();
        NativeInterface.init();
        this.alarmManager = (AlarmManager)this.getSystemService("alarm");
        this.mTelephonyManager = (TelephonyManager)this.getSystemService("phone");
        this.mConnManager = (ConnectivityManager)this.getApplicationContext().getSystemService("connectivity");
        IntentFilter filter = new IntentFilter(CONNECT_ACTION);
        filter.addAction(CHECK_ACTION);
        this.receiver = new InnerCoreReceiver();
        this.registerReceiver(this.receiver, filter);
        this.callControlManager = CallControlManager.initialize(this.getApplicationContext());
        this.mediaManager = MediaManager.initialize(this.getApplicationContext());
        this.mPhoneStateListener = new PhoneStateListener(){

            public void onCallStateChanged(int state, String incomingNumber) {
                Log4Util.d("onCallStateChanged: " + state + ",IncomingNumber: " + incomingNumber);
                switch (state) {
                    case 0: {
                        Log4Util.i("SDK_DEVICE", "system call idle.");
                        break;
                    }
                    case 1: 
                    case 2: {
                        Log4Util.i("SDK_DEVICE", "handle voip call when system call offhook.");
                        CCPService.this.callControlManager.postCommand(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    List<Device> devices = CCPCallImpl.getInstance().listDevices();
                                    for (int i = 0; i < devices.size(); ++i) {
                                        DeviceImpl device = (DeviceImpl)devices.get(i);
                                        if (device == null || !device.isKeepingCall() && !device.isVoicePlaying() && !device.isVoiceRecording()) continue;
                                        Log4Util.i("SDK_DEVICE", "found system call coming, then notify apps. ThreadName: " + Thread.currentThread().getName());
                                        device.getDeviceListener().onReceiveEvents(DeviceListener.CCPEvents.SYSCallComing);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                }
            }
        };
        this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
    }

    private boolean handleCheckAction() {
        if (VoiceUtil.getNetWorkType() == 0 || this.callControlManager == null) {
            return false;
        }
        if (this.callControlManager.checkNormalSoftAddress()) {
            this.cancelAlarmTime(CHECK_ACTION);
            Log4Util.i("SDK_DEVICE", "soft switch address normal, so cancel check of alarm.");
            return true;
        }
        try {
            this.callControlManager.doQuerySoftSwitchAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void handleNetChanged(final Intent intent) {
        this.callControlManager.postCommand(new Runnable(){

            @Override
            public void run() {
                boolean haveConnection = !intent.getBooleanExtra("noConnectivity", false);
                boolean wasConnected = CCPService.this.curNetworkType != -1;
                boolean netTypeChanged = CCPService.this.updateNetworkState();
                Log4Util.d("SDK_DEVICE", "[NeedReconnected] network state: " + haveConnection + ", connect type changed: " + netTypeChanged);
                if (wasConnected && !haveConnection) {
                    Log4Util.d("SDK_DEVICE", "this is type is 1.last connect 2.this have disconnect");
                    CCPService.this.lastDisconnectTime = System.currentTimeMillis();
                    CCPService.this.notifyApnEvents(CCPService.this.transferNetType(-1), false, false);
                } else if (!wasConnected && haveConnection && !netTypeChanged && System.currentTimeMillis() - CCPService.this.lastDisconnectTime > 20000L) {
                    Log4Util.d("SDK_DEVICE", "this is type is 1.last disconnect 2.this have connect 3.network not changed 4.interval over 20s.");
                    CCPService.this.notifyApnEvents(CCPService.this.transferNetType(CCPService.this.curNetworkType), haveConnection, true);
                } else if (!wasConnected && haveConnection) {
                    Log4Util.d("SDK_DEVICE", "this is type is 1.last disconnect 2.this have connect");
                    CCPService.this.notifyApnEvents(CCPService.this.transferNetType(CCPService.this.curNetworkType), haveConnection, true);
                } else if (netTypeChanged) {
                    Log4Util.d("SDK_DEVICE", "this is type is 1.network changed.");
                    CCPService.this.notifyApnEvents(CCPService.this.transferNetType(CCPService.this.curNetworkType), haveConnection, true);
                } else if (haveConnection && !netTypeChanged && CCPService.this.lastConnectedNetworkType == 0) {
                    Log4Util.d("SDK_DEVICE", "this is type is 1.this have connect 2.network not changed 3.last network mobile.");
                    CCPService.this.notifyApnEvents(CCPService.this.transferNetType(CCPService.this.curNetworkType), haveConnection, true);
                }
            }
        });
    }

    private synchronized int transferNetType(int localType) {
        int finalType = 0;
        switch (localType) {
            case -1: {
                finalType = 0;
                break;
            }
            case 1: {
                finalType = 2;
                break;
            }
            case 0: {
                if (this.apn == DeviceListener.APN.WONET) {
                    finalType = 4;
                    break;
                }
                finalType = 3;
                break;
            }
            default: {
                Log4Util.e("[transferNetType] found a new local net type: " + localType);
            }
        }
        return finalType;
    }

    private void notifyApnEvents(int netType, boolean haveConnection, boolean reconnect) {
        try {
            Log4Util.d("[notifyApnEvents] tell so the network changed.");
            VoiceUtil.setNetWorkType(netType);
            if (haveConnection && reconnect && this.handleCheckAction()) {
                this.callControlManager.setNetworkType(netType, haveConnection, reconnect);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean updateNetworkState() {
        boolean changed = false;
        int oldNetworkType = this.lastConnectedNetworkType;
        NetworkInfo netInfo = this.mConnManager.getActiveNetworkInfo();
        if (netInfo != null) {
            this.lastConnectedNetworkType = this.curNetworkType = netInfo.getType();
            this.networkState = netInfo.getState() == NetworkInfo.State.CONNECTING || netInfo.getState() == NetworkInfo.State.CONNECTED ? DeviceListener.NetworkState.CONNECTED : (netInfo.getState() == NetworkInfo.State.DISCONNECTED ? DeviceListener.NetworkState.DISCONNECTED : DeviceListener.NetworkState.UNKNOWN);
            if (netInfo.getType() == 1) {
                this.apn = DeviceListener.APN.WIFI;
            } else if (netInfo.getType() == 0) {
                this.apn = this.checkNetworkType(netInfo);
            }
        } else {
            this.curNetworkType = -1;
            this.networkState = DeviceListener.NetworkState.UNKNOWN;
            this.apn = DeviceListener.APN.UNKNOWN;
        }
        boolean bl = changed = this.curNetworkType != -1 && this.lastConnectedNetworkType != oldNetworkType;
        if (this.curNetworkType == 1 && oldNetworkType == 1) {
            WifiManager wifiMan = (WifiManager)this.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiMan.getConnectionInfo();
            if (wifiInfo != null) {
                String oldSSID = this.lastWifiSSID;
                this.lastWifiSSID = wifiInfo.getSSID();
                if (this.lastWifiSSID == null || !this.lastWifiSSID.equals(oldSSID)) {
                    changed = true;
                }
            } else {
                this.lastWifiSSID = null;
            }
        } else {
            this.lastWifiSSID = null;
        }
        return changed;
    }

    public String getNetworkName() {
        if (this.apn == DeviceListener.APN.WIFI) {
            return "WIFI";
        }
        if (this.apn == DeviceListener.APN.CMWAP || this.apn == DeviceListener.APN.CMNET || this.apn == DeviceListener.APN.UNIWAP || this.apn == DeviceListener.APN.UNINET || this.apn == DeviceListener.APN.CTWAP || this.apn == DeviceListener.APN.CTNET || this.apn == DeviceListener.APN.INTERNET || this.apn == DeviceListener.APN.GPRS) {
            return "2G";
        }
        return "3G";
    }

    public void onDestroy() {
        Log4Util.e("SDK_DEVICE", "[CCPService - onDestroy] CCPService destroy.");
        try {
            this.unregisterReceiver(this.receiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.callControlManager != null) {
            this.callControlManager.destroy();
        }
        if (this.mediaManager != null) {
            this.mediaManager.destroy();
        }
        this.cancelAlarmTime(CHECK_ACTION);
        this.lastStartId = -1;
        this.apn = null;
        this.networkState = null;
        this.curNetworkType = -1;
        this.lastConnectedNetworkType = -1;
        this.lastWifiSSID = null;
        this.lastDisconnectTime = 0L;
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            return super.onStartCommand(intent, flags, startId);
        }
        String action = intent.getAction() == null ? "" : intent.getAction();
        Log4Util.d("SDK_DEVICE", "[CCPService] onStart action=" + action + ", flags=" + flags + ", startId=" + startId);
        if ((flags & 1) != 0) {
            this.restoreState(intent, this.binder);
        }
        if (this.lastStartId != -1) {
            this.stopSelfResult(this.lastStartId);
        }
        this.lastStartId = startId;
        return 3;
    }

    public void restoreState(Intent intent, CCPCallBinder ccpBinder) {
        Log4Util.w("SDK_DEVICE", "[CCPService - restoreState] restore state from CCPService.");
        CCPCallImpl ccpImpl = CCPCallImpl.getInstance();
        if (ccpImpl.isInitializing() || ccpImpl.isInitialized()) {
            Log4Util.w("SDK_DEVICE", "CCPImpl is initializing or initialized.");
            return;
        }
        ArrayList parcelable = intent.getParcelableArrayListExtra("com.ccp.phone.devices");
        if (parcelable == null || parcelable.isEmpty()) {
            return;
        }
        ArrayList<Device> devicesInfo = new ArrayList<Device>(parcelable.size());
        for (Parcelable p : parcelable) {
            if (!(p instanceof Device)) continue;
            devicesInfo.add((Device)p);
        }
        if (devicesInfo.isEmpty()) {
            return;
        }
        ccpImpl.reverseInitialize(this.getApplicationContext(), ccpBinder, devicesInfo);
    }

    public boolean onUnbind(Intent intent) {
        Log4Util.e("SDK_DEVICE", "[CCPService - onUnbind]");
        return super.onUnbind(intent);
    }

    private void setAlarmTime(long triggerAtTime, long interval, String action) {
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)new Intent(action), (int)0x10000000);
        this.alarmManager.setRepeating(0, triggerAtTime, interval, pendingIntent);
    }

    private void cancelAlarmTime(String action) {
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)new Intent(action), (int)0x10000000);
        this.alarmManager.cancel(pendingIntent);
    }

    public CallControlManager getCallControlManager() {
        return this.callControlManager;
    }

    public Exception getCallManagerError() {
        return this.callManagerError;
    }

    public MediaManager getMediaManager() {
        return this.mediaManager;
    }

    private DeviceListener.APN checkNetworkType(NetworkInfo info) {
        try {
            if (info != null && info.isAvailable() && info.getState() == NetworkInfo.State.CONNECTED) {
                switch (info.getType()) {
                    case 1: {
                        return DeviceListener.APN.WIFI;
                    }
                    case 0: {
                        switch (info.getSubtype()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 7: {
                                return DeviceListener.APN.WOWAP;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 12: {
                                return DeviceListener.APN.WONET;
                            }
                            case 0: {
                                return DeviceListener.APN.UNKNOWN;
                            }
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return DeviceListener.APN.INTERNET;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return DeviceListener.APN.UNKNOWN;
        }
        return DeviceListener.APN.UNKNOWN;
    }

    class CCPCallBinder
    extends Binder {
        CCPCallBinder() {
        }

        public CallControlManager getCallControlManager() {
            return CCPService.this.getCallControlManager();
        }

        public MediaManager getMediaManager() {
            return CCPService.this.getMediaManager();
        }

        public RecordManager getRecordManager() {
            return RecordManager.getInstance();
        }

        public AudioRecordManager getAudioRecordManager() {
            return AudioRecordManager.getInstance();
        }

        public MediaPlayManager getMediaPlayManager() {
            return MediaPlayManager.getInstance();
        }

        public Exception getError() {
            return CCPService.this.getCallManagerError();
        }

        public DeviceListener.NetworkState getNetworkState() {
            return CCPService.this.networkState;
        }

        public DeviceListener.APN getAPN() {
            return CCPService.this.apn;
        }

        public void setAlarmTime() {
            CCPService.this.setAlarmTime(System.currentTimeMillis(), 15000L, CCPService.CHECK_ACTION);
        }
    }

    class InnerCoreReceiver
    extends BroadcastReceiver {
        public InnerCoreReceiver() {
            CCPService.this.updateNetworkState();
            if (CCPService.this.curNetworkType == -1) {
                CCPService.this.lastDisconnectTime = System.currentTimeMillis();
            }
        }

        public void onReceive(Context context, Intent intent) {
            if (intent == null || context == null) {
                return;
            }
            String action = intent.getAction() == null ? "" : intent.getAction();
            Log4Util.d("SDK_DEVICE", "[CCPService - onReceive] action = " + action);
            if (action.equals(CCPService.CONNECT_ACTION)) {
                CCPService.this.handleNetChanged(intent);
            } else if (action.equals(CCPService.CHECK_ACTION)) {
                CCPService.this.handleCheckAction();
            }
        }
    }
}

