/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.socket.websocket.response;

import com.useasy.callsdk.socket.java_websocket.framing.Framedata;
import com.useasy.callsdk.socket.websocket.response.ByteBufferResponse;
import com.useasy.callsdk.socket.websocket.response.ErrorResponse;
import com.useasy.callsdk.socket.websocket.response.PingResponse;
import com.useasy.callsdk.socket.websocket.response.PongResponse;
import com.useasy.callsdk.socket.websocket.response.Response;
import com.useasy.callsdk.socket.websocket.response.TextResponse;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;

public class ResponseFactory {
    private static final int POOL_SIZE = 7;
    private static Queue<ErrorResponse> ERROR_RESPONSE_POOL = new ArrayDeque<ErrorResponse>(7);
    private static Queue<TextResponse> TEXT_RESPONSE_POOL = new ArrayDeque<TextResponse>(7);
    private static Queue<ByteBufferResponse> BYTE_BUFFER_RESPONSE_POOL = new ArrayDeque<ByteBufferResponse>(7);
    private static Queue<PingResponse> PING_RESPONSE_POOL = new ArrayDeque<PingResponse>(7);
    private static Queue<PongResponse> PONG_RESPONSE_POOL = new ArrayDeque<PongResponse>(7);

    public static ErrorResponse createErrorResponse() {
        ErrorResponse response2 = ERROR_RESPONSE_POOL.poll();
        if (response2 == null) {
            response2 = new ErrorResponse();
        }
        return response2;
    }

    public static Response<String> createTextResponse() {
        Response response2 = TEXT_RESPONSE_POOL.poll();
        if (response2 == null) {
            response2 = new TextResponse();
        }
        return response2;
    }

    public static Response<ByteBuffer> createByteBufferResponse() {
        Response response2 = BYTE_BUFFER_RESPONSE_POOL.poll();
        if (response2 == null) {
            response2 = new ByteBufferResponse();
        }
        return response2;
    }

    public static Response<Framedata> createPingResponse() {
        Response response2 = PING_RESPONSE_POOL.poll();
        if (response2 == null) {
            response2 = new PingResponse();
        }
        return response2;
    }

    public static Response<Framedata> createPongResponse() {
        Response response2 = PONG_RESPONSE_POOL.poll();
        if (response2 == null) {
            response2 = new PongResponse();
        }
        return response2;
    }

    static void releaseErrorResponse(ErrorResponse response2) {
        ERROR_RESPONSE_POOL.offer(response2);
    }

    static void releaseTextResponse(TextResponse response2) {
        TEXT_RESPONSE_POOL.offer(response2);
    }

    static void releaseByteBufferResponse(ByteBufferResponse response2) {
        BYTE_BUFFER_RESPONSE_POOL.offer(response2);
    }

    static void releasePingResponse(PingResponse response2) {
        PING_RESPONSE_POOL.offer(response2);
    }

    static void releasePongResponse(PongResponse response2) {
        PONG_RESPONSE_POOL.offer(response2);
    }
}

