/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.multimedia;

import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.hisun.phone.core.voice.DeviceImpl;
import com.hisun.phone.core.voice.util.Log4Util;
import java.io.File;
import java.io.FileInputStream;

public final class MediaPlayManager {
    private static MediaPlayManager mInstance = null;
    private AudioFocusLinstener mAudioFoucsManager;
    public static final int ERROR = 0;
    private DeviceImpl listener;
    private String fileUrl = "";
    private State mState = State.NO_SOURCE;
    private MediaPlayer mPlayer = new MediaPlayer();
    private final MediaPlayer.OnCompletionListener mMediaEndListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            try {
                MediaPlayManager.this.mState = State.COMPLETION;
                MediaPlayManager.this.handler.sendEmptyMessage(0);
                MediaPlayManager.this.mPlayer.release();
                MediaPlayManager.this.mAudioFoucsManager.clearFocus();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log4Util.v("SDK_DEVICE", "[MediaPlayManager - setCompletion] File[" + MediaPlayManager.this.fileUrl + "] ErrMsg[" + e.getStackTrace() + "]");
            }
        }
    };
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            try {
                if (MediaPlayManager.this.listener != null && MediaPlayManager.this.mState == State.COMPLETION) {
                    MediaPlayManager.this.listener.onFinishedPlaying();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            super.handleMessage(msg);
        }
    };

    public static synchronized MediaPlayManager getInstance() {
        if (null == mInstance) {
            mInstance = new MediaPlayManager();
        }
        return mInstance;
    }

    public synchronized boolean setSource(String path, boolean speakerOn) {
        this.mState = State.NO_SOURCE;
        if (TextUtils.isEmpty((CharSequence)path) || !new File(path).exists()) {
            Log4Util.d("SDK_DEVICE", "Set file source failed, path " + path);
            return false;
        }
        this.fileUrl = path;
        if (null != this.mPlayer) {
            this.mPlayer.release();
            this.mPlayer = null;
        }
        this.mPlayer = new MediaPlayer();
        this.mAudioFoucsManager.clearFocus();
        int streamtype = 3;
        if (!speakerOn) {
            streamtype = 0;
        }
        this.mPlayer.reset();
        this.mPlayer.setAudioStreamType(streamtype);
        Log4Util.v("SDK_DEVICE", "MediaPlay.streamtype  " + streamtype);
        try {
            FileInputStream inputStream = new FileInputStream(new File(path));
            this.mPlayer.setLooping(false);
            this.mPlayer.setDataSource(inputStream.getFD());
            this.mPlayer.prepare();
            this.mState = State.IDLE;
            this.mPlayer.setOnCompletionListener(this.mMediaEndListener);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log4Util.i("SDK_DEVICE", "[MediaPlayManager] playImp : failed, exception = " + e.getMessage());
            return false;
        }
    }

    public State getState() {
        return this.mState;
    }

    public synchronized boolean play(DeviceImpl listener) {
        this.listener = listener;
        if (State.IDLE == this.mState || State.STOP == this.mState) {
            this.mAudioFoucsManager.requestFocus();
            this.mPlayer.start();
            this.mState = State.PLAYING;
            return true;
        }
        Log4Util.e("SDK_DEVICE", "[MediaPlayManager - play] play file[" + this.fileUrl + "] failed . ");
        return false;
    }

    public synchronized boolean pause() {
        if (State.PLAYING == this.mState) {
            this.mPlayer.pause();
            this.mState = State.IDLE;
            return true;
        }
        return false;
    }

    public synchronized void stop() {
        if (this.mState == State.STOP || this.mState == State.COMPLETION) {
            return;
        }
        this.mAudioFoucsManager.clearFocus();
        this.mPlayer.stop();
        this.mPlayer.release();
        this.mState = State.STOP;
    }

    public synchronized void release() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer.release();
        }
        this.listener = null;
        this.mPlayer = null;
        this.mState = State.NO_SOURCE;
    }

    public synchronized boolean seek(int position) {
        if (State.NO_SOURCE != this.mState) {
            this.mPlayer.seekTo(position);
            return true;
        }
        return false;
    }

    public int getCurrentPosition() {
        if (State.NO_SOURCE != this.mState) {
            return this.mPlayer.getCurrentPosition();
        }
        return 0;
    }

    public int getMediaLength() {
        if (State.NO_SOURCE != this.mState) {
            return this.mPlayer.getDuration();
        }
        return 0;
    }

    public DeviceImpl getListener() {
        return this.listener;
    }

    public void setListener(DeviceImpl listener) {
        this.listener = listener;
    }

    public void setOnAudioFocusLinstener(AudioFocusLinstener linstener) {
        this.mAudioFoucsManager = linstener;
    }

    public static interface AudioFocusLinstener {
        public boolean requestFocus();

        public boolean clearFocus();
    }

    public static enum State {
        NO_SOURCE,
        IDLE,
        PLAYING,
        STOP,
        COMPLETION;

    }
}

