/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.multimedia;

import android.media.AudioRecord;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.hisun.phone.core.voice.model.RecourProductInfo;
import com.hisun.phone.core.voice.multimedia.AmrEncoder;
import com.hisun.phone.core.voice.multimedia.Suppressor.AudioPreProcess;
import com.hisun.phone.core.voice.util.Log4Util;

public class CCPAudioRecorder {
    public static final byte[] AMR_CODEC_HEAD = new byte[]{35, 33, 65, 77, 82, 10};
    public static final byte[] AMR_STOP = new byte[]{35, 33, 72, 73, 83, 85, 78, 83, 84, 79, 80};
    public static final byte[] AMR_ERROR = new byte[]{35, 33, 72, 73, 83, 85, 78, 69, 82, 82, 79, 82};
    public static final int[] sampleRates = new int[]{44100, 16000, 22050, 11025, 8000};
    public static final int mChannelConfig = 2;
    public static final int mAudioEncoding = 2;
    private static final int TIMER_INTERVAL = 120;
    private AudioRecord mAudioRecord = null;
    private RecourProductInfo info = null;
    private Looper mRecordLooper;
    private Handler mRecordHandler;
    private Thread mEncodeThread = null;
    private int mAmplitude = 0;
    private String filePath = null;
    private State state;
    AmrEncoder encoder = null;
    private short nChannels;
    private int mSampleRate;
    private short bSamples;
    private int mBufferSize = -2;
    private int mAudioSource;
    private int mAudioFormat;
    private int mFramePeriod;
    private byte[] mBuffer;
    private boolean isChunked = false;
    private AudioRecord.OnRecordPositionUpdateListener updateListener = new AudioRecord.OnRecordPositionUpdateListener(){

        public void onPeriodicNotification(AudioRecord recorder) {
            block4: {
                int readSize = CCPAudioRecorder.this.mAudioRecord.read(CCPAudioRecorder.this.mBuffer, 0, CCPAudioRecorder.this.mBuffer.length);
                Log4Util.d("SDK_DEVICE", "OnRecordPositionUpdateListener on thread: " + Thread.currentThread().getName());
                Log4Util.v("SDK_DEVICE", "read len :" + readSize);
                if (readSize <= 0 || CCPAudioRecorder.this.encoder == null) break block4;
                CCPAudioRecorder.this.encoder.putData(CCPAudioRecorder.this.mBuffer, readSize);
                if (CCPAudioRecorder.this.bSamples == 16) {
                    for (int i = 0; i < CCPAudioRecorder.this.mBuffer.length / 2; ++i) {
                        short curSample = CCPAudioRecorder.this.getShort(CCPAudioRecorder.this.mBuffer[i * 2], CCPAudioRecorder.this.mBuffer[i * 2 + 1]);
                        if (curSample <= CCPAudioRecorder.this.mAmplitude) continue;
                        CCPAudioRecorder.this.mAmplitude = curSample;
                    }
                } else {
                    for (int i = 0; i < CCPAudioRecorder.this.mBuffer.length; ++i) {
                        if (CCPAudioRecorder.this.mBuffer[i] <= CCPAudioRecorder.this.mAmplitude) continue;
                        CCPAudioRecorder.this.mAmplitude = CCPAudioRecorder.this.mBuffer[i];
                    }
                }
            }
        }

        public void onMarkerReached(AudioRecord recorder) {
        }
    };

    public State getState() {
        return this.state;
    }

    public boolean isChunkedRecord() {
        return this.isChunked;
    }

    public CCPAudioRecorder(int audioSource, int sampleRate, int channelConfig, int audioFormat, boolean isChunked) {
        this.isChunked = isChunked;
        try {
            this.bSamples = audioFormat == 2 ? (short)16 : (short)8;
            this.nChannels = channelConfig == 2 ? (short)1 : (short)2;
            this.mAudioSource = audioSource;
            this.mSampleRate = sampleRate;
            this.mAudioFormat = audioFormat;
            this.mFramePeriod = sampleRate * 120 / 1000;
            this.mBufferSize = this.mFramePeriod * 2 * this.bSamples * this.nChannels / 8;
            Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - Construction method ] bufferSize " + Integer.toString(this.mBufferSize));
            int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat);
            if (this.mBufferSize < minBufferSize) {
                this.mBufferSize = minBufferSize / 2 * 10;
                Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - Construction method ] Increasing buffer size to " + Integer.toString(this.mBufferSize));
            }
            this.mAudioRecord = new AudioRecord(audioSource, sampleRate, channelConfig, audioFormat, this.mBufferSize);
            if (this.mAudioRecord.getState() != 1) {
                throw new Exception("AudioRecord initialization failed");
            }
            AudioPreProcess audioPreProcess = new AudioPreProcess();
            audioPreProcess.init(this.mAudioRecord);
            HandlerThread handlerThread = new HandlerThread("CCPPcmRecorder", -19);
            handlerThread.start();
            this.mRecordLooper = handlerThread.getLooper();
            this.mRecordHandler = new Handler(this.mRecordLooper);
            this.mAudioRecord.setRecordPositionUpdateListener(this.updateListener, this.mRecordHandler);
            this.mAudioRecord.setPositionNotificationPeriod(this.mFramePeriod);
            this.mAmplitude = 0;
            this.filePath = null;
            this.state = State.INITIALIZING;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage() != null) {
                Log4Util.v("SDK_DEVICE", e.getMessage());
            } else {
                Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - Construction method ] Unknown error occured while initializing recording");
            }
            this.state = State.ERROR;
        }
    }

    public void setOutputFile(String argPath) {
        try {
            if (this.state == State.INITIALIZING) {
                this.filePath = argPath;
                this.info = new RecourProductInfo();
                this.info.fileName = argPath;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage() != null) {
                Log4Util.v("SDK_DEVICE", e.getMessage());
            } else {
                Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - setOutputFile ] Unknown error occured while setting output path");
            }
            this.state = State.ERROR;
        }
    }

    public void setSendParameters(String groupId, String userData, String uniqueID) {
        try {
            if (this.state != State.INITIALIZING) {
                throw new Exception("AudioRecord is uninitializing ..");
            }
            this.info.groupId = groupId;
            this.info.userData = userData;
            this.info.uniqueID = uniqueID;
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                Log4Util.v("SDK_DEVICE", e.getMessage());
            } else {
                Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - setSendParameters ] Unknown error occured while setting output path");
            }
            this.state = State.ERROR;
        }
    }

    public int getMaxAmplitude() {
        if (this.state == State.RECORDING) {
            int result = this.mAmplitude;
            this.mAmplitude = 0;
            return result;
        }
        return 0;
    }

    public void prepare() {
        try {
            if (this.state == State.INITIALIZING) {
                if (this.mAudioRecord.getState() == 1 & this.filePath != null) {
                    this.mBuffer = new byte[this.mFramePeriod * this.bSamples / 8 * this.nChannels];
                    Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - prepare ] buffer length : " + this.mFramePeriod * this.bSamples / 8 * this.nChannels);
                    this.encoder = new AmrEncoder(this.info, this.isChunked);
                    this.mEncodeThread = new Thread(this.encoder);
                    this.encoder.setRunning(true);
                    this.mEncodeThread.start();
                    this.state = State.READY;
                } else {
                    Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - prepare ] prepare() method called on uninitialized recorder");
                    this.state = State.ERROR;
                }
            } else {
                Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - prepare ] prepare() method called on illegal state");
                this.release();
                this.state = State.ERROR;
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                Log4Util.v("SDK_DEVICE", e.getMessage());
            } else {
                Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - prepare ] Unknown error occured in prepare()");
            }
            this.state = State.ERROR;
        }
    }

    public void release() {
        if (this.state == State.RECORDING) {
            this.stop();
        }
        if (this.mAudioRecord != null) {
            this.mAudioRecord.release();
            this.mAudioRecord = null;
            if (this.mRecordLooper != null) {
                this.mRecordLooper.quit();
                this.mRecordLooper = null;
            }
            this.mRecordHandler = null;
            Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - release] audioRecorder release .");
        }
        if (this.encoder != null) {
            this.encoder.setRunning(false);
        }
        this.mEncodeThread = null;
        this.filePath = null;
        this.mFramePeriod = 0;
        this.mAmplitude = 0;
        this.encoder = null;
        this.isChunked = false;
        this.mAudioRecord = null;
    }

    public void reset() {
        try {
            if (this.state != State.ERROR) {
                this.release();
                this.filePath = null;
                this.mAmplitude = 0;
                this.mAudioRecord = new AudioRecord(this.mAudioSource, this.mSampleRate, this.nChannels + 1, this.mAudioFormat, this.mBufferSize);
                this.state = State.INITIALIZING;
            }
        }
        catch (Exception e) {
            Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - reset] " + e.getMessage());
            this.state = State.ERROR;
        }
    }

    public void start() {
        if (this.state == State.READY) {
            this.mAudioRecord.startRecording();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int len = this.mAudioRecord.read(this.mBuffer, 0, this.mBuffer.length);
            this.state = State.RECORDING;
            Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - start] To start recording, first read the data length : " + len);
        } else {
            Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - start] start() called on illegal state");
            this.state = State.ERROR;
        }
    }

    public void stop() {
        if (this.state == State.RECORDING) {
            this.mAudioRecord.stop();
            this.mAudioRecord.setRecordPositionUpdateListener(null);
            this.state = State.STOPPED;
            this.encoder.setRunning(false);
            this.encoder.putData(new byte[0], 0);
            Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - stop] audioRecorder stop .");
        } else {
            Log4Util.v("SDK_DEVICE", "[CCPAudioRecorder - stop]  stop() called on illegal state");
            this.state = State.ERROR;
        }
    }

    public void cancleEnable(boolean isCancle) {
        if (this.state == State.RECORDING && this.encoder != null) {
            this.encoder.setIsCancle(isCancle);
        }
    }

    private short getShort(byte argB1, byte argB2) {
        return (short)(argB1 | argB2 << 8);
    }

    public static enum State {
        INITIALIZING,
        READY,
        RECORDING,
        ERROR,
        STOPPED;

    }
}

