/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.model.setup;

import android.text.TextUtils;
import java.util.Map;

public class UserAgentConfig {
    public static final String KEY_SID = "ccp_key_sid";
    public static final String KEY_PWD = "ccp_key_pwd";
    public static final String KEY_SUBID = "ccp_key_subid";
    public static final String KEY_SUBPWD = "ccp_key_subpwd";
    public static final String KEY_IP = "ccp_key_ip";
    public static final String KEY_PORT = "ccp_key_port";
    public static final String KEY_UA = "ccp_key_useragent";
    public static final String KEY_PRIVATECLOUD = "ccp_key_privateCloud";
    public static final String KEY_VALIDATE = "ccp_key_validate";
    private String sid;
    private String password;
    private String ua_server;
    private int ua_port;
    private String subaccountid;
    private String subpassword;
    private String privateCloud;
    private String validate;
    private String ua;
    private String audio_decoder;
    private String ringtone;
    private int prior;
    private String p2pServerPort = "42.121.15.99:3478";

    public final String getRequestUrl(String protocol) {
        if (!this.checkHttpScheme()) {
            if ("HTTP".equalsIgnoreCase(protocol)) {
                return "http://" + this.ua_server + ":8881";
            }
            return "https://" + this.ua_server + ":" + this.ua_port;
        }
        return this.ua_server + ":" + this.ua_port;
    }

    public UserAgentConfig(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            throw new RuntimeException("sdk need params is null.");
        }
        if (!(params.containsKey(KEY_IP) && params.containsKey(KEY_PORT) && params.containsKey(KEY_PWD) && params.containsKey(KEY_SID) && params.containsKey(KEY_UA))) {
            throw new RuntimeException("sdk need params errors.");
        }
        try {
            if (params.containsKey(KEY_VALIDATE) && params.containsKey(KEY_PRIVATECLOUD)) {
                this.privateCloud = params.get(KEY_PRIVATECLOUD);
                this.validate = params.get(KEY_VALIDATE);
            }
            this.sid = params.get(KEY_SID);
            this.password = params.get(KEY_PWD);
            this.ua_server = params.get(KEY_IP);
            this.ua_port = Integer.parseInt(params.get(KEY_PORT));
            this.subaccountid = params.get(KEY_SUBID);
            this.subpassword = params.get(KEY_SUBPWD);
            this.ua = params.get(KEY_UA);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("create UserAgentConfig failed. params is incorrect." + e.toString());
        }
        finally {
            if (params != null) {
                params.clear();
                params = null;
            }
        }
    }

    private boolean checkHttpScheme() {
        return TextUtils.isEmpty((CharSequence)this.ua_server) || this.ua_server.toLowerCase().startsWith("https://") || this.ua_server.toLowerCase().startsWith("http://");
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getUa_server() {
        return this.ua_server;
    }

    public void setUa_server(String ua_server) {
        this.ua_server = ua_server;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getUa_port() {
        return this.ua_port;
    }

    public void setUa_port(int ua_port) {
        this.ua_port = ua_port;
    }

    public String getAudio_decoder() {
        return this.audio_decoder;
    }

    public void setAudio_decoder(String audio_decoder) {
        this.audio_decoder = audio_decoder;
    }

    public String getRingtone() {
        return this.ringtone;
    }

    public void setRingtone(String ringtone) {
        this.ringtone = ringtone;
    }

    public int getPrior() {
        return this.prior;
    }

    public void setPrior(int prior) {
        this.prior = prior;
    }

    public String getUa() {
        return this.ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getSubaccountid() {
        return this.subaccountid;
    }

    public void setSubaccountid(String subaccountid) {
        this.subaccountid = subaccountid;
    }

    public String getSubpassword() {
        return this.subpassword;
    }

    public void setSubpassword(String subpassword) {
        this.subpassword = subpassword;
    }

    public String getPrivateCloud() {
        return this.privateCloud;
    }

    public void setPrivateCloud(String privateCloud) {
        this.privateCloud = privateCloud;
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    public void released() {
        this.sid = null;
        this.password = null;
        this.ua_server = null;
        this.audio_decoder = null;
        this.ringtone = null;
        this.ua = null;
        this.subaccountid = null;
        this.subpassword = null;
        this.p2pServerPort = null;
        this.privateCloud = null;
        this.validate = null;
    }

    public String getP2pServerPort() {
        return this.p2pServerPort;
    }

    public void setP2pServerPort(String p2pServerPort) {
        this.p2pServerPort = p2pServerPort;
    }
}

