/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.model.setup;

import android.text.TextUtils;
import com.hisun.phone.core.voice.model.Response;
import java.util.ArrayList;

public class SoftSwitch
extends Response {
    private static final long serialVersionUID = -7103314886132705486L;
    private ArrayList<Clpss> mClpsses = new ArrayList();
    private String P2PServerPort;
    private String control;
    private String nwgid;

    public String getP2PServerPort() {
        return this.P2PServerPort;
    }

    public void setP2PServerPort(String p2pServerPort) {
        this.P2PServerPort = p2pServerPort;
    }

    public void addSoftClpsses(Clpss clpss) {
        if (this.mClpsses == null) {
            this.mClpsses = new ArrayList();
        }
        this.mClpsses.add(clpss);
    }

    public void clearSoftClpsses() {
        if (this.mClpsses != null) {
            this.mClpsses.clear();
        }
    }

    public ArrayList<Clpss> getSoftClpss() {
        if (this.mClpsses == null) {
            this.mClpsses = new ArrayList();
        }
        return this.mClpsses;
    }

    public String getControl() {
        return this.control;
    }

    public void setNetworkGroupId(String nwgid) {
        this.nwgid = nwgid;
    }

    public String getNetworkGroupId() {
        return this.nwgid;
    }

    public void setControl(String control) {
        this.control = control;
    }

    public String toXMLBody() {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?>\t\n\r\n");
        sb.append("<Response>\r\n");
        sb.append("\t<statusCode>").append(this.statusCode).append("</statusCode>\r\n");
        if (this.getSoftClpss() != null && !this.getSoftClpss().isEmpty()) {
            sb.append("\t<Switch>\r\n");
            for (Clpss clpss : this.getSoftClpss()) {
                if (clpss == null) continue;
                sb.append("\t\t<clpss>\r\n");
                sb.append("\t\t\t<ip>").append(clpss.getIp()).append("</ip>\r\n");
                sb.append("\t\t\t<port>").append(clpss.getPort()).append("</port>\r\n");
                sb.append("\t\t\t</clpss>\r\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.getControl())) {
                sb.append("\t\t<control>").append(this.getControl()).append("</control>\r\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.getP2PServerPort())) {
                sb.append("\t\t<p2p>").append(this.getP2PServerPort()).append("</p2p>\r\n");
            }
            sb.append("\t</Switch>\r\n");
        }
        sb.append("</Response>\r\n");
        return sb.toString();
    }

    public static class Clpss {
        public String ip;
        public String port;

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public int getPort() {
            try {
                return Integer.parseInt(this.port);
            }
            catch (Exception e) {
                return 0;
            }
        }

        public void setPort(String port) {
            this.port = port;
        }
    }
}

