/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.SurfaceView;
import android.view.View;
import com.CCP.phone.CCPCallEvent;
import com.CCP.phone.CameraInfo;
import com.CCP.phone.NativeInterface;
import com.CCP.phone.VideoSnapshot;
import com.hisun.phone.core.voice.CCPCall;
import com.hisun.phone.core.voice.CCPCallImpl;
import com.hisun.phone.core.voice.CallControlManager;
import com.hisun.phone.core.voice.CallbackHandler;
import com.hisun.phone.core.voice.Device;
import com.hisun.phone.core.voice.DeviceListener;
import com.hisun.phone.core.voice.exception.CCPRecordException;
import com.hisun.phone.core.voice.listener.OnChatroomListener;
import com.hisun.phone.core.voice.listener.OnIMListener;
import com.hisun.phone.core.voice.listener.OnInterphoneListener;
import com.hisun.phone.core.voice.listener.OnProcessOriginalAudioDataListener;
import com.hisun.phone.core.voice.listener.OnTriggerSrtpListener;
import com.hisun.phone.core.voice.listener.OnVideoConferenceListener;
import com.hisun.phone.core.voice.listener.OnVideoMemberFrameListener;
import com.hisun.phone.core.voice.listener.OnVoIPListener;
import com.hisun.phone.core.voice.model.CallStatisticsInfo;
import com.hisun.phone.core.voice.model.CloopenReason;
import com.hisun.phone.core.voice.model.DownloadInfo;
import com.hisun.phone.core.voice.model.NetworkStatistic;
import com.hisun.phone.core.voice.model.Response;
import com.hisun.phone.core.voice.model.chatroom.Chatroom;
import com.hisun.phone.core.voice.model.chatroom.ChatroomDismissMsg;
import com.hisun.phone.core.voice.model.chatroom.ChatroomMember;
import com.hisun.phone.core.voice.model.chatroom.ChatroomMsg;
import com.hisun.phone.core.voice.model.chatroom.ChatroomRemoveMemberMsg;
import com.hisun.phone.core.voice.model.im.IMTextMsg;
import com.hisun.phone.core.voice.model.im.InstanceMsg;
import com.hisun.phone.core.voice.model.interphone.InterphoneMember;
import com.hisun.phone.core.voice.model.interphone.InterphoneMsg;
import com.hisun.phone.core.voice.model.setup.UserAgentConfig;
import com.hisun.phone.core.voice.model.videoconference.VideoConference;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceDismissMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceMember;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceRemoveMemberMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoPartnerPortrait;
import com.hisun.phone.core.voice.multimedia.AudioFoucsManager;
import com.hisun.phone.core.voice.multimedia.AudioRecordManager;
import com.hisun.phone.core.voice.multimedia.MediaManager;
import com.hisun.phone.core.voice.multimedia.MediaPlayManager;
import com.hisun.phone.core.voice.net.ApiParser;
import com.hisun.phone.core.voice.opts.ConferenceOptions;
import com.hisun.phone.core.voice.util.AdaptationTools;
import com.hisun.phone.core.voice.util.ConferenceUtils;
import com.hisun.phone.core.voice.util.Cryptos;
import com.hisun.phone.core.voice.util.Log4Util;
import com.hisun.phone.core.voice.util.VoiceUtil;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class DeviceImpl
extends Device
implements CCPCallEvent {
    private Context context;
    private String capabilityToken;
    private PendingIntent incomingIntent;
    private CallControlManager callControlManager;
    private MediaManager mediaManager;
    private AudioRecordManager audRecordManager;
    private MediaPlayManager mediaPlayManager;
    private TelephonyManager mTelephonyManager;
    private Device.CallType makeCallType;
    private CallbackHandler mCallbackHandler;
    private final UUID uuid = UUID.randomUUID();
    private volatile boolean online = false;
    private volatile boolean keepingCall = false;
    private static Map<String, SurfaceView> mRemoteViewMap = new HashMap<String, SurfaceView>();
    private volatile boolean voiceRecording = false;
    private volatile boolean voicePlaying = false;
    private boolean isAutoJoin = true;
    private Map<String, String> userAgentParams;
    static final int WAKE_TIME = 15000;
    private volatile boolean isIncomingCall = false;
    private final LinkedList<String> incomingCallIDArray = new LinkedList();
    private final LinkedList<String> outgoingCallIDArray = new LinkedList();
    private final HashMap<String, Object> multiViewHashMap = new HashMap();
    private String selfPhone = "";
    private String selfName = "";
    private String confpwd = "";
    private SurfaceView localView;
    private String ccpCallingID;
    private Device.RunningType runningType = Device.RunningType.RunningType_None;
    private String mOriginalConferenceNo;
    Device.CCPListenerInfo mListenerInfo;
    Object mLocks = new Object();
    long mt = 0L;
    private Device.CallType incomingCallType;
    private int currVolume = 0;
    public static final int RING_TIME = 60000;
    public static final Parcelable.Creator<DeviceImpl> CREATOR = new Parcelable.Creator<DeviceImpl>(){

        public DeviceImpl createFromParcel(Parcel in) {
            UUID uuid = (UUID)in.readSerializable();
            return CCPCallImpl.getInstance().findDeviceByUUID(uuid);
        }

        public DeviceImpl[] newArray(int size) {
            throw new UnsupportedOperationException();
        }
    };

    Device.CCPListenerInfo getCCPListenerInfo() {
        if (this.mListenerInfo != null) {
            return this.mListenerInfo;
        }
        this.mListenerInfo = new Device.CCPListenerInfo();
        return this.mListenerInfo;
    }

    DeviceImpl() {
        this.context = CCPCallImpl.getInstance().getContext();
        this.callControlManager = CCPCallImpl.getInstance().getCallControlManager();
        this.mediaManager = CCPCallImpl.getInstance().getMediaManager();
        this.audRecordManager = CCPCallImpl.getInstance().getAudioRecordManager();
        this.mediaPlayManager = CCPCallImpl.getInstance().getMediaPlayManager();
        this.mTelephonyManager = (TelephonyManager)this.getContext().getSystemService("phone");
    }

    DeviceImpl(DeviceListener deviceListener, Map<String, String> params) throws Exception {
        this();
        this.setDeviceListener(deviceListener);
        this.setCapabilityToken(params);
        this.setCallbackHandler(new CallbackHandler(this.getCCPListenerInfo()));
    }

    DeviceImpl(DeviceImpl d) throws Exception {
        this(d.getDeviceListener(), d.getUserAgentParams());
    }

    private void setCapabilityToken(final Map<String, String> params) throws Exception {
        this.userAgentParams = params;
        final CallControlManager mCallManager = this.callControlManager;
        this.callControlManager.postCommand(new Runnable(){

            @Override
            public void run() {
                try {
                    mCallManager.init(DeviceImpl.this, new UserAgentConfig(params));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DeviceImpl.this.onConnectError(DeviceListener.Reason.UNKNOWN.getStatus());
                }
            }
        });
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setDeviceListener(DeviceListener inListener) {
        this.getCCPListenerInfo().deviceListener = inListener;
        this.audRecordManager.setListener(this);
        this.mediaPlayManager.setListener(this);
        this.mediaPlayManager.setOnAudioFocusLinstener(new AudioFoucsManager(this.getContext()));
    }

    public void setCallbackHandler(CallbackHandler handler) {
        this.mCallbackHandler = handler;
    }

    public void sendToTarget(int what, int arg1, int arg2, Object object) {
        if (this.mCallbackHandler != null) {
            this.mCallbackHandler.obtainMessage(what, arg1, arg2, object).sendToTarget();
        }
    }

    public void sendToTarget(int what, Object object) {
        if (this.mCallbackHandler != null) {
            this.mCallbackHandler.obtainMessage(what, object).sendToTarget();
        }
    }

    private void sendTarget(int what, int arg1, Object obj) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.mCallbackHandler != null) {
            Message obtainMessage = this.mCallbackHandler.obtainMessage(what);
            obtainMessage.arg1 = arg1;
            obtainMessage.obj = obj;
            obtainMessage.sendToTarget();
        }
        Log4Util.v("SDK_DEVICE", "time consum " + (System.currentTimeMillis() - currentTimeMillis) + "mils");
    }

    @Override
    public void setIncomingIntent(PendingIntent paramPendingIntent) {
        this.incomingIntent = paramPendingIntent;
        CCPCallImpl.getInstance().deviceChanged(this);
    }

    void destroy() {
        try {
            this.online = false;
            this.context = null;
            this.capabilityToken = null;
            this.getCCPListenerInfo().release();
            this.mListenerInfo = null;
            this.incomingIntent = null;
            this.callControlManager = null;
            this.mediaManager = null;
            this.selfName = null;
            this.selfPhone = null;
            this.confpwd = null;
            this.localView = null;
            if (this.audRecordManager != null) {
                this.audRecordManager.release();
            }
            if (this.userAgentParams != null) {
                this.userAgentParams.clear();
            }
            if (this.incomingCallIDArray != null) {
                this.incomingCallIDArray.clear();
            }
            if (this.outgoingCallIDArray != null) {
                this.outgoingCallIDArray.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void release() {
        CCPCall.shutdown();
    }

    @Override
    public void setSelfName(String name) {
        if (name == null || name.length() == 0) {
            Log4Util.e("[DeviceImpl - setSelfUserName] name is null.");
            return;
        }
        this.selfName = "nickname=" + name + ";";
        Log4Util.i("[DeviceImpl - setSelfUserName] set user name: " + this.selfName);
        if (this.callControlManager != null) {
            this.callControlManager.setUserData(2, this.getSelfInfo());
        }
    }

    void setConfpwd(String pwd) {
        if (TextUtils.isEmpty((CharSequence)pwd)) {
            Log4Util.e("[DeviceImpl - setConfpwd] pwd is null.");
            return;
        }
        this.confpwd = "confpwd=" + Cryptos.toBase64QES("10C173A98BAD2FF723BE0E81A9D85965", pwd) + ";";
        Log4Util.i("[DeviceImpl - setConfpwd] set conference password: " + pwd);
        if (this.callControlManager != null) {
            this.callControlManager.setUserData(2, this.getSelfInfo());
        }
    }

    private String getSelfInfo() {
        StringBuffer sb = new StringBuffer();
        if (!TextUtils.isEmpty((CharSequence)this.selfName)) {
            sb.append(this.selfName);
        }
        if (!TextUtils.isEmpty((CharSequence)this.selfPhone)) {
            sb.append(this.selfPhone);
        }
        if (!TextUtils.isEmpty((CharSequence)this.confpwd)) {
            sb.append(this.confpwd);
        }
        return sb.length() != 0 ? sb.toString() : "";
    }

    @Override
    public void setSelfPhoneNumber(String mobile) {
        if (mobile == null || mobile.length() == 0) {
            Log4Util.e("[DeviceImpl - setSelfPhoneNumber] mobile is null.");
            return;
        }
        this.selfPhone = "tel=" + mobile + ";";
        Log4Util.i("[DeviceImpl - setSelfPhoneNumber] set mobile number: " + this.selfPhone);
        if (this.callControlManager != null) {
            this.callControlManager.setUserData(2, this.getSelfInfo());
        }
    }

    private void clearUserData() {
        if (this.callControlManager != null) {
            this.callControlManager.setUserData(2, "");
        }
    }

    private void resetUserData() {
        if (this.callControlManager != null) {
            this.callControlManager.setUserData(2, this.getSelfInfo());
        }
    }

    @Override
    public void setVideoView(String userid, SurfaceView remoteView, SurfaceView localView) {
        mRemoteViewMap.put(userid, remoteView);
        this.localView = localView;
    }

    public static SurfaceView getVideoView(String account) {
        return mRemoteViewMap.get(account);
    }

    @Override
    public Device.State isOnline() {
        return this.online ? Device.State.ONLINE : Device.State.OFFLINE;
    }

    boolean isKeepingCall() {
        return this.keepingCall;
    }

    boolean isHoldSystemCall() {
        return this.mTelephonyManager.getCallState() == 2;
    }

    @Override
    public String makeCall(Device.CallType callType, String accountId) {
        this.ccpCallingID = this.makeCallByRunningType(callType, accountId, Device.RunningType.RunningType_Voip);
        return this.ccpCallingID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String makeCallByRunningType(Device.CallType callType, String accountId, Device.RunningType rType) {
        if (this.runningType != Device.RunningType.RunningType_None) {
            this.onMakeCallFailed("0", 170001);
            return null;
        }
        if (!this.checkCallToken()) {
            Log4Util.e("[DeviceImpl - makeCall] your server capability token forbid your call.");
            this.onMakeCallFailed("", 2);
            return null;
        }
        if (this.isKeepingCall() || this.isHoldSystemCall()) {
            Log4Util.e("SDK_DEVICE", "Currently hold a call.");
            return this.getCurrentCall();
        }
        this.makeCallType = callType;
        if (this.callControlManager != null && Math.abs(System.currentTimeMillis() - this.mt) > 2000L) {
            this.mt = System.currentTimeMillis();
            if (callType == Device.CallType.VIDEO) {
                if (mRemoteViewMap.get(accountId) != null) {
                    this.callControlManager.setVideoView(accountId, mRemoteViewMap.get(accountId), null);
                    Log4Util.i("SDK_DEVICE", "[DeviceImpl -  makeCall] video view has been setting.");
                } else {
                    Log4Util.w("SDK_DEVICE", "[DeviceImpl -  makeCall] video view is null.");
                }
            } else if (VoiceUtil.isP2LCallNumnber(accountId)) {
                this.setFirewallPolicy(0);
            }
            this.resetUserData();
            this.runningType = rType;
            final String callid = this.callControlManager.makeCall(callType.getValue(), accountId);
            Log4Util.i("SDK_DEVICE", "[DeviceImpl - makeCallByRunningType] Current SDK  runningType " + this.runningType.getValue());
            if (this.runningType == Device.RunningType.RunningType_Voip) {
                LinkedList<String> linkedList = this.outgoingCallIDArray;
                synchronized (linkedList) {
                    this.outgoingCallIDArray.add(callid);
                }
            }
            if (TextUtils.isEmpty((CharSequence)callid)) {
                this.callControlManager.postCommand(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(500L);
                            DeviceImpl.this.onMakeCallFailed(callid, 170000);
                            DeviceImpl.this.runningType = Device.RunningType.RunningType_None;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return callid;
        }
        throw new RuntimeException("Call intervals not less than 2000s");
    }

    @Override
    public void releaseCall(String callid) {
        this.keepingCall = false;
        this.makeCallType = null;
        this.incomingCallType = null;
        this.mOriginalConferenceNo = null;
        if (this.callControlManager != null) {
            this.callControlManager.releaseCall(callid, 0);
        }
        this.onCallReleased(callid);
    }

    @Override
    public void acceptCall(String callid, String account) {
        if (this.callControlManager != null) {
            if (this.incomingCallType == Device.CallType.VIDEO) {
                if (mRemoteViewMap.get(account) != null) {
                    this.callControlManager.setVideoView(account, mRemoteViewMap.get(account), null);
                    Log4Util.i("SDK_DEVICE", "[DeviceImpl -  acceptCall] video view has been setting.");
                } else {
                    Log4Util.w("SDK_DEVICE", "[DeviceImpl -  acceptCall] video view is null.");
                }
            }
            this.callControlManager.acceptCall(callid);
        }
    }

    @Override
    public void rejectCall(String callid) {
        this.rejectCall(callid, 3);
    }

    @Override
    public void rejectCall(String callid, int reason) {
        if (this.callControlManager != null) {
            this.keepingCall = false;
            this.makeCallType = null;
            this.incomingCallType = null;
            this.callControlManager.rejectCall(callid, reason);
        }
    }

    @Override
    public void pauseCall(String callid) {
        if (this.callControlManager != null) {
            this.callControlManager.pauseCall(callid);
        }
    }

    @Override
    public void resumeCall(String callid) {
        if (this.callControlManager != null) {
            this.callControlManager.resumeCall(callid);
        }
    }

    @Override
    public int transferCall(String callid, String destionation) {
        return this.transferCall(callid, destionation, Device.CallType.VOICE);
    }

    @Override
    public int transferCall(String callid, String destionation, Device.CallType callType) {
        if (this.callControlManager != null) {
            return this.callControlManager.transferCall(callid, destionation, callType.getValue());
        }
        return 170006;
    }

    public void cancelCall(String callid) {
        if (this.runningType == Device.RunningType.RunningType_Interphone || this.runningType == Device.RunningType.RunningType_ChatRoom) {
            return;
        }
        if (this.callControlManager != null) {
            this.callControlManager.cancelCall(callid);
        }
    }

    @Override
    public String getCurrentCall() {
        if (this.callControlManager != null) {
            return this.callControlManager.getCurrentCall();
        }
        return null;
    }

    @Override
    public void sendDTMF(String callid, char dtmf) {
        if (this.callControlManager != null) {
            this.callControlManager.sendDTMF(callid, dtmf);
        }
    }

    @Override
    public void makeCallback(String selfPhone, String destPhone) {
        this.makeCallback(selfPhone, destPhone, null, null);
    }

    @Override
    public void makeCallback(String selfPhoneNumber, String destPhoneNumber, String srcSerNum, String destSerNum) {
        if (this.runningType != Device.RunningType.RunningType_None) {
            return;
        }
        if (this.callControlManager != null) {
            this.resetUserData();
            this.callControlManager.makeCallBack(selfPhoneNumber, destPhoneNumber, srcSerNum, destSerNum);
        }
    }

    @Override
    public void enableLoudsSpeaker(boolean enable) {
        try {
            if (enable == this.getLoudsSpeakerStatus()) {
                return;
            }
            if (this.callControlManager != null) {
                this.callControlManager.enableLoudsSpeaker(enable);
            }
            Log4Util.d("SDK_DEVICE", "LoudsSpeaker is " + enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean getLoudsSpeakerStatus() {
        return this.callControlManager.getLoudsSpeakerStatus();
    }

    @Override
    public void setMute(boolean isMute) {
        try {
            if (isMute == this.getMuteStatus()) {
                return;
            }
            this.callControlManager.setMute(isMute);
        }
        catch (Exception e) {
            Log4Util.d("SDK_DEVICE", "[DeviceImpl -  setMute] " + e.getMessage());
        }
    }

    @Override
    public boolean getMuteStatus() {
        return this.callControlManager.getMuteStatus();
    }

    public void OpenSpeaker() {
        try {
            AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
            audioManager.setMode(3);
            if (!audioManager.isSpeakerphoneOn()) {
                audioManager.setSpeakerphoneOn(true);
                audioManager.setStreamVolume(0, audioManager.getStreamMaxVolume(0), 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void CloseSpeaker() {
        try {
            AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
            if (audioManager != null) {
                audioManager.setMode(3);
                audioManager.setSpeakerphoneOn(false);
                audioManager.setStreamVolume(0, 5, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void _OpenSpeaker() {
        try {
            AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
            audioManager.setMode(2);
            this.currVolume = audioManager.getStreamVolume(0);
            if (!audioManager.isSpeakerphoneOn()) {
                audioManager.setMode(-2);
                audioManager.setSpeakerphoneOn(true);
                audioManager.setStreamVolume(0, audioManager.getStreamMaxVolume(0), 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void _CloseSpeaker() {
        try {
            AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
            if (audioManager != null && audioManager.isSpeakerphoneOn()) {
                audioManager.setSpeakerphoneOn(false);
                audioManager.setStreamVolume(0, this.currVolume, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public DeviceListener getDeviceListener() {
        return this.getCCPListenerInfo().deviceListener;
    }

    @Override
    public void onCallProceeding(String callid) {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallProceeding] " + callid);
        if (AdaptationTools.isXinweiDevice()) {
            this.CloseSpeaker();
        }
        if (this.runningType == Device.RunningType.RunningType_Voip) {
            this.sendToTarget(5, 8203, -1, callid);
        }
    }

    @Override
    public void onCallAlerting(String callid) {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallAlerting] " + callid);
        this.keepingCall = true;
        this.mediaManager.queueSound(MediaManager.StockSound.OUTGOING, 60000L, new MediaManager.SoundPlaybackListener(){

            @Override
            public void onCompletion() {
                Log4Util.i("[DeviceImpl - makeCall]MediaManager.StockSound.OUTGOING onCompletion.");
            }
        });
        this.sendToTarget(5, 8196, -1, callid);
    }

    @Override
    public void onCallAnswered(String callid) {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallAnswered] " + callid);
        this.keepingCall = true;
        this.mediaManager.stop();
        Bundle bundle = this.getCloopenReasonBundle(CallbackHandler.getCloopenReason(0));
        bundle.putString("com.ccp.phone.interphone.confNo", this.mOriginalConferenceNo);
        if (this.runningType == Device.RunningType.RunningType_Interphone) {
            this.sendTarget(2, 8213, bundle);
            return;
        }
        if (this.runningType == Device.RunningType.RunningType_ChatRoom) {
            bundle.putString("com.ccp.phone.interphone.confNo", ConferenceUtils.getProcesConferenceNo(this.mOriginalConferenceNo));
            this.sendTarget(1, 8217, bundle);
            return;
        }
        if (this.runningType == Device.RunningType.RunningType_VideoConference) {
            bundle.putString("com.ccp.phone.interphone.confNo", ConferenceUtils.getProcesConferenceNo(this.mOriginalConferenceNo));
            this.sendTarget(4, 8226, bundle);
            return;
        }
        this.sendToTarget(5, 8197, -1, callid);
    }

    @Override
    public void onCallPaused(String callid) {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallPaused] " + callid);
        if (this.runningType == Device.RunningType.RunningType_Voip) {
            this.sendToTarget(5, 8198, -1, callid);
        }
    }

    @Override
    public void onCallPausedByRemote(String callid) {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallPausedByRemote] " + callid);
        if (this.runningType == Device.RunningType.RunningType_Voip) {
            this.sendToTarget(5, 8199, -1, callid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCallReleased(String callid) {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallReleased] " + callid);
        boolean isUpwards = false;
        try {
            LinkedList<String> linkedList = this.incomingCallIDArray;
            synchronized (linkedList) {
                if (this.incomingCallIDArray.size() > 0) {
                    for (String element : this.incomingCallIDArray) {
                        if (element.equals(callid)) {
                            isUpwards = true;
                            this.incomingCallIDArray.clear();
                            Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallReleased] removed incoming callid success, it's " + callid + ", size = " + this.incomingCallIDArray.size());
                            continue;
                        }
                        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallReleased] removed incoming callid failed, it's no equals, callid: " + callid + ", first = " + element);
                    }
                }
            }
            linkedList = this.outgoingCallIDArray;
            synchronized (linkedList) {
                if (this.outgoingCallIDArray.size() > 0) {
                    for (String element : this.outgoingCallIDArray) {
                        if (element.equals(callid)) {
                            isUpwards = true;
                            this.outgoingCallIDArray.clear();
                            Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallReleased] removed outgoing callid success, it's " + callid + ", size = " + this.incomingCallIDArray.size());
                            continue;
                        }
                        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallReleased] removed outgoing callid failed, it's no equals, callid: " + callid + ", first = " + element);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isUpwards = true;
        }
        this.enableLoudsSpeaker(false);
        NativeInterface.UNInitAudioDevice();
        this.confpwd = null;
        if (isUpwards) {
            this.keepingCall = false;
            this.isAutoJoin = true;
            this.makeCallType = null;
            this.incomingCallType = null;
            this.mOriginalConferenceNo = null;
            this.ccpCallingID = null;
            this.mediaManager.stop();
            Log4Util.i("SDK_DEVICE", "[DeviceImpl - onIncomingCallReceived] Current SDK  runningType " + this.runningType.getValue());
            if (this.runningType == Device.RunningType.RunningType_Voip) {
                this.runningType = Device.RunningType.RunningType_None;
                this.sendToTarget(5, 8200, -1, callid);
            }
            Log4Util.e("SDK_DEVICE", "[DeviceImpl - onCallReleased] upwards callid: " + callid);
            this.setFirewallPolicy(1);
        }
    }

    @Override
    public void onCallTransfered(String callid, String destionation) {
        if (this.runningType == Device.RunningType.RunningType_Voip) {
            Log4Util.i("SDK_DEVICE", "[DeviceImpl - onCallTransfered] " + callid);
            this.sendToTarget(5, 8201, -1, callid + " ," + destionation);
        }
    }

    @Override
    public void onConnectError(int reason) {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onConnectError] " + reason);
        this.online = false;
        DeviceListener.Reason r = DeviceListener.Reason.UNKNOWN;
        switch (reason) {
            case 0: {
                r = DeviceListener.Reason.UNKNOWN;
                break;
            }
            case 1: {
                r = DeviceListener.Reason.NOTRESPONSE;
                break;
            }
            case 2: {
                r = DeviceListener.Reason.AUTHFAILED;
                break;
            }
            case 3: {
                r = DeviceListener.Reason.DECLINED;
                break;
            }
            case 4: {
                r = DeviceListener.Reason.NOTFOUND;
                break;
            }
            case 5: {
                r = DeviceListener.Reason.CALLMISSED;
                break;
            }
            case 6: {
                r = DeviceListener.Reason.BUSY;
                break;
            }
            case 7: 
            case 170005: 
            case 170019: {
                r = DeviceListener.Reason.NOTNETWORK;
                break;
            }
            case 8: {
                if (this.callControlManager == null) break;
                this.callControlManager.getSoftSwitchAddress();
                break;
            }
            case 9: {
                r = DeviceListener.Reason.KICKEDOFF;
                break;
            }
            case 11: {
                r = DeviceListener.Reason.INVALIDPROXY;
            }
        }
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onConnectError] " + r.name());
        this.sendToTarget(7, 8193, -1, r);
    }

    @Override
    public void onConnected() {
        this.online = true;
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onConnected] connect success.");
        this.sendToTarget(7, 8192, -1, null);
    }

    @Override
    public void onDisconnect() {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onDisconnect] connect failed.");
        this.onConnectError(1);
    }

    @Override
    public void onDtmfReceived(String callid, char dtmf) {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onDtmfReceived] callid: " + callid + ", dtmf: " + dtmf);
        if (this.getCCPListenerInfo().mOnVoIPListener != null) {
            // empty if block
        }
    }

    private boolean checkCallToken() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIncomingCallReceived(Device.CallType type, final String callid, String caller) {
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onIncomingCallReceived] onIncoming received: Type: " + type + ", callid: " + callid + ", caller: " + caller);
        if (this.runningType != Device.RunningType.RunningType_None || this.isHoldSystemCall()) {
            Log4Util.i("SDK_DEVICE", "[DeviceImpl - onIncomingCallReceived] Current is not idle , runningType " + this.runningType.getValue() + " , then reject.");
            if (this.callControlManager != null) {
                this.callControlManager.rejectCall(callid, 6);
            }
            return;
        }
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onIncomingCallReceived] Current SDK  runningType " + this.runningType.getValue());
        try {
            LinkedList<String> linkedList = this.incomingCallIDArray;
            synchronized (linkedList) {
                if (this.incomingCallIDArray.size() > 0) {
                    this.releaseCall(callid);
                    Log4Util.i("SDK_DEVICE", "[DeviceImpl - onIncomingCallReceived] another call incoming, so release another callid: " + callid);
                    return;
                }
                this.incomingCallIDArray.add(callid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isKeepingCall() || this.isHoldSystemCall()) {
            Log4Util.d("SDK_DEVICE", "Currently hold other call, system call or voip call.");
            return;
        }
        this.isIncomingCall = true;
        this.incomingCallType = type;
        if (this.incomingIntent != null) {
            this.runningType = Device.RunningType.RunningType_Voip;
            Intent intent = new Intent();
            intent.putExtra("com.ccp.phone.calltype", (Serializable)((Object)type));
            intent.putExtra("com.ccp.phone.callid", callid);
            intent.putExtra("com.ccp.phone.caller", caller);
            String[] infos = VoiceUtil.split(this.callControlManager.getUserData(2), ";");
            if (infos != null) {
                intent.putExtra("com.ccp.phone.remote", infos);
                for (int i = 0; i < infos.length; ++i) {
                    Log4Util.i("[DeviceImpl - onIncomingCallReceived] get remote caller params: " + infos[i] + "\r\n");
                }
            }
            try {
                this.incomingIntent.send(this.getContext(), 0, intent);
                this.mediaManager.queueSound(MediaManager.StockSound.INCOMING, 60000L, new MediaManager.SoundPlaybackListener(){

                    @Override
                    public void onCompletion() {
                        Log4Util.i("[DeviceImpl - onIncomingCallReceived]MediaManager.StockSound.INCOMING onCompletion.");
                        if (DeviceImpl.this.isIncomingCall) {
                            DeviceImpl.this.isIncomingCall = false;
                            DeviceImpl.this.onMakeCallFailed(callid, 5);
                        }
                    }
                });
            }
            catch (PendingIntent.CanceledException e) {
                Log4Util.e("SDK_DEVICE", "Unable to send PendingIntent for incoming connection: PendingIntent was canceled");
            }
        }
    }

    @Override
    public void onMakeCallFailed(final String callid, int reason) {
        DeviceListener.Reason r = DeviceListener.Reason.UNKNOWN;
        switch (reason) {
            case 0: {
                r = DeviceListener.Reason.UNKNOWN;
                break;
            }
            case 1: {
                r = DeviceListener.Reason.NOTRESPONSE;
                break;
            }
            case 2: {
                r = DeviceListener.Reason.AUTHFAILED;
                break;
            }
            case 3: {
                r = DeviceListener.Reason.DECLINED;
                break;
            }
            case 4: {
                r = DeviceListener.Reason.NOTFOUND;
                break;
            }
            case 5: {
                r = DeviceListener.Reason.CALLMISSED;
                break;
            }
            case 408: {
                r = DeviceListener.Reason.TIME_OUT;
                break;
            }
            case 488: {
                r = DeviceListener.Reason.MEDIACONSULTFAILED;
                break;
            }
            case 700: {
                r = DeviceListener.Reason.AUTHADDRESSFAILED;
                break;
            }
            case 410: 
            case 701: {
                r = DeviceListener.Reason.MAINACCOUNTPAYMENT;
                break;
            }
            case 702: {
                r = DeviceListener.Reason.MAINACCOUNTINVALID;
                break;
            }
            case 704: {
                r = DeviceListener.Reason.CALLERSAMECALLED;
                break;
            }
            case 705: {
                r = DeviceListener.Reason.SUBACCOUNTPAYMENT;
                break;
            }
            case 707: {
                r = DeviceListener.Reason.CONFERENCE_NOT_EXIST;
                break;
            }
            case 708: {
                r = DeviceListener.Reason.PASSWORD_ERROR;
                break;
            }
            case 6: {
                r = DeviceListener.Reason.BUSY;
                break;
            }
            case 10: {
                r = DeviceListener.Reason.OTHERVERSIONNOTSUPPORT;
                break;
            }
            case 170007: {
                r = DeviceListener.Reason.VERSIONNOTSUPPORT;
                break;
            }
            case 170001: {
                r = DeviceListener.Reason.LOCAL_CALL_BUSY;
                break;
            }
            default: {
                Log4Util.e("SDK_DEVICE", "[DeviceImpl - onMakeCallFailed] found new reason: " + reason + ", currentyly can't handle.");
            }
        }
        this.keepingCall = false;
        Bundle bundle = this.getCloopenReasonBundle(CallbackHandler.getCloopenReason(reason, r.getValue()));
        bundle.putString("com.ccp.phone.interphone.confNo", this.mOriginalConferenceNo);
        Device.RunningType _rRunningType = this.runningType;
        this.runningType = Device.RunningType.RunningType_None;
        if (_rRunningType == Device.RunningType.RunningType_Interphone) {
            this.sendTarget(2, 8213, bundle);
        } else if (_rRunningType == Device.RunningType.RunningType_ChatRoom) {
            this.sendTarget(1, 8217, bundle);
        } else if (_rRunningType == Device.RunningType.RunningType_VideoConference) {
            this.sendTarget(4, 8226, bundle);
        } else {
            this.mediaManager.stop();
            if (r == DeviceListener.Reason.BUSY || r == DeviceListener.Reason.DECLINED) {
                this.runningType = Device.RunningType.RunningType_Voip;
                this.mediaManager.queueSound(MediaManager.StockSound.BUSY, new MediaManager.SoundPlaybackListener(){

                    @Override
                    public void onCompletion() {
                        Log4Util.i("[DeviceImpl - makeCall]MediaManager.StockSound.BUSY onCompletion.");
                        DeviceImpl.this.onCallReleased(callid);
                    }
                });
            } else if (r == DeviceListener.Reason.CALLMISSED) {
                this.runningType = Device.RunningType.RunningType_Voip;
            }
            bundle.clear();
            bundle.putString("callid", callid);
            bundle.putSerializable("com.ccp.phone.reason", (Serializable)((Object)r));
            this.sendTarget(5, 8194, bundle);
        }
        Log4Util.i("SDK_DEVICE", "[DeviceImpl - onMakeCallFailed] callid: " + callid + ", reason: " + r.name());
    }

    @Override
    public void onTextMessageReceived(String sender, String message) {
        try {
            Log4Util.i("SDK_DEVICE", "[DeviceImpl - onTextMessageReceived] " + sender + message);
            StringBuffer buffer = new StringBuffer("<Response>");
            buffer.append(sender).append(message).append("</Response>");
            Response doParser = ApiParser.doParser(980118, new ByteArrayInputStream(buffer.toString().getBytes()));
            if (doParser instanceof IMTextMsg) {
                IMTextMsg imTextMsg = (IMTextMsg)doParser;
                this.onReceiveInstanceMessage(imTextMsg);
            } else {
                Log4Util.e("SDK_DEVICE", "Response parser not IMTextMsg object.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Deprecated
    public void onMessageSendReport(String msgid, int status) {
        Log4Util.d("SDK_DEVICE", "[DeviceImpl - onMessageSendReport] receive message report that msgId :" + msgid + " , status " + status);
        String sendStatus = "0";
        switch (status) {
            case 200: {
                sendStatus = "1";
                break;
            }
            case 100: 
            case 202: 
            case 404: 
            case 408: 
            case 477: {
                sendStatus = "0";
                break;
            }
            default: {
                sendStatus = "-1";
            }
        }
        if ("-1".equals(sendStatus)) {
            this.onSendInstanceMessage(CallbackHandler.getCloopenReason(status), new IMTextMsg(msgid, sendStatus));
        } else {
            this.onSendInstanceMessage(CallbackHandler.getCloopenReason(0), new IMTextMsg(msgid, sendStatus));
        }
    }

    @Override
    public void onMessageSendReport(String msgid, String date, int status) {
        Log4Util.d("SDK_DEVICE", "[DeviceImpl - onMessageSendReport] receive message report that msgId :" + msgid + " , status " + status + " , date " + date);
        String sendStatus = "0";
        switch (status) {
            case 200: {
                sendStatus = "1";
                break;
            }
            case 100: 
            case 202: 
            case 404: 
            case 408: 
            case 477: {
                sendStatus = "0";
                break;
            }
            default: {
                sendStatus = "-1";
            }
        }
        int reason = status;
        if (!"-1".equals(sendStatus)) {
            reason = 0;
        }
        IMTextMsg imTextMsg = new IMTextMsg(msgid, sendStatus);
        imTextMsg.setDateCreated(date);
        this.onSendInstanceMessage(CallbackHandler.getCloopenReason(reason), imTextMsg);
    }

    @Override
    public void onCallBack(int status, String self, String dest) {
        this.sendToTarget(5, 8208, status, self + "," + dest);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeSerializable((Serializable)this.uuid);
    }

    public Context getContext() {
        return this.context;
    }

    public String getCapabilityToken() {
        return this.capabilityToken;
    }

    public Map<String, String> getUserAgentParams() {
        return this.userAgentParams;
    }

    @Override
    public void onRecordingTimeOut(long mills) {
        this.voiceRecording = false;
        if (this.getCCPListenerInfo().mOnIMListener != null) {
            this.getCCPListenerInfo().mOnIMListener.onRecordingTimeOut(mills);
        }
    }

    @Override
    public void onRecordingAmplitude(double amplitude) {
        if (this.getCCPListenerInfo().mOnIMListener != null) {
            this.getCCPListenerInfo().mOnIMListener.onRecordingAmplitude(amplitude);
        }
    }

    @Override
    public void onFinishedPlaying() {
        this.voicePlaying = false;
        if (this.getCCPListenerInfo().mOnIMListener != null) {
            this.getCCPListenerInfo().mOnIMListener.onFinishedPlaying();
        }
    }

    public boolean isVoiceRecording() {
        return this.voiceRecording;
    }

    public boolean isVoicePlaying() {
        return this.voicePlaying;
    }

    @Override
    public long getVoiceDuration(String fileName) {
        this.mediaPlayManager.setSource(fileName, true);
        return this.mediaPlayManager.getMediaLength();
    }

    @Override
    public void startInterphone(String[] members, String appid) {
        if (this.runningType == Device.RunningType.RunningType_None) {
            if (this.callControlManager != null) {
                this.callControlManager.startInterphone(members, "1", appid);
            }
        } else {
            this.onInterphoneState(CallbackHandler.getCloopenReason(170001), null);
        }
    }

    @Override
    public void joinInterphone(String confNo) {
        if (this.runningType == Device.RunningType.RunningType_None) {
            this.mOriginalConferenceNo = confNo;
            this.clearUserData();
            this.ccpCallingID = this.makeCallByRunningType(Device.CallType.VOICE, confNo, Device.RunningType.RunningType_Interphone);
        } else {
            this.onInterphoneState(CallbackHandler.getCloopenReason(170001), confNo);
        }
    }

    @Override
    public boolean exitInterphone() {
        this.runningType = Device.RunningType.RunningType_None;
        if (this.ccpCallingID != null) {
            this.releaseCall(this.ccpCallingID);
            this.ccpCallingID = null;
            return true;
        }
        return false;
    }

    @Override
    public void controlMic(String confNo) {
        if (this.runningType == Device.RunningType.RunningType_Interphone) {
            if (this.callControlManager != null) {
                this.callControlManager.controlMIC(confNo);
            }
        } else {
            this.onControlMicState(CallbackHandler.getCloopenReason(170001), null);
        }
    }

    @Override
    public void releaseMic(String confNo) {
        if (this.runningType == Device.RunningType.RunningType_Interphone) {
            if (this.callControlManager != null) {
                this.callControlManager.releaseMic(confNo);
            }
        } else {
            this.onReleaseMicState(CallbackHandler.getCloopenReason(170001));
        }
    }

    @Override
    public void onInterphoneState(CloopenReason reason, String confNo) {
        if (reason != null && !reason.isError() && this.runningType == Device.RunningType.RunningType_None) {
            this.mOriginalConferenceNo = confNo;
            this.clearUserData();
            this.ccpCallingID = this.makeCallByRunningType(Device.CallType.VOICE, confNo, Device.RunningType.RunningType_Interphone);
        } else {
            this.runningType = Device.RunningType.RunningType_None;
            Bundle bundle = this.getCloopenReasonBundle(reason);
            bundle.putString("com.ccp.phone.interphone.confNo", confNo);
            this.sendTarget(2, 8213, bundle);
        }
    }

    @Override
    public void onControlMicState(CloopenReason reason, String speaker) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("speaker", speaker);
        this.sendTarget(2, 8214, bundle);
    }

    @Override
    public void onReleaseMicState(CloopenReason reason) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("speaker", null);
        this.sendTarget(2, 8215, bundle);
    }

    @Override
    public void onPushMessageArrived(String body) {
        if (this.callControlManager == null) {
            return;
        }
        try {
            Response response = ApiParser.doParser(980107, new ByteArrayInputStream(body.getBytes()));
            if (response instanceof InterphoneMsg) {
                this.onReceiveInterphoneMsg((InterphoneMsg)response);
            } else if (response instanceof ChatroomMsg) {
                if (response instanceof ChatroomDismissMsg || response instanceof ChatroomRemoveMemberMsg) {
                    if (response instanceof ChatroomRemoveMemberMsg) {
                        String roomNo;
                        ChatroomRemoveMemberMsg removeMemberMsg = (ChatroomRemoveMemberMsg)response;
                        if (removeMemberMsg != null && removeMemberMsg.getWho().equals(this.callControlManager.getUserAgentConfig().getSid()) && !TextUtils.isEmpty((CharSequence)(roomNo = removeMemberMsg.getRoomNo())) && roomNo.equals(this.mOriginalConferenceNo)) {
                            this.exitChatroom();
                        }
                    } else {
                        ChatroomDismissMsg dismissMsg = (ChatroomDismissMsg)response;
                        String roomNo = dismissMsg.getRoomNo();
                        if (!TextUtils.isEmpty((CharSequence)roomNo) && roomNo.equals(this.mOriginalConferenceNo)) {
                            this.exitChatroom();
                        }
                    }
                }
                this.onReceiveChatroomMsg((ChatroomMsg)response);
            } else if (response instanceof InstanceMsg) {
                this.onReceiveInstanceMessage((InstanceMsg)response);
            } else if (response instanceof VideoConferenceMsg) {
                if (response instanceof VideoConferenceDismissMsg || response instanceof VideoConferenceRemoveMemberMsg) {
                    if (response instanceof VideoConferenceRemoveMemberMsg) {
                        VideoConferenceRemoveMemberMsg removeMemberMsg = (VideoConferenceRemoveMemberMsg)response;
                        String conferenceId = removeMemberMsg.getConferenceId();
                        if (removeMemberMsg != null && removeMemberMsg.getWho().equals(this.callControlManager.getUserAgentConfig().getSid()) && !TextUtils.isEmpty((CharSequence)conferenceId) && conferenceId.equals(this.mOriginalConferenceNo)) {
                            this.exitVideoConference();
                        }
                    } else {
                        VideoConferenceDismissMsg dismissMsg = (VideoConferenceDismissMsg)response;
                        String conferenceId = dismissMsg.getConferenceId();
                        if (!TextUtils.isEmpty((CharSequence)conferenceId) && conferenceId.equals(this.mOriginalConferenceNo)) {
                            this.exitVideoConference();
                        }
                    }
                }
                this.onReceiveVideoConferenceMsg((VideoConferenceMsg)response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onReceiveInterphoneMsg(InterphoneMsg msg) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("InterphoneMsg", (Serializable)msg);
        this.sendTarget(2, 8210, bundle);
    }

    public void onReceiveChatroomMsg(ChatroomMsg msg) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("ChatroomMsg", (Serializable)msg);
        this.sendTarget(1, 8209, bundle);
    }

    public void onReceiveVideoConferenceMsg(VideoConferenceMsg VideoMsg) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("VideoConferenceMsg", (Serializable)VideoMsg);
        this.sendTarget(4, 8212, bundle);
    }

    @Override
    public void queryMembersWithInterphone(String confNo) {
        if (this.callControlManager != null) {
            this.callControlManager.queryMembersWithInterphone(confNo);
        }
    }

    @Override
    public void onInterphoneMembers(CloopenReason reason, List<InterphoneMember> member) {
        if (this.keepingCall && member != null) {
            for (InterphoneMember interphoneMember : member) {
                if (interphoneMember.type == null || this.callControlManager == null || !interphoneMember.voipId.equals(this.callControlManager.getUserAgentConfig().getSid())) continue;
                interphoneMember.online = "1";
            }
        }
        Bundle bundle = this.getCloopenReasonBundle(reason);
        ArrayList<List<InterphoneMember>> arrayList = new ArrayList<List<InterphoneMember>>();
        arrayList.add(member);
        bundle.putParcelableArrayList("member", arrayList);
        this.sendTarget(2, 8216, bundle);
    }

    @Override
    @Deprecated
    public void startChatroom(String appId, String roomName, int square, String keywords, String pwd) {
        this.startChatroom(appId, roomName, square, keywords, pwd, true);
    }

    @Override
    @Deprecated
    public void startChatroom(String appId, String roomName, int square, String keywords, String pwd, boolean isAutoClose) {
        this.startChatroom(appId, roomName, square, keywords, pwd, isAutoClose, 1, true);
    }

    @Override
    public void startChatroom(String appId, String roomName, int square, String keywords, String pwd, boolean isAutoClose, int voiceMod, boolean isAutoDelete) {
        this.startChatroom(appId, roomName, square, keywords, pwd, isAutoClose, voiceMod, isAutoDelete, true);
    }

    @Override
    public void startChatroom(String appId, String roomName, int square, String keywords, String pwd, boolean isAutoClose, int voiceMod, boolean isAutoDelete, boolean isAutoJoin) {
        this.isAutoJoin = isAutoJoin;
        if (this.runningType == Device.RunningType.RunningType_None) {
            if (this.callControlManager != null) {
                if (!TextUtils.isEmpty((CharSequence)pwd)) {
                    this.setConfpwd(pwd);
                    keywords = Cryptos.toBase64QES("10C173A98BAD2FF723BE0E81A9D85965", pwd);
                }
                this.callControlManager.startChatroom(appId, roomName, square, keywords, keywords, isAutoClose ? 0 : 1, voiceMod, isAutoDelete ? 1 : 0);
            }
        } else {
            this.onChatRoomState(CallbackHandler.getCloopenReason(170001), null);
        }
    }

    @Override
    public void dismissChatroom(String appId, String roomNo) {
        if (this.callControlManager != null) {
            this.callControlManager.dismissChatroom(appId, roomNo);
        }
    }

    @Override
    public void removeMemberFromChatroom(String appId, String roomNo, String member) {
        if (this.callControlManager != null) {
            this.callControlManager.removeMemberFromChatroom(appId, roomNo, member);
        }
    }

    @Override
    public void joinChatroom(String roomNo, String pwd) {
        if (this.runningType == Device.RunningType.RunningType_None) {
            this.mOriginalConferenceNo = ConferenceUtils.getOriginalConferenceNo(roomNo);
            this.clearUserData();
            if (!TextUtils.isEmpty((CharSequence)pwd)) {
                this.setConfpwd(pwd);
            }
            this.ccpCallingID = this.makeCallByRunningType(Device.CallType.VOICE, this.mOriginalConferenceNo, Device.RunningType.RunningType_ChatRoom);
        } else {
            this.onChatRoomState(CallbackHandler.getCloopenReason(170001), null);
        }
    }

    @Override
    public boolean exitChatroom() {
        this.runningType = Device.RunningType.RunningType_None;
        if (this.ccpCallingID != null) {
            this.releaseCall(this.ccpCallingID);
            this.ccpCallingID = null;
            return true;
        }
        return false;
    }

    @Override
    public void queryMembersWithChatroom(String roomNo) {
        if (this.callControlManager != null) {
            this.callControlManager.queryMembersWithChatroom(roomNo);
        }
    }

    @Override
    public void setChatroomMemberSpeakOpt(String appId, String roomNo, String member, int opt) {
        if (this.callControlManager != null) {
            this.callControlManager.setChatroomMemberSpeakOpt(appId, roomNo, member, opt);
        }
    }

    @Override
    public void onChatRoomState(CloopenReason reason, String confNo) {
        if (reason != null && !reason.isError() && this.runningType == Device.RunningType.RunningType_None && this.isAutoJoin) {
            this.mOriginalConferenceNo = confNo;
            ConferenceUtils.procesConferenceNo(Device.RunningType.RunningType_ChatRoom, confNo);
            this.clearUserData();
            this.ccpCallingID = this.makeCallByRunningType(Device.CallType.VOICE, confNo, Device.RunningType.RunningType_ChatRoom);
        } else {
            this.runningType = Device.RunningType.RunningType_None;
            Bundle bundle = this.getCloopenReasonBundle(reason);
            bundle.putString("com.ccp.phone.interphone.confNo", ConferenceUtils.getProcesConferenceNo(confNo));
            this.sendTarget(1, 8217, bundle);
            this.isAutoJoin = true;
        }
    }

    @Override
    public void onChatRoomDismiss(CloopenReason reason, String roomNo) {
        this.releaseCallNoneVoip();
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("com.ccp.phone.interphone.confNo", roomNo);
        this.sendTarget(1, 8218, bundle);
    }

    @Override
    public void onChatRoomRemoveMember(CloopenReason reason, String member) {
        String sid;
        if (this.callControlManager != null && !TextUtils.isEmpty((CharSequence)(sid = this.callControlManager.getUserAgentConfig().getSid())) && sid.equals(member)) {
            this.releaseCall(this.ccpCallingID);
        }
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("member", member);
        this.sendTarget(1, 8219, bundle);
    }

    @Override
    public void onSetChatroomSpeakOpt(CloopenReason reason, String member) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("member", member);
        this.sendTarget(1, 8239, bundle);
    }

    @Override
    public void setCodecEnabled(Device.Codec codec, boolean enabled) {
        if (this.callControlManager != null) {
            this.callControlManager.setCodecEnabled(codec.getValue(), enabled);
        }
    }

    @Override
    public boolean getCodecEnabled(Device.Codec codec) {
        if (this.callControlManager != null) {
            return this.callControlManager.getCodecEnabled(codec.getValue());
        }
        return true;
    }

    @Override
    public void setSrtpEnabled(String key) {
        if (this.callControlManager != null) {
            this.callControlManager.setSrtpEnabled(true, true, 3, key);
        }
    }

    @Override
    public void onChatRooms(CloopenReason reason, List<Chatroom> chatRoomList) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        List<Chatroom> procesChatrooms = ConferenceUtils.procesChatrooms(chatRoomList);
        ArrayList<List<Chatroom>> arrayList = new ArrayList<List<Chatroom>>();
        arrayList.add(procesChatrooms);
        bundle.putParcelableArrayList("chatroomList", arrayList);
        this.sendTarget(1, 8220, bundle);
    }

    @Override
    public CameraInfo[] getCameraInfo() {
        if (this.callControlManager == null) {
            return null;
        }
        return this.callControlManager.getCameraInfo();
    }

    @Override
    public void selectCamera(int cameraIndex, int capabilityIndex, int fps, Device.Rotate rotate, boolean force) {
        if (this.callControlManager != null) {
            this.callControlManager.selectCamera(cameraIndex, capabilityIndex, fps, rotate.getValue(), force);
        }
    }

    @Override
    public void onChatRoomMembers(CloopenReason reason, List<ChatroomMember> member) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        ArrayList<List<ChatroomMember>> arrayList = new ArrayList<List<ChatroomMember>>();
        arrayList.add(member);
        bundle.putParcelableArrayList("chatroomMembers", arrayList);
        this.sendTarget(1, 8222, bundle);
    }

    @Override
    public void onChatRoomInvite(CloopenReason reason, String confNo) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("com.ccp.phone.interphone.confNo", confNo);
        this.sendTarget(1, 8221, bundle);
    }

    @Override
    public void queryChatrooms(String appId, String keywords) {
        if (this.callControlManager != null) {
            this.callControlManager.queryChatRooms(appId, keywords);
        }
    }

    @Override
    public void inviteMembersJoinChatroom(String[] members, String roomNo, String appId) {
        if (this.callControlManager != null) {
            this.callControlManager.inviteMembersJoinChatroom(members, roomNo, appId);
        }
    }

    @Override
    public void acceptCall(String callid, String accountid, Device.CallType callType) {
        if (this.callControlManager != null) {
            if (this.incomingCallType == Device.CallType.VIDEO) {
                if (mRemoteViewMap.get(accountid) != null) {
                    this.callControlManager.setVideoView(accountid, mRemoteViewMap.get(accountid), null);
                    Log4Util.i("SDK_DEVICE", "[DeviceImpl -  acceptCall] video view has been setting.");
                } else {
                    Log4Util.w("SDK_DEVICE", "[DeviceImpl -  acceptCall] video view is null.");
                }
            }
            this.callControlManager.acceptCallByMediaType(callid, callType.getValue());
        }
    }

    @Override
    public void updateCallType(String callid, Device.CallType callType) {
        this.requestSwitchCallMediaType(callid, callType);
    }

    @Override
    public void requestSwitchCallMediaType(String callid, Device.CallType callType) {
        if (this.callControlManager != null) {
            this.callControlManager.updateCallMedia(callid, callType.getValue());
        }
    }

    @Override
    public void answerCallTypeUpdate(String callid, int action) {
        this.responseSwitchCallMediaType(callid, action);
    }

    @Override
    public void responseSwitchCallMediaType(String callid, int action) {
        if (this.callControlManager != null) {
            this.callControlManager.answerCallMediaUpdate(callid, action);
        }
    }

    @Override
    public Device.CallType getCallType(String callid) {
        if (this.callControlManager != null) {
            int type = this.callControlManager.getCallMediaType(callid);
            if (type == 0) {
                return Device.CallType.VOICE;
            }
            if (type == 1) {
                return Device.CallType.VIDEO;
            }
        }
        return null;
    }

    @Override
    public int setAudioConfigEnabled(Device.AudioType type, boolean enabled, Device.AudioMode mode) {
        if (this.callControlManager == null) {
            return -1;
        }
        return this.callControlManager.setAudioConfigEnabled(type.getValue(), enabled, mode.getValue());
    }

    @Override
    public boolean getAudioConfig(Device.AudioType type) {
        if (this.callControlManager == null) {
            return false;
        }
        return this.callControlManager.getAudioConfig(type.getValue());
    }

    @Override
    public Device.AudioMode getAudioConfigMode(Device.AudioType type) {
        if (this.callControlManager == null) {
            return null;
        }
        int mode = this.callControlManager.getAudioConfigMode(type.getValue());
        Device.AudioMode audiomode = null;
        if (type == Device.AudioType.AUDIO_NS) {
            switch (mode) {
                case 0: {
                    audiomode = Device.AudioMode.kNsUnchanged;
                    break;
                }
                case 1: {
                    audiomode = Device.AudioMode.kNsDefault;
                    break;
                }
                case 2: {
                    audiomode = Device.AudioMode.kNsConference;
                    break;
                }
                case 3: {
                    audiomode = Device.AudioMode.kNsLowSuppression;
                    break;
                }
                case 4: {
                    audiomode = Device.AudioMode.kNsModerateSuppression;
                    break;
                }
                case 5: {
                    audiomode = Device.AudioMode.kNsHighSuppression;
                    break;
                }
                case 6: {
                    audiomode = Device.AudioMode.kNsVeryHighSuppression;
                    break;
                }
                default: {
                    audiomode = Device.AudioMode.kNsDefault;
                    break;
                }
            }
        } else if (type == Device.AudioType.AUDIO_AGC) {
            switch (mode) {
                case 0: {
                    audiomode = Device.AudioMode.kAgcUnchanged;
                    break;
                }
                case 1: {
                    audiomode = Device.AudioMode.kAgcDefault;
                    break;
                }
                case 2: {
                    audiomode = Device.AudioMode.kAgcAdaptiveAnalog;
                    break;
                }
                case 3: {
                    audiomode = Device.AudioMode.kAgcAdaptiveDigital;
                    break;
                }
                case 4: {
                    audiomode = Device.AudioMode.kAgcFixedDigital;
                    break;
                }
                default: {
                    audiomode = Device.AudioMode.kAgcUnchanged;
                    break;
                }
            }
        } else if (type == Device.AudioType.AUDIO_EC) {
            switch (mode) {
                case 0: {
                    audiomode = Device.AudioMode.kEcUnchanged;
                    break;
                }
                case 1: {
                    audiomode = Device.AudioMode.kEcDefault;
                    break;
                }
                case 2: {
                    audiomode = Device.AudioMode.kEcConference;
                    break;
                }
                case 3: {
                    audiomode = Device.AudioMode.kEcAec;
                    break;
                }
                case 4: {
                    audiomode = Device.AudioMode.kEcAecm;
                    break;
                }
                default: {
                    audiomode = Device.AudioMode.kEcUnchanged;
                }
            }
        }
        return audiomode;
    }

    @Override
    public void setVideoBitRates(int bitrates) {
        if (this.callControlManager != null) {
            this.callControlManager.setVideoBitRates(bitrates);
        }
    }

    @Override
    public int startRtpDump(String callid, int mediaType, String fileName, int direction) {
        if (this.callControlManager == null) {
            return -1;
        }
        return this.callControlManager.startRtpDump(callid, mediaType, fileName, direction);
    }

    @Override
    public int stopRtpDump(String callid, int mediaType, int direction) {
        if (this.callControlManager == null) {
            return -1;
        }
        return this.callControlManager.stopRtpDump(callid, mediaType, direction);
    }

    @Override
    public void onCallMediaUpdateRequest(String callid, int reason) {
        if (this.runningType == Device.RunningType.RunningType_Voip) {
            this.sendToTarget(5, 8204, reason, callid);
        }
    }

    @Override
    public void onCallMediaUpdateResponse(String callid, int reason) {
        if (this.runningType == Device.RunningType.RunningType_Voip) {
            this.sendToTarget(5, 8205, reason, callid);
        }
    }

    @Override
    public void onCallVideoRatioChanged(String callid, String resolution, int state) {
        if (this.runningType == Device.RunningType.RunningType_Voip) {
            this.sendToTarget(5, 8206, -1, callid + "," + resolution);
        } else if (this.runningType == Device.RunningType.RunningType_VideoConference) {
            this.sendToTarget(4, 8241, -1, callid + "," + resolution);
        }
    }

    @Override
    public void onCallMediaInitFailed(String callid, int reason) {
        if (this.runningType == Device.RunningType.RunningType_Voip) {
            this.sendToTarget(5, 8207, reason, callid);
        }
    }

    @Override
    public String sendInstanceMessage(String receiver, String text, String attached, String userData) {
        if (this.callControlManager == null) {
            return null;
        }
        String uniqueID = null;
        if (text != null && attached == null) {
            int errorCode = 0;
            if (Device.State.ONLINE == this.isOnline()) {
                if (text.getBytes().length <= 2000 && (TextUtils.isEmpty((CharSequence)userData) || userData.getBytes().length <= 255)) {
                    uniqueID = this.callControlManager.sendTextMessage(receiver, text, userData);
                    errorCode = 0;
                } else {
                    errorCode = 170022;
                }
            } else {
                errorCode = 170000;
            }
            final int code = errorCode;
            if (errorCode != 0) {
                String msgId;
                uniqueID = msgId = this.callControlManager.getUniqueID();
                this.callControlManager.postCommand(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(500L);
                            DeviceImpl.this.onSendInstanceMessage(CallbackHandler.getCloopenReason(code), new IMTextMsg(msgId, "-1"));
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return uniqueID;
        }
        if (attached != null && this.callControlManager != null) {
            uniqueID = this.callControlManager.getUniqueID();
            this.callControlManager.sendMediaMsg(uniqueID, attached, receiver, userData);
        }
        return uniqueID;
    }

    @Override
    public void startVideoRecording(String receiver, String path, boolean chunked) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String startVoiceRecording(String receiver, String path, boolean chunked, String userData) throws CCPRecordException {
        Object object = this.mLocks;
        synchronized (object) {
            if (!VoiceUtil.isAvaiableSpace(1)) {
                throw new CCPRecordException("The current did not load SDcard or lack of SDcard memory space.");
            }
            if (this.callControlManager == null) {
                return null;
            }
            String uniqueID = this.callControlManager.getUniqueID();
            this.voiceRecording = true;
            if (chunked) {
                this.audRecordManager.startRecord(uniqueID, path, receiver, userData);
            } else {
                this.audRecordManager.startRecord(uniqueID, path);
            }
            return uniqueID;
        }
    }

    @Override
    public void onSendInstanceMessage(CloopenReason reason, InstanceMsg data) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putSerializable("InstanceMsg", (Serializable)data);
        this.sendTarget(3, 8223, bundle);
    }

    @Override
    public void onDownloadAttached(CloopenReason reason, String fileName) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("fileName", fileName);
        this.sendTarget(3, 8224, bundle);
    }

    @Override
    public void onReceiveInstanceMessage(InstanceMsg msg) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("InstanceMsg", (Serializable)msg);
        this.sendTarget(3, 8211, bundle);
    }

    @Override
    public void confirmIntanceMessage(String[] msgId) {
        if (this.callControlManager != null) {
            this.callControlManager.confirmDownloadMediaMessage(msgId);
        }
    }

    @Override
    public void downloadAttached(ArrayList<DownloadInfo> urlList) {
        if (this.callControlManager != null) {
            this.callControlManager.downloadAttachmentFiles(urlList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopVoiceRecording() {
        Object object = this.mLocks;
        synchronized (object) {
            this.voiceRecording = false;
            Log4Util.i("stopVoiceRecording");
            this.audRecordManager.stopRecord();
        }
    }

    @Override
    public void playVoiceMsg(String path) {
        this.playVoiceMsg(path, true);
    }

    @Override
    public void playVoiceMsg(String path, boolean speakerOn) {
        this.voicePlaying = true;
        this.mediaPlayManager.setSource(path, speakerOn);
        this.mediaPlayManager.play(this);
    }

    @Override
    public void stopVoiceMsg() {
        this.voicePlaying = false;
        this.mediaPlayManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelVoiceRecording() {
        Object object = this.mLocks;
        synchronized (object) {
            this.voiceRecording = false;
            this.audRecordManager.cancleRecord(true);
            this.audRecordManager.stopRecord();
        }
    }

    @Override
    public void onConfirmIntanceMessage(CloopenReason reason) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        this.sendTarget(3, 8225, bundle);
    }

    @Override
    public String getVersion() {
        if (this.callControlManager == null) {
            return null;
        }
        return this.callControlManager.getVersion();
    }

    @Override
    public CallStatisticsInfo getCallStatistics(Device.CallType callType) {
        if (this.callControlManager == null) {
            return null;
        }
        String callState = this.callControlManager.getCallStatistics(callType.getValue());
        Log4Util.d("getCallStatistics", callState);
        String[] split = callState.split("#");
        CallStatisticsInfo callStatisticsInfo = null;
        if (split != null && split.length >= 9) {
            try {
                callStatisticsInfo = new CallStatisticsInfo();
                callStatisticsInfo.setFractionLost(Integer.parseInt(split[0]));
                callStatisticsInfo.setCumulativeLost(Integer.parseInt(split[1]));
                callStatisticsInfo.setExtendedMax(Integer.parseInt(split[2]));
                callStatisticsInfo.setJitterSamples(Integer.parseInt(split[3]));
                callStatisticsInfo.setRttMs(Integer.parseInt(split[4]));
                callStatisticsInfo.setBytesSent(Integer.parseInt(split[5]));
                callStatisticsInfo.setPacketsSent(Integer.parseInt(split[6]));
                callStatisticsInfo.setBytesReceived(Integer.parseInt(split[7]));
                callStatisticsInfo.setPacketsReceived(Integer.parseInt(split[8]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return callStatisticsInfo;
    }

    public int setFirewallPolicy(int policy) {
        if (this.callControlManager == null) {
            return -1;
        }
        return this.callControlManager.setFirewallPolicy(policy);
    }

    @Override
    public void onFirewallPolicyEnabled() {
        this.sendToTarget(7, 8235, -1, null);
    }

    @Override
    public void setOnVoIPListener(OnVoIPListener onVoIPListener) {
        this.getCCPListenerInfo().mOnVoIPListener = onVoIPListener;
    }

    @Override
    public void setOnChatroomListener(OnChatroomListener onChatroomListener) {
        this.getCCPListenerInfo().mOnChatroomListener = onChatroomListener;
    }

    @Override
    public void setOnInterphoneListener(OnInterphoneListener onInterphoneListener) {
        this.getCCPListenerInfo().mOnInterphoneListener = onInterphoneListener;
    }

    @Override
    public void setOnIMListener(OnIMListener onIMListener) {
        this.getCCPListenerInfo().mOnIMListener = onIMListener;
    }

    @Override
    public void setOnVideoConferenceListener(OnVideoConferenceListener onVideoConferenceListener) {
        this.getCCPListenerInfo().mOnVideoConferenceListener = onVideoConferenceListener;
    }

    @Override
    @Deprecated
    public void startVideoConference(String appId, String conferenceName, int square, String keywords, String conferencePwd) {
        this.startVideoConference(appId, conferenceName, square, keywords, conferencePwd, true);
    }

    @Override
    @Deprecated
    public void startVideoConference(String appId, String conferenceName, int square, String keywords, String conferencePwd, boolean isAutoClose) {
        this.startVideoConference(appId, conferenceName, square, keywords, conferencePwd, isAutoClose, 1, true);
    }

    @Override
    public void startVideoConference(String appId, String conferenceName, int square, String keywords, String conferencePwd, boolean isAutoClose, int voiceMod, boolean isAutoDelete) {
        this.startVideoConference(appId, conferenceName, square, keywords, conferencePwd, isAutoClose, voiceMod, isAutoDelete, true);
    }

    @Override
    public void startVideoConference(String appId, String conferenceName, int square, String keywords, String conferencePwd, boolean isAutoClose, int voiceMod, boolean isAutoDelete, boolean isAutoJoin) {
        this.isAutoJoin = isAutoJoin;
        if (this.runningType == Device.RunningType.RunningType_None) {
            if (this.callControlManager != null) {
                this.callControlManager.startVideoConference(appId, conferenceName, square, keywords, conferencePwd, isAutoClose ? 0 : 1, voiceMod, isAutoDelete ? 1 : 0);
            }
        } else {
            this.onVideoConferenceState(CallbackHandler.getCloopenReason(170001), null);
        }
    }

    @Override
    public void startMultiVideoConference(String appId, String conferenceName, int square, String keywords, String conferencePwd, boolean isAutoClose, int voiceMod, boolean isAutoDelete, boolean isAutoJoin) {
        ConferenceOptions options = new ConferenceOptions();
        options.inAutoClose = isAutoClose;
        options.inVoiceMod = voiceMod;
        options.inMultiVideo = true;
        options.inAutoDelete = isAutoDelete;
        this.startVideoConference(appId, conferenceName, conferencePwd, isAutoJoin, options);
    }

    private void startVideoConference(String appId, String conferenceName, String conferencePwd, boolean isAutoJoin, ConferenceOptions options) {
        this.isAutoJoin = isAutoJoin;
        if (this.runningType == Device.RunningType.RunningType_None) {
            if (this.callControlManager != null) {
                this.callControlManager.startVideoConference(appId, conferenceName, conferencePwd, options);
            }
        } else {
            this.onVideoConferenceState(CallbackHandler.getCloopenReason(170001), null);
        }
    }

    @Override
    public void joinVideoConference(String conferenceId) {
        if (this.runningType == Device.RunningType.RunningType_None) {
            this.mOriginalConferenceNo = ConferenceUtils.getOriginalConferenceNo(conferenceId);
            this.clearUserData();
            this.ccpCallingID = this.makeCallByRunningType(Device.CallType.VIDEO, this.mOriginalConferenceNo, Device.RunningType.RunningType_VideoConference);
        } else {
            this.onVideoConferenceState(CallbackHandler.getCloopenReason(170001), null);
        }
    }

    @Override
    public boolean exitVideoConference() {
        this.runningType = Device.RunningType.RunningType_None;
        if (this.ccpCallingID != null) {
            this.releaseCall(this.ccpCallingID);
            this.ccpCallingID = null;
            if (this.callControlManager != null) {
                this.callControlManager.removeVideoConferenceHandleMessage();
            }
            return true;
        }
        return false;
    }

    @Override
    public void queryMembersInVideoConference(String conferenceId) {
        if (this.callControlManager != null) {
            this.callControlManager.queryMembersInVideoConference(conferenceId);
        }
    }

    @Override
    public void queryVideoConferences(String appId, String keywords) {
        if (this.callControlManager != null) {
            this.callControlManager.queryVideoConferences(appId, keywords);
        }
    }

    @Override
    public void dismissVideoConference(String appId, String conferenceId) {
        if (this.callControlManager != null) {
            this.callControlManager.dismissVideoConference(appId, conferenceId);
        }
    }

    @Override
    public void removeMemberFromVideoConference(String appId, String conferenceId, String member) {
        if (this.callControlManager != null) {
            this.callControlManager.removeMemberFromVideoConference(appId, conferenceId, member);
        }
    }

    @Override
    public void switchRealScreenToVoip(String appId, String conferenceId, String voip) {
        if (this.callControlManager != null) {
            this.callControlManager.switchRealScreenToVoip(appId, conferenceId, voip);
        }
    }

    @Override
    public void onVideoConferenceState(CloopenReason reason, String conferenceId) {
        if (reason != null && !reason.isError() && this.runningType == Device.RunningType.RunningType_None && this.isAutoJoin) {
            this.mOriginalConferenceNo = conferenceId;
            ConferenceUtils.procesConferenceNo(Device.RunningType.RunningType_VideoConference, conferenceId);
            this.clearUserData();
            this.ccpCallingID = this.makeCallByRunningType(Device.CallType.VIDEO, conferenceId, Device.RunningType.RunningType_VideoConference);
        } else {
            this.runningType = Device.RunningType.RunningType_None;
            Bundle bundle = this.getCloopenReasonBundle(reason);
            bundle.putString("com.ccp.phone.interphone.confNo", ConferenceUtils.getProcesConferenceNo(conferenceId));
            this.sendTarget(4, 8226, bundle);
            this.isAutoJoin = false;
        }
    }

    @Override
    public void onVideoConferenceMembers(CloopenReason reason, List<VideoConferenceMember> members) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        ArrayList<List<VideoConferenceMember>> arrayList = new ArrayList<List<VideoConferenceMember>>();
        arrayList.add(members);
        bundle.putParcelableArrayList("videoMembers", arrayList);
        this.sendTarget(4, 8227, bundle);
    }

    @Override
    public void onVideoConferences(CloopenReason reason, List<VideoConference> conferences) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        conferences = ConferenceUtils.procesVideoConferences(conferences);
        ArrayList<List<VideoConference>> arrayList = new ArrayList<List<VideoConference>>();
        arrayList.add(conferences);
        bundle.putParcelableArrayList("conferences", arrayList);
        this.sendTarget(4, 8228, bundle);
    }

    @Override
    public void onVideoConferenceInvite(CloopenReason reason, String conferenceId) {
    }

    @Override
    public void onVideoConferenceDismiss(CloopenReason reason, String conferenceId) {
        this.releaseCallNoneVoip();
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("com.ccp.phone.interphone.confNo", conferenceId);
        this.sendTarget(4, 8229, bundle);
    }

    private void releaseCallNoneVoip() {
        this.runningType = Device.RunningType.RunningType_None;
        if (!TextUtils.isEmpty((CharSequence)this.ccpCallingID)) {
            this.releaseCall(this.ccpCallingID);
            this.ccpCallingID = null;
        }
    }

    @Override
    public void onVideoConferenceRemoveMember(CloopenReason reason, String member) {
        String sid;
        if (this.callControlManager != null && TextUtils.isEmpty((CharSequence)(sid = this.callControlManager.getUserAgentConfig().getSid())) && sid.equals(member)) {
            this.releaseCall(this.ccpCallingID);
        }
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("member", member);
        this.sendTarget(4, 8230, bundle);
    }

    public void disConnectToCCP() {
        if (this.callControlManager != null) {
            this.callControlManager.disConnectToCCP();
        }
    }

    @Override
    public void onDownloadVideoConferencePortraits(CloopenReason reason, VideoPartnerPortrait portrait) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putSerializable("portrait", (Serializable)portrait);
        this.sendTarget(4, 8233, bundle);
    }

    @Override
    public void getPortraitsFromVideoConference(String conferenceId) {
        if (this.callControlManager != null) {
            this.callControlManager.GetPortraitsFromVideoConference(conferenceId);
        }
    }

    @Override
    public void onGetPortraitsFromVideoConference(CloopenReason reason, List<VideoPartnerPortrait> videoPortraits) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        ArrayList<List<VideoPartnerPortrait>> arrayList = new ArrayList<List<VideoPartnerPortrait>>();
        arrayList.add(videoPortraits);
        bundle.putParcelableArrayList("videoPortraits", arrayList);
        this.sendTarget(4, 8232, bundle);
    }

    Bundle getCloopenReasonBundle(CloopenReason reason) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("com.ccp.phone.cloopenreason", (Serializable)reason);
        return bundle;
    }

    @Override
    public VideoSnapshot getLocalVideoSnapshot() {
        VideoSnapshot vSnapshot = null;
        if (this.runningType != Device.RunningType.RunningType_None && this.makeCallType == Device.CallType.VIDEO && this.callControlManager != null) {
            Object localVideoSnapshot = this.callControlManager.getLocalVideoSnapshot(this.ccpCallingID);
            if (localVideoSnapshot == null) {
                return vSnapshot;
            }
            if (localVideoSnapshot instanceof VideoSnapshot) {
                vSnapshot = (VideoSnapshot)localVideoSnapshot;
            }
        }
        return vSnapshot;
    }

    @Override
    public VideoSnapshot getRemoteVideoSnapshot() {
        VideoSnapshot vSnapshot = null;
        if (this.runningType != Device.RunningType.RunningType_None && this.makeCallType == Device.CallType.VIDEO && this.callControlManager != null) {
            Object localVideoSnapshot = this.callControlManager.getRemoteVideoSnapshot(this.ccpCallingID);
            if (localVideoSnapshot == null) {
                return vSnapshot;
            }
            if (localVideoSnapshot instanceof VideoSnapshot) {
                vSnapshot = (VideoSnapshot)localVideoSnapshot;
            }
        }
        return vSnapshot;
    }

    @Override
    public void sendLocalPortrait(String fileName, String conferenceId) {
        if (this.callControlManager != null) {
            this.callControlManager.SendLocalPortrait(fileName, conferenceId);
        }
    }

    @Override
    public void onSwitchRealScreenToVoip(CloopenReason reason) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        this.sendTarget(4, 8231, bundle);
    }

    @Override
    public void downloadVideoConferencePortraits(ArrayList<VideoPartnerPortrait> portraitsList) {
        if (this.callControlManager != null) {
            this.callControlManager.DownloadVideoConferencePortraits(portraitsList);
        }
    }

    @Override
    public void onSendLocalPortrait(CloopenReason reason, String conferenceId) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putString("com.ccp.phone.interphone.confNo", conferenceId);
        this.sendTarget(4, 8234, bundle);
    }

    @Override
    public void startVoiceCallRecording(String callid, String fileName) throws CCPRecordException {
        if (this.runningType == Device.RunningType.RunningType_None) {
            throw new CCPRecordException("The current state of the SDK " + this.runningType + ", there is no calls in progress.");
        }
        if (this.makeCallType == null || this.makeCallType != Device.CallType.VOICE) {
            throw new CCPRecordException("The current call in progress not Voice , that is " + this.makeCallType);
        }
        try {
            if (this.callControlManager != null) {
                this.callControlManager.startRecordVoice(callid, fileName);
            }
        }
        catch (Exception e) {
            throw new CCPRecordException("Record Voice error ," + e.getMessage());
        }
    }

    @Override
    public void stopVoiceCallRecording(String callid) {
        try {
            if (this.callControlManager != null) {
                this.callControlManager.stopRecordVoice(callid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onCallRecord(String callid, String fileName, int reason) {
        if (this.getCCPListenerInfo().mOnCallRecordListener != null) {
            if (reason == 0) {
                this.sendTarget(6, 8236, fileName);
            } else {
                this.sendToTarget(6, 8237, reason, null);
            }
        }
    }

    @Override
    public void setOnCallRecordListener(OnVoIPListener.OnCallRecordListener onCallRecordListener) {
        this.getCCPListenerInfo().mOnCallRecordListener = onCallRecordListener;
    }

    @Override
    public void setOnTriggerSrtpListener(OnTriggerSrtpListener onTriggerSrtpListener) {
        this.getCCPListenerInfo().mOnTriggerSrtpListener = onTriggerSrtpListener;
    }

    @Override
    public void OnTriggerSrtp(String callId, boolean caller) {
        if (this.getCCPListenerInfo().mOnTriggerSrtpListener != null) {
            this.getCCPListenerInfo().mOnTriggerSrtpListener.OnTriggerSrtp(callId, caller);
        }
    }

    @Override
    public int setShieldMosaic(boolean flag) {
        if (this.callControlManager == null) {
            return -1;
        }
        return this.callControlManager.setShieldMosaic(flag);
    }

    @Override
    public Device.State checkUserOnline(String account) {
        if (this.callControlManager == null) {
            return Device.State.OFFLINE;
        }
        int _userOnline = this.callControlManager.checkUserOnline(account);
        Device.State state = Device.State.OFFLINE;
        switch (_userOnline) {
            case 0: {
                state = Device.State.ONLINE;
                break;
            }
            case 1: {
                state = Device.State.OFFLINE;
                break;
            }
            case 2: {
                state = Device.State.NOTEXIST;
                break;
            }
            case 3: {
                state = Device.State.TIMEOUT;
                break;
            }
        }
        return state;
    }

    @Override
    public NetworkStatistic getNetworkStatistic(String callid) {
        if (!TextUtils.isEmpty((CharSequence)callid) && !callid.matches("[0-9]+")) {
            callid = this.ccpCallingID;
        }
        if (this.callControlManager == null || TextUtils.isEmpty((CharSequence)callid)) {
            return null;
        }
        String trafficStats = this.callControlManager.getNetworkStatistic(callid);
        Log4Util.d("SDK_DEVICE", "callid : " + callid + " , trafficStats: " + trafficStats);
        if (TextUtils.isEmpty((CharSequence)trafficStats)) {
            return null;
        }
        return VoiceUtil.parserTrafficStats(trafficStats);
    }

    @Override
    public byte[] onCallProcessData(byte[] b, int transDirection) {
        if (this.getCCPListenerInfo().mOnCallProcessDataListener != null) {
            return this.getCCPListenerInfo().mOnCallProcessDataListener.onCallProcessData(b, transDirection);
        }
        return b;
    }

    @Override
    public void setProcessDataEnabled(String callid, boolean enabled, OnVoIPListener.OnCallProcessDataListener l) {
        if (this.callControlManager != null) {
            this.callControlManager.setProcessDataEnabled(callid, enabled);
        }
        if (enabled) {
            this.getCCPListenerInfo().mOnCallProcessDataListener = l;
        }
    }

    public void setNativeLog(boolean enabled) {
        this.callControlManager.setTraceFlag(enabled);
    }

    @Override
    public void setKeepAliveTimeout(int wifi, int mobile) {
        if (this.callControlManager != null) {
            this.callControlManager.setKeepAliveTimeout(wifi, mobile);
        }
    }

    @Override
    public boolean setRootCAPath(String caPath) {
        int enabled = NativeInterface.setRootCAPath(caPath);
        return this.checkSuccess(enabled);
    }

    public boolean checkSuccess(int value) {
        return value == 0;
    }

    @Override
    public boolean setClientCertPath(String certPath) {
        int enabled = NativeInterface.setClientCertPath(certPath);
        return this.checkSuccess(enabled);
    }

    @Override
    public boolean setClientKeyPath(String keyPath) {
        int enabled = NativeInterface.setClientKeyPath(keyPath);
        return this.checkSuccess(enabled);
    }

    @Override
    public boolean setTlsSrtpEnabled(boolean tls, boolean srtp, int cryptType, String key) {
        NativeInterface.setTlsSrtpEnabled(tls, srtp, cryptType, key);
        return true;
    }

    @Override
    public void onTransferStateSucceed(String callid, boolean result) {
        Bundle bundle = new Bundle();
        bundle.putString("callid", callid);
        bundle.putBoolean("result", result);
        this.sendTarget(5, 8238, bundle);
    }

    @Override
    public boolean registerAudioDevice() {
        if (this.callControlManager != null) {
            return this.callControlManager.registerAudioDevice() == 0;
        }
        return false;
    }

    @Override
    public boolean deregisterAudioDevice() {
        if (this.callControlManager != null) {
            return this.callControlManager.deregisterAudioDevice() == 0;
        }
        return false;
    }

    @Override
    public boolean SetNetworkGroupId(String groupId) {
        if (this.callControlManager != null) {
            return this.callControlManager.setNetworkGroupId(groupId) == 0;
        }
        return false;
    }

    @Override
    public void setProcessOriginalDataEnabled(String callid, boolean enabled, OnProcessOriginalAudioDataListener l) {
        if (this.callControlManager != null) {
            this.callControlManager.setProcessOriginalDataEnabled(callid, enabled);
        }
        if (enabled) {
            this.getCCPListenerInfo().mProcessOriginalAudioDataListener = l;
        }
    }

    @Override
    public byte[] onProcessOriginalData(byte[] b) {
        if (this.getCCPListenerInfo().mProcessOriginalAudioDataListener != null) {
            this.getCCPListenerInfo().mProcessOriginalAudioDataListener.onProcessOriginalAudioData(this.ccpCallingID, b, b != null ? b.length : 0);
        }
        return null;
    }

    @Override
    public void setSrtpEnabled(boolean srtp, boolean userMode, int cryptType, String key) {
        if (this.callControlManager != null) {
            this.callControlManager.setSrtpEnabled(srtp, userMode, cryptType, key);
        }
    }

    @Override
    public int requestMemberVideo(String conferenceNo, String conferencePasswd, String remoteSipNo, View videoWindow, String ip, int port) {
        NativeInterface.SetVideoConferenceAddr(ip);
        return NativeInterface.requestMemberVideo(conferenceNo, conferencePasswd, remoteSipNo, videoWindow, port, this.multiViewHashMap);
    }

    @Override
    public int cancelMemberVideo(String conferenceNo, String conferencePasswd, String remoteSipNo) {
        Log4Util.d("stopMemberVideo remoteSipNo :=" + remoteSipNo);
        return NativeInterface.stopMemberVideo(conferenceNo, conferencePasswd, remoteSipNo, this.multiViewHashMap);
    }

    @Override
    public void publishVideoFrame(String appId, String conferenceNo, OnVideoMemberFrameListener l) {
        if (this.callControlManager != null) {
            this.getCCPListenerInfo().onVideoMemberFrameListener = l;
            this.callControlManager.handleVideoPublishOperate(appId, conferenceNo, true);
        }
    }

    @Override
    public void unPublishVideoFrame(String appId, String conferenceNo, OnVideoMemberFrameListener l) {
        if (this.callControlManager != null) {
            this.getCCPListenerInfo().onVideoMemberFrameListener = l;
            this.callControlManager.handleVideoPublishOperate(appId, conferenceNo, false);
        }
    }

    @Override
    public void resetVideoConfWindow(String sipNo, View videoWindow) {
        if (TextUtils.isEmpty((CharSequence)sipNo)) {
            return;
        }
        int resetVideoConfWindow = NativeInterface.resetVideoConfWindow(sipNo, videoWindow);
        Log4Util.i("resetVideoConfWindow " + resetVideoConfWindow);
    }

    @Override
    public void OnPublishVideoFrameRequest(int type, CloopenReason reason) {
        Bundle bundle = this.getCloopenReasonBundle(reason);
        bundle.putInt("type", type);
        this.sendTarget(4, 8240, bundle);
    }

    @Override
    public void onRequestConferenceMemberVideoFailed(int reason, String conferenceId, String voip) {
        if (this.getCCPListenerInfo().mOnVideoConferenceListener != null) {
            this.getCCPListenerInfo().mOnVideoConferenceListener.onRequestConferenceMemberVideoFailed(reason, conferenceId, voip);
        }
    }

    @Override
    public void onCancelConferenceMemberVideo(int reason, String conferenceId, String voip) {
        if (this.getCCPListenerInfo().mOnVideoConferenceListener != null) {
            this.getCCPListenerInfo().mOnVideoConferenceListener.onCancelConferenceMemberVideo(reason, conferenceId, voip);
        }
    }

    @Override
    public int setScreenShareActivity(String callid, View view) {
        if (this.callControlManager != null) {
            return this.callControlManager.setScreenShareActivity(callid, view);
        }
        return 0;
    }
}

