/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.CCP.phone.CCPCallEvent;
import com.CCP.phone.NativeInterface;
import com.hisun.phone.core.voice.CallbackHandler;
import com.hisun.phone.core.voice.DeviceListener;
import com.hisun.phone.core.voice.exception.CCPException;
import com.hisun.phone.core.voice.exception.CCPHttpException;
import com.hisun.phone.core.voice.exception.CCPXmlParserException;
import com.hisun.phone.core.voice.model.CCPParameters;
import com.hisun.phone.core.voice.model.DownloadInfo;
import com.hisun.phone.core.voice.model.Response;
import com.hisun.phone.core.voice.model.UploadImessage;
import com.hisun.phone.core.voice.model.chatroom.ChatRoomList;
import com.hisun.phone.core.voice.model.chatroom.ChatRoomMemberList;
import com.hisun.phone.core.voice.model.chatroom.Chatroom;
import com.hisun.phone.core.voice.model.chatroom.ChatroomMember;
import com.hisun.phone.core.voice.model.chatroom.ChatroomMsg;
import com.hisun.phone.core.voice.model.im.IMAttachedMsg;
import com.hisun.phone.core.voice.model.interphone.InterphoneControlMic;
import com.hisun.phone.core.voice.model.interphone.InterphoneMember;
import com.hisun.phone.core.voice.model.interphone.InterphoneMemberList;
import com.hisun.phone.core.voice.model.interphone.InterphoneMsg;
import com.hisun.phone.core.voice.model.setup.SoftSwitch;
import com.hisun.phone.core.voice.model.setup.UserAgentConfig;
import com.hisun.phone.core.voice.model.videoconference.VideoConference;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceList;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceMember;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceMemberList;
import com.hisun.phone.core.voice.model.videoconference.VideoConferenceMsg;
import com.hisun.phone.core.voice.model.videoconference.VideoPartnerPortrait;
import com.hisun.phone.core.voice.model.videoconference.VideoPartnerPortraitList;
import com.hisun.phone.core.voice.net.ApiParser;
import com.hisun.phone.core.voice.net.HttpClientUtil;
import com.hisun.phone.core.voice.net.HttpManager;
import com.hisun.phone.core.voice.opts.ConferenceOptions;
import com.hisun.phone.core.voice.token.Base64;
import com.hisun.phone.core.voice.util.CheckApnTypeUtils;
import com.hisun.phone.core.voice.util.Log4Util;
import com.hisun.phone.core.voice.util.UserAgentUtils;
import com.hisun.phone.core.voice.util.VoiceUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;

@SuppressLint(value={"HandlerLeak"})
public abstract class AbstractDispatcher {
    private ServiceHandler mServiceHandler;
    private Looper mServiceLooper;
    private UserAgentConfig userAgentConfig;
    private CCPCallEvent listener;
    private String registBody = null;
    private String softSwitchDefaultAddress = null;
    private int softSwitchDefaultPort = 0;
    private String control = null;
    private Context context;
    private String protocol = "https";
    public static final int WHAT_MAKECALLBACK = 1;
    public static final int WHAT_START_INTERPHONE = 7;
    public static final int WHAT_CONTROL_MIC = 8;
    public static final int WHAT_RELEASE_MIC = 9;
    public static final int WHAT_QUERY_INTERPHONE_MEMBERS = 10;
    public static final int WHAT_START_CHATROOM = 11;
    public static final int WHAT_QUERY_CHATROOMS = 12;
    public static final int WHAT_INVITE_JOIN_CHATROOM = 13;
    public static final int WHAT_QUERY_CHATROOM_MEMBERS = 14;
    public static final int WHAT_SEND_MEDIA_MSG = 15;
    public static final int WHAT_NOTIFY_MEDIA_MSG_STATUES = 16;
    public static final int WHAT_DOWNLOAD_MEDIA_MSG = 17;
    public static final int WHAT_UPLOAD_MEDIA_CHUNKED = 18;
    public static final int WHAT_CONFIRM_DOWNLOAD_MEDIAMESSAGE = 19;
    public static final int WHAT_DISMISS_CHATROOM = 20;
    public static final int WHAT_REMOVE_MEMBER_CHATROOM = 21;
    public static final int WHAT_START_VIDEOCONFERENCE = 22;
    public static final int WHAT_QUERY_VIDEOCONFERENCES = 23;
    public static final int WHAT_QUERY_VIDEOCONFERENCE_MEMBERS = 24;
    public static final int WHAT_REMOVE_MEMBER_VIDEOCONFERENCE = 25;
    public static final int WHAT_DISMISS_VIDEOCONFERENCE = 26;
    public static final int WHAT_SWITCH_REALSCREEN = 27;
    public static final int WHAT_CCP_DOWNLOAD = 28;
    public static final int WHAT_GET_VIDEO_CONFERENCE_PORPRRAIT = 29;
    public static final int WHAT_SEND_LOCAL_VIDEO_PORPRTAIT = 30;
    public static final int WHAT_SET_CHATROOM_SPEAK_OPT = 31;
    public static final int WHAT_START_VIDEOCONFERENCE_MULTI = 32;
    public static final int WHAT_PUBLISH_VIDEO = 33;

    public AbstractDispatcher(Context context) {
        this.context = context;
        this.checkSimState();
        this.initServiceHandler();
    }

    public void checkSimState() {
        if (CheckApnTypeUtils.checkNetworkAPNType(this.context) == DeviceListener.APN.WIFI) {
            this.protocol = "https";
            return;
        }
        VoiceUtil.SIMProvider provider = VoiceUtil.getSIMProvider(this.context);
        this.protocol = provider == VoiceUtil.SIMProvider.TELECOM ? "http" : (CheckApnTypeUtils._isChinaMobileUnicomWap(this.context) ? "http" : "https");
    }

    private void initServiceHandler() {
        HandlerThread thread = new HandlerThread("CCPServiceArguments", 10);
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public final Message getHandleMessage() {
        Message msg = this.mServiceHandler.obtainMessage();
        return msg;
    }

    public final void sendHandleMessage(Message msg) {
        this.mServiceHandler.sendMessage(msg);
    }

    public final void sendHandleMessageAtFront(Message msg) {
        this.mServiceHandler.sendMessageAtFrontOfQueue(msg);
    }

    public final void removeHandleMessages(int what) {
        this.mServiceHandler.removeMessages(what);
    }

    private StringBuffer getStringBuffer() {
        StringBuffer sb = new StringBuffer(this.userAgentConfig.getRequestUrl(this.protocol));
        sb.append("/2013-12-26");
        return sb;
    }

    private void register(String xmlBody, String accountSid, String password) {
        if (TextUtils.isEmpty((CharSequence)this.softSwitchDefaultAddress) || this.softSwitchDefaultPort == 0) {
            Log4Util.e("SDK_DEVICE", "soft address errors, can't register.");
            return;
        }
        if (accountSid == null || password == null) {
            Log4Util.e("SDK_DEVICE", "voip account errors, can't register.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)xmlBody) ? NativeInterface.connectToCCP(this.softSwitchDefaultAddress, this.softSwitchDefaultPort, accountSid, password, this.getControl()) != 0 : NativeInterface.connectToCCPWithXML(xmlBody, accountSid, password, this.getControl()) != 0) {
            throw new IllegalStateException("connectToCCP failed.");
        }
        Log4Util.i("SDK_DEVICE", "[CallControllerManager - register] register finished, sid: " + accountSid + ", pwd:" + password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMakeCallBack(String selfPhoneNumber, String destPhoneNumber, String srcSerNum, String destSerNum) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/Calls/Callback");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("CallBack");
        parameters.add("from", VoiceUtil.getStandardMDN(selfPhoneNumber));
        parameters.add("to", VoiceUtil.getStandardMDN(VoiceUtil.getStandardMDN(destPhoneNumber)));
        if (!TextUtils.isEmpty((CharSequence)srcSerNum)) {
            parameters.add("fromSerNum", srcSerNum);
        }
        if (!TextUtils.isEmpty((CharSequence)destSerNum)) {
            parameters.add("customerSerNum", destSerNum);
        }
        try {
            if (this.listener != null) {
                this.listener.onCallBack(170010, selfPhoneNumber, destPhoneNumber);
            }
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String xml = HttpManager.doRequestUrl(url.toString(), "POST", parameters);
            Response response = ApiParser.doParser(980101, new ByteArrayInputStream(xml.getBytes()));
            int status = -1;
            if (response != null) {
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
            if (this.listener != null) {
                this.listener.onCallBack(status, selfPhoneNumber, destPhoneNumber);
            }
        }
        catch (Exception e) {
            int errorCode = this.handleSDKRequestException(e);
            if (this.listener != null) {
                this.listener.onCallBack(errorCode, selfPhoneNumber, destPhoneNumber);
            }
        }
        finally {
            this.clearRequestCache(parameters);
        }
    }

    void doQuerySoftSwitchAddress() throws Exception {
        if (this.userAgentConfig == null) {
            return;
        }
        this.doQuerySoftSwitchAddress(this.userAgentConfig.getPrivateCloud(), this.userAgentConfig.getSid(), this.userAgentConfig.getSubaccountid(), this.userAgentConfig.getSubpassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doQuerySoftSwitchAddress(String privateCloud, String accountId, String subAccountId, String subAuthToken) throws Exception {
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/Switchs/").append(accountId);
        if (!TextUtils.isEmpty((CharSequence)privateCloud)) {
            url.append("/").append(privateCloud);
        }
        url.append("?sig=").append(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        url.append("&deviceNo=").append(VoiceUtil.createDeviceNo(this.context));
        url.append("&ua=").append(Base64.encode(UserAgentUtils.getUser_Agent(this.getContext()).getBytes()));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        CCPParameters params = new CCPParameters();
        params.add("Authorization", authorization);
        String method = "GET";
        boolean encrypt = false;
        if (!TextUtils.isEmpty((CharSequence)privateCloud) && url.indexOf(privateCloud) != -1) {
            encrypt = true;
            method = "POST";
            params.setParamerTagKey("Switch");
            params.add("validate", this.userAgentConfig.getValidate());
            params.add("voippwd", this.userAgentConfig.getPassword());
        }
        int status = 170009;
        try {
            String xml = HttpManager.doRequestUrl(url.toString(), method, params, encrypt);
            Response response = ApiParser.doParser(980100, new ByteArrayInputStream(xml.getBytes()));
            if (response == null) {
                Log4Util.e("SDK_DEVICE", "get soft address return null.");
                status = 170019;
            }
            if (response.isError()) {
                Log4Util.e("SDK_DEVICE", "get soft address return errors: " + response.statusCode);
                try {
                    status = Integer.valueOf(response.statusCode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (response instanceof SoftSwitch) {
                status = 0;
                SoftSwitch sswitch = (SoftSwitch)response;
                if (sswitch.getSoftClpss() != null && !sswitch.getSoftClpss().isEmpty()) {
                    SoftSwitch.Clpss clpss = sswitch.getSoftClpss().get(0);
                    if (clpss.getIp().equals(this.softSwitchDefaultAddress)) {
                        Log4Util.w("SDK_DEVICE", "currently soft address was samed with last.");
                    } else {
                        this.softSwitchDefaultAddress = clpss.getIp();
                        this.softSwitchDefaultPort = clpss.getPort();
                    }
                }
                this.registBody = sswitch.toXMLBody();
                this.control = sswitch.getControl();
                Log4Util.d("nwgid " + sswitch.getNetworkGroupId());
                NativeInterface.SetNetworkGroupId(sswitch.getNetworkGroupId());
                if (!TextUtils.isEmpty((CharSequence)sswitch.getP2PServerPort())) {
                    this.userAgentConfig.setP2pServerPort(sswitch.getP2PServerPort());
                    this.setStunServer(sswitch.getP2PServerPort());
                }
            }
            Log4Util.i("SDK_DEVICE", "Request successful, SoftSwitch : " + this.registBody);
            this.register(this.registBody, this.userAgentConfig.getSid(), this.userAgentConfig.getPassword());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(params);
        }
        if (this.getListener() != null && status != 0) {
            this.getListener().onConnectError(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void QueryNWGID() throws Exception {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/QueryNWGID");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("Request");
        parameters.add("sha", Base64.encode((VoiceUtil.getIMEI(this.getContext()) + ";" + VoiceUtil.getLocalMacAddress(this.getContext())).getBytes()));
        String networkGroupId = null;
        String message = null;
        int status = -1;
        try {
            String xml = HttpManager.doRequestUrl(url.toString(), "POST", parameters);
            Response response = ApiParser.doParser(980129, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    SoftSwitch sswitch = (SoftSwitch)response;
                    networkGroupId = sswitch.getNetworkGroupId();
                }
            } else {
                status = 170002;
            }
            if (!TextUtils.isEmpty(networkGroupId) && VoiceUtil.isNetWorkTypeWIFI()) {
                NativeInterface.SetNetworkGroupId(networkGroupId);
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
    }

    private void clearRequestCache(CCPParameters params) {
        if (params != null) {
            params.clear();
            params = null;
        }
    }

    private void checkSecurityUrl(StringBuffer url) {
        if (!URLUtil.isHttpsUrl((String)url.toString()) && !URLUtil.isHttpUrl((String)url.toString())) {
            throw new RuntimeException("login security address invalid.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartInterphone(String[] members, String type, String appid) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/interphone/create");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("Interphone");
        parameters.add("appId", appid);
        parameters.add("type", type);
        StringBuffer body = new StringBuffer();
        for (int i = 0; i < members.length; ++i) {
            body.append("\t<member>").append(members[i]).append("</member>\r\n");
        }
        parameters.add("members", body.toString());
        String confN = null;
        String message = null;
        int status = -1;
        try {
            String xml = HttpManager.doRequestUrl(url.toString(), "POST", parameters);
            Response response = ApiParser.doParser(980108, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    InterphoneMsg interphone = (InterphoneMsg)response;
                    confN = interphone.interphoneId;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onInterphoneState(CallbackHandler.getCloopenReason(status, message), confN);
        }
    }

    private int handleSDKRequestException(Exception e) {
        e.printStackTrace();
        Log4Util.e("SDK_DEVICE", e.getMessage());
        if (e instanceof CCPHttpException) {
            CCPHttpException httpException = (CCPHttpException)e;
            return httpException.getStatusCode();
        }
        if (e instanceof CCPXmlParserException) {
            return 170004;
        }
        return 170009;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doControlMIC(String confNo) {
        int status;
        String message;
        String speaker;
        block11: {
            String subAccountId = this.userAgentConfig.getSubaccountid();
            String subAuthToken = this.userAgentConfig.getSubpassword();
            String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
            StringBuffer url = this.getStringBuffer();
            url.append("/SubAccounts/").append(subAccountId).append("/interphone/robMic");
            CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
            this.checkSecurityUrl(url);
            String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
            parameters.add("Authorization", authorization);
            parameters.setParamerTagKey("Interphone");
            parameters.add("interphoneId", confNo);
            speaker = null;
            message = null;
            status = -1;
            try {
                String xml = HttpManager.doRequestUrl(url.toString(), "POST", parameters);
                Response response = ApiParser.doParser(980109, new ByteArrayInputStream(xml.getBytes()));
                if (response != null) {
                    message = response.getStatusMsg();
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (response.isError()) {
                        InterphoneControlMic mic = (InterphoneControlMic)response;
                        speaker = mic.speaker;
                    } else {
                        speaker = this.userAgentConfig.getSid();
                    }
                    break block11;
                }
                status = 170002;
            }
            catch (Exception e) {
                status = this.handleSDKRequestException(e);
            }
            finally {
                this.clearRequestCache(parameters);
            }
        }
        if (this.getListener() != null) {
            this.getListener().onControlMicState(CallbackHandler.getCloopenReason(status, message), speaker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReleaseMIC(String confNo) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/interphone/releaseMic");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("Interphone");
        parameters.add("interphoneId", confNo);
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestUrl(url.toString(), "POST", parameters);
            Response response = ApiParser.doParser(980110, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onReleaseMicState(CallbackHandler.getCloopenReason(status, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doQueryMembersWithInterphone(String confNo) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/interphone/members");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("Interphone");
        parameters.add("interphoneId", confNo);
        int status = -1;
        String message = null;
        ArrayList<InterphoneMember> interphoneMembers = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980111, new ByteArrayInputStream(xml.getBytes()));
            InterphoneMemberList list = null;
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    list = (InterphoneMemberList)response;
                }
            } else {
                status = 170002;
            }
            interphoneMembers = list == null ? null : list.interphoneMemberList;
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onInterphoneMembers(CallbackHandler.getCloopenReason(status, message), interphoneMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartChatroom(String appid, String roomName, int square, String keywords, String pwd, int isAutoClose, int voiceMod, int isAutoDelete) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/chatroom/create");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("ChatRoom");
        parameters.add("appId", appid);
        parameters.add("square", square);
        parameters.add("roomName", roomName);
        if (!TextUtils.isEmpty((CharSequence)pwd)) {
            parameters.add("pwd", pwd);
        }
        if (!TextUtils.isEmpty((CharSequence)keywords)) {
            parameters.add("keywords", keywords);
        }
        parameters.add("isAutoClose", isAutoClose);
        parameters.add("autoDelete", isAutoDelete);
        parameters.add("voiceMod", voiceMod);
        String ChatRoomId = null;
        String message = null;
        int status = -1;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980112, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    ChatroomMsg chatRoomMsg = (ChatroomMsg)response;
                    if (chatRoomMsg != null) {
                        ChatRoomId = chatRoomMsg.getRoomNo();
                    }
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onChatRoomState(CallbackHandler.getCloopenReason(status, message), ChatRoomId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDismissChatRomm(String appId, String chatroomid) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/chatroom/dismiss");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("ChatRoom");
        parameters.add("appId", appId);
        parameters.add("roomId", chatroomid);
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980119, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onChatRoomDismiss(CallbackHandler.getCloopenReason(status, message), chatroomid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveMemberFromChatRoom(String appId, String chatroomid, String member) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/chatroom/remove");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("ChatRoom");
        parameters.add("appId", appId);
        parameters.add("roomId", chatroomid);
        parameters.add("mobile", member);
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980120, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onChatRoomRemoveMember(CallbackHandler.getCloopenReason(status, message), member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetChatroomSpeakType(String appId, String chatroomid, String member, int opt) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/chatroom/allowSpeak");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("ChatRoom");
        parameters.add("appId", appId);
        parameters.add("roomId", chatroomid);
        parameters.add("number", member);
        parameters.add("opt", opt);
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980130, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onSetChatroomSpeakOpt(CallbackHandler.getCloopenReason(status, message), member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doQueryChatRooms(String appId, String keywords) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/chatroom/roomlist");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("ChatRoom");
        parameters.add("appId", appId);
        if (!TextUtils.isEmpty((CharSequence)keywords)) {
            parameters.add("keywords", keywords);
        }
        int status = -1;
        String message = null;
        ArrayList<Chatroom> chatRoomList = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980113, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    ChatRoomList list = (ChatRoomList)response;
                    if (list != null) {
                        chatRoomList = list.chatroomInfos;
                    }
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onChatRooms(CallbackHandler.getCloopenReason(status, message), chatRoomList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doInviteMembersJoinChatroom(String[] members, String roomNo, String appId) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/chatroom/invite");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("ChatRoom");
        parameters.add("appId", appId);
        parameters.add("roomId", roomNo);
        StringBuffer body = new StringBuffer();
        for (int i = 0; i < members.length; ++i) {
            body.append("\t<mobile>").append(members[i]).append("</mobile>\r\n");
        }
        parameters.add("mobiles", body.toString());
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980114, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onChatRoomInvite(CallbackHandler.getCloopenReason(status, message), roomNo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doQueryMembersWithChatroom(String chatRoomId) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/chatroom/members");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("ChatRoom");
        parameters.add("roomId", chatRoomId);
        ArrayList<ChatroomMember> member = null;
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980115, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    ChatRoomMemberList list = (ChatRoomMemberList)response;
                    if (list != null) {
                        member = list.chatRoomInfos;
                    }
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onChatRoomMembers(CallbackHandler.getCloopenReason(status, message), member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSendMediaMsg(String uniqueID, String fileName, String receiver, String userData) {
        String accountId = this.userAgentConfig.getSid();
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        File file = new File(fileName);
        if (!file.exists()) {
            throw new RuntimeException("The file URL does not exist,  " + fileName + ".");
        }
        String state = Environment.getExternalStorageState();
        if (!state.equals("mounted")) {
            throw new RuntimeException("SD Card is not mounted,It is  " + state + ".");
        }
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/IM/SendMsg");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("InstanceMessage");
        parameters.add("sender", accountId);
        parameters.add("receiver", receiver);
        parameters.add("type", 0);
        parameters.add("fileSize", file.length());
        parameters.add("msgId", uniqueID);
        if (!TextUtils.isEmpty((CharSequence)userData)) {
            parameters.add("userData", userData);
        }
        String ext = VoiceUtil.getExtensionName(fileName);
        if (fileName.length() == ext.length()) {
            ext = "";
        }
        parameters.add("fileExt", ext);
        int status = -1;
        String message = null;
        IMAttachedMsg imAttachedMsg = null;
        try {
            UploadImessage response = this.querySendMediaMsgServerAddress(url.toString(), parameters);
            if (response == null) {
                Log4Util.e("SDK_DEVICE", "Get the file server address error .");
                throw new IllegalStateException("Get the file server address error .");
            }
            status = Integer.parseInt(response.statusCode);
            message = response.getStatusMsg();
            if (response.isError() || TextUtils.isEmpty((CharSequence)response.getUploadUrl()) || response.mediaMsg == null) {
                if (this.getListener() != null) {
                    this.getListener().onSendInstanceMessage(CallbackHandler.getCloopenReason(status, message), response.mediaMsg);
                }
                return;
            }
            imAttachedMsg = response.mediaMsg;
            imAttachedMsg.setMsgId(uniqueID);
            imAttachedMsg.setExt(ext);
            imAttachedMsg.setFileUrl(fileName);
            formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
            StringBuffer uploadUrl = new StringBuffer(response.getUploadUrl());
            uploadUrl.append("?token=").append(response.getUploadToken());
            Log4Util.w("SDK_DEVICE", "url: " + uploadUrl + "\r\n");
            String xml = HttpClientUtil.postRequestUploadFileChunk(uploadUrl.toString(), fileName);
            Log4Util.w("SDK_DEVICE", xml + "\r\n");
            Response uVoiceRes = ApiParser.doParser(980106, new ByteArrayInputStream(xml.getBytes()));
            imAttachedMsg.setFileSize(file.length());
            imAttachedMsg.setSender(accountId);
            imAttachedMsg.setReceiver(receiver);
            if (uVoiceRes != null) {
                response.statusCode = uVoiceRes.statusCode;
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
                message = response.getStatusMsg();
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            imAttachedMsg = new IMAttachedMsg(uniqueID);
            imAttachedMsg.setExt(ext);
            imAttachedMsg.setFileUrl(fileName);
            this.getListener().onSendInstanceMessage(CallbackHandler.getCloopenReason(status, message), imAttachedMsg);
        }
    }

    UploadImessage querySendMediaMsgServerAddress(String url, CCPParameters parameters) throws CCPException {
        String xml = HttpManager.doRequestPostUrl(url, parameters);
        Log4Util.w("SDK_DEVICE", xml + "\r\n");
        return (UploadImessage)ApiParser.doParser(980116, new ByteArrayInputStream(xml.getBytes()));
    }

    void doConfirmDownloadMediaMessage(String[] msgId) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/IM/Done");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("InstanceMessage");
        if (msgId != null) {
            StringBuffer body = new StringBuffer();
            for (int i = 0; i < msgId.length; ++i) {
                body.append("\t<msgId>").append(msgId[i]).append("</msgId>\r\n");
            }
            parameters.add("InstanceMessage", body.toString());
        }
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestUrl(url.toString(), "POST", parameters);
            Response response = ApiParser.doParser(980100, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        if (this.getListener() != null) {
            this.getListener().onConfirmIntanceMessage(CallbackHandler.getCloopenReason(status, message));
        }
    }

    void doDownloadAttachmentFiles(ArrayList<DownloadInfo> dLoadList) {
        if (dLoadList != null && !dLoadList.isEmpty()) {
            for (DownloadInfo dLoadInfo : dLoadList) {
                int status = 170009;
                String url = null;
                try {
                    if (dLoadInfo != null && !TextUtils.isEmpty((CharSequence)dLoadInfo.getUploadurl())) {
                        String fileExt = VoiceUtil.getExtensionName(dLoadInfo.getUploadurl());
                        status = dLoadInfo.isChunked() && "amr".equals(fileExt) ? HttpClientUtil.postRequestDownload(dLoadInfo.getUploadurl(), dLoadInfo.getSavePath()) : HttpManager.httpDowloadFile(dLoadInfo.getUploadurl(), dLoadInfo.getSavePath());
                        Log4Util.w("SDK_DEVICE", "url: " + dLoadInfo.getUploadurl() + "\r\n");
                        url = dLoadInfo.getSavePath();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    status = 170009;
                }
                if (this.getListener() == null) continue;
                this.getListener().onDownloadAttached(CallbackHandler.getCloopenReason(status), url);
            }
        }
    }

    void doCCPDownload(ArrayList<DownloadInfo> dLoadList) {
        if (dLoadList != null && !dLoadList.isEmpty()) {
            for (DownloadInfo dLoadInfo : dLoadList) {
                int reason = 170002;
                try {
                    if (dLoadInfo != null && !TextUtils.isEmpty((CharSequence)dLoadInfo.getUploadurl())) {
                        Log4Util.w("SDK_DEVICE", "url: " + dLoadInfo.getUploadurl() + "\r\n");
                        reason = HttpManager.httpDowload(dLoadInfo.getUploadurl(), dLoadInfo.getSavePath()) ? 0 : 170002;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    reason = 170002;
                }
                this.doRedirectCCPDownloadCallback(reason, dLoadInfo);
            }
        }
    }

    void doRedirectCCPDownloadCallback(int reason, DownloadInfo downloadInfo) {
        if (downloadInfo == null || this.getListener() == null) {
            return;
        }
    }

    void doDownloadVideoConferencePortraits(ArrayList<VideoPartnerPortrait> portraitsList) {
        if (portraitsList != null && !portraitsList.isEmpty()) {
            for (VideoPartnerPortrait portraits : portraitsList) {
                int reason = 170002;
                try {
                    if (portraits != null && !TextUtils.isEmpty((CharSequence)portraits.getFileUrl())) {
                        Log4Util.w("SDK_DEVICE", "doDownloadVideoConferencePortraits.url: " + portraits.getFileUrl() + "\r\n");
                        reason = HttpManager.httpDowload(portraits.getFileUrl(), portraits.getFileLocalPath()) ? 0 : 170005;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    reason = 170009;
                }
                if (this.getListener() == null) continue;
                this.getListener().onDownloadVideoConferencePortraits(CallbackHandler.getCloopenReason(reason), portraits);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUploadMediaChunked(String uniqueID, String fileName, String receiver, String userData) {
        String accountId = this.userAgentConfig.getSid();
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer httpsurl = this.getStringBuffer();
        httpsurl.append("/SubAccounts/").append(subAccountId).append("/IM/SendMsg");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(httpsurl);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("InstanceMessage");
        parameters.add("sender", accountId);
        parameters.add("receiver", receiver);
        parameters.add("type", 1);
        parameters.add("fileSize", 0);
        parameters.add("msgId", uniqueID);
        if (!TextUtils.isEmpty((CharSequence)userData)) {
            parameters.add("userData", userData);
        }
        parameters.add("fileExt", "amr");
        int status = -1;
        String message = null;
        IMAttachedMsg imAttachedMsg = null;
        try {
            UploadImessage response = this.querySendMediaMsgServerAddress(httpsurl.toString(), parameters);
            if (response == null) {
                Log4Util.e("SDK_DEVICE", "Get the file server address error .");
                throw new IllegalStateException("Get the file server address error .");
            }
            status = Integer.parseInt(response.statusCode);
            message = response.getStatusMsg();
            if (response.isError() || TextUtils.isEmpty((CharSequence)response.getUploadUrl()) || response.mediaMsg == null) {
                if (this.getListener() != null) {
                    this.getListener().onSendInstanceMessage(CallbackHandler.getCloopenReason(status, message), response.mediaMsg);
                }
                return;
            }
            imAttachedMsg = response.mediaMsg;
            imAttachedMsg.setMsgId(uniqueID);
            imAttachedMsg.setFileUrl(fileName);
            imAttachedMsg.setExt("amr");
            imAttachedMsg.setSender(accountId);
            imAttachedMsg.setReceiver(receiver);
            StringBuffer url = new StringBuffer(response.getUploadUrl());
            url.append("?token=").append(response.getUploadToken());
            Log4Util.w("SDK_DEVICE", "url: " + url + "\r\n");
            String xml = HttpClientUtil.postRequestUploadChunk(url.toString());
            Log4Util.w("SDK_DEVICE", xml + "\r\n");
            Response uVoiceRes = ApiParser.doParser(980106, new ByteArrayInputStream(xml.getBytes()));
            if (uVoiceRes != null) {
                response.statusCode = uVoiceRes.statusCode;
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
                message = response.getStatusMsg();
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
            imAttachedMsg = new IMAttachedMsg(uniqueID);
            imAttachedMsg.setFileUrl(fileName);
            imAttachedMsg.setExt("amr");
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onSendInstanceMessage(CallbackHandler.getCloopenReason(status, message), imAttachedMsg);
        }
    }

    @Deprecated
    void doStartVideoConference(String appid, String roomName, int square, String keywords, String pwd, int isAutoClose) {
        this.doStartVideoConference(appid, roomName, square, keywords, pwd, isAutoClose, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartVideoConference(String appid, String roomName, int square, String keywords, String pwd, int isAutoClose, int voiceMod, int isAutoDelete) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/create");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("appId", appid);
        parameters.add("square", square);
        parameters.add("roomName", roomName);
        if (!TextUtils.isEmpty((CharSequence)pwd)) {
            parameters.add("pwd", pwd);
        }
        if (!TextUtils.isEmpty((CharSequence)keywords)) {
            parameters.add("keywords", keywords);
        }
        parameters.add("isAutoClose", isAutoClose);
        parameters.add("autoDelete", isAutoDelete);
        parameters.add("voiceMod", voiceMod);
        String videoConference = null;
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980124, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    VideoConferenceMsg roomMsg = (VideoConferenceMsg)response;
                    if (roomMsg != null) {
                        videoConference = roomMsg.getConferenceId();
                    }
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onVideoConferenceState(CallbackHandler.getCloopenReason(status, message), videoConference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartVideoConference(String appid, String roomName, String pwd, ConferenceOptions options) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/create");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("appId", appid);
        parameters.add("square", options.inSquare);
        parameters.add("roomName", roomName);
        if (!TextUtils.isEmpty((CharSequence)pwd)) {
            parameters.add("pwd", pwd);
        }
        if (!TextUtils.isEmpty((CharSequence)options.inKeywords)) {
            parameters.add("keywords", options.inKeywords);
        }
        parameters.add("isAutoClose", options.inAutoClose ? 0 : 1);
        parameters.add("autoDelete", options.inAutoDelete ? 1 : 0);
        parameters.add("voiceMod", options.inVoiceMod);
        parameters.add("isMultiVideo", options.inMultiVideo ? 1 : 0);
        parameters.add("isPresenter", options.inPresenter ? 1 : 0);
        String videoConference = null;
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980124, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    VideoConferenceMsg roomMsg = (VideoConferenceMsg)response;
                    if (roomMsg != null) {
                        videoConference = roomMsg.getConferenceId();
                    }
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onVideoConferenceState(CallbackHandler.getCloopenReason(status, message), videoConference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doQueryVideoConferences(String appId, String keywords) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/roomlist");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("appId", appId);
        if (!TextUtils.isEmpty((CharSequence)keywords)) {
            parameters.add("keywords", keywords);
        }
        ArrayList<VideoConference> conferences = null;
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980125, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    VideoConferenceList list = (VideoConferenceList)response;
                    if (list != null) {
                        conferences = list.videoConferences;
                    }
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onVideoConferences(CallbackHandler.getCloopenReason(status, message), conferences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doQueryMembersInVideoConference(String conferenceId) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/members");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("roomId", conferenceId);
        int status = -1;
        String message = null;
        ArrayList<VideoConferenceMember> videoConferenceList = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980127, new ByteArrayInputStream(xml.getBytes()));
            VideoConferenceMemberList list = null;
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    list = (VideoConferenceMemberList)response;
                }
            } else {
                status = 170002;
            }
            videoConferenceList = list == null ? null : list.videoConferenceMembers;
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onVideoConferenceMembers(CallbackHandler.getCloopenReason(status, message), videoConferenceList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDismissVideoConference(String appId, String conferenceId) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/dismiss");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("appId", appId);
        parameters.add("roomId", conferenceId);
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980121, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onVideoConferenceDismiss(CallbackHandler.getCloopenReason(status, message), conferenceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveMemberFromVideoConference(String appId, String conferenceId, String member) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/remove");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("appId", appId);
        parameters.add("roomId", conferenceId);
        parameters.add("voip", member);
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980122, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onVideoConferenceRemoveMember(CallbackHandler.getCloopenReason(status, message), member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doPublishVideoRequest(String appId, String conferenceId) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/publish");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("appId", appId);
        parameters.add("roomId", conferenceId);
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980131, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().OnPublishVideoFrameRequest(0, CallbackHandler.getCloopenReason(status, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUnPublishVideoRequest(String appId, String conferenceId) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/unpublish");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("appId", appId);
        parameters.add("roomId", conferenceId);
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980131, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().OnPublishVideoFrameRequest(1, CallbackHandler.getCloopenReason(status, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doswitchRealScreenToVoip(String appId, String conferenceId, String voip) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/changed");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("appId", appId);
        parameters.add("roomId", conferenceId);
        parameters.add("toVoip", voip);
        int status = -1;
        String message = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980123, new ByteArrayInputStream(xml.getBytes()));
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onSwitchRealScreenToVoip(CallbackHandler.getCloopenReason(status, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doPortraitsFromVideoConference(String conferenceId) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/download");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("roomId", conferenceId);
        int status = -1;
        String message = null;
        ArrayList<VideoPartnerPortrait> videoPortraitList = null;
        try {
            String xml = HttpManager.doRequestPostUrl(url.toString(), parameters);
            Response response = ApiParser.doParser(980128, new ByteArrayInputStream(xml.getBytes()));
            VideoPartnerPortraitList list = null;
            if (response != null) {
                message = response.getStatusMsg();
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                    list = (VideoPartnerPortraitList)response;
                }
            } else {
                status = 170002;
            }
            videoPortraitList = list == null ? null : list.videoPartnerPortraits;
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onGetPortraitsFromVideoConference(CallbackHandler.getCloopenReason(status, message), videoPortraitList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSendLocalPortrait(String fileName, String conferenceId) {
        String subAccountId = this.userAgentConfig.getSubaccountid();
        String subAuthToken = this.userAgentConfig.getSubpassword();
        String formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
        StringBuffer url = this.getStringBuffer();
        url.append("/SubAccounts/").append(subAccountId).append("/video/upload");
        CCPParameters parameters = this.getCCPParameters(VoiceUtil.md5(subAccountId + subAuthToken + formatTimestamp));
        File file = new File(fileName);
        if (!file.exists()) {
            throw new RuntimeException("The file URL does not exist,  " + fileName + ".");
        }
        String state = Environment.getExternalStorageState();
        if (!state.equals("mounted")) {
            throw new RuntimeException("SD Card is not mounted,It is  " + state + ".");
        }
        this.checkSecurityUrl(url);
        String authorization = Base64.encode((subAccountId + ":" + formatTimestamp).getBytes());
        parameters.add("Authorization", authorization);
        parameters.setParamerTagKey("VideoConf");
        parameters.add("roomId", conferenceId);
        parameters.add("fileSize", file.length());
        String ext = VoiceUtil.getExtensionName(fileName);
        if (fileName.length() == ext.length()) {
            ext = "";
        }
        parameters.add("fileExt", ext);
        int status = -1;
        String message = null;
        try {
            UploadImessage response = this.querySendMediaMsgServerAddress(url.toString(), parameters);
            if (response == null) {
                Log4Util.e("SDK_DEVICE", "Get the file server address error .");
                throw new IllegalStateException("Get the file server address error .");
            }
            status = Integer.parseInt(response.statusCode);
            message = response.getStatusMsg();
            if (response.isError() || TextUtils.isEmpty((CharSequence)response.getUploadUrl())) {
                if (this.getListener() != null) {
                    this.getListener().onSendLocalPortrait(CallbackHandler.getCloopenReason(status, message), conferenceId);
                }
                return;
            }
            formatTimestamp = VoiceUtil.formatTimestamp(System.currentTimeMillis());
            StringBuffer uploadUrl = new StringBuffer(response.getUploadUrl());
            uploadUrl.append("?token=").append(response.getUploadToken());
            Log4Util.w("SDK_DEVICE", "url: " + uploadUrl + "\r\n");
            String xml = HttpClientUtil.postRequestUploadFileChunk(uploadUrl.toString(), fileName);
            Log4Util.w("SDK_DEVICE", xml + "\r\n");
            Response uVoiceRes = ApiParser.doParser(980106, new ByteArrayInputStream(xml.getBytes()));
            if (uVoiceRes != null) {
                response.statusCode = uVoiceRes.statusCode;
                if (response.isError()) {
                    try {
                        status = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    status = 0;
                }
                message = response.getStatusMsg();
            } else {
                status = 170002;
            }
        }
        catch (Exception e) {
            status = this.handleSDKRequestException(e);
            Log4Util.w("SDK_DEVICE", "doSendLocalPorprtait result : " + status + "\r\n");
        }
        finally {
            this.clearRequestCache(parameters);
        }
        if (this.getListener() != null) {
            this.getListener().onSendLocalPortrait(CallbackHandler.getCloopenReason(status, message), conferenceId);
        }
    }

    CCPParameters getCCPParameters(String capacity) {
        CCPParameters parameters = new CCPParameters();
        if (!TextUtils.isEmpty((CharSequence)capacity)) {
            parameters.add("sig", capacity);
        }
        return parameters;
    }

    protected void setStunServer(String server) {
    }

    void destroy() {
        if (this.userAgentConfig != null) {
            this.userAgentConfig.released();
        }
        this.userAgentConfig = null;
        this.listener = null;
        if (this.mServiceLooper != null) {
            this.mServiceLooper.quit();
        }
        this.mServiceHandler = null;
    }

    UserAgentConfig getUserAgentConfig() {
        return this.userAgentConfig;
    }

    void setUserAgentConfig(UserAgentConfig userAgentConfig) throws Exception {
        this.userAgentConfig = userAgentConfig;
    }

    CCPCallEvent getListener() {
        return this.listener;
    }

    void setListener(CCPCallEvent listener) {
        this.listener = listener;
    }

    Context getContext() {
        return this.context;
    }

    String getSoftSwitchAddress() {
        return this.softSwitchDefaultAddress;
    }

    int getSoftSwitchPort() {
        return this.softSwitchDefaultPort;
    }

    String getControl() {
        return this.control;
    }

    public ServiceHandler getServiceHandler() {
        return this.mServiceHandler;
    }

    public void postCommand(Runnable command) {
        if (this.mServiceHandler != null) {
            this.mServiceHandler.post(command);
        } else {
            Log4Util.d("SDK_DEVICE", "mServiceHandler is null, then init.");
            this.initServiceHandler();
        }
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Log4Util.i("SDK_DEVICE", Thread.currentThread().getName());
            Bundle b = (Bundle)msg.obj;
            int what = msg.arg1;
            Log4Util.i("SDK_DEVICE", "What: " + what);
            if (what == 1) {
                String selfPhoneNumber = (String)b.get("com.ccp.phone.selfphone");
                String destPhoneNumber = (String)b.get("com.ccp.phone.destphone");
                String srcSerNum = (String)b.get("com.ccp.phone.srcSerNum");
                String destSerNum = (String)b.get("com.ccp.phone.destSerNum");
                AbstractDispatcher.this.doMakeCallBack(selfPhoneNumber, destPhoneNumber, srcSerNum, destSerNum);
            } else if (what == 7) {
                String[] members = b.getStringArray("com.ccp.phone.members");
                String type = b.getString("com.ccp.phone.type");
                String appid = b.getString("com.ccp.phone.appId");
                AbstractDispatcher.this.doStartInterphone(members, type, appid);
            } else if (what == 8) {
                String confNo = b.getString("com.ccp.phone.confNo");
                AbstractDispatcher.this.doControlMIC(confNo);
            } else if (what == 9) {
                String confNo = b.getString("com.ccp.phone.confNo");
                AbstractDispatcher.this.doReleaseMIC(confNo);
            } else if (what == 10) {
                String confNo = b.getString("com.ccp.phone.confNo");
                AbstractDispatcher.this.doQueryMembersWithInterphone(confNo);
            } else if (what == 11) {
                String appid = b.getString("com.ccp.phone.appId");
                String roomName = b.getString("com.ccp.phone.roomName");
                int square = b.getInt("com.ccp.phone.square");
                String keywords = b.getString("com.ccp.phone.keywords");
                String pwd = b.getString("com.ccp.phone.pwd");
                int isAutoClose = b.getInt("com.ccp.phone.flag");
                int isAutoDelete = b.getInt("com.ccp.phone.flag.isAutoDelete");
                int voiceMod = b.getInt("com.ccp.phone.voiceMod");
                AbstractDispatcher.this.doStartChatroom(appid, roomName, square, keywords, pwd, isAutoClose, voiceMod, isAutoDelete);
            } else if (what == 20) {
                String appid = b.getString("com.ccp.phone.appId");
                String roomNo = b.getString("com.ccp.phone.roomNo");
                AbstractDispatcher.this.doDismissChatRomm(appid, roomNo);
            } else if (what == 21) {
                String appid = b.getString("com.ccp.phone.appId");
                String roomNo = b.getString("com.ccp.phone.roomNo");
                String member = b.getString("com.ccp.phone.member");
                AbstractDispatcher.this.doRemoveMemberFromChatRoom(appid, roomNo, member);
            } else if (what == 31) {
                String appid = b.getString("com.ccp.phone.appId");
                String roomNo = b.getString("com.ccp.phone.roomNo");
                String member = b.getString("com.ccp.phone.member");
                int speakOpt = b.getInt("com.ccp.phone.speak_opt");
                AbstractDispatcher.this.doSetChatroomSpeakType(appid, roomNo, member, speakOpt);
            } else if (what == 12) {
                String appId = b.getString("com.ccp.phone.appId");
                String keywords = b.getString("com.ccp.phone.keywords");
                AbstractDispatcher.this.doQueryChatRooms(appId, keywords);
            } else if (what == 13) {
                String[] members = b.getStringArray("com.ccp.phone.members");
                String roomNo = b.getString("com.ccp.phone.roomNo");
                String appId = b.getString("com.ccp.phone.appId");
                AbstractDispatcher.this.doInviteMembersJoinChatroom(members, roomNo, appId);
            } else if (what == 14) {
                String chatRoomId = b.getString("com.ccp.phone.roomNo");
                AbstractDispatcher.this.doQueryMembersWithChatroom(chatRoomId);
            } else if (what == 15) {
                String fileName = b.getString("com.ccp.phone.fileName");
                String receiver = b.getString("com.ccp.phone.receiver");
                String uniqueID = b.getString("com.ccp.phone.uniqueID");
                String userData = b.getString("com.ccp.phone.userData");
                Log4Util.w("SDK_DEVICE", "doSendMediaMsg WHAT_SEND_MEDIA_MSG\r\n");
                AbstractDispatcher.this.doSendMediaMsg(uniqueID, fileName, receiver, userData);
            } else if (what == 17) {
                ArrayList dLoadList = (ArrayList)b.getSerializable("com.ccp.phone.downloadParameters");
                AbstractDispatcher.this.doDownloadAttachmentFiles(dLoadList);
            } else if (what == 19) {
                String[] msgIds = b.getStringArray("com.ccp.phone.msgIds");
                AbstractDispatcher.this.doConfirmDownloadMediaMessage(msgIds);
            } else if (what == 22) {
                String appid = b.getString("com.ccp.phone.appId");
                String name = b.getString("com.ccp.phone.roomName");
                int square = b.getInt("com.ccp.phone.square");
                String keywords = b.getString("com.ccp.phone.keywords");
                String pwd = b.getString("com.ccp.phone.pwd");
                int isAutoClose = b.getInt("com.ccp.phone.flag");
                int isAutoDelete = b.getInt("com.ccp.phone.flag.isAutoDelete");
                int voiceMod = b.getInt("com.ccp.phone.voiceMod");
                AbstractDispatcher.this.doStartVideoConference(appid, name, square, keywords, pwd, isAutoClose, voiceMod, isAutoDelete);
            } else if (what == 32) {
                String appid = b.getString("com.ccp.phone.appId");
                String name = b.getString("com.ccp.phone.roomName");
                String pwd = b.getString("com.ccp.phone.pwd");
                ConferenceOptions options = (ConferenceOptions)b.getSerializable("com.ccp.phone.conf_options");
                AbstractDispatcher.this.doStartVideoConference(appid, name, pwd, options);
            } else if (what == 24) {
                String conferenceId = b.getString("com.ccp.phone.videoconf.conferenceId");
                AbstractDispatcher.this.doQueryMembersInVideoConference(conferenceId);
            } else if (what == 23) {
                String appid = b.getString("com.ccp.phone.appId");
                String keywords = b.getString("com.ccp.phone.keywords");
                AbstractDispatcher.this.doQueryVideoConferences(appid, keywords);
            } else if (what == 26) {
                String appId = b.getString("com.ccp.phone.appId");
                String conferenceId = b.getString("com.ccp.phone.videoconf.conferenceId");
                AbstractDispatcher.this.doDismissVideoConference(appId, conferenceId);
            } else if (what == 25) {
                String appId = b.getString("com.ccp.phone.appId");
                String conferenceId = b.getString("com.ccp.phone.videoconf.conferenceId");
                String member = b.getString("com.ccp.phone.member");
                AbstractDispatcher.this.doRemoveMemberFromVideoConference(appId, conferenceId, member);
            } else if (what == 27) {
                String appId = b.getString("com.ccp.phone.appId");
                String conferenceId = b.getString("com.ccp.phone.videoconf.conferenceId");
                String voip = b.getString("com.ccp.phone.voip");
                AbstractDispatcher.this.doswitchRealScreenToVoip(appId, conferenceId, voip);
            } else if (what == 29) {
                String conferenceId = b.getString("com.ccp.phone.videoconf.conferenceId");
                AbstractDispatcher.this.doPortraitsFromVideoConference(conferenceId);
            } else if (what == 28) {
                ArrayList portraitsList = (ArrayList)b.getSerializable("com.ccp.phone.downloadParameters.PORTRAIT");
                AbstractDispatcher.this.doDownloadVideoConferencePortraits(portraitsList);
            } else if (what == 30) {
                String fileName = b.getString("com.ccp.phone.fileName");
                String conferenceId = b.getString("com.ccp.phone.videoconf.conferenceId");
                AbstractDispatcher.this.doSendLocalPortrait(fileName, conferenceId);
            } else if (what == 33) {
                String appId = b.getString("com.ccp.phone.appId");
                String conferenceId = b.getString("com.ccp.phone.videoconf.conferenceId");
                boolean publish = b.getBoolean("com.ccp.phone.video_publish");
                if (publish) {
                    AbstractDispatcher.this.doPublishVideoRequest(appId, conferenceId);
                } else {
                    AbstractDispatcher.this.doUnPublishVideoRequest(appId, conferenceId);
                }
            }
            super.handleMessage(msg);
        }
    }

    protected class Constant {
        public static final String APP_ID = "com.ccp.phone.appId";
        public static final String CCP_MSGIDS = "com.ccp.phone.msgIds";
        public static final String CCP_SQUARE = "com.ccp.phone.square";
        public static final String CCP_KEYWORDS = "com.ccp.phone.keywords";
        public static final String CCP_PWD = "com.ccp.phone.pwd";
        public static final String CCP_ARRAY_MEMBERS = "com.ccp.phone.members";
        public static final String CCP_TYPE = "com.ccp.phone.type";
        public static final String CCP_ROOM_NAME = "com.ccp.phone.roomName";
        public static final String CCP_MEMBER = "com.ccp.phone.member";
        public static final String SPEAK_OPT = "com.ccp.phone.speak_opt";
        public static final String CCP_VOIP = "com.ccp.phone.voip";
        public static final String CCP_FILENAME = "com.ccp.phone.fileName";
        public static final String CCP_RECEIVER = "com.ccp.phone.receiver";
        public static final String CCP_UNIQUEID = "com.ccp.phone.uniqueID";
        public static final String CCP_USERDATA = "com.ccp.phone.userData";
        public static final String CCP_DOWNLOAD_PARAMETERS = "com.ccp.phone.downloadParameters";
        public static final String CCP_DOWNLOAD_PARAMETERS_PORTRAIT = "com.ccp.phone.downloadParameters.PORTRAIT";
        public static final String CCP_SELF_PHONENUMBER = "com.ccp.phone.selfphone";
        public static final String CCP_DEST_PHONENUMBER = "com.ccp.phone.destphone";
        public static final String CCP_SELF_SERNUM = "com.ccp.phone.srcSerNum";
        public static final String CCP_DEST_SERNUM = "com.ccp.phone.destSerNum";
        public static final String INTERPHONE_ID = "com.ccp.phone.confNo";
        public static final String CHATROOM_ID = "com.ccp.phone.roomNo";
        public static final String CONFERENCE_ID = "com.ccp.phone.videoconf.conferenceId";
        public static final String VIDEO_PUBLISH = "com.ccp.phone.video_publish";
        public static final String CCP_FLAGE = "com.ccp.phone.flag";
        public static final String CCP_FLAGE_AUTODELETE = "com.ccp.phone.flag.isAutoDelete";
        public static final String CCP_VOICEMOD = "com.ccp.phone.voiceMod";
        public static final String CCP_CONF_OPTIONS = "com.ccp.phone.conf_options";

        protected Constant() {
        }
    }
}

