/*
 * Decompiled with CFR 0.152.
 */
package com.yuntongxun.ecsdk.core.voip;

import android.graphics.PixelFormat;
import android.hardware.Camera;
import android.os.Build;
import android.view.SurfaceHolder;
import com.hisun.phone.core.voice.util.Log4Util;
import com.yuntongxun.ecsdk.core.voip.CaptureCapabilityAndroid;
import com.yuntongxun.ecsdk.core.voip.ViERenderer;
import com.yuntongxun.ecsdk.core.voip.VideoCaptureDeviceInfoAndroid;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class VideoCaptureAndroid
implements Camera.PreviewCallback,
SurfaceHolder.Callback {
    private static final String TAG = "console";
    private Camera camera;
    private VideoCaptureDeviceInfoAndroid.AndroidVideoCaptureDevice currentDevice = null;
    public ReentrantLock previewBufferLock = new ReentrantLock();
    private ReentrantLock captureLock = new ReentrantLock();
    private int PIXEL_FORMAT = 17;
    PixelFormat pixelFormat = new PixelFormat();
    private boolean isCaptureStarted = false;
    private boolean isCaptureRunning = false;
    private boolean isSurfaceReady = false;
    private SurfaceHolder surfaceHolder = null;
    private final int numCaptureBuffers = 3;
    private int expectedFrameSize = 0;
    private int orientation = 0;
    private int id = 0;
    private long context = 0L;
    private SurfaceHolder localPreview = null;
    private boolean ownsBuffers = false;
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFPS = -1;

    public static void DeleteVideoCaptureAndroid(VideoCaptureAndroid captureAndroid) {
        captureAndroid.StopCapture();
        captureAndroid.camera.release();
        captureAndroid.camera = null;
        captureAndroid.context = 0L;
    }

    public VideoCaptureAndroid(int in_id, long in_context, Camera in_camera, VideoCaptureDeviceInfoAndroid.AndroidVideoCaptureDevice in_device) {
        this.id = in_id;
        this.context = in_context;
        this.camera = in_camera;
        this.currentDevice = in_device;
    }

    private int tryStartCapture(int width, int height, int frameRate) {
        if (this.camera == null) {
            return -1;
        }
        if (this.isCaptureRunning || !this.isSurfaceReady || !this.isCaptureStarted) {
            return 0;
        }
        try {
            this.camera.setPreviewDisplay(this.surfaceHolder);
            CaptureCapabilityAndroid currentCapability = new CaptureCapabilityAndroid();
            currentCapability.width = width;
            currentCapability.height = height;
            currentCapability.maxFPS = frameRate;
            PixelFormat.getPixelFormatInfo((int)this.PIXEL_FORMAT, (PixelFormat)this.pixelFormat);
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setPreviewSize(currentCapability.width, currentCapability.height);
            parameters.setPreviewFormat(this.PIXEL_FORMAT);
            parameters.setPreviewFrameRate(currentCapability.maxFPS);
            List list = parameters.getSupportedFocusModes();
            if (list != null && list.contains("continuous-video") && Build.VERSION.SDK_INT >= 14 && this.currentDevice.frontCameraType == VideoCaptureDeviceInfoAndroid.FrontFacingCameraType.None) {
                parameters.setFocusMode("continuous-video");
                this.camera.cancelAutoFocus();
            }
            this.camera.setParameters(parameters);
            int bufSize = width * height * this.pixelFormat.bitsPerPixel / 8;
            byte[] buffer = null;
            for (int i = 0; i < 3; ++i) {
                buffer = new byte[bufSize];
                this.camera.addCallbackBuffer(buffer);
            }
            this.previewBufferLock.lock();
            this.expectedFrameSize = bufSize;
            this.isCaptureRunning = true;
            this.previewBufferLock.unlock();
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            this.ownsBuffers = true;
            this.camera.startPreview();
        }
        catch (Exception ex) {
            return -1;
        }
        this.isCaptureRunning = true;
        return 0;
    }

    public int StartCapture(int width, int height, int frameRate) {
        this.localPreview = ViERenderer.GetLocalRenderer();
        if (this.localPreview != null) {
            if (ViERenderer.isHolderReady()) {
                this.surfaceHolder = ViERenderer.getLocalHolder();
                this.isSurfaceReady = true;
            } else {
                this.localPreview.addCallback((SurfaceHolder.Callback)this);
            }
        }
        this.captureLock.lock();
        this.isCaptureStarted = true;
        this.mCaptureWidth = width;
        this.mCaptureHeight = height;
        this.mCaptureFPS = frameRate;
        int res = this.tryStartCapture(this.mCaptureWidth, this.mCaptureHeight, this.mCaptureFPS);
        this.captureLock.unlock();
        return res;
    }

    public int StopCapture() {
        try {
            this.previewBufferLock.lock();
            this.isCaptureRunning = false;
            this.previewBufferLock.unlock();
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        catch (Exception ex) {
            return -1;
        }
        this.isCaptureStarted = false;
        return 0;
    }

    native void ProvideCameraFrame(byte[] var1, int var2, long var3);

    public void onPreviewFrame(byte[] data, Camera camera) {
        this.previewBufferLock.lock();
        if (this.isCaptureRunning && data.length == this.expectedFrameSize) {
            this.ProvideCameraFrame(data, this.expectedFrameSize, this.context);
            if (this.ownsBuffers) {
                camera.addCallbackBuffer(data);
            }
        }
        this.previewBufferLock.unlock();
    }

    public void SetPreviewRotation(int rotation) {
        Log4Util.v(TAG, "SetPreviewRotation:" + rotation);
        if (this.camera != null) {
            this.previewBufferLock.lock();
            int width = 0;
            int height = 0;
            int framerate = 0;
            boolean isRestart = false;
            if (this.isCaptureRunning) {
                width = this.mCaptureWidth;
                height = this.mCaptureHeight;
                framerate = this.mCaptureFPS;
                this.StopCapture();
                isRestart = true;
            }
            int resultRotation = 0;
            if (this.currentDevice.frontCameraType == VideoCaptureDeviceInfoAndroid.FrontFacingCameraType.Android23) {
                resultRotation = (360 - rotation) % 360;
                Log4Util.d(TAG, "VideoCaptureAndroid::SetPreviewRotation front rotation:" + rotation + " reRotation:%d" + resultRotation);
            } else {
                resultRotation = rotation;
                Log4Util.d(TAG, "VideoCaptureAndroid::SetPreviewRotation back rotation:" + rotation + " reRotation:%d" + resultRotation);
            }
            this.camera.setDisplayOrientation(resultRotation);
            if (isRestart) {
                this.StartCapture(width, height, framerate);
            }
            this.previewBufferLock.unlock();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log4Util.d(TAG, "VideoCaptureAndroid::surfaceChanged");
        this.captureLock.lock();
        this.isSurfaceReady = true;
        this.surfaceHolder = holder;
        this.tryStartCapture(this.mCaptureWidth, this.mCaptureHeight, this.mCaptureFPS);
        this.captureLock.unlock();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log4Util.d(TAG, "VideoCaptureAndroid::surfaceCreated");
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log4Util.d(TAG, "VideoCaptureAndroid::surfaceDestroyed");
        this.isSurfaceReady = false;
    }
}

